/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ProcessoFiscalizacaoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.ProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroFiscalizacaoEnum;
import br.com.elotech.portalarrecadacao.exception.ProcessoFiscalizacaoException;
import br.com.elotech.portalarrecadacao.rest.AlvaraObjectMapper;
import br.com.elotech.portalarrecadacao.rest.service.RestRequestService;
import br.com.elotech.portalarrecadacao.service.SrvFiscalizacao;
import br.com.elotech.portalarrecadacao.service.SrvLaudoAlvara;
import br.com.elotech.portalarrecadacao.service.impl.SrvFiscalizacaoElotechImpl;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryUsuario;
import br.com.elotech.util.crypto.EloCryptoUtils;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.exceptions.InvalidDateString;
import br.com.elotech.util.json.EloJsonUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import javax.faces.context.FacesContext;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.MultiValueMap;

@EloService(value="srvFiscalizacaoElotech")
public class SrvFiscalizacaoElotechImpl
implements SrvFiscalizacao {
    public static final String SERVICE_NAME = "srvFiscalizacaoElotech";
    private static final String ATRIBUTO_MESSAGES = "messages";
    private static final String ATRIBUTO_TOKEN = "token";
    private static final String ATRIBUTO_EXPIRATION_TIME = "expirationTime";
    private static final String ATRIBUTO_RESPONSE = "response";
    private static final String ATRIBUTO_ERRO = "errors";
    private static final String ATRIBUTO_ID_PROCESSO = "id";
    private static final String ATRIBUTO_NUMERO_PROCESSO = "numero";
    private static final String ATRIBUTO_EXERCICIO_PROCESSO = "exercicio";
    private static final String ATRIBUTO_LAUDO_PROCESSO = "idLaudoAlvara";
    @Resource
    private SrvLaudoAlvara srvLaudoAlvara;
    @Resource
    private RepositoryUsuario repositoryUsuario;

    public List<ProcessoFiscalizacao> abrirProcesso(SolicitacaoAlvaraEntity solicitacao, List<LaudoAlvaraEntity> laudos, Optional<Integer> idAssunto) throws BaseException {
        String token = this.getToken();
        JSONObject jsonLaudos = this.montarBody(solicitacao, laudos);
        String uri = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.URL_ABERTURA_PROCESSO_FISCALIZACAO);
        JSONObject jsonProcesso = this.post(jsonLaudos, uri, Optional.of(token));
        this.verificarErros(jsonProcesso);
        JSONArray response = EloJsonUtils.getArray((JSONObject)jsonProcesso, (String)ATRIBUTO_RESPONSE);
        if (Objects.isNull(response)) {
            throw new ProcessoFiscalizacaoException("N\u00e3o foi poss\u00edvel abrir os processos de fiscaliza\u00e7\u00e3o.");
        }
        ArrayList<ProcessoFiscalizacao> processos = new ArrayList<ProcessoFiscalizacao>();
        response.forEach(item -> {
            JSONObject obj = (JSONObject)item;
            ProcessoFiscalizacao processoFiscalizacao = new ProcessoFiscalizacao();
            processoFiscalizacao.setId(EloJsonUtils.getLong((JSONObject)obj, (String)ATRIBUTO_ID_PROCESSO));
            processoFiscalizacao.setNumero(EloJsonUtils.getLong((JSONObject)obj, (String)ATRIBUTO_NUMERO_PROCESSO));
            processoFiscalizacao.setExercicio(EloJsonUtils.getLong((JSONObject)obj, (String)ATRIBUTO_EXERCICIO_PROCESSO));
            processoFiscalizacao.setLaudo(EloJsonUtils.getLong((JSONObject)obj, (String)ATRIBUTO_LAUDO_PROCESSO));
            processos.add(processoFiscalizacao);
        });
        if (processos.isEmpty()) {
            throw new ProcessoFiscalizacaoException("O sistema fiscaliza\u00e7\u00e3o gerou nenhum processo.");
        }
        return processos;
    }

    protected JSONObject montarBody(SolicitacaoAlvaraEntity solicitacao, List<LaudoAlvaraEntity> laudos) {
        DadosProcessoFiscalizacao dados = new DadosProcessoFiscalizacao(this, null);
        dados.idCadastroGeral = String.valueOf(solicitacao.getCadastroMobiliario().getCadastroGeral().getIdUnico());
        dados.usuarioSolicitacao = this.getUsuarioSolicitacao(solicitacao);
        dados.solicitacaoAlvara = solicitacao.getSolicitacaoAlvara();
        dados.numeroSolicitacao = solicitacao.getNumeroSolicitacao();
        dados.exercicioSolicitacao = solicitacao.getExercicio();
        dados.laudos = new ArrayList();
        for (LaudoAlvaraEntity laudo : laudos) {
            LaudoProcessoFiscalizacao laudoProcesso = new LaudoProcessoFiscalizacao(this, null);
            laudoProcesso.idLaudoAlvara = laudo.getIdLaudoAlvara();
            laudoProcesso.tipoLaudo = laudo.getTipoLaudo().getCodigo().getValue();
            dados.laudos.add(laudoProcesso);
        }
        return EloJsonUtils.getJson((String)AlvaraObjectMapper.jsonToString((Object)dados));
    }

    private String getUsuarioSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        return solicitacao != null && solicitacao.getUsuario() != null && solicitacao.getUsuario().getUsuario() != null ? solicitacao.getUsuario().getUsuario() : "";
    }

    protected String getToken() throws BaseException {
        JSONObject tokenFiscalizacao = this.getTokenSessao();
        if (!this.isTokenValido(tokenFiscalizacao)) {
            String uri = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.URL_LOGIN_FISCALIZACAO);
            tokenFiscalizacao = this.post(this.getDadosLogin(), uri, Optional.empty());
            this.verificarErros(tokenFiscalizacao);
            tokenFiscalizacao = EloJsonUtils.getJsonObject((JSONObject)tokenFiscalizacao, (String)ATRIBUTO_RESPONSE);
            if (Objects.isNull(tokenFiscalizacao)) {
                throw new ProcessoFiscalizacaoException("O sistema de fiscaliza\u00e7\u00e3o n\u00e3o retornou o token");
            }
            this.setTokenSessao(tokenFiscalizacao);
        }
        return EloJsonUtils.getString((JSONObject)tokenFiscalizacao, (String)ATRIBUTO_TOKEN);
    }

    private JSONObject getTokenSessao() {
        if (this.isSessaoValida()) {
            return (JSONObject)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get(ParametroFiscalizacaoEnum.TOKEN_FISCALIZACAO_SESSION.getDescricao());
        }
        return null;
    }

    private void setTokenSessao(JSONObject token) {
        if (this.isSessaoValida()) {
            FacesContext.getCurrentInstance().getExternalContext().getSessionMap().put(ParametroFiscalizacaoEnum.TOKEN_FISCALIZACAO_SESSION.getDescricao(), token);
        }
    }

    private boolean isSessaoValida() {
        return FacesContext.getCurrentInstance() != null && FacesContext.getCurrentInstance().getExternalContext() != null && FacesContext.getCurrentInstance().getExternalContext().getSessionMap() != null;
    }

    protected JSONObject getDadosLogin() throws BaseException {
        UsuarioEntity usuarioLogado = this.getUsuarioLogado();
        String acessoFiscalizacao = this.getSenhaAcessoFiscalizacao();
        if (Objects.isNull(acessoFiscalizacao)) {
            throw new ProcessoFiscalizacaoException("N\u00e3o foi poss\u00edvel recuperar a senha de acesso da fiscaliza\u00e7\u00e3o.");
        }
        JSONObject json = new JSONObject();
        json.put("username", (Object)(usuarioLogado.getUsername() != null ? usuarioLogado.getUsername() : usuarioLogado.getUsuario()));
        json.put("password", (Object)EloCryptoUtils.decifra((String)acessoFiscalizacao));
        return json;
    }

    private String getSenhaAcessoFiscalizacao() throws BaseException {
        String senha;
        if (this.isSessaoValida() && !EloStringUtils.isEmpty((String)(senha = (String)FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get(ParametroFiscalizacaoEnum.SENHA_ACESSO_FISCALIZACAO_SESSION.getDescricao())))) {
            return senha;
        }
        return UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.SENHA_USUARIO_API_FISCALIZACAO);
    }

    private UsuarioEntity getUsuarioLogado() throws BaseException {
        if (this.isUsuarioLogado()) {
            return (UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        }
        String usuario = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.NOME_USUARIO_API_FISCALIZACAO);
        return this.repositoryUsuario.getUsuario(usuario);
    }

    private boolean isUsuarioLogado() {
        return SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().getPrincipal() != null;
    }

    protected boolean isTokenValido(JSONObject tokenFiscalizacao) throws InvalidDateString {
        if (Objects.isNull(tokenFiscalizacao)) {
            return false;
        }
        String expirationTime = EloJsonUtils.getString((JSONObject)tokenFiscalizacao, (String)ATRIBUTO_EXPIRATION_TIME);
        Date expiration = EloDateUtils.fromAnsiDateString((String)expirationTime, (String)"dd/MM/yyyy HH:mm:ss Z");
        return expiration.compareTo(new Date()) >= 0;
    }

    protected void verificarErros(JSONObject json) throws ProcessoFiscalizacaoException {
        if (Objects.nonNull(EloJsonUtils.getArray((JSONObject)json, (String)ATRIBUTO_ERRO))) {
            JSONObject jsonErro;
            JSONArray arrayMessages;
            JSONArray erros = EloJsonUtils.getArray((JSONObject)json, (String)ATRIBUTO_ERRO);
            if (Objects.nonNull(erros) && !erros.isNull(0) && Objects.nonNull(arrayMessages = EloJsonUtils.getArray((JSONObject)(jsonErro = erros.getJSONObject(0)), (String)ATRIBUTO_MESSAGES)) && !arrayMessages.isNull(0)) {
                throw new ProcessoFiscalizacaoException(arrayMessages.getString(0));
            }
            throw new ProcessoFiscalizacaoException("Ocorreu um problema inesperado!");
        }
    }

    protected JSONObject post(JSONObject body, String uri, Optional<String> token) {
        RestRequestService restRequestService = new RestRequestService();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        if (token.isPresent()) {
            headers.set("X-Auth-Token", token.get());
        }
        HttpEntity httpEntity = new HttpEntity((Object)body.toString(), (MultiValueMap)headers);
        ResponseEntity response = restRequestService.postWithBody(uri, httpEntity, String.class);
        JSONObject json = EloJsonUtils.getJson((String)((String)response.getBody()));
        return json;
    }

    public void salvarInformacoesProcesso(SolicitacaoAlvaraEntity solicitacao, List<ProcessoFiscalizacao> processos) throws ProcessoFiscalizacaoException, URISyntaxException {
        try {
            for (ProcessoFiscalizacao processo : processos) {
                LaudoAlvaraEntity laudo = this.srvLaudoAlvara.findLaudoById(processo.getLaudo());
                laudo.setStatus(StatusLaudoAlvara.ENCAMINHADO_PARA_VISTORIA);
                UsuarioEntity usuarioLogado = this.getUsuarioLogado();
                AndamentoLaudoAlvaraEntity andamento = new AndamentoLaudoAlvaraEntity();
                andamento.setDataAndamento(new Date());
                andamento.setStatus(StatusLaudoAlvara.ENCAMINHADO_PARA_VISTORIA);
                andamento.setIdLaudoAlvara(laudo);
                andamento.setUsuario(usuarioLogado);
                andamento.setProcessoFiscalizacao(ProcessoFiscalizacaoEntity.of((AndamentoLaudoAlvaraEntity)andamento, (ProcessoFiscalizacao)processo));
                this.srvLaudoAlvara.salvarAndamento(laudo, andamento, solicitacao);
            }
        }
        catch (BaseException e) {
            throw new ProcessoFiscalizacaoException(e.getMessage());
        }
    }

    public void cancelarProcessoFiscalizacao(List<LaudoAlvaraEntity> laudoAlvara, String motivo) throws BaseException {
    }
}

