/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Endereco;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.aise.BairroEntity;
import br.com.elotech.tributacao.domain.aise.LogradouroEntity;
import br.com.elotech.tributacao.domain.vo.BairroAiseVo;
import br.com.elotech.tributacao.domain.vo.LogradouroTipoLogradouroVo;
import br.com.elotech.tributacao.enumerator.DatabaseEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryBairro;
import br.com.elotech.tributacao.repository.aise.RepositoryLogradouro;
import br.com.elotech.tributacao.repository.aise.RepositoryTipoLogradouro;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Scope;

@EloService(value="srvFindLogradouroBySimilarity")
@Scope(value="prototype")
public class SrvFindEnderecoBySimilarity {
    private static final Logger log = LoggerFactory.getLogger(SrvFindEnderecoBySimilarity.class);
    @Value(value="${AISE.jdbc.databaseType:}")
    private String databaseType;
    @Resource
    private RepositoryLogradouro repositoryLogradouro;
    @Resource
    private RepositoryTipoLogradouro repositoryTipoLogradouro;
    @Resource
    private RepositoryBairro repositoryBairro;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;

    public void addEnderecoCadastroGeral(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        if (Objects.isNull(solicitacaoAlvara.getCadastroImobiliario())) {
            SolicitacaoRedeSimEntity solicitacaoRedeSim = this.repositoryConsultaRedeSim.getConsultaByTipo(solicitacaoAlvara.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
            Endereco enderecoJson = PortalUtils.normalizeJson((String)solicitacaoRedeSim.getArquivoDadosEmpresa()).getDados_solicitacao().getEmpresa().getEndereco();
            LogradouroEntity logradouro = this.findDescricaoLogradouroBySimilarity(enderecoJson.getDs_tipo_logradouro().concat(" ").concat(enderecoJson.getDs_endereco()));
            solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setLogradouro(logradouro);
            BairroEntity bairro = this.findDescricaoBairroBySimilarity(enderecoJson.getDs_bairro());
            solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setBairro(bairro);
            solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setComplemento(Optional.ofNullable(enderecoJson.getDs_complemento()).orElse(""));
            solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setNumero(enderecoJson.getNu_numero());
            solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral().setCep(new BigDecimal(enderecoJson.getCo_cep()));
        }
    }

    public LogradouroEntity findDescricaoLogradouroBySimilarity(String descricao) {
        log.info("Busca logradouro por semelhan\u00e7a : {}", (Object)descricao);
        descricao = descricao.replaceAll("['\"]", "");
        LogradouroEntity logradouro = null;
        Optional logradouroTipoLogradouroVo = Optional.empty();
        if (DatabaseEnum.POSTGRESSQL.getName().equalsIgnoreCase(this.databaseType)) {
            logradouroTipoLogradouroVo = this.repositoryLogradouro.findLogradouroBySimilarityPostgresql(descricao);
        } else if (DatabaseEnum.ORACLE.getName().equalsIgnoreCase(this.databaseType)) {
            logradouroTipoLogradouroVo = this.repositoryLogradouro.findLogradouroBySimilarityOracle(descricao);
        }
        if (logradouroTipoLogradouroVo.isPresent()) {
            log.info("Endere\u00e7o encontrado");
            logradouro = this.repositoryLogradouro.findByIdLogradouroIdCidade(((LogradouroTipoLogradouroVo)logradouroTipoLogradouroVo.get()).getIdLogradouro(), ((LogradouroTipoLogradouroVo)logradouroTipoLogradouroVo.get()).getIdCidade());
        }
        return logradouro;
    }

    public BairroEntity findDescricaoBairroBySimilarity(String descricao) {
        log.info("Busca bairro por semelhan\u00e7a : {}", (Object)descricao);
        descricao = descricao.replaceAll("['\"]", "");
        BairroEntity bairro = null;
        Optional bairroVo = null;
        if (DatabaseEnum.ORACLE.getName().equalsIgnoreCase(this.databaseType)) {
            bairroVo = this.repositoryBairro.findBairroBySimilarityOracle(descricao);
        } else if (DatabaseEnum.POSTGRESSQL.getName().equalsIgnoreCase(this.databaseType)) {
            bairroVo = this.repositoryBairro.findBairroBySimilarityPostgresql(descricao);
        }
        if (bairroVo.isPresent()) {
            log.info("Bairro encontrado");
            bairro = this.repositoryBairro.findByIdBairroIdCidade(((BairroAiseVo)bairroVo.get()).getIdBairro(), ((BairroAiseVo)bairroVo.get()).getIdCidade());
        }
        return bairro;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }
}

