/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.portalarrecadacao.domain.ExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.filter.FiltroExigenciaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryExigenciaRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvExigenciaRedeSim;
import java.util.List;
import javax.annotation.Resource;

@EloService(value="srvExigenciaRedeSim")
public class SrvExigenciaRedeSimImpl
implements SrvExigenciaRedeSim {
    @Resource
    private RepositoryExigenciaRedeSim repositoryExigenciaRedeSim;

    public void salvarExigencia(ExigenciaRedeSimEntity exigencia) throws ValidacaoException {
        exigencia.validar();
        this.repositoryExigenciaRedeSim.saveOrUpdate(exigencia);
    }

    public void removerExigencia(ExigenciaRedeSimEntity exigencia) {
        this.repositoryExigenciaRedeSim.remove(exigencia);
    }

    public List<ExigenciaRedeSimEntity> getExigenciasRedeSim(FiltroExigenciaRedeSim filtro) {
        return this.repositoryExigenciaRedeSim.carregarExigenciasRedeSim(filtro);
    }

    public ExigenciaRedeSimEntity carregar(Long id) {
        return this.repositoryExigenciaRedeSim.load(id);
    }
}

