/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.portalarrecadacao.domain.EventoRedeSimEntity;
import br.com.elotech.portalarrecadacao.filter.FiltroEventoRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryEventoRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvEventoRedeSim;
import java.util.List;
import javax.annotation.Resource;

@EloService(value="srvEventoRedeSim")
public class SrvEventoRedeSimImpl
implements SrvEventoRedeSim {
    @Resource
    private RepositoryEventoRedeSim repositoryEventoRedeSim;

    public void removerEvento(EventoRedeSimEntity evento) {
        this.repositoryEventoRedeSim.remove(evento);
    }

    public void salvarEvento(EventoRedeSimEntity evento) throws ValidacaoException {
        evento.validar();
        if (!evento.getEdicao().booleanValue() && this.repositoryEventoRedeSim.existeEvento(evento).booleanValue()) {
            throw new ValidacaoException("O evento informado j\u00e1 existe.");
        }
        this.repositoryEventoRedeSim.saveOrUpdate(evento);
    }

    public Boolean existeEvento(EventoRedeSimEntity evento) {
        return this.repositoryEventoRedeSim.existeEvento(evento);
    }

    public List<EventoRedeSimEntity> buscarEventosRedeSim(FiltroEventoRedeSim filtro) {
        return this.repositoryEventoRedeSim.buscarEventosRedeSim(filtro);
    }
}

