/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.FilaEnvioEmailSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.service.SrvEnviaEmailAlteracoesSolicitacao;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.AppWebConfEntity;
import br.com.elotech.tributacao.repository.RepositoryAppWebConf;
import br.com.elotech.tributacao.repository.RepositoryParametroGeral;
import br.com.elotech.util.email.EloMailUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

@EloService(value="srvEnviaEmailAlteracoesSolicitacao")
public class SrvEnviaEmailAlteracoesSolicitacaoImpl
implements SrvEnviaEmailAlteracoesSolicitacao {
    private static final String DESENVOLVIMENTO = "D";
    @Resource
    private EloMailUtils eloMailUtils;
    @Resource
    private RepositoryParametroGeral repositoryParametroGeral;
    @Resource
    private RepositoryAppWebConf repositoryAppWebConf;

    public void enviaEmailDireto(SolicitacaoAlvaraEntity solicitacao, List<FilaEnvioEmailSolicitacaoAlvaraEntity> alteracoes) throws BaseException {
        AppWebConfEntity appWebConf = this.repositoryAppWebConf.loadFirst();
        if (!DESENVOLVIMENTO.equals(appWebConf.getDev())) {
            StringBuilder mensagem = new StringBuilder();
            mensagem.append("<div style='font-family: Arial, times, Serif;'>");
            mensagem.append("<p><strong>Altera&ccedil;&otilde;es na Solicita&ccedil;&atilde;o: </strong>");
            mensagem.append(solicitacao.getNumeroSolicitacaoExercicio());
            if (solicitacao.isRedeSim()) {
                mensagem.append("<strong>Protocolo Rede Sim: </strong>").append(solicitacao.getProtocoloRedeSim());
            }
            mensagem.append("</p>");
            mensagem.append("<table style='width: 605px; height: 42px;'>");
            mensagem.append("<tbody>");
            mensagem.append("<tr>");
            mensagem.append("<td style='width: 194px;'><strong>Data</strong></td>");
            mensagem.append("<td style='width: 149px;'><strong>Tipo</strong></td>");
            mensagem.append("<td style='width: 261px;'>&nbsp;</td>");
            mensagem.append("</tr>");
            for (FilaEnvioEmailSolicitacaoAlvaraEntity alteracao : alteracoes) {
                mensagem.append("<tr>");
                mensagem.append("<td style='width: 194px;'>");
                mensagem.append(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(alteracao.getDataHora()));
                mensagem.append("</td>");
                mensagem.append("<td style='width: 149px;'>");
                mensagem.append(EloStringUtils.replaceTemplates((String)alteracao.getTipoEnvioEmail().getDescricao(), (Map)EloStringUtils.HTML_ACENTOS_TEMPLATE));
                mensagem.append("</td>");
                mensagem.append("<td style='width: 261px;'>");
                mensagem.append(EloStringUtils.replaceTemplates((String)alteracao.getObservacao(), (Map)EloStringUtils.HTML_ACENTOS_TEMPLATE));
                mensagem.append("</td>");
                mensagem.append("</tr>");
            }
            mensagem.append("</tbody>");
            mensagem.append("</table>");
            mensagem.append("Para visualizar o tramite e obter mais informa\u00e7\u00f5es <a href='").append(PortalUtils.getUrlApplicacao()).append("/app/acompanhamento'>clique aqui e fa\u00e7a login</a>");
            mensagem.append("<p>&nbsp;</p>");
            mensagem.append("<p>Atenciosamente,</p>");
            mensagem.append("<p><strong>Alvar&aacute; Online</strong></p>");
            mensagem.append("<p>&nbsp;</p>");
            mensagem.append("<p>&nbsp;Obs.: Esta &eacute; uma mensagem autom&aacute;tica, por favor n&atilde;o responda este e-mail.</p>");
            mensagem.append("</div>");
            this.eloMailUtils.sendMail(this.repositoryParametroGeral.getParametro(PortalUtils.getModuloAlvaraonline(), "REMETENTEEMAIL"), solicitacao.getEmail(), null, null, String.format("Altera\u00e7\u00f5es na Solicita\u00e7\u00e3o: %s", solicitacao.getNumeroSolicitacaoExercicio()), mensagem.toString(), new ArrayList());
        }
    }
}

