/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.EixoPermitidoEntity;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.portalarrecadacao.repository.RepositoryEixo;
import br.com.elotech.portalarrecadacao.service.SrvEixo;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.EixoEntity;
import br.com.elotech.util.math.EloNumberUtils;
import java.util.List;
import javax.annotation.Resource;

@EloService(value="srvEixo")
public class SrvEixoImpl
implements SrvEixo {
    @Resource
    private RepositoryEixo repositoryEixo;

    public List<EixoPermitidoEntity> carregarEixosPermitidos(ConfiguracaoAtividadeEntity configuracaoAtividade) {
        if (configuracaoAtividade == null) {
            throw new IllegalArgumentException("Atividade n\u00e3o selecionada para consultar as Proibi\u00e7\u00f5es.");
        }
        return this.repositoryEixo.carregarEixosPermitidos(configuracaoAtividade);
    }

    public void salvarEixoPermitido(EixoPermitidoEntity eixoPermitido) throws BaseException {
        if (this.eixoNaoCadastrado(eixoPermitido)) {
            if (!EloNumberUtils.isBiggerThanZero((Number)eixoPermitido.getIdEixoPermitido()).booleanValue()) {
                eixoPermitido.setIdEixoPermitido(this.repositoryEixo.getSequence());
            }
            this.repositoryEixo.saveOrUpdate(eixoPermitido);
            ShowMessage.addInfoMessage((String)"msgEixoPermitido", (String)("Eixo " + eixoPermitido.getEixo().getSigla() + " adicionado com sucesso"));
        } else {
            ShowMessage.addWarnMessage((String)"msgEixoPermitido", (String)("Eixo " + eixoPermitido.getEixo().getSigla() + " j\u00e1 est\u00e1 vinculado a esta Atividade."));
        }
    }

    private boolean eixoNaoCadastrado(EixoPermitidoEntity eixoPermitido) {
        return this.repositoryEixo.eixoNaoCadastrado(eixoPermitido);
    }

    public void excluirEixoPermitido(EixoPermitidoEntity eixoPermitido) {
        this.repositoryEixo.remove(eixoPermitido);
    }

    public List<EixoEntity> carregarTodosEixos() {
        return this.repositoryEixo.carregarTodosEixos();
    }
}

