/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.enumerator.ModeloDocumentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.service.SrvDocumentoRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraRedeSim;
import br.com.elotech.tributacao.domain.aise.DebitoEntity;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;

@EloService(value="srvDocumentoRedeSim")
public class SrvDocumentoRedeSimImpl
implements SrvDocumentoRedeSim {
    @Resource
    private SrvSolicitacaoAlvaraRedeSim srvSolicitacaoAlvaraRedeSim;

    public void enviarDocumento(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao, boolean enviaDam, ImprimirTaxasAlvara imprimirTaxasAlvara, List<HistoricoExigenciaRedeSimEntity> historicoExigenciaRedeSim, ModeloDocumentoRedeSimEnum modeloDocumento, List<DebitoEntity> listaDebitosSelecionadosParaEnvio) throws BaseException {
        if (Objects.nonNull(imprimirTaxasAlvara)) {
            this.srvSolicitacaoAlvaraRedeSim.enviarTaxas(solicitacaoRedeSim, situacao, imprimirTaxasAlvara);
        } else if (Objects.isNull(historicoExigenciaRedeSim)) {
            if (modeloDocumento.equals((Object)ModeloDocumentoRedeSimEnum.INSCRICAO_MUNICIPAL)) {
                this.srvSolicitacaoAlvaraRedeSim.enviarDocumentoInscricaoMunicipal(solicitacaoRedeSim, situacao);
            } else {
                this.srvSolicitacaoAlvaraRedeSim.enviarDocumento(solicitacaoRedeSim, situacao, enviaDam, listaDebitosSelecionadosParaEnvio);
            }
        } else {
            this.srvSolicitacaoAlvaraRedeSim.enviarDocumento(solicitacaoRedeSim, historicoExigenciaRedeSim, enviaDam, listaDebitosSelecionadosParaEnvio);
        }
    }

    public void enviarDocumento(SolicitacaoRedeSimEntity solicitacaoRedeSim, SituacaoRespostaRedeSimEnum situacao) throws BaseException {
        this.srvSolicitacaoAlvaraRedeSim.enviarDocumento(solicitacaoRedeSim, situacao, false, null);
    }

    public void enviarIndeferimentoRedeSim(SolicitacaoRedeSimEntity solicitacaoRedeSim, String observacaoIndeferimento) throws BaseException {
        this.srvSolicitacaoAlvaraRedeSim.enviarIndeferimentoRedeSim(solicitacaoRedeSim, observacaoIndeferimento);
    }
}

