/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.BoletimMobiliarioAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryConfiguracaoAtividadeBoletim;
import br.com.elotech.portalarrecadacao.service.SrvConsultaTaxaMobiliaria;
import br.com.elotech.portalarrecadacao.service.SrvDebitosPortal;
import br.com.elotech.portalarrecadacao.service.SrvWebServiceGeo;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.aise.BoletimMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.BoletimMobiliarioPK;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeTributacaoEntity;
import br.com.elotech.tributacao.domain.aise.ModeloRespostaEntity;
import br.com.elotech.tributacao.enumerator.ModeloIdentificacaoEnum;
import br.com.elotech.tributacao.enumerator.TipoAtividadeEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryBoletimMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryContratoSocial;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.tributacao.repository.aise.RepositoryModeloResposta;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="srvConsultaTaxaMobiliariaPMM")
@Scope(value="prototype")
public class SrvConsultaTaxaMobiliariaPMMImpl
implements SrvConsultaTaxaMobiliaria {
    public static final String SERVICE_NAME = "srvConsultaTaxaMobiliariaPMM";
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    @Resource
    private SrvWebServiceGeo srvWebServiceGeo;
    @Resource
    private SrvDebitosPortal srvDebitosPortal;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;
    @Resource
    private RepositoryConfiguracaoAtividadeBoletim repositoryConfiguracaoAtividadeBoletim;
    @Resource
    private RepositoryBoletimMobiliario repositoryBoletimMobiliario;
    @Resource
    private RepositoryModeloResposta repositoryModeloResposta;
    @Resource
    private RepositoryContratoSocial repositoryContratoSocial;

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    /*
     * Enabled aggressive block sorting
     */
    public BigDecimal getValorTaxaMobiliaria() throws BaseException {
        String taxaLocalizacao;
        block5: {
            taxaLocalizacao = null;
            if (this.solicitacaoAlvara.getTaxaLocalizacao() == null) {
                if (!EloListUtils.safeIsEmpty((List)this.solicitacaoAlvara.getCadastroMobiliario().getMobiliarioCnaes()).booleanValue() || !EloListUtils.safeIsEmpty((List)this.solicitacaoAlvara.getCadastroMobiliario().getMobiliarioCbos()).booleanValue()) {
                    taxaLocalizacao = this.srvWebServiceGeo.getCodTaxa(this.solicitacaoAlvara);
                    break block5;
                } else {
                    String tipoAtividade = this.solicitacaoAlvara.isSolicitacaoCBO() ? TipoAtividadeEnum.CBO.name() : TipoAtividadeEnum.CNAE.name();
                    throw new SolicitacaoAlvaraException(String.format("N\u00e3o foi encontrado nenhum %s no cadastro mobili\u00e1rio.\nPor favor, envie um e-mail para \"%s\" informando o cadastro da inscri\u00e7\u00e3o.", tipoAtividade, UtilsController.getEmailSetorAlvara()));
                }
            }
            taxaLocalizacao = this.solicitacaoAlvara.getTaxaLocalizacao().toString();
        }
        if (this.solicitacaoAlvara.getAreaUtilizada() == null) {
            if (this.solicitacaoAlvara.getCadastroMobiliario().getAreaUtilizada() == null) {
                throw new SolicitacaoAlvaraException(String.format("Campo \"\u00c1rea Utilizada\" n\u00e3o informado no cadastro. \nPor favor, envie um e-mail para \"%s\" informando o cadastro da inscri\u00e7\u00e3o." + UtilsController.getEmailSetorAlvara(), new Object[0]));
            }
            this.solicitacaoAlvara.setAreaUtilizada(this.solicitacaoAlvara.getCadastroMobiliario().getAreaUtilizada());
        }
        BigDecimal valorTaxaLocalizacao = this.srvDebitosPortal.calculaValorTaxaMobiliaria(PortalUtils.getEntidade(), this.getExercicio(), this.solicitacaoAlvara, taxaLocalizacao);
        BigDecimal valorLicencaSanitaria = this.srvDebitosPortal.calculaValorLicencaSanitaria(PortalUtils.getEntidade(), this.getExercicio(), this.solicitacaoAlvara);
        BigDecimal valorTaxasMob = EloNumberUtils.safeAdd((BigDecimal)valorTaxaLocalizacao, (BigDecimal)valorLicencaSanitaria, (int)2);
        BigDecimal valorISSQN = BigDecimal.ZERO;
        if (!this.solicitacaoAlvara.isSolicitacaoCBO()) return EloNumberUtils.safeAdd((BigDecimal)valorTaxasMob, (BigDecimal)valorISSQN, (int)2);
        valorISSQN = this.getValorISSQN(this.solicitacaoAlvara);
        return EloNumberUtils.safeAdd((BigDecimal)valorTaxasMob, (BigDecimal)valorISSQN, (int)2);
    }

    private BigDecimal getValorISSQN(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return this.srvDebitosPortal.calculaValorTaxaMobiliariaISSQN(solicitacao, PortalUtils.getEntidade(), this.getExercicio());
    }

    private Long getExercicio() throws BaseException {
        EntidadeTributacaoEntity exercicioAtual = this.repositoryEntidadeTributacao.getExercicioAtual(Long.valueOf(EloDateUtils.getYear((Date)new Date())));
        return exercicioAtual.getId().getExercicioTributacao().getExercicio();
    }

    public List<BoletimMobiliarioEntity> getBoletins(SolicitacaoAlvaraEntity solicitacaoAlvara, BoletimMobiliarioAlvaraEntity boletimAlvara) {
        ArrayList<BoletimMobiliarioEntity> boletins = new ArrayList<BoletimMobiliarioEntity>();
        boletins.addAll(this.gerarBoletimMobTaxaLocalizacao(solicitacaoAlvara, boletimAlvara));
        boletins.addAll(this.gerarBoletimMobNumSocios(solicitacaoAlvara, boletimAlvara));
        return boletins;
    }

    private List<BoletimMobiliarioEntity> gerarBoletimMobTaxaLocalizacao(SolicitacaoAlvaraEntity solicitacaoAlvara, BoletimMobiliarioAlvaraEntity boletimAlvara) {
        ArrayList<BoletimMobiliarioEntity> boletins = new ArrayList<BoletimMobiliarioEntity>();
        if (boletimAlvara.getModeloIdentificacao().getIdentificacao().equals(ModeloIdentificacaoEnum.TAXA_LOCALIZACAO.getValor()) && solicitacaoAlvara.getTaxaLocalizacao() != null) {
            BoletimMobiliarioPK idBoletim = new BoletimMobiliarioPK();
            ModeloRespostaEntity modeloRespostaSelecionado = this.repositoryModeloResposta.getModeloRespostaByCodigo(Long.valueOf(solicitacaoAlvara.getTaxaLocalizacao().longValue()));
            BoletimMobiliarioEntity boletim = this.repositoryBoletimMobiliario.findByCadastroGeralAndModelCampo(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral(), modeloRespostaSelecionado.getId().getModeloCampo());
            if (boletim == null || boletim.getId() == null) {
                boletim = new BoletimMobiliarioEntity();
                idBoletim.setCadastroMobiliario(solicitacaoAlvara.getCadastroMobiliario());
                idBoletim.setModeloResposta(modeloRespostaSelecionado);
                boletim.setId(idBoletim);
            } else {
                boletim.getId().setModeloResposta(modeloRespostaSelecionado);
            }
            boletins.add(boletim);
        }
        return boletins;
    }

    private List<BoletimMobiliarioEntity> gerarBoletimMobNumSocios(SolicitacaoAlvaraEntity solicitacaoAlvara, BoletimMobiliarioAlvaraEntity boletimAlvara) {
        ArrayList<BoletimMobiliarioEntity> boletins = new ArrayList<BoletimMobiliarioEntity>();
        if (solicitacaoAlvara.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS}) && boletimAlvara.getModeloIdentificacao().getIdentificacao().equals(ModeloIdentificacaoEnum.NUMERO_SOCIOS.getValor())) {
            BoletimMobiliarioPK idBoletim = new BoletimMobiliarioPK();
            ModeloRespostaEntity modeloRespostaSelecionado = this.repositoryModeloResposta.getModeloRespostaPorIdentificacao(boletimAlvara.getModeloIdentificacao());
            BoletimMobiliarioEntity boletim = this.repositoryBoletimMobiliario.findByCadastroGeralAndModelCampo(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral(), modeloRespostaSelecionado.getId().getModeloCampo());
            if (boletim == null || boletim.getId() == null) {
                boletim = new BoletimMobiliarioEntity();
                idBoletim.setCadastroMobiliario(solicitacaoAlvara.getCadastroMobiliario());
                idBoletim.setModeloResposta(modeloRespostaSelecionado);
                boletim.setId(idBoletim);
            } else {
                boletim.getId().setModeloResposta(modeloRespostaSelecionado);
            }
            if (solicitacaoAlvara.isNaturezaInicial()) {
                boletim.setDescricaoResposta(String.valueOf(solicitacaoAlvara.getContratoSocial().getPessoas().size()));
            } else {
                ContratoSocialEntity contrato = this.repositoryContratoSocial.getUltimoContratoSocial(solicitacaoAlvara.getCadastroMobiliario());
                if (contrato != null && contrato.getPessoas().size() <= 0) {
                    contrato.setPessoas(new ArrayList());
                }
                if (contrato != null) {
                    boletim.setDescricaoResposta(String.valueOf(contrato.getPessoas().size()));
                } else {
                    boletim.setDescricaoResposta("0");
                }
            }
            boletins.add(boletim);
        }
        return boletins;
    }
}

