/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.BoletimMobiliarioAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ConfiguracaoAtividadeBoletimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.ConfiguracaoAtividadeBoletimException;
import br.com.elotech.portalarrecadacao.exception.ConsultaTaxaMobiliariaException;
import br.com.elotech.portalarrecadacao.exception.ExercicioException;
import br.com.elotech.portalarrecadacao.repository.RepositoryConfiguracaoAtividadeBoletim;
import br.com.elotech.portalarrecadacao.service.SrvConsultaTaxaMobiliaria;
import br.com.elotech.portalarrecadacao.service.impl.SrvDebitosPortalImpl;
import br.com.elotech.portalarrecadacao.service.impl.SrvGeraBoletimMobiliarioImpl;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.domain.aise.BoletimMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.BoletimMobiliarioPK;
import br.com.elotech.tributacao.domain.aise.ModeloIdentificacaoEntity;
import br.com.elotech.tributacao.domain.aise.ModeloRespostaEntity;
import br.com.elotech.tributacao.domain.aise.ModeloRespostaPK;
import br.com.elotech.tributacao.enumerator.ModeloIdentificacaoEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryBoletimMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryCoeficienteCalculo;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.tributacao.repository.aise.RepositoryModeloIdentificacao;
import br.com.elotech.tributacao.repository.aise.RepositoryModeloResposta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="srvConsultaTaxaMobiliariaPMCGS")
public class SrvConsultaTaxaMobiliariaPMCGSImpl
implements SrvConsultaTaxaMobiliaria {
    public static final String SERVICE_NAME = "srvConsultaTaxaMobiliariaPMCGS";
    private SolicitacaoAlvaraEntity solicitacaoAlvara;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;
    @Resource
    private RepositoryCoeficienteCalculo repositoryCoeficienteCalculo;
    @Resource
    private SrvDebitosPortalImpl srvDebitosPortalImpl;
    @Resource
    protected RepositoryModeloIdentificacao repositoryModeloIdentificacao;
    @Resource
    private SrvGeraBoletimMobiliarioImpl srvGeraBoletimMobiliarioImpl;
    @Resource
    private RepositoryConfiguracaoAtividadeBoletim repositoryConfiguracaoAtividadeBoletim;
    @Resource
    private RepositoryBoletimMobiliario repositoryBoletimMobiliario;
    @Resource
    private RepositoryModeloResposta repositoryModeloResposta;

    public void setSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        this.solicitacaoAlvara = solicitacaoAlvara;
    }

    public void setRepositoryCoeficienteCalculo(RepositoryCoeficienteCalculo repositoryCoeficienteCalculo) {
        this.repositoryCoeficienteCalculo = repositoryCoeficienteCalculo;
    }

    public SrvDebitosPortalImpl getSrvDebitosPortalImpl() {
        return this.srvDebitosPortalImpl;
    }

    public void setSrvDebitosPortalImpl(SrvDebitosPortalImpl srvDebitosPortalImpl) {
        this.srvDebitosPortalImpl = srvDebitosPortalImpl;
    }

    public BigDecimal getValorTaxaMobiliaria() throws BaseException {
        BigDecimal valorAlvaraPorAtividadeEspecial = BigDecimal.ZERO;
        BigDecimal valorURF = BigDecimal.ZERO;
        if (this.solicitacaoAlvara.isSolicitacaoCBO()) {
            Long exercicio = UtilsController.getExercicio();
            valorAlvaraPorAtividadeEspecial = this.repositoryCoeficienteCalculo.retornaValorAlvaraFixo(exercicio, PortalUtils.getEntidade(), this.getCodigoAtividadeEspecial());
            valorURF = this.repositoryCoeficienteCalculo.retornaValorAlvaraURF(exercicio, PortalUtils.getEntidade());
        }
        BigDecimal valorTotalTaxaMobiliria = this.srvDebitosPortalImpl.calculaValorRestanteNoAno(valorAlvaraPorAtividadeEspecial.multiply(valorURF));
        if (this.solicitacaoAlvara.isSolicitacaoCBO()) {
            valorTotalTaxaMobiliria = valorTotalTaxaMobiliria.add(valorTotalTaxaMobiliria);
        }
        return valorTotalTaxaMobiliria.add(valorURF);
    }

    Integer getCodigoAtividadeEspecial() throws BaseException {
        ModeloIdentificacaoEntity modeloIdentificacao = this.repositoryModeloIdentificacao.getAtividadeEspecial();
        BoletimMobiliarioAlvaraEntity boletimAlvara = new BoletimMobiliarioAlvaraEntity();
        boletimAlvara.setModeloIdentificacao(modeloIdentificacao);
        Long numeroAtividadeEspecial = this.getNumeroAtividadeEspecial(this.solicitacaoAlvara.getSolicitacaoAlvaraAtividades(), boletimAlvara);
        return numeroAtividadeEspecial.intValue();
    }

    public List<BoletimMobiliarioEntity> getBoletins(SolicitacaoAlvaraEntity solicitacaoAlvara, BoletimMobiliarioAlvaraEntity boletimAlvara) throws BaseException {
        ArrayList<BoletimMobiliarioEntity> boletins = new ArrayList<BoletimMobiliarioEntity>();
        boletins.addAll(this.gerarBoletimAtividadeEspecial(solicitacaoAlvara, boletimAlvara));
        return boletins;
    }

    private List<BoletimMobiliarioEntity> gerarBoletimAtividadeEspecial(SolicitacaoAlvaraEntity solicitacaoAlvara, BoletimMobiliarioAlvaraEntity boletimAlvara) throws BaseException {
        ArrayList<BoletimMobiliarioEntity> boletins = new ArrayList<BoletimMobiliarioEntity>();
        if (boletimAlvara.getModeloIdentificacao().getIdentificacao().equals(ModeloIdentificacaoEnum.ATIVIDADE_ESPECIAL.getValor())) {
            BoletimMobiliarioEntity boletim = new BoletimMobiliarioEntity();
            BoletimMobiliarioPK idBoletim = new BoletimMobiliarioPK();
            ModeloRespostaEntity modeloResposta = new ModeloRespostaEntity();
            ModeloRespostaPK idModeloResposta = new ModeloRespostaPK();
            idModeloResposta.setModeloResposta(this.getNumeroAtividadeEspecial(solicitacaoAlvara.getSolicitacaoAlvaraAtividades(), boletimAlvara));
            modeloResposta.setId(idModeloResposta);
            boletim = this.repositoryBoletimMobiliario.findByCadastroGeralAndModelCampo(solicitacaoAlvara.getCadastroMobiliario().getCadastroGeral(), boletimAlvara.getModeloIdentificacao().getModeloResposta().getId().getModeloCampo());
            if (boletim == null || boletim.getId() == null) {
                boletim = new BoletimMobiliarioEntity();
                idBoletim.setCadastroMobiliario(solicitacaoAlvara.getCadastroMobiliario());
                idBoletim.setModeloResposta(modeloResposta);
                idBoletim.setCadastroMobiliario(solicitacaoAlvara.getCadastroMobiliario());
                idBoletim.setModeloResposta(this.repositoryModeloResposta.getModeloRespostaPorIdentificacao(boletimAlvara.getModeloIdentificacao(), modeloResposta));
                boletim.setId(idBoletim);
            } else {
                boletim.getId().setModeloResposta(this.repositoryModeloResposta.getModeloRespostaPorIdentificacao(boletimAlvara.getModeloIdentificacao(), modeloResposta));
            }
            boletins.add(boletim);
        }
        return boletins;
    }

    public Long getNumeroAtividadeEspecial(List<SolicitacaoAlvaraAtividadeEntity> solicitacaoAlvaraAtividades, BoletimMobiliarioAlvaraEntity boletimAlvara) throws BaseException {
        BigDecimal maiorValor = BigDecimal.ZERO;
        Long atividadeEspecial = null;
        Long exercicio = this.getExercicioAtual();
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacaoAlvaraAtividades) {
            ConfiguracaoAtividadeBoletimEntity config = this.recuperarConfiguracaoAtividadeBoletim(boletimAlvara, atividade);
            BigDecimal valorAtividadeEspecial = this.retornaValorAlvaraFixo(config, exercicio, atividade);
            if (valorAtividadeEspecial.compareTo(maiorValor) < 0) continue;
            maiorValor = valorAtividadeEspecial;
            atividadeEspecial = config.getModeloResposta().getId().getModeloResposta();
        }
        return atividadeEspecial;
    }

    private ConfiguracaoAtividadeBoletimEntity recuperarConfiguracaoAtividadeBoletim(BoletimMobiliarioAlvaraEntity boletimAlvara, SolicitacaoAlvaraAtividadeEntity atividade) throws ConfiguracaoAtividadeBoletimException, BaseException {
        ConfiguracaoAtividadeBoletimEntity config = this.repositoryConfiguracaoAtividadeBoletim.recuperarConfiguracaoAtividadeBoletim(atividade.getConfiguracaoAtividade(), boletimAlvara.getModeloIdentificacao());
        if (config == null) {
            throw new ConfiguracaoAtividadeBoletimException("N\u00e3o foi encontrada a configura\u00e7\u00e3o da atividade");
        }
        return config;
    }

    private BigDecimal retornaValorAlvaraFixo(ConfiguracaoAtividadeBoletimEntity config, Long exercicio, SolicitacaoAlvaraAtividadeEntity atividade) throws ConsultaTaxaMobiliariaException {
        BigDecimal valorAtividadeEspecial = this.repositoryCoeficienteCalculo.retornaValorAlvaraFixo(exercicio, PortalUtils.getEntidade(), Integer.valueOf(config.getModeloResposta().getId().getModeloResposta().intValue()));
        if (valorAtividadeEspecial == null) {
            throw new ConsultaTaxaMobiliariaException(atividade.getSequenciaCbo().getDescricao());
        }
        return valorAtividadeEspecial;
    }

    public Long getExercicioAtual() throws ExercicioException {
        try {
            Long exercicio = UtilsController.getExercicio();
            return exercicio;
        }
        catch (BaseException e) {
            throw new ExercicioException();
        }
    }
}

