/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.portalarrecadacao.domain.EventoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialPessoaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvConsultaPrevia;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaGenericaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioAtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioCboEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioCnaeEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioSituacaoEntity;
import br.com.elotech.tributacao.domain.aise.ObservacaoConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.SituacaoMobiliarioEntity;
import br.com.elotech.tributacao.enumerator.SituacaoMobiliarioAlvaraEnum;
import br.com.elotech.tributacao.enumerator.TipoAtividadeEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryCadastroMobiliario;
import br.com.elotech.tributacao.repository.aise.RepositoryImobiliarioTestadaGenerica;
import br.com.elotech.tributacao.repository.aise.RepositorySituacaoMobiliario;
import br.com.elotech.util.list.EloListUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.hibernate.Hibernate;

@EloService(value="srvConsultaPrevia")
public class SrvConsultaPreviaImpl
implements SrvConsultaPrevia {
    @Resource
    private RepositoryCadastroMobiliario repositoryCadastroMobiliario;
    @Resource
    private RepositorySituacaoMobiliario repositorySituacaoMobiliario;
    @Resource
    private RepositoryImobiliarioTestadaGenerica repositoryImobiliarioTestadaGenerica;
    @Resource
    private RepositoryConfiguracaoAtividade repositoryConfiguracaoAtividade;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;

    public List<CadastroMobiliarioEntity> carregarCadastrosMobiliarios(String cpfCnpj) {
        List cadastros = this.repositoryCadastroMobiliario.cadastrosMobiliariosValidosComSolicitacoes(cpfCnpj);
        List<CadastroMobiliarioEntity> cadastrosMobiliariosAtivos = cadastros.size() == 1 ? Collections.singletonList(this.repositoryCadastroMobiliario.carregarCadastroMobiliarioPorCodigo((Long)cadastros.get(0))) : this.repositoryCadastroMobiliario.cadastrosMobiliariosComPessoaAtivaExclusaoLogicaByCpfCnpj(cpfCnpj);
        SituacaoMobiliarioEntity situacaoBaixada = this.repositorySituacaoMobiliario.getSituacaoMobiliario(SituacaoMobiliarioAlvaraEnum.SITUACAO_BAIXADO);
        SituacaoMobiliarioEntity situacaoCassada = this.repositorySituacaoMobiliario.getSituacaoMobiliario(SituacaoMobiliarioAlvaraEnum.SITUACAO_CASSADO);
        ArrayList<CadastroMobiliarioEntity> cadastrosMobiliariosNaoBaixados = new ArrayList<CadastroMobiliarioEntity>();
        for (CadastroMobiliarioEntity cadastroMobiliario : cadastrosMobiliariosAtivos) {
            if (!Objects.nonNull(cadastroMobiliario.getMobiliarioSituacaoAtual()) || !Objects.nonNull(cadastroMobiliario.getMobiliarioSituacaoAtual().getId()) || cadastroMobiliario.getMobiliarioSituacaoAtual().getId().equals(situacaoBaixada.getId()) || cadastroMobiliario.getMobiliarioSituacaoAtual().getId().equals(situacaoCassada.getId())) continue;
            cadastrosMobiliariosNaoBaixados.add(cadastroMobiliario);
        }
        return cadastrosMobiliariosNaoBaixados;
    }

    public CadastroImobiliarioTestadaGenericaEntity buscarTestadaGenericaPrincipal(CadastroGeralAisePK cadastroGeralPK) throws SolicitacaoAlvaraException {
        CadastroImobiliarioTestadaGenericaEntity testada = this.repositoryImobiliarioTestadaGenerica.buscarTestadaPrincipal(cadastroGeralPK);
        if (Objects.isNull(testada)) {
            throw new SolicitacaoAlvaraException("N\u00e3o foi poss\u00edvel encontrar a testada principal para este registro, favor entre em contato com a prefeitura para uma atualiza\u00e7\u00e3o cadastral.");
        }
        return testada;
    }

    public String getObservacaoConfiguracaoAtividade(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        TipoAtividadeEnum tipo = null;
        tipo = solicitacaoAlvara.isSolicitacaoMEI() ? TipoAtividadeEnum.MEI : (solicitacaoAlvara.isSolicitacaoJuridicaNormal() ? TipoAtividadeEnum.CNAE : TipoAtividadeEnum.CBO);
        StringBuilder observacao = new StringBuilder();
        HashSet observacaoSemRepeticao = new HashSet();
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacaoAlvara.getSolicitacaoAlvaraAtividades()) {
            ConfiguracaoAtividadeEntity configuracaoAtividade = null;
            configuracaoAtividade = tipo == TipoAtividadeEnum.MEI ? this.repositoryConfiguracaoAtividade.getConfiguracaoAtividadeByidAtividade(atividade.getAtividadeMei().getAtividadeMei(), tipo) : this.repositoryConfiguracaoAtividade.getConfiguracaoAtividadeByidAtividade(atividade.getCnae().getId(), tipo);
            if (!Objects.nonNull(configuracaoAtividade) || EloListUtils.safeIsEmpty((List)configuracaoAtividade.getObservacoes()).booleanValue()) continue;
            observacaoSemRepeticao.addAll(Sets.newHashSet((Iterable)configuracaoAtividade.getObservacoes()));
        }
        for (ObservacaoConfiguracaoAtividadeEntity obs : observacaoSemRepeticao) {
            observacao.append(obs.getObservacao());
        }
        return observacao.toString();
    }

    public List<CadastroMobiliarioEntity> loadCadastroMobiliarioByCpfCnpj(String cpfCnpj) {
        List cadastrosMobiliarios = this.carregarCadastrosMobiliarios(cpfCnpj);
        if (EloListUtils.safeIsEmpty((List)cadastrosMobiliarios).booleanValue()) {
            return cadastrosMobiliarios;
        }
        for (CadastroMobiliarioEntity mobiliario : cadastrosMobiliarios) {
            Hibernate.initialize((Object)mobiliario.getCadastroGeral().getPessoa().getContatos());
            Hibernate.initialize((Object)mobiliario.getMobiliarioSituacao());
            Hibernate.initialize((Object)mobiliario.getMobiliarioServicos());
            Hibernate.initialize((Object)mobiliario.getMobiliarioAtividades());
            if (Objects.nonNull(mobiliario.getMobiliarioSituacao())) {
                for (MobiliarioSituacaoEntity mobiliarioSituacao : mobiliario.getMobiliarioSituacao()) {
                    Hibernate.initialize((Object)mobiliarioSituacao.getSituacaoMobiliario());
                    Hibernate.initialize((Object)mobiliarioSituacao.getSituacaoMobiliario().getSituacoesMobiliarioAlvara());
                }
            }
            if (Objects.isNull(mobiliario.getMobiliarioCnaes())) {
                mobiliario.setMobiliarioCnaes(new ArrayList());
            } else {
                Hibernate.initialize((Object)mobiliario.getMobiliarioCnaes());
            }
            for (MobiliarioCnaeEntity mobiliarioCnae : mobiliario.getMobiliarioCnaes()) {
                if (!EloListUtils.safeIsEmpty((List)mobiliarioCnae.getId().getCnae().getCarteirasProfissionais()).booleanValue()) continue;
                mobiliarioCnae.getId().getCnae().setCarteirasProfissionais(new ArrayList());
            }
            if (Objects.isNull(mobiliario.getMobiliarioCbos())) {
                mobiliario.setMobiliarioCbos(new ArrayList());
            }
            for (CadastroMobiliarioCboEntity mobiliarioCbo : mobiliario.getMobiliarioCbos()) {
                if (!EloListUtils.safeIsEmpty((List)mobiliarioCbo.getRhCbo().getCarteirasProfissionais()).booleanValue()) continue;
                mobiliarioCbo.getRhCbo().setCarteirasProfissionais(new ArrayList());
            }
            Hibernate.initialize((Object)mobiliario.getMobiliarioAtividadeMeis());
            for (CadastroMobiliarioAtividadeMeiEntity mei : mobiliario.getMobiliarioAtividadeMeis()) {
                if (!EloListUtils.safeIsEmpty((List)mei.getAtividadeMei().getCarteirasProfissionais()).booleanValue()) continue;
                mei.getAtividadeMei().setCarteirasProfissionais(new ArrayList());
            }
            if (Objects.nonNull(mobiliario.getCadastroImobiliario())) {
                Hibernate.initialize((Object)mobiliario.getCadastroImobiliario().getSegmentos());
                Hibernate.initialize((Object)mobiliario.getCadastroImobiliario().getTestadas());
                Hibernate.initialize((Object)mobiliario.getCadastroImobiliario().getTestadasGenericas());
            }
            if (Objects.isNull(mobiliario.getMobiliarioSituacao())) {
                mobiliario.setMobiliarioSituacao(new ArrayList());
            }
            Hibernate.initialize((Object)mobiliario.getMobiliarioSituacaoAtual().getSituacoesMobiliarioAlvara());
            Hibernate.initialize((Object)mobiliario.getContratosSociais());
            if (!EloListUtils.safeIsEmpty((List)mobiliario.getContratosSociais()).booleanValue()) {
                for (ContratoSocialEntity contratoSocial : mobiliario.getContratosSociais()) {
                    Hibernate.initialize((Object)contratoSocial.getPessoas());
                    for (ContratoSocialPessoaEntity contratoPessoa : contratoSocial.getPessoas()) {
                        Hibernate.initialize((Object)contratoPessoa.getId().getPessoa().getEnderecos());
                        Hibernate.initialize((Object)contratoPessoa.getId().getPessoa().getContatos());
                    }
                }
            }
            if (!Objects.nonNull(mobiliario.getCadastroGeral()) || !Objects.nonNull(mobiliario.getCadastroGeral().getPessoa())) continue;
            Hibernate.initialize((Object)mobiliario.getCadastroGeral().getPessoa().getContatos());
            Hibernate.initialize((Object)mobiliario.getCadastroGeral().getPessoa().getEnderecos());
        }
        return cadastrosMobiliarios;
    }

    public SolicitacaoRedeSimEntity getSolicitacaoByProtocoloAndTipo(String protocolo, TipoSolicitacaoRedeSimEnum tipoSolicitacao) {
        SolicitacaoRedeSimEntity solicitacao = this.repositoryConsultaRedeSim.getConsultaByTipo(protocolo, tipoSolicitacao);
        if (Objects.isNull(solicitacao)) {
            return null;
        }
        Hibernate.initialize((Object)solicitacao.getEventos());
        Hibernate.initialize((Object)solicitacao.getSolicitacoesAlvara());
        Hibernate.initialize((Object)solicitacao.getIndeferimentos());
        if (Objects.nonNull(solicitacao.getSolicitacaoAlvara())) {
            if (!EloListUtils.safeIsEmpty((List)solicitacao.getSolicitacaoAlvara().getDebitos()).booleanValue()) {
                Hibernate.initialize((Object)solicitacao.getSolicitacaoAlvara().getDebitos());
            }
            Hibernate.initialize((Object)solicitacao.getSolicitacaoAlvara().getNaturezas());
            Hibernate.initialize((Object)solicitacao.getSolicitacaoAlvara().getDocumentos());
            Hibernate.initialize((Object)solicitacao.getSolicitacaoAlvara().getSefazDocumentos());
            Hibernate.initialize((Object)solicitacao.getSolicitacaoAlvara().getLaudos());
            if (!EloListUtils.safeIsEmpty((List)solicitacao.getHistoricosExigencias()).booleanValue()) {
                Hibernate.initialize((Object)solicitacao.getHistoricosExigencias());
                for (HistoricoExigenciaRedeSimEntity hist : solicitacao.getHistoricosExigencias()) {
                    Hibernate.initialize((Object)hist.getUrlsDocHistoricoExigencia());
                }
            }
            if (!EloListUtils.safeIsEmpty((List)solicitacao.getSolicitacaoAlvara().getLaudos()).booleanValue()) {
                for (LaudoAlvaraEntity laudo : solicitacao.getSolicitacaoAlvara().getLaudos()) {
                    Hibernate.initialize((Object)laudo.getDocumentos());
                    if (!Objects.isNull(laudo.getDocumentos())) continue;
                    laudo.setDocumentos(new ArrayList());
                }
            }
            if (Objects.nonNull(solicitacao.getSolicitacaoAlvara().getCadastroImobiliario())) {
                Hibernate.initialize((Object)solicitacao.getSolicitacaoAlvara().getCadastroImobiliario().getSegmentos());
                Hibernate.initialize((Object)solicitacao.getSolicitacaoAlvara().getCadastroImobiliario().getTestadas());
                Hibernate.initialize((Object)solicitacao.getSolicitacaoAlvara().getCadastroImobiliario().getTestadasGenericas());
            }
            if (Objects.nonNull(solicitacao.getSolicitacaoAlvara().getContratoSocial())) {
                Hibernate.initialize((Object)solicitacao.getSolicitacaoAlvara().getContratoSocial().getPessoas());
                for (SolicitacaoContratoSocialPessoaEntity p2 : solicitacao.getSolicitacaoAlvara().getContratoSocial().getPessoas()) {
                    Hibernate.initialize((Object)p2.getPessoa().getEnderecos());
                    Hibernate.initialize((Object)p2.getPessoa().getContatos());
                }
            }
            Optional.ofNullable(solicitacao.getSolicitacaoAlvara().getCadastroMobiliario()).ifPresent(cadastroMobiliario -> {
                if (Objects.nonNull(cadastroMobiliario.getCadastroGeral())) {
                    Hibernate.initialize((Object)cadastroMobiliario.getCadastroGeral().getIsencoes());
                    if (Objects.nonNull(cadastroMobiliario.getCadastroGeral().getPessoa())) {
                        Hibernate.initialize((Object)cadastroMobiliario.getCadastroGeral().getPessoa().getContatos());
                        Hibernate.initialize((Object)cadastroMobiliario.getCadastroGeral().getPessoa().getEnderecos());
                    }
                }
                Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioCnaes());
                Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioCbos());
                Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioAtividades());
                Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioAtividadeMeis());
                Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioServicos());
                Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioSituacao());
                cadastroMobiliario.getMobiliarioSituacao().forEach(p -> Optional.ofNullable(p.getSituacaoMobiliario()).ifPresent(situacao -> Hibernate.initialize((Object)situacao.getSituacoesMobiliarioAlvara())));
                Hibernate.initialize((Object)cadastroMobiliario.getMobiliarioHorarioEspecial());
                Hibernate.initialize((Object)cadastroMobiliario.getContratosSociais());
                if (!EloListUtils.safeIsEmpty((List)cadastroMobiliario.getContratosSociais()).booleanValue()) {
                    for (ContratoSocialEntity contratoSocial : cadastroMobiliario.getContratosSociais()) {
                        if (!Objects.nonNull(contratoSocial) || EloListUtils.safeIsEmpty((List)contratoSocial.getPessoas()).booleanValue()) continue;
                        Hibernate.initialize((Object)contratoSocial.getPessoas());
                        for (ContratoSocialPessoaEntity contratoPessoa : contratoSocial.getPessoas()) {
                            Hibernate.initialize((Object)contratoPessoa.getId().getPessoa().getEnderecos());
                            Hibernate.initialize((Object)contratoPessoa.getId().getPessoa().getContatos());
                        }
                    }
                }
            });
            if (!EloListUtils.safeIsEmpty((List)solicitacao.getEventos()).booleanValue()) {
                for (EventoRedeSimEntity evento : solicitacao.getEventos()) {
                    Hibernate.initialize((Object)evento);
                }
            }
            Hibernate.initialize((Object)solicitacao.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades());
            if (!EloListUtils.safeIsEmpty((List)solicitacao.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades()).booleanValue()) {
                solicitacao.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades().stream().forEach(p -> Hibernate.initialize((Object)p.getNumerosConselho()));
            }
        }
        return solicitacao;
    }
}

