/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.ConsultaGeoRestLogEntity;
import br.com.elotech.portalarrecadacao.exception.IntegracaoGeoException;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaGeoRestLog;
import br.com.elotech.portalarrecadacao.rest.AlvaraObjectMapper;
import br.com.elotech.portalarrecadacao.rest.service.RestRequestService;
import br.com.elotech.portalarrecadacao.service.SrvUsuario;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ConsultaAtividadeEnvioNovoGeo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ErroConsultaGeo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ErroGeo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.FiltrarAtividadesResposta;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornaAtividadeResponse;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornoConsultaAtividade;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.util.json.EloJsonUtils;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;

@EloService(value="srvConsultaGeoRest")
public class SrvConsultaGeoRest
extends EloLogger {
    @Value(value="${ws.FiltroAtividade:}")
    private String URI_FILTRAR;
    @Value(value="${ws.ConsultaAtividade:}")
    private String URI_CONSULTAR;
    @Resource
    private SrvUsuario srvUsuario;
    @Resource
    private RepositoryConsultaGeoRestLog repositoryConsultaGeoRestLog;

    public void setRepositoryConsultaGeoRestLog(RepositoryConsultaGeoRestLog repositoryConsultaGeoRestLog) {
        this.repositoryConsultaGeoRestLog = repositoryConsultaGeoRestLog;
    }

    private void saveConsultaGeoRestLog(ConsultaGeoRestLogEntity consultaGeoRestLog, String response) {
        consultaGeoRestLog.setDataHoraResponse(new Date());
        consultaGeoRestLog.setResponse(response);
        this.repositoryConsultaGeoRestLog.saveOrUpdate(consultaGeoRestLog);
        this.repositoryConsultaGeoRestLog.flush();
    }

    public FiltrarAtividadesResposta getAtividadeGeo(String filtro) throws IOException, URISyntaxException, IntegracaoGeoException {
        URIBuilder uri = new URIBuilder(this.URI_FILTRAR).addParameter("filtro", filtro);
        this.logger.info((Object)String.format("Request Geo url: %s", uri.toString()));
        Date requestStart = new Date();
        UsuarioEntity usuarioAutenticado = this.srvUsuario.getUsuarioAutenticado();
        ConsultaGeoRestLogEntity consultaGeoRestLog = new ConsultaGeoRestLogEntity();
        consultaGeoRestLog.setId(this.repositoryConsultaGeoRestLog.getSequence());
        consultaGeoRestLog.setUrlRequest(uri.toString());
        consultaGeoRestLog.setDataHoraRequest(requestStart);
        Optional.ofNullable(usuarioAutenticado).map(UsuarioEntity::getUsuario).ifPresent(arg_0 -> ((ConsultaGeoRestLogEntity)consultaGeoRestLog).setUsuario(arg_0));
        try {
            RestRequestService rest = new RestRequestService();
            HttpHeaders headers = new HttpHeaders();
            headers.add("Accept", "application/json");
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = rest.getWithHeaders(uri.toString(), httpEntity, String.class);
            this.saveConsultaGeoRestLog(consultaGeoRestLog, (String)response.getBody());
            FiltrarAtividadesResposta filtrarAtividadesResposta = this.montarListaAtividades((String)response.getBody());
            if (EloListUtils.safeIsEmpty((List)filtrarAtividadesResposta.getAtividades()).booleanValue()) {
                throw new IntegracaoGeoException("Nenhuma atividade encontrada.");
            }
            if (filtrarAtividadesResposta.getAtividades().size() != 1) {
                throw new IntegracaoGeoException("Busca inv\u00e1lida, mais de um resultado para mesmo CNAE.");
            }
            return filtrarAtividadesResposta;
        }
        catch (Exception e) {
            boolean httpError = e instanceof HttpClientErrorException || e instanceof HttpServerErrorException;
            String response = httpError ? ((HttpStatusCodeException)e).getResponseBodyAsString() : AlvaraObjectMapper.getInstance().writeValueAsString((Object)e);
            this.saveConsultaGeoRestLog(consultaGeoRestLog, response);
            ArrayList<String> mensagemDeErro = new ArrayList<String>();
            mensagemDeErro.add("Erro ao filtrar atividades no GEO");
            mensagemDeErro.add(e.getMessage());
            if (httpError) {
                ErroConsultaGeo dto = (ErroConsultaGeo)EloJsonUtils.fromJson((String)response, ErroConsultaGeo.class);
                Optional.ofNullable(dto.getErro()).map(ErroGeo::getMensagem).filter(mensagem -> !EloStringUtils.isEmpty((String)mensagem)).ifPresent(mensagemDeErro::add);
            }
            String erro = String.join((CharSequence)" - ", mensagemDeErro);
            this.logger.error((Object)erro, (Throwable)e);
            throw new IntegracaoGeoException(erro, (Throwable)e);
        }
    }

    public RetornaAtividadeResponse getConsultarAtividade(ConsultaAtividadeEnvioNovoGeo consultaAtividadeEnvio) throws URISyntaxException, IntegracaoGeoException, IOException {
        URIBuilder uri = new URIBuilder(this.URI_CONSULTAR).addParameter("atividadeId", consultaAtividadeEnvio.getAtividadeId()).addParameter("cadastroImobiliario", consultaAtividadeEnvio.getCadastroImobiliario()).addParameter("codigoLogradouro", consultaAtividadeEnvio.getCodigoLogradouro());
        this.logger.info((Object)String.format("Request Geo url: %s", uri.toString()));
        Date requestStart = new Date();
        UsuarioEntity usuarioAutenticado = this.srvUsuario.getUsuarioAutenticado();
        ConsultaGeoRestLogEntity consultaGeoRestLog = new ConsultaGeoRestLogEntity();
        consultaGeoRestLog.setId(this.repositoryConsultaGeoRestLog.getSequence());
        consultaGeoRestLog.setUrlRequest(uri.toString());
        consultaGeoRestLog.setDataHoraRequest(requestStart);
        Optional.ofNullable(usuarioAutenticado).map(UsuarioEntity::getUsuario).ifPresent(arg_0 -> ((ConsultaGeoRestLogEntity)consultaGeoRestLog).setUsuario(arg_0));
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Accept", "application/json");
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = new RestRequestService().getWithHeaders(uri.toString(), httpEntity, String.class);
            this.saveConsultaGeoRestLog(consultaGeoRestLog, (String)response.getBody());
            RetornoConsultaAtividade retornoConsultaAtividade = (RetornoConsultaAtividade)EloJsonUtils.fromJson((String)((String)response.getBody()), RetornoConsultaAtividade.class);
            RetornaAtividadeResponse retornaAtividadeResponse = new RetornaAtividadeResponse();
            retornaAtividadeResponse.setRetornoConsultaAtividade(retornoConsultaAtividade);
            return retornaAtividadeResponse;
        }
        catch (HttpClientErrorException hcee) {
            this.saveConsultaGeoRestLog(consultaGeoRestLog, hcee.getResponseBodyAsString());
            if (HttpStatus.NOT_FOUND.equals((Object)hcee.getStatusCode())) {
                this.logger.error((Object)String.format("Request ID: %d, X-REQUEST-ID: %s - Status: %s -- Erro: Cadastro Imobili\u00e1rio Inv\u00e1lido", consultaGeoRestLog.getId(), this.recuperarIdErro(hcee), hcee.getStatusCode().toString()));
                throw new IntegracaoGeoException("Houve uma falha ao consultar o GEO. Cadastro Imobili\u00e1rio inv\u00e1lido.", (Throwable)hcee);
            }
            if (HttpStatus.INTERNAL_SERVER_ERROR.equals((Object)hcee.getStatusCode())) {
                this.logger.error((Object)String.format("Request ID: %d, X-REQUEST-ID: %s - Status: %s -- Erro: Falha ao consultar servi\u00e7o do GEO.", consultaGeoRestLog.getId(), this.recuperarIdErro(hcee), hcee.getStatusCode().toString()));
                throw new IntegracaoGeoException("Houve uma falha ao consultar o GEO.", (Throwable)hcee);
            }
            if (HttpStatus.BAD_REQUEST.equals((Object)hcee.getStatusCode())) {
                this.logger.error((Object)String.format("Request ID: %d, X-REQUEST-ID: %s - Status: %s -- Erro: Falha ao consultar servi\u00e7o do GEO. Consulta inv\u00e1lida.", consultaGeoRestLog.getId(), this.recuperarIdErro(hcee), hcee.getStatusCode().toString()));
                throw new IntegracaoGeoException("Houve uma falha ao consultar o GEO. Consulta inv\u00e1lida.", (Throwable)hcee);
            }
            this.logger.error((Object)String.format("Request ID: %d, X-REQUEST-ID: %s", consultaGeoRestLog.getId(), this.recuperarIdErro(hcee)));
            throw new IntegracaoGeoException(hcee.getMessage(), (Throwable)hcee);
        }
        catch (HttpServerErrorException e) {
            String response = e.getResponseBodyAsString();
            consultaGeoRestLog.setDataHoraResponse(new Date());
            this.saveConsultaGeoRestLog(consultaGeoRestLog, response);
            ArrayList<String> mensagemDeErro = new ArrayList<String>();
            mensagemDeErro.add("Erro ao consultar atividade no GEO");
            mensagemDeErro.add(e.getMessage());
            ErroConsultaGeo dto = (ErroConsultaGeo)EloJsonUtils.fromJson((String)response, ErroConsultaGeo.class);
            Optional.ofNullable(dto).map(ErroConsultaGeo::getErro).map(ErroGeo::getMensagem).filter(mensagem -> !EloStringUtils.isEmpty((String)mensagem)).ifPresent(mensagemDeErro::add);
            String erro = String.join((CharSequence)" - ", mensagemDeErro);
            this.logger.error((Object)erro, (Throwable)e);
            throw new IntegracaoGeoException(erro, (Throwable)e);
        }
        catch (Exception e) {
            consultaGeoRestLog.setDataHoraResponse(new Date());
            this.saveConsultaGeoRestLog(consultaGeoRestLog, AlvaraObjectMapper.getInstance().writeValueAsString((Object)e));
            this.logger.error((Object)("Erro ao consultar atividade no GEO - " + e.getMessage()), (Throwable)e);
            throw new IntegracaoGeoException(e.getMessage(), (Throwable)e);
        }
    }

    private FiltrarAtividadesResposta montarListaAtividades(String json) {
        return (FiltrarAtividadesResposta)EloJsonUtils.fromJson((String)json, FiltrarAtividadesResposta.class);
    }

    private String recuperarIdErro(HttpClientErrorException hcee) {
        List header = Optional.ofNullable(hcee.getResponseHeaders()).map(httpHeaders -> httpHeaders.get((Object)"X-REQUEST-ID")).orElse(new ArrayList());
        if (!EloListUtils.safeIsEmpty((List)header).booleanValue()) {
            return (String)header.get(0);
        }
        return null;
    }
}

