/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.ExigenciaEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoExigidoEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ProibicaoAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.ProibicaoEntity;
import br.com.elotech.portalarrecadacao.domain.ScriptAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.TipoExigenciaEntity;
import br.com.elotech.portalarrecadacao.domain.ZoneamentoPermitidoEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaAtividadeVo;
import br.com.elotech.portalarrecadacao.dto.RespostaScriptZoneamentoLocacionalDTO;
import br.com.elotech.portalarrecadacao.dto.ZoneamentoPermitidoDTO;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoScriptAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.ValidaEixoZoneamentoPontoReferenciaTipoInscricao;
import br.com.elotech.portalarrecadacao.exception.AnexoRedeSimNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoConfiguradaException;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoPermitidaException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoExigido;
import br.com.elotech.portalarrecadacao.repository.RepositoryProibicaoAtividade;
import br.com.elotech.portalarrecadacao.repository.RepositoryScriptAlvara;
import br.com.elotech.portalarrecadacao.service.SrvConsultaAtividadeSemGeo;
import br.com.elotech.portalarrecadacao.service.impl.SrvConsultaAtividadeImpl;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornaAtividadeResponse;
import br.com.elotech.tributacao.domain.aise.AtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroRestricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.EixoEntity;
import br.com.elotech.tributacao.domain.aise.RhCboEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.TipoAtividadeEnum;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.util.list.EloListUtils;
import groovy.lang.GroovyShell;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;

public class SrvConsultaAtividadeSemGeoImpl
extends SrvConsultaAtividadeImpl
implements SrvConsultaAtividadeSemGeo {
    protected ConsultaAtividadeVo consultaAtividadeVo;
    @Resource
    private RepositoryConfiguracaoAtividade repositoryConfiguracaoAtividade;
    @Resource
    private RepositoryLaudoExigido repositoryLaudoExigido;
    @Resource
    private RepositoryProibicaoAtividade repositoryProibicaoAtividade;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;
    @Resource
    private RepositoryScriptAlvara repositoryScriptAlvara;
    private static final GroovyShell SHELL = new GroovyShell();

    public void setConsultaAtividadeVo(ConsultaAtividadeVo consultaAtividadeVo) {
        this.consultaAtividadeVo = consultaAtividadeVo;
    }

    public RetornaAtividadeResponse consultar() throws BaseException {
        Atividade atividadeSelecionada;
        ConfiguracaoAtividadeEntity configuracaoAtividade;
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE}) && Objects.nonNull(configuracaoAtividade = this.carregarConfiguracaoAtividade(atividadeSelecionada = this.consultaAtividadeVo.getAtividadeSelecionada()))) {
            this.validarEixoZoneamento(configuracaoAtividade, atividadeSelecionada);
            this.adicionarAtividade(atividadeSelecionada);
        }
        return null;
    }

    public Boolean isPemitiValidarEixoZoneamento() throws BaseException {
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().isPossuiPontoReferencia()) {
            ParametroAlvaraEntity param = this.getParametroAlvara(ParametroAlvaraEnum.VALIDA_EIXOZONEAMENTO_PONTOREFERENCIA_TIPOINSCRICAO);
            if (ValidaEixoZoneamentoPontoReferenciaTipoInscricao.NENHUM.getValor().equals(param.getValor())) {
                return Boolean.FALSE;
            }
            if (ValidaEixoZoneamentoPontoReferenciaTipoInscricao.AMBOS.getValor().equals(param.getValor())) {
                return Boolean.TRUE;
            }
            if (this.consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoJuridicaNormal()) {
                return ValidaEixoZoneamentoPontoReferenciaTipoInscricao.PESSOAJURIDICA.getValor().equals(param.getValor());
            }
            if (this.consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoMEI()) {
                return ValidaEixoZoneamentoPontoReferenciaTipoInscricao.MEI.getValor().equals(param.getValor());
            }
        }
        return Boolean.TRUE;
    }

    public void validarZoneamentoPermitido(ConfiguracaoAtividadeEntity configuracaoAtividade, Atividade atividade) throws BaseException {
        CadastroImobiliarioTestadaEntity testadaPrincipal;
        SolicitacaoAlvaraEntity solicitacaoAlvara = this.consultaAtividadeVo.getSolicitacaoAlvara();
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.repositoryConsultaRedeSim.getConsultaByTipo(solicitacaoAlvara.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.CONSULTA);
        ScriptAlvaraEntity scriptAlvaraZoneamentoLocacional = this.repositoryScriptAlvara.findByTipo(TipoScriptAlvaraEnum.ZONEAMENTO_LOCACIONAL);
        ZoneamentoPermitidoEntity zoneamentoPermitidoEntity = null;
        ParametroAlvaraEntity parametroAlvara = this.getParametroAlvara(ParametroAlvaraEnum.EMAILSETORCADASTROALVARA);
        if (!solicitacaoRedeSim.isRuralArquivoConsulta() && Objects.isNull(zoneamentoPermitidoEntity = this.repositoryConfiguracaoAtividade.carregarZoneamentoPermitido(testadaPrincipal = solicitacaoAlvara.getCadastroImobiliario().getTestadaPrincipal(), configuracaoAtividade)) && Objects.isNull(scriptAlvaraZoneamentoLocacional)) {
            throw new AtividadeNaoPermitidaException(String.format("Atividade %s n\u00e3o \u00e9 permitida no local informado. Caso possua Certid\u00e3o de Uso de Solo, Alvar\u00e1 Anterior ou Permiss\u00e3o para exercer este CNAE neste local, realizar nova consulta pr\u00e9via, anexando o documento no preenchimento da solicita\u00e7\u00e3o para nova an\u00e1lise. Para mais informa\u00e7\u00f5es entrar em contato atrav\u00e9s do endere\u00e7o: %s", atividade.getDescricao(), parametroAlvara.getValor()));
        }
        this.validateZoneamentoLocacionalPorScriptAlvara(solicitacaoAlvara, zoneamentoPermitidoEntity, parametroAlvara, atividade, scriptAlvaraZoneamentoLocacional);
        atividade.setSomenteEscritorio(this.consultaAtividadeVo.getOpcaoSomenteEscritorio() ? SimNaoEnum.getSimShortText() : SimNaoEnum.getNaoShortText());
    }

    public void validarEixoPermitido(ConfiguracaoAtividadeEntity configuracaoAtividade, Atividade atividade) throws BaseException {
        EixoEntity eixo = this.consultaAtividadeVo.getSolicitacaoAlvara().getEixo();
        if (!this.repositoryConfiguracaoAtividade.isEixoPermitido(eixo, configuracaoAtividade)) {
            throw new AtividadeNaoPermitidaException(String.format("Atividade %s n\u00e3o permitida no eixo.", atividade.getDescricao()));
        }
    }

    public void carregarTabelaAtividadesAtuais() throws BaseException {
    }

    protected void adicionarAtividade(Atividade atividade) {
        this.consultaAtividadeVo.getListaAtiv().add(this.consultaAtividadeVo.getAtividadeSelecionada());
        this.consultaAtividadeVo.setCodigoAtividade("");
    }

    public boolean verificarExisteRestricaoResponsavelTec(SolicitacaoAlvaraEntity solicitacao, ArrayList<CadastroRestricaoAlvaraEntity> listaCadastroRestricaoAlvara, StringBuilder textoRestricaoBuilder) throws BaseException {
        return false;
    }

    public void carregaExigenciasProibicaoNaSolicitacao(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraAtividadeEntity> listaSolicitacaoAtividades) throws BaseException {
        ArrayList exigencias = new ArrayList();
        ArrayList proibicoesAtividades = new ArrayList();
        for (SolicitacaoAlvaraAtividadeEntity atividade : listaSolicitacaoAtividades) {
            ConfiguracaoAtividadeEntity configuracaoAtividade = this.getConfiguracaoAtividade(atividade);
            if (configuracaoAtividade == null) continue;
            exigencias.addAll(this.repositoryConfiguracaoAtividade.recuperarExigencias(configuracaoAtividade));
            proibicoesAtividades.addAll(this.repositoryProibicaoAtividade.carregarProibicoesAtividade(configuracaoAtividade));
        }
        this.atribuirExigenciasNaSolicitacao(solicitacao, exigencias);
        this.atribuirProibicoesNaSolicitacao(solicitacao, proibicoesAtividades);
    }

    public Integer retornaMaiorCodigoISSQN(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        throw new SolicitacaoAlvaraException("N\u00e3o existe implementa\u00e7\u00e3o para verifica\u00e7\u00e3o do maior codigo ISSQN sem GEO");
    }

    public void carregaGrauRiscoDaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
    }

    public void executaVerificacaoLaudoExigido(SolicitacaoAlvaraEntity solicitacaoAlvara, Set<LaudoExigidoEntity> listaLaudoExigido, SolicitacaoAlvaraAtividadeEntity atividade) throws BaseException {
        List laudosExigidos;
        if (listaLaudoExigido == null) {
            listaLaudoExigido = new HashSet<LaudoExigidoEntity>();
        }
        if (!EloListUtils.safeIsEmpty((List)(laudosExigidos = this.repositoryLaudoExigido.getLaudoPorAtividade(solicitacaoAlvara.getSolicitacaoAlvaraAtividades()))).booleanValue()) {
            listaLaudoExigido.addAll(laudosExigidos);
        }
    }

    public void validaAtividadeNaoPermitida(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
    }

    private ConfiguracaoAtividadeEntity carregarConfiguracaoAtividade(Atividade atividade) throws BaseException {
        ConfiguracaoAtividadeEntity configuracaoAtividade = null;
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoMEI()) {
            if (this.consultaAtividadeVo.getSolicitacaoAlvara().getClassificacaoTipoInscricao() != null && this.consultaAtividadeVo.getSolicitacaoAlvara().getClassificacaoTipoInscricao().isPrestadorServico() && !this.isValidarAtividadeParaPrestador()) {
                this.adicionarAtividade(atividade);
                return null;
            }
            AtividadeMeiEntity atividadeMei = (AtividadeMeiEntity)atividade;
            configuracaoAtividade = this.repositoryConfiguracaoAtividade.getConfiguracaoAtividadeByidAtividade(atividadeMei.getAtividadeMei(), TipoAtividadeEnum.MEI);
        }
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoJuridicaNormal()) {
            CnaeEntity cnae = (CnaeEntity)atividade;
            configuracaoAtividade = this.repositoryConfiguracaoAtividade.getConfiguracaoAtividadeByidAtividade(cnae.getId(), TipoAtividadeEnum.CNAE);
        }
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoCBO()) {
            RhCboEntity cbo = (RhCboEntity)atividade;
            configuracaoAtividade = this.repositoryConfiguracaoAtividade.getConfiguracaoAtividadeByidAtividade(cbo.getId(), TipoAtividadeEnum.CBO);
        }
        if (Objects.isNull(configuracaoAtividade)) {
            throw new AtividadeNaoConfiguradaException(String.format("Atividade n\u00e3o est\u00e1 configurada na tabela de Configura\u00e7\u00f5es Atividades", new Object[0]));
        }
        return configuracaoAtividade;
    }

    private void validarEixoZoneamento(ConfiguracaoAtividadeEntity configuracaoAtividade, Atividade atividade) throws BaseException {
        if (Boolean.FALSE.equals(this.isPemitiValidarEixoZoneamento())) {
            return;
        }
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().isPossuiEixoNaTestada()) {
            this.validarEixoPermitido(configuracaoAtividade, atividade);
            return;
        }
        this.validarZoneamentoPermitido(configuracaoAtividade, atividade);
    }

    private ConfiguracaoAtividadeEntity getConfiguracaoAtividade(SolicitacaoAlvaraAtividadeEntity atividade) {
        if (atividade.getCnae() != null) {
            return atividade.getCnae().getIdConfiguracaoAtividade();
        }
        if (atividade.getSequenciaCbo() != null) {
            return atividade.getSequenciaCbo().getIdConfiguracaoAtividade();
        }
        return atividade.getAtividadeMei().getIdConfiguracaoAtividade();
    }

    private void atribuirExigenciasNaSolicitacao(SolicitacaoAlvaraEntity solicitacao, List<ExigenciaEntity> exigencias) {
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<TipoExigenciaEntity> tipos = new LinkedHashSet<TipoExigenciaEntity>();
        for (ExigenciaEntity ex : exigencias) {
            tipos.add(ex.getTipoExigencia());
        }
        for (TipoExigenciaEntity tipo : tipos) {
            sb.append(tipo.getDescricao()).append("; ");
        }
        solicitacao.setExigencias(sb.toString().contains(";") ? sb.substring(0, sb.length() - 2) : sb.toString());
    }

    private void atribuirProibicoesNaSolicitacao(SolicitacaoAlvaraEntity solicitacao, List<ProibicaoAtividadeEntity> proibicoesAtividades) {
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<ProibicaoEntity> proibicoes = new LinkedHashSet<ProibicaoEntity>();
        for (ProibicaoAtividadeEntity ex : proibicoesAtividades) {
            proibicoes.add(ex.getId().getProibicao());
        }
        for (ProibicaoEntity tipo : proibicoes) {
            sb.append(tipo.getDescricao()).append("; ");
        }
        solicitacao.setProibicao(sb.toString().contains(";") ? sb.substring(0, sb.length() - 2) : sb.toString());
    }

    private boolean isValidarAtividadeParaPrestador() throws BaseException {
        ParametroAlvaraEntity parametro = this.getParametroAlvara(ParametroAlvaraEnum.VERIFICA_ATIVIDADE_MEI_PRESTADORSERVICO);
        return parametro.getValor().equals(SimNaoEnum.SIM.getShortText()) ? Boolean.TRUE : Boolean.FALSE;
    }

    private void validateZoneamentoLocacionalPorScriptAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara, ZoneamentoPermitidoEntity zoneamentoPermitido, ParametroAlvaraEntity parametroAlvara, Atividade atividade, ScriptAlvaraEntity scriptAlvaraZoneamentoLocacional) throws AtividadeNaoPermitidaException, AnexoRedeSimNaoEncontradoException {
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.repositoryConsultaRedeSim.getConsultaByTipo(solicitacaoAlvara.getProtocoloRedeSim(), TipoSolicitacaoRedeSimEnum.CONSULTA);
        if (Objects.nonNull(scriptAlvaraZoneamentoLocacional) && Objects.nonNull(solicitacaoRedeSim)) {
            SHELL.getContext().setVariable("scriptZoneamento", (Object)SHELL.parse(scriptAlvaraZoneamentoLocacional.getCodigoFonte()));
            SHELL.getContext().setVariable("consultaPreviaJson", (Object)solicitacaoRedeSim.getArquivoConsulta());
            SHELL.getContext().setVariable("zoneamentoPermitido", (Object)ZoneamentoPermitidoDTO.from((ZoneamentoPermitidoEntity)zoneamentoPermitido, (Atividade)atividade));
            Object[] respostaScript = (Object[])SHELL.evaluate("scriptZoneamento.validateZoneamento(consultaPreviaJson, zoneamentoPermitido)");
            RespostaScriptZoneamentoLocacionalDTO respostaZoneamentoRedeSim = new RespostaScriptZoneamentoLocacionalDTO();
            respostaZoneamentoRedeSim.setTipo(SituacaoConsultaPreviaRedeSimEnum.valueOf((String)respostaScript[0].toString()));
            Optional.ofNullable(respostaScript[1]).ifPresent(motivo -> respostaZoneamentoRedeSim.setMotivo(motivo.toString()));
            if (respostaZoneamentoRedeSim.getTipo().equals((Object)SituacaoConsultaPreviaRedeSimEnum.INDEFERIDO)) {
                throw new AtividadeNaoPermitidaException(String.format("Atividade %s n\u00e3o \u00e9 permitida devido a valida\u00e7\u00e3o locacional. %s. Para mais informa\u00e7\u00f5es entrar em contato atrav\u00e9s do endere\u00e7o: %s", atividade.getDescricao(), respostaZoneamentoRedeSim.getMotivo(), parametroAlvara.getValor()));
            }
            if (respostaZoneamentoRedeSim.getTipo().equals((Object)SituacaoConsultaPreviaRedeSimEnum.ANALISE)) {
                throw new AnexoRedeSimNaoEncontradoException(String.format("Atividade %s foi encaminhada para an\u00e1lise do Departamento de Urbanismo. Os documentos anexos ser\u00e3o analisados e em breve sua solicita\u00e7\u00e3o ser\u00e1 respondida.", atividade.getDescricao()));
            }
        }
    }
}

