/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.LaudoExigidoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaAtividadeVo;
import br.com.elotech.portalarrecadacao.enumerator.GrauDeRiscoEnum;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoPermitidaException;
import br.com.elotech.portalarrecadacao.exception.ConsultaAtividadeException;
import br.com.elotech.portalarrecadacao.exception.IntegracaoGeoException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryCadastroRestricaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraAtividade;
import br.com.elotech.portalarrecadacao.repository.RepositoryTipoLaudo;
import br.com.elotech.portalarrecadacao.service.SrvConsultaAtividade;
import br.com.elotech.portalarrecadacao.service.SrvVerificaExigenciaCnae;
import br.com.elotech.portalarrecadacao.service.impl.SrvConsultaAtividadeImpl;
import br.com.elotech.portalarrecadacao.service.impl.SrvConsultaGeoRest;
import br.com.elotech.portalarrecadacao.service.impl.SrvVerificaExigenciaCnaeImpl;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ConsultaAtividadeEnvioNovoGeo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.DecisaoGeo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.EixoGeo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ExigenciaGeo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.FiltrarAtividadesResposta;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ObservacaoGeo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.PermissaoGeo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornaAtividadeResponse;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornoConsultaAtividade;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ZonaGeo;
import br.com.elotech.tributacao.domain.aise.AtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroRestricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.enumerator.TipoLaudoEnum;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.tributacao.repository.aise.RepositoryImobiliarioTestada;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="srvConsultaAtividadeNovoGeoImpl")
@Scope(value="prototype")
public class SrvConsultaAtividadeNovoGeoImpl
extends SrvConsultaAtividadeImpl
implements SrvConsultaAtividade {
    public static final String SERVICE_NAME = "srvConsultaAtividadeNovoGeoImpl";
    public static final String INCLUSAO = "I";
    public static final String QUEBRA_LINHA = "<br/>";
    private ConsultaAtividadeVo consultaAtividadeVo;
    @Resource
    private RepositorySolicitacaoAlvaraAtividade repositorySolicitacaoAlvaraAtividade;
    @Resource
    private RepositoryCadastroRestricaoAlvara repositoryCadastroRestricaoAlvara;
    @Resource
    private SrvVerificaExigenciaCnae srvVerificaExigenciaCnae;
    @Resource
    private RepositoryTipoLaudo repositoryTipoLaudo;
    @Resource
    private SrvConsultaGeoRest srvConsultaGeoRest;
    @Resource
    private RepositoryImobiliarioTestada repositoryImobiliarioTestada;

    public void setConsultaAtividadeVo(ConsultaAtividadeVo consultaAtividadeVo) {
        this.consultaAtividadeVo = consultaAtividadeVo;
    }

    public void setSrvVerificaExigenciaCnaeImpl(SrvVerificaExigenciaCnaeImpl srvVerificaExigenciaCnaeImpl) {
        this.srvVerificaExigenciaCnae = srvVerificaExigenciaCnaeImpl;
    }

    public void setSrvConsultaGeoRest(SrvConsultaGeoRest srvConsultaGeoRest) {
        this.srvConsultaGeoRest = srvConsultaGeoRest;
    }

    public void setRepositoryTipoLaudo(RepositoryTipoLaudo repositoryTipoLaudo) {
        this.repositoryTipoLaudo = repositoryTipoLaudo;
    }

    public void setRepositoryCadastroRestricaoAlvara(RepositoryCadastroRestricaoAlvara repositoryCadastroRestricaoAlvara) {
        this.repositoryCadastroRestricaoAlvara = repositoryCadastroRestricaoAlvara;
    }

    public void setRepositorySolicitacaoAlvaraAtividade(RepositorySolicitacaoAlvaraAtividade repositorySolicitacaoAlvaraAtividade) {
        this.repositorySolicitacaoAlvaraAtividade = repositorySolicitacaoAlvaraAtividade;
    }

    public void carregarTabelaAtividadesAtuais() throws BaseException {
    }

    public boolean verificarExisteRestricaoResponsavelTec(SolicitacaoAlvaraEntity solicitacao, ArrayList<CadastroRestricaoAlvaraEntity> listaCadastroRestricaoAlvara, StringBuilder textoRestricaoBuilder) {
        boolean possuiRestricao = false;
        List listaRetornoConsultaAtividade = this.consultarAtividades(solicitacao);
        if (this.possuiRestricaoRespTecVigilanciaSanitaria(listaRetornoConsultaAtividade)) {
            CadastroRestricaoAlvaraEntity cadastroRestricaoAlvara = this.repositoryCadastroRestricaoAlvara.carregaCadastroRestricaoAlvara(PortalUtils.getCodRestricaoresptecVigsanitaria());
            if (cadastroRestricaoAlvara != null) {
                cadastroRestricaoAlvara.setDescricao("Respons\u00e1vel T\u00e9cnico Vigil\u00e2ncia Sanit\u00e1ria ");
                listaCadastroRestricaoAlvara.add(cadastroRestricaoAlvara);
                if (cadastroRestricaoAlvara.isBloqueante()) {
                    textoRestricaoBuilder.append("Respons\u00e1vel T\u00e9cnico Vigil\u00e2ncia Sanit\u00e1ria ");
                    textoRestricaoBuilder.append(QUEBRA_LINHA);
                }
            }
            possuiRestricao = true;
        }
        return possuiRestricao;
    }

    private boolean possuiRestricaoRespTecVigilanciaSanitaria(List<RetornoConsultaAtividade> listaRetornoConsultaAtividade) {
        for (RetornoConsultaAtividade retornoConsulta : listaRetornoConsultaAtividade) {
            if (EloListUtils.safeIsEmpty((List)retornoConsulta.getAtividade().getExigencias()).booleanValue()) continue;
            return retornoConsulta.getAtividade().getExigencias().stream().anyMatch(ExigenciaGeo::isResponsavelTecnicoVigilanciaSanitaria);
        }
        return false;
    }

    private List<RetornoConsultaAtividade> consultarAtividades(SolicitacaoAlvaraEntity solicitacao) throws IntegracaoGeoException {
        List listaAtividade = this.repositorySolicitacaoAlvaraAtividade.carregaAtividadesBySolicitacao(solicitacao.getSolicitacaoAlvara());
        ArrayList<RetornoConsultaAtividade> listaRetornoConsultaAtividade = new ArrayList<RetornoConsultaAtividade>();
        if (solicitacao.isSolicitacaoMEINormal()) {
            List<SolicitacaoAlvaraAtividadeEntity> atividades = listaAtividade.stream().filter(EloListUtils.distinctByKey(p -> p.getAtividadeMei().getCnae().getCodigo())).collect(Collectors.toList());
            atividades.forEach(mei -> {
                try {
                    br.com.elotech.portalarrecadacao.ws.oxm.geo.Atividade atividade = (br.com.elotech.portalarrecadacao.ws.oxm.geo.Atividade)Optional.ofNullable(this.srvConsultaGeoRest.getAtividadeGeo(mei.getAtividadeMei().getCnae().getCodigo())).map(FiltrarAtividadesResposta::getAtividades).orElseThrow(() -> new SolicitacaoAlvaraException("Ocorreu uma falha na consulta do Geo Processamento: Erro ao obter atividades")).stream().findFirst().orElseThrow(() -> new SolicitacaoAlvaraException("Ocorreu uma falha na consulta do Geo Processamento: Erro ao obter atividade principal"));
                    ConsultaAtividadeEnvioNovoGeo envio = this.instanciarConsultaEnvio(atividade, solicitacao);
                    RetornaAtividadeResponse resposta = this.srvConsultaGeoRest.getConsultarAtividade(envio);
                    if (this.isSituacaoAtividadeInclusao(mei.getSituacao(), resposta)) {
                        listaRetornoConsultaAtividade.add(resposta.getRetornoConsultaAtividade());
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new IntegracaoGeoException(e.getMessage(), (Throwable)e);
                }
            });
        } else {
            listaAtividade.forEach(cnae -> {
                try {
                    br.com.elotech.portalarrecadacao.ws.oxm.geo.Atividade atividade = (br.com.elotech.portalarrecadacao.ws.oxm.geo.Atividade)Optional.ofNullable(this.srvConsultaGeoRest.getAtividadeGeo(cnae.getCnae().getCodigo())).map(FiltrarAtividadesResposta::getAtividades).orElseThrow(() -> new SolicitacaoAlvaraException("Ocorreu uma falha na consulta do Geo Processamento: Erro ao obter atividades")).stream().findFirst().orElseThrow(() -> new SolicitacaoAlvaraException("Ocorreu uma falha na consulta do Geo Processamento: Erro ao obter atividade principal"));
                    ConsultaAtividadeEnvioNovoGeo envio = this.instanciarConsultaEnvio(atividade, solicitacao);
                    RetornaAtividadeResponse resposta = this.srvConsultaGeoRest.getConsultarAtividade(envio);
                    if (this.isSituacaoAtividadeInclusao(cnae.getSituacao(), resposta)) {
                        listaRetornoConsultaAtividade.add(resposta.getRetornoConsultaAtividade());
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new IntegracaoGeoException(e.getMessage(), (Throwable)e);
                }
            });
        }
        return listaRetornoConsultaAtividade;
    }

    private boolean isSituacaoAtividadeInclusao(String situacao, RetornaAtividadeResponse resposta) {
        return Objects.nonNull(resposta) && Objects.nonNull(resposta.getRetornoConsultaAtividade()) && INCLUSAO.equals(situacao);
    }

    public void carregaExigenciasProibicaoNaSolicitacao(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraAtividadeEntity> listaSolicitacaoAtividades) throws BaseException {
        try {
            ArrayList listaRetornoConsultaAtividades = new ArrayList();
            if (EloListUtils.safeIsEmpty(listaSolicitacaoAtividades).booleanValue()) {
                listaSolicitacaoAtividades.addAll(this.prepararListaSolicitacaoAtividades(solicitacao));
            }
            this.preencherAtividadesGeo(solicitacao, listaSolicitacaoAtividades, listaRetornoConsultaAtividades);
            this.preencherProibicoes(solicitacao, listaRetornoConsultaAtividades);
            this.preencherExigencias(solicitacao, listaRetornoConsultaAtividades);
        }
        catch (IOException | URISyntaxException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IntegracaoGeoException("Houve um erro ao consultar o servi\u00e7o de Geo Processamento.", (Throwable)e);
        }
    }

    private void preencherExigencias(SolicitacaoAlvaraEntity solicitacao, List<RetornoConsultaAtividade> listaRetornoConsultaAtividades) {
        if (StringUtils.isBlank((CharSequence)solicitacao.getExigencias())) {
            solicitacao.setExigencias(this.srvVerificaExigenciaCnae.verificaExigenciasNovoGeo(listaRetornoConsultaAtividades));
        }
    }

    private void preencherAtividadesGeo(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraAtividadeEntity> listaSolicitacaoAtividades, List<RetornoConsultaAtividade> listaRetornoConsultaAtividades) throws IOException, URISyntaxException {
        if (Objects.isNull(solicitacao.getProibicao())) {
            for (SolicitacaoAlvaraAtividadeEntity solAlvaraAtividade : listaSolicitacaoAtividades) {
                FiltrarAtividadesResposta atividadeGeo = this.srvConsultaGeoRest.getAtividadeGeo(solAlvaraAtividade.getCnae().getCodigo());
                br.com.elotech.portalarrecadacao.ws.oxm.geo.Atividade atividade = (br.com.elotech.portalarrecadacao.ws.oxm.geo.Atividade)atividadeGeo.getAtividades().get(0);
                ConsultaAtividadeEnvioNovoGeo envio = this.instanciarConsultaEnvio(atividade, solicitacao);
                RetornaAtividadeResponse retornaAtividadeResponse = this.srvConsultaGeoRest.getConsultarAtividade(envio);
                listaRetornoConsultaAtividades.add(retornaAtividadeResponse.getRetornoConsultaAtividade());
            }
        }
    }

    private void preencherProibicoes(SolicitacaoAlvaraEntity solicitacao, List<RetornoConsultaAtividade> listaRetornoConsultaAtividades) {
        ArrayList listaProibicao = new ArrayList();
        for (RetornoConsultaAtividade retornoConsultaAtividade : listaRetornoConsultaAtividades) {
            Optional.ofNullable(retornoConsultaAtividade.getDecisao()).map(DecisaoGeo::getObservacao).filter(Objects::nonNull).map(ObservacaoGeo::getDescricao).filter(descricao -> !EloStringUtils.isEmpty((String)descricao)).filter(descricao -> listaProibicao.stream().noneMatch(descricao::equalsIgnoreCase)).ifPresent(listaProibicao::add);
            Optional.ofNullable(retornoConsultaAtividade.getMotivosProibicao()).filter(motivos -> !EloStringUtils.isEmpty((String)motivos)).filter(motivos -> listaProibicao.stream().noneMatch(motivos::equalsIgnoreCase)).ifPresent(listaProibicao::add);
        }
        if (!listaProibicao.isEmpty()) {
            solicitacao.setProibicao(String.join((CharSequence)QUEBRA_LINHA, listaProibicao));
        }
    }

    public Integer retornaMaiorCodigoISSQN(SolicitacaoAlvaraEntity solicitacao) {
        return null;
    }

    public void carregaGrauRiscoDaSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
    }

    public void executaVerificacaoLaudoExigido(SolicitacaoAlvaraEntity solicitacaoAlvara, Set<LaudoExigidoEntity> listaLaudoExigido, SolicitacaoAlvaraAtividadeEntity atividade) throws BaseException {
        try {
            if (solicitacaoAlvara.isSolicitacaoMEINormal() && Objects.isNull(solicitacaoAlvara.carregarCadastroImobiliario())) {
                return;
            }
            br.com.elotech.portalarrecadacao.ws.oxm.geo.Atividade atividadeGeo = this.defineAtividadeGeoSeMeiNormal(solicitacaoAlvara, atividade);
            ConsultaAtividadeEnvioNovoGeo envio = this.instanciarConsultaEnvio(atividadeGeo, solicitacaoAlvara);
            RetornaAtividadeResponse resposta = this.srvConsultaGeoRest.getConsultarAtividade(envio);
            this.carregaCodigoTaxa(solicitacaoAlvara, resposta);
            listaLaudoExigido.addAll(this.verificaLaudoExigido(resposta));
            this.carregaGrauRiscoDaSolicitacao(solicitacaoAlvara, resposta);
        }
        catch (IOException | URISyntaxException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IntegracaoGeoException(e.getMessage(), (Throwable)e);
        }
    }

    private br.com.elotech.portalarrecadacao.ws.oxm.geo.Atividade defineAtividadeGeoSeMeiNormal(SolicitacaoAlvaraEntity solicitacaoAlvara, SolicitacaoAlvaraAtividadeEntity atividade) throws IOException, URISyntaxException {
        if (solicitacaoAlvara.isSolicitacaoMEINormal()) {
            return this.srvConsultaGeoRest.getAtividadeGeo(atividade.getAtividadeMei().getCnae().getCodigo()).getAtividadeSelecionada();
        }
        return this.srvConsultaGeoRest.getAtividadeGeo(atividade.getCnae().getCodigo()).getAtividadeSelecionada();
    }

    private void carregaGrauRiscoDaSolicitacao(SolicitacaoAlvaraEntity solicitacaoAlvara, RetornaAtividadeResponse resposta) {
        if (GrauDeRiscoEnum.RISCO_ALTO.getSigla().equals(resposta.getRetornoConsultaAtividade().getAtividade().getGrauDeRisco())) {
            solicitacaoAlvara.setGrauRisco(resposta.getRetornoConsultaAtividade().getAtividade().getGrauDeRisco());
        }
    }

    private List<LaudoExigidoEntity> verificaLaudoExigido(RetornaAtividadeResponse resposta) {
        LaudoExigidoEntity laudoExigido;
        ArrayList<LaudoExigidoEntity> listaLaudoExigido = new ArrayList<LaudoExigidoEntity>();
        if (resposta.possuiLaudoAmbiental()) {
            TipoLaudoEntity tipoLaudoAmbiental = this.repositoryTipoLaudo.getTipoLaudoPorId(TipoLaudoEnum.AMBIENTAL.getCodigo());
            laudoExigido = new LaudoExigidoEntity();
            laudoExigido.setTipoLaudo(tipoLaudoAmbiental);
            if (!this.existeTipoLaudoNaLista(laudoExigido.getTipoLaudo(), listaLaudoExigido)) {
                listaLaudoExigido.add(laudoExigido);
            }
        }
        if (resposta.possuiLaudoBombeiro()) {
            TipoLaudoEntity tipoLaudoBombeiro = this.repositoryTipoLaudo.getTipoLaudoPorId(TipoLaudoEnum.BOMBEIRO.getCodigo());
            laudoExigido = new LaudoExigidoEntity();
            laudoExigido.setTipoLaudo(tipoLaudoBombeiro);
            if (!this.existeTipoLaudoNaLista(laudoExigido.getTipoLaudo(), listaLaudoExigido)) {
                listaLaudoExigido.add(laudoExigido);
            }
        }
        if (resposta.possuiLaudoPostura()) {
            TipoLaudoEntity tipoLaudoPostura = this.repositoryTipoLaudo.getTipoLaudoPorId(TipoLaudoEnum.POSTURA.getCodigo());
            laudoExigido = new LaudoExigidoEntity();
            laudoExigido.setTipoLaudo(tipoLaudoPostura);
            if (!this.existeTipoLaudoNaLista(laudoExigido.getTipoLaudo(), listaLaudoExigido)) {
                listaLaudoExigido.add(laudoExigido);
            }
        }
        if (resposta.possuiLaudoTransporte()) {
            TipoLaudoEntity tipoLaudoTransporte = this.repositoryTipoLaudo.getTipoLaudoPorId(TipoLaudoEnum.TRANSPORTE.getCodigo());
            laudoExigido = new LaudoExigidoEntity();
            laudoExigido.setTipoLaudo(tipoLaudoTransporte);
            if (!this.existeTipoLaudoNaLista(laudoExigido.getTipoLaudo(), listaLaudoExigido)) {
                listaLaudoExigido.add(laudoExigido);
            }
        }
        if (resposta.possuiLaudoVigSanitaria()) {
            TipoLaudoEntity tipoLaudoVigSanitaria = this.repositoryTipoLaudo.getTipoLaudoPorId(TipoLaudoEnum.VIGILANCIA_SANITARIA.getCodigo());
            laudoExigido = new LaudoExigidoEntity();
            laudoExigido.setTipoLaudo(tipoLaudoVigSanitaria);
            if (!this.existeTipoLaudoNaLista(laudoExigido.getTipoLaudo(), listaLaudoExigido)) {
                listaLaudoExigido.add(laudoExigido);
            }
        }
        return listaLaudoExigido;
    }

    private void carregaCodigoTaxa(SolicitacaoAlvaraEntity solicitacaoAlvara, RetornaAtividadeResponse resposta) {
        if (solicitacaoAlvara.getTaxaLocalizacao() == null) {
            solicitacaoAlvara.setTaxaLocalizacao(resposta.getRetornoConsultaAtividade().getAtividade().getCodigoDeTaxa());
        } else if (resposta.getRetornoConsultaAtividade().getAtividade().getCodigoDeTaxa() > solicitacaoAlvara.getTaxaLocalizacao()) {
            solicitacaoAlvara.setTaxaLocalizacao(resposta.getRetornoConsultaAtividade().getAtividade().getCodigoDeTaxa());
        }
    }

    public void validaAtividadeNaoPermitida(SolicitacaoAlvaraEntity solicitacaoAlvara) {
    }

    public RetornaAtividadeResponse consultar() throws BaseException {
        try {
            if (this.consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoJuridicaNormal() || this.consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoMEINormal()) {
                RetornaAtividadeResponse retornaAtividadeResponse = this.getRetornaAtividadeResponse();
                this.validaPermissaoAtividade(retornaAtividadeResponse);
                this.validaRespostaGeo(retornaAtividadeResponse.getRetornoConsultaAtividade());
                return retornaAtividadeResponse;
            }
            return null;
        }
        catch (IntegracaoGeoException ige) {
            this.logger.error((Object)ige.getMessage(), (Throwable)ige);
            throw ige;
        }
        catch (IOException | URISyntaxException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new IntegracaoGeoException(e.getMessage());
        }
    }

    private void validaPermissaoAtividade(RetornaAtividadeResponse retornaAtividadeResponse) throws SolicitacaoAlvaraException {
        if (retornaAtividadeResponse.getRetornoConsultaAtividade().isAtividadePermitida()) {
            this.verificarAtividade(retornaAtividadeResponse.getRetornoConsultaAtividade());
        } else {
            this.consultaAtividadeVo.getAtividadeSelecionada().setAtividadeNaoPermitida(true);
            if (Optional.ofNullable(retornaAtividadeResponse.getRetornoConsultaAtividade().getMapa()).isPresent()) {
                this.consultaAtividadeVo.setMapaRetornoConsulta(retornaAtividadeResponse.getRetornoConsultaAtividade().getMapa());
            }
        }
    }

    private RetornaAtividadeResponse getRetornaAtividadeResponse() throws IOException, URISyntaxException {
        br.com.elotech.portalarrecadacao.ws.oxm.geo.Atividade atividade = (br.com.elotech.portalarrecadacao.ws.oxm.geo.Atividade)this.srvConsultaGeoRest.getAtividadeGeo(this.consultaAtividadeVo.getAtividadeSelecionada().getCodigo()).getAtividades().get(0);
        ConsultaAtividadeEnvioNovoGeo consultaAtividadeEnvio = this.instanciarConsultaEnvio(atividade);
        return this.srvConsultaGeoRest.getConsultarAtividade(consultaAtividadeEnvio);
    }

    private void verificarAtividade(RetornoConsultaAtividade retorno) throws SolicitacaoAlvaraException {
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().getEixoGeo() == null && !EloListUtils.safeIsEmpty((List)retorno.getEixos()).booleanValue()) {
            this.consultaAtividadeVo.getSolicitacaoAlvara().setEixoGeo(this.preencherEixosGeo(retorno));
        }
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().getZonaGeo() == null && !EloListUtils.safeIsEmpty((List)retorno.getZonas()).booleanValue()) {
            this.consultaAtividadeVo.getSolicitacaoAlvara().setZonaGeo(this.preencherZonasGeo(retorno));
        }
        if (retorno.getDecisao() != null && retorno.getDecisao().getObservacao() != null) {
            this.consultaAtividadeVo.getAtividadeSelecionada().setObservacao(retorno.getDecisao().getObservacao().getDescricao());
        }
        if (retorno.getAtividade().exigeResponsavelTecnico()) {
            this.consultaAtividadeVo.getAtividadeSelecionada().setResponsavelTecnico(SimNaoEnum.getSimShortText());
        } else {
            this.consultaAtividadeVo.getAtividadeSelecionada().setResponsavelTecnico(SimNaoEnum.getNaoShortText());
        }
        if (!this.consultaAtividadeVo.getSolicitacaoAlvara().isRedeSim() && this.consultaAtividadeVo.atividadeExistenteNaTabela(this.consultaAtividadeVo.getAtividadeSelecionada())) {
            throw new SolicitacaoAlvaraException("Atividade j\u00e1 adicionada!");
        }
        this.consultaAtividadeVo.setRetornoConsultaAtividade(retorno);
        this.consultaAtividadeVo.getAtividadeSelecionada().setSituacao(INCLUSAO);
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().getVerificaPropImovel() == null || !this.consultaAtividadeVo.getSolicitacaoAlvara().getVerificaPropImovel().equals(SimNaoEnum.getSimShortText()) && retorno.isVerificarProprietario()) {
            this.consultaAtividadeVo.getSolicitacaoAlvara().setVerificaPropImovel(SimNaoEnum.getSimShortText());
        }
        if (retorno.getDecisao().getPermissao() != null) {
            PermissaoGeo permissao = retorno.getDecisao().getPermissao();
            this.consultaAtividadeVo.getAtividadeSelecionada().setAtividadeConcomitanteRes(permissao.isAtividadeConcomitanteRes());
            this.consultaAtividadeVo.getAtividadeSelecionada().setSomenteEscritorio(permissao.isSomenteEscritorio());
            this.consultaAtividadeVo.getAtividadeSelecionada().setSomenteEscrConcomitanteRes(permissao.isEscritorioConcomitante());
        }
        this.validaRetornoConsultaMEINormal(retorno);
        this.adicionarAtividade();
    }

    private void validaRetornoConsultaMEINormal(RetornoConsultaAtividade retorno) {
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoMEINormal()) {
            AtividadeMeiEntity atividadeMei = (AtividadeMeiEntity)this.consultaAtividadeVo.getAtividadeSelecionada();
            atividadeMei.setTaxaLocalizacao(retorno.getAtividade().getCodigoDeTaxa());
            atividadeMei.getCnae().setGrauRisco(retorno.getAtividade().getGrauDeRisco());
            this.consultaAtividadeVo.setAtividadeSelecionada((Atividade)atividadeMei);
        } else {
            CnaeEntity cnae = (CnaeEntity)this.consultaAtividadeVo.getAtividadeSelecionada();
            cnae.setGrauRisco(retorno.getAtividade().getGrauDeRisco());
            cnae.setTaxaLocalizacao(retorno.getAtividade().getCodigoDeTaxa());
            this.consultaAtividadeVo.setAtividadeSelecionada((Atividade)cnae);
        }
    }

    private void adicionarAtividade() {
        this.consultaAtividadeVo.getListaAtiv().add(this.consultaAtividadeVo.getAtividadeSelecionada());
        this.consultaAtividadeVo.setAtividadeSelecionada(null);
        this.consultaAtividadeVo.setCodigoAtividade("");
    }

    private String preencherZonasGeo(RetornoConsultaAtividade retorno) {
        List siglasZonas = retorno.getZonas().stream().sorted(Comparator.comparingLong(ZonaGeo::getId)).map(ZonaGeo::getSigla).collect(Collectors.toList());
        return String.join((CharSequence)",", siglasZonas);
    }

    private String preencherEixosGeo(RetornoConsultaAtividade retorno) {
        List siglasEixos = retorno.getEixos().stream().sorted(Comparator.comparingLong(EixoGeo::getId)).map(EixoGeo::getSigla).collect(Collectors.toList());
        return String.join((CharSequence)",", siglasEixos);
    }

    protected void validaRespostaGeo(RetornoConsultaAtividade resposta) throws BaseException {
        if (resposta == null) {
            throw new ConsultaAtividadeException("N\u00e3o foi poss\u00edvel consultar esta atividade!");
        }
        if (resposta.getAtividade() == null) {
            throw new ConsultaAtividadeException("N\u00e3o foi poss\u00edvel consultar a atividade selecionada. Atividade n\u00e3o \u00e9 v\u00e1lida, falha ao consultar servi\u00e7o do Geo Processamento.");
        }
        if (!resposta.isAtividadePermitida()) {
            throw new AtividadeNaoPermitidaException("Atividade n\u00e3o \u00e9 permitida. " + resposta.getMotivosProibicao());
        }
    }

    public ConsultaAtividadeEnvioNovoGeo instanciarConsultaEnvio(br.com.elotech.portalarrecadacao.ws.oxm.geo.Atividade atividade) throws IntegracaoGeoException {
        CadastroImobiliarioTestadaEntity testada = this.carregarTestada(this.consultaAtividadeVo.getSolicitacaoAlvara());
        return new ConsultaAtividadeEnvioNovoGeo(atividade.getAtividadeId().toString(), this.consultaAtividadeVo.getSolicitacaoAlvara().carregarCadastroImobiliario().getId().getCodigo().toString(), testada.getId().getLogradouroTestada().getLogradouro().getId().getLogradouro().toString());
    }

    public ConsultaAtividadeEnvioNovoGeo instanciarConsultaEnvio(br.com.elotech.portalarrecadacao.ws.oxm.geo.Atividade atividade, SolicitacaoAlvaraEntity solicitacao) throws IntegracaoGeoException {
        CadastroImobiliarioEntity cadastroImobiliario = solicitacao.carregarCadastroImobiliario();
        CadastroImobiliarioTestadaEntity testada = this.carregarTestada(solicitacao);
        if (Objects.isNull(cadastroImobiliario)) {
            throw new IntegracaoGeoException("N\u00e3o foi encontrado nenhum cadastro imobili\u00e1rio no cadastro mobili\u00e1rio.");
        }
        return new ConsultaAtividadeEnvioNovoGeo(atividade.getAtividadeId().toString(), cadastroImobiliario.getId().getCodigo().toString(), testada.getId().getLogradouroTestada().getLogradouro().getId().getLogradouro().toString());
    }

    private CadastroImobiliarioTestadaEntity carregarTestada(SolicitacaoAlvaraEntity solicitacaoAlvara) throws IntegracaoGeoException {
        if (Objects.isNull(solicitacaoAlvara.getImobiliarioTestada())) {
            return Optional.ofNullable(this.repositoryImobiliarioTestada.buscarTestadaPrincipal(solicitacaoAlvara.carregarCadastroImobiliario().getId().getCodigo())).orElseThrow(() -> new IntegracaoGeoException("N\u00e3o foi encontrado nenhuma testada no cadastro."));
        }
        return Optional.ofNullable(solicitacaoAlvara.getImobiliarioTestada()).orElseThrow(() -> new IntegracaoGeoException("N\u00e3o foi encontrado nenhuma testada no cadastro."));
    }

    public void setRepositoryImobiliarioTestada(RepositoryImobiliarioTestada repositoryImobiliarioTestada) {
        this.repositoryImobiliarioTestada = repositoryImobiliarioTestada;
    }
}

