/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.ConsultaAtividadeException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.service.impl.SrvConsultaAtividadeGeoImpl;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ConsultaAtividadeEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornaAtividadeResponse;
import br.com.elotech.tributacao.domain.aise.AtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioAtividadeMeiEntity;
import br.com.elotech.tributacao.enumerator.TipoAtividadeEnum;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="srvConsultaAtividadeMeiGeo")
public class SrvConsultaAtividadeMeiGeoImpl
extends SrvConsultaAtividadeGeoImpl {
    public static final String SERVICE_NAME = "srvConsultaAtividadeMeiGeo";

    protected ConsultaAtividadeEnvio prepararEnvioAtividadeNova() {
        ConsultaAtividadeEnvio envio = super.prepararEnvioAtividadeNova();
        AtividadeMeiEntity atividadeMei = (AtividadeMeiEntity)this.consultaAtividadeVo.getAtividadeSelecionada();
        envio.setTipoAtividade(TipoAtividadeEnum.MEI);
        envio.setOcupacao(atividadeMei.getOcupacao());
        return envio;
    }

    protected ConsultaAtividadeEnvio prepararEnvioAtividadeExistente() {
        ConsultaAtividadeEnvio envio = super.prepararEnvioAtividadeExistente();
        envio.setTipoAtividade(TipoAtividadeEnum.MEI);
        return envio;
    }

    protected void verificarAtividade(RetornaAtividadeResponse resposta) throws BaseException {
        super.verificarAtividade(resposta);
        AtividadeMeiEntity atividadeMei = (AtividadeMeiEntity)this.consultaAtividadeVo.getAtividadeSelecionada();
        atividadeMei.getCnae().setGrauRisco(resposta.getRespostaWSAtividade().getGrauRisco());
        atividadeMei.setTaxaLocalizacao(Integer.valueOf(Integer.parseInt(resposta.getRespostaWSAtividade().getCodTaxa())));
        this.consultaAtividadeVo.setAtividadeSelecionada((Atividade)atividadeMei);
        super.adicionarAtividade();
    }

    public void carregarTabelaAtividadesAtuais() throws BaseException {
        if (!EloListUtils.safeIsEmpty((List)this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioAtividadeMeis()).booleanValue()) {
            for (CadastroMobiliarioAtividadeMeiEntity mobMei : this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioAtividadeMeis()) {
                if (!this.consultaAtividadeVo.getSolicitacaoAlvara().isSolicitacaoMEINormal()) continue;
                ConsultaAtividadeEnvio envio = this.prepararEnvioAtividadeExistente();
                envio.setCnae(mobMei.getAtividadeMei().getCnae().getCodigo());
                envio.setOcupacao(mobMei.getAtividadeMei().getOcupacao());
                RetornaAtividadeResponse resposta = this.getRespostaGeo(envio);
                mobMei.getAtividadeMei().getCnae().setGrauRisco(resposta.getRespostaWSAtividade().getGrauRisco());
                AtividadeMeiEntity atividade = mobMei.getAtividadeMei();
                atividade.setPrincipal(mobMei.getPrincipal());
                atividade.setTaxaLocalizacao(Integer.valueOf(Integer.parseInt(resposta.getRespostaWSAtividade().getCodTaxa())));
                atividade.setSituacao("A");
                this.consultaAtividadeVo.getListaAtiv().add(atividade);
            }
        } else {
            throw new ConsultaAtividadeException("N\u00e3o foi encontrada nenhuma Atividade MEI no cadastro mobili\u00e1rio, favor entrar em contato com o Setor de Alvar\u00e1, email: \"" + UtilsController.getEmailSetorAlvara() + "\"");
        }
    }

    public ConsultaAtividadeEnvio prepararEnvioParaVerificacaoResponsavelTecnico(SolicitacaoAlvaraAtividadeEntity atividade) throws SolicitacaoAlvaraException {
        ConsultaAtividadeEnvio envio = super.prepararEnvioParaVerificacaoResponsavelTecnico(atividade);
        envio.setTipoAtividade(TipoAtividadeEnum.MEI);
        envio.setOcupacao(atividade.getAtividadeMei().getOcupacao());
        return envio;
    }

    public void carregaExigenciasProibicaoNaSolicitacao(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraAtividadeEntity> listaSolicitacaoAtividades) throws BaseException {
        listaSolicitacaoAtividades = this.prepararListaSolicitacaoAtividades(solicitacao);
        super.carregaExigenciasProibicaoNaSolicitacao(solicitacao, listaSolicitacaoAtividades);
    }
}

