/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.LaudoExigidoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaAtividadeVo;
import br.com.elotech.portalarrecadacao.enumerator.GrauDeRiscoEnum;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoPermitidaException;
import br.com.elotech.portalarrecadacao.exception.ConsultaAtividadeException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.repository.RepositoryCadastroRestricaoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoAlvaraAtividade;
import br.com.elotech.portalarrecadacao.repository.RepositoryTipoLaudo;
import br.com.elotech.portalarrecadacao.service.SrvConsultaAtividadeGeo;
import br.com.elotech.portalarrecadacao.service.SrvRestricaoLote;
import br.com.elotech.portalarrecadacao.service.SrvVerificaExigenciaCnae;
import br.com.elotech.portalarrecadacao.service.SrvWebServiceGeo;
import br.com.elotech.portalarrecadacao.service.impl.SrvConsultaAtividadeImpl;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ConsultaAtividadeEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.Proibicao;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RespostaWSAtividade;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RestricaoPermissivel;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RestricoesLote;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornaAtividadeResponse;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.CadastroRestricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.LogradouroEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.enumerator.TipoAtividadeEnum;
import br.com.elotech.tributacao.enumerator.TipoLaudoEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryBoletimImobiliarioTerreno;
import br.com.elotech.tributacao.repository.aise.RepositoryImobiliarioTestada;
import br.com.elotech.tributacao.repository.aise.RepositoryModeloIdentificacao;
import br.com.elotech.util.string.EloStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;

public class SrvConsultaAtividadeGeoImpl
extends SrvConsultaAtividadeImpl
implements SrvConsultaAtividadeGeo {
    @Resource
    protected SrvWebServiceGeo srvWebServiceGeo;
    @Resource
    private RepositorySolicitacaoAlvaraAtividade repositorySolicitacaoAlvaraAtividade;
    @Resource
    private SrvVerificaExigenciaCnae srvVerificaExigencia;
    @Resource
    private RepositoryCadastroRestricaoAlvara repositoryCadastroRestricaoAlvara;
    @Resource
    private SrvVerificaExigenciaCnae srvVerificaExigenciaCnae;
    @Resource
    private RepositoryImobiliarioTestada repositoryImobiliarioTestada;
    @Resource
    private RepositoryTipoLaudo repositoryTipoLaudo;
    protected ConsultaAtividadeVo consultaAtividadeVo;
    @Resource
    private RepositoryModeloIdentificacao repositoryModeloIdentificacao;
    @Resource
    private RepositoryBoletimImobiliarioTerreno repositoryBoletimImobiliarioTerreno;
    @Resource
    private SrvRestricaoLote srvRestricaoLote;

    public void setConsultaAtividadeVo(ConsultaAtividadeVo consultaAtividadeVo) {
        this.consultaAtividadeVo = consultaAtividadeVo;
    }

    public void setSrvRestricaoLote(SrvRestricaoLote srvRestricaoLote) {
        this.srvRestricaoLote = srvRestricaoLote;
    }

    public RetornaAtividadeResponse consultar() throws BaseException {
        ConsultaAtividadeEnvio envio = this.prepararEnvioAtividadeNova();
        RetornaAtividadeResponse resposta = this.getRespostaGeo(envio);
        if (resposta != null && resposta.getRespostaWSAtividade().isAtividadePermitida()) {
            this.verificarAtividade(resposta);
        } else {
            this.consultaAtividadeVo.getAtividadeSelecionada().setAtividadeNaoPermitida(true);
            this.validaRespostaGeo(resposta);
            if (this.consultaAtividadeVo.getSolicitacaoAlvara().possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO}) && !this.consultaAtividadeVo.getSolicitacaoAlvara().possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
                this.consultaAtividadeVo.setRespostaWSAtividade(resposta.getRespostaWSAtividade());
            }
        }
        return resposta;
    }

    public void carregarTabelaAtividadesAtuais() throws BaseException {
    }

    protected ConsultaAtividadeEnvio prepararEnvioAtividadeNova() {
        ConsultaAtividadeEnvio envio = new ConsultaAtividadeEnvio();
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().isNaturezaAlteracaoAtividade()) {
            envio = this.preencherEnvioAlteracaoAtividades();
        } else {
            CadastroImobiliarioEntity cadastroImobiliario = this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroImobiliario();
            envio.setCadastroImobiliario(cadastroImobiliario.getId().getCodigo().toString());
            envio.setCnae(this.consultaAtividadeVo.getAtividadeSelecionada().getCodigo());
            envio.setCodLogradouro(Integer.valueOf(Integer.parseInt(this.consultaAtividadeVo.getSolicitacaoAlvara().getImobiliarioTestada().getId().getLogradouroTestada().getLogradouro().getId().getLogradouro().toString())));
            envio.setRestricoesLote(this.carregarRestricaoLote(cadastroImobiliario));
        }
        return envio;
    }

    private ConsultaAtividadeEnvio preencherEnvioAlteracaoAtividades() {
        ConsultaAtividadeEnvio envio = new ConsultaAtividadeEnvio();
        CadastroImobiliarioEntity cadastroImobiliario = this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroImobiliario();
        LogradouroEntity logradouro = this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral().getLogradouro();
        envio.setCadastroImobiliario(cadastroImobiliario.getId().getCodigo().toString());
        envio.setCnae(this.consultaAtividadeVo.getAtividadeSelecionada().getCodigo());
        envio.setCodLogradouro(Integer.valueOf(logradouro.getId().getLogradouro().toString()));
        envio.setRestricoesLote(this.carregarRestricaoLote(cadastroImobiliario));
        return envio;
    }

    protected ConsultaAtividadeEnvio prepararEnvioAtividadeExistente() {
        ConsultaAtividadeEnvio envio = new ConsultaAtividadeEnvio();
        CadastroImobiliarioEntity cadastroImobiliario = null;
        if (this.consultaAtividadeVo.getSolicitacaoAlvara() != null) {
            if (this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroImobiliario() == null || this.consultaAtividadeVo.getSolicitacaoAlvara().getImobiliarioTestada() == null) {
                cadastroImobiliario = this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroImobiliario();
                envio.setCadastroImobiliario(cadastroImobiliario.getId().getCodigo().toString());
                envio.setCodLogradouro(Integer.valueOf(cadastroImobiliario.getTestadaPrincipal().getId().getLogradouroTestada().getLogradouro().getId().getLogradouro().intValue()));
            } else {
                cadastroImobiliario = this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroImobiliario();
                envio.setCadastroImobiliario(this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroImobiliario().getId().getCodigo().toString());
                envio.setCodLogradouro(Integer.valueOf(this.consultaAtividadeVo.getSolicitacaoAlvara().getImobiliarioTestada().getId().getLogradouroTestada().getLogradouro().getId().getLogradouro().intValue()));
            }
        }
        envio.setRestricoesLote(this.carregarRestricaoLote(cadastroImobiliario));
        return envio;
    }

    protected RestricoesLote carregarRestricaoLote(CadastroImobiliarioEntity cadastroImobiliario) {
        return this.srvRestricaoLote.getRestricaoLote(cadastroImobiliario.getCadastroGeral());
    }

    protected void verificarAtividade(RetornaAtividadeResponse resposta) throws BaseException {
        this.validaRespostaGeo(resposta);
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().getEixoGeo() == null) {
            this.consultaAtividadeVo.getSolicitacaoAlvara().setEixoGeo(resposta.getRespostaWSAtividade().getEixo());
        }
        if (this.consultaAtividadeVo.getSolicitacaoAlvara().getZonaGeo() == null) {
            this.consultaAtividadeVo.getSolicitacaoAlvara().setZonaGeo(resposta.getRespostaWSAtividade().getZona());
        }
        this.consultaAtividadeVo.getAtividadeSelecionada().setObservacao(resposta.getRespostaWSAtividade().getMotivosDescricao());
        if (resposta.getRespostaWSAtividade().exigeResponsavelTecnico()) {
            this.consultaAtividadeVo.getAtividadeSelecionada().setResponsavelTecnico("S");
        } else {
            this.consultaAtividadeVo.getAtividadeSelecionada().setResponsavelTecnico("N");
        }
        if (!this.consultaAtividadeVo.getSolicitacaoAlvara().isRedeSim() && this.consultaAtividadeVo.atividadeExistenteNaTabela(this.consultaAtividadeVo.getAtividadeSelecionada())) {
            throw new SolicitacaoAlvaraException("Esta atividade j\u00e1 foi adicionada!");
        }
        this.consultaAtividadeVo.setRespostaWSAtividade(resposta.getRespostaWSAtividade());
        this.consultaAtividadeVo.getAtividadeSelecionada().setSituacao("I");
        if ((this.consultaAtividadeVo.getSolicitacaoAlvara().getVerificaPropImovel() == null || !this.consultaAtividadeVo.getSolicitacaoAlvara().getVerificaPropImovel().equals("S")) && resposta.getRespostaWSAtividade().isVerificarProprietario()) {
            this.consultaAtividadeVo.getSolicitacaoAlvara().setVerificaPropImovel("S");
        }
        if (resposta.getRespostaWSAtividade().getRestricaoPermissivel() != null) {
            RestricaoPermissivel restricao = resposta.getRespostaWSAtividade().getRestricaoPermissivel();
            this.consultaAtividadeVo.getAtividadeSelecionada().setAreaProcessamento(restricao.getAreaMaximaProcessamento());
            this.consultaAtividadeVo.getAtividadeSelecionada().setAtividadeConcomitanteRes(restricao.isAtividadeConcomitante());
            this.consultaAtividadeVo.getAtividadeSelecionada().setSomenteEscritorio(restricao.isSomenteEscritorio());
            this.consultaAtividadeVo.getAtividadeSelecionada().setSomenteEscrConcomitanteRes(restricao.isEscritorioConcomitante());
        }
    }

    protected void adicionarAtividade() {
        this.consultaAtividadeVo.getListaAtiv().add(this.consultaAtividadeVo.getAtividadeSelecionada());
        this.consultaAtividadeVo.setAtividadeSelecionada(null);
        this.consultaAtividadeVo.setCodigoAtividade("");
    }

    protected void validaRespostaGeo(RetornaAtividadeResponse resposta) throws BaseException {
        if (resposta == null) {
            throw new ConsultaAtividadeException("N\u00e3o foi poss\u00edvel consultar esta atividade!");
        }
        if (resposta.getRespostaWSAtividade() == null) {
            throw new ConsultaAtividadeException("N\u00e3o foi poss\u00edvel consultar a atividade selecionada. Atividade n\u00e3o \u00e9 v\u00e1lida, falha ao consultar servi\u00e7o do Geo Processamento.");
        }
        if (!resposta.getRespostaWSAtividade().isAtividadePermitida()) {
            throw new AtividadeNaoPermitidaException("Atividade n\u00e3o \u00e9 permitida, " + resposta.getRespostaWSAtividade().getMotivosDescricao());
        }
    }

    protected RetornaAtividadeResponse getRespostaGeo(ConsultaAtividadeEnvio envio) throws BaseException {
        return this.srvWebServiceGeo.consultaTabelaConfiguracaoCnae(envio);
    }

    public boolean verificarExisteRestricaoResponsavelTec(SolicitacaoAlvaraEntity solicitacao, ArrayList<CadastroRestricaoAlvaraEntity> listaCadastroRestricaoAlvara, StringBuilder textoRestricaoBuilder) throws BaseException {
        CadastroRestricaoAlvaraEntity cadastroRestricaoAlvara;
        boolean possuiRestricao = false;
        List listaRespostaWSAtividade = this.consultaWSAtividade(solicitacao.getSolicitacaoAlvara());
        if (this.possuiRestricaoRespTecVigSanitaria(listaRespostaWSAtividade).booleanValue()) {
            cadastroRestricaoAlvara = this.repositoryCadastroRestricaoAlvara.carregaCadastroRestricaoAlvara(PortalUtils.getCodRestricaoresptecVigsanitaria());
            if (cadastroRestricaoAlvara != null) {
                cadastroRestricaoAlvara.setDescricao("Respons\u00e1vel T\u00e9cnico Vigil\u00e2ncia Sanit\u00e1ria ");
                listaCadastroRestricaoAlvara.add(cadastroRestricaoAlvara);
                cadastroRestricaoAlvara = null;
            }
            possuiRestricao = true;
            textoRestricaoBuilder.append("Respons\u00e1vel T\u00e9cnico Vigil\u00e2ncia Sanit\u00e1ria ");
            textoRestricaoBuilder.append("<br/>");
        }
        if (this.possuiRestricaoRespTecMeioAmbiente(listaRespostaWSAtividade).booleanValue()) {
            cadastroRestricaoAlvara = this.repositoryCadastroRestricaoAlvara.carregaCadastroRestricaoAlvara(PortalUtils.getCodRestricaoresptecMeioambiente());
            if (cadastroRestricaoAlvara != null) {
                cadastroRestricaoAlvara.setDescricao("Respons\u00e1vel T\u00e9cnico Meio Ambiente ");
                listaCadastroRestricaoAlvara.add(cadastroRestricaoAlvara);
                cadastroRestricaoAlvara = null;
            }
            possuiRestricao = true;
            textoRestricaoBuilder.append("Respons\u00e1vel T\u00e9cnico Meio Ambiente ");
            textoRestricaoBuilder.append("<br/>");
        }
        if (this.possuiRestricaoRespTecVigAmbiental(listaRespostaWSAtividade).booleanValue()) {
            cadastroRestricaoAlvara = this.repositoryCadastroRestricaoAlvara.carregaCadastroRestricaoAlvara(PortalUtils.getCodRestricaoresptecVigambiental());
            if (cadastroRestricaoAlvara != null) {
                cadastroRestricaoAlvara.setDescricao("Respons\u00e1vel T\u00e9cnico Vigil\u00e2ncia Ambiental ");
                listaCadastroRestricaoAlvara.add(cadastroRestricaoAlvara);
                cadastroRestricaoAlvara = null;
            }
            possuiRestricao = true;
            textoRestricaoBuilder.append("Respons\u00e1vel T\u00e9cnico Vigil\u00e2ncia Ambiental \n");
            textoRestricaoBuilder.append("<br/>");
        }
        return possuiRestricao;
    }

    private List<RespostaWSAtividade> consultaWSAtividade(Long idSolicitacao) throws BaseException {
        List listaAtividade = this.repositorySolicitacaoAlvaraAtividade.carregaAtividadesBySolicitacao(idSolicitacao);
        ArrayList<RespostaWSAtividade> listaRespostaWSAtividade = new ArrayList<RespostaWSAtividade>();
        for (SolicitacaoAlvaraAtividadeEntity atividade : listaAtividade) {
            ConsultaAtividadeEnvio envio = this.prepararEnvioParaVerificacaoResponsavelTecnico(atividade);
            try {
                RetornaAtividadeResponse resposta = this.getRespostaGeo(envio);
                if (resposta == null || !"I".equals(atividade.getSituacao())) continue;
                listaRespostaWSAtividade.add(resposta.getRespostaWSAtividade());
            }
            catch (Exception e) {
                throw new ConsultaAtividadeException("N\u00e3o foi poss\u00edvel consultar a atividade no Web Service ", e.getCause());
            }
        }
        return listaRespostaWSAtividade;
    }

    public ConsultaAtividadeEnvio prepararEnvioParaVerificacaoResponsavelTecnico(SolicitacaoAlvaraAtividadeEntity atividade) throws SolicitacaoAlvaraException {
        SolicitacaoAlvaraEntity solicitacaoAlvara = atividade.getSolicitacaoAlvara();
        if (solicitacaoAlvara.getImobiliarioTestada() == null) {
            if (solicitacaoAlvara.getCadastroMobiliario().getCadastroImobiliario().getTestadaPrincipalOuPrimeira() == null) {
                throw new SolicitacaoAlvaraException("O Imobili\u00e1rio n\u00e3o possui testada. Entre em contato com a prefeitura.");
            }
            solicitacaoAlvara.setImobiliarioTestada(solicitacaoAlvara.getCadastroMobiliario().getCadastroImobiliario().getTestadaPrincipalOuPrimeira());
        }
        ConsultaAtividadeEnvio envio = new ConsultaAtividadeEnvio();
        if (solicitacaoAlvara.isNaturezaInicial()) {
            envio.setCadastroImobiliario(solicitacaoAlvara.getCadastroImobiliario().getId().getCodigo().toString());
        } else {
            envio.setCadastroImobiliario(solicitacaoAlvara.getCadastroMobiliario().getCadastroImobiliario().getId().getCodigo().toString());
        }
        envio.setCnae(atividade.getCodigoAtividade());
        envio.setCodLogradouro(Integer.valueOf(Integer.parseInt(solicitacaoAlvara.getImobiliarioTestada().getId().getLogradouroTestada().getLogradouro().getId().getLogradouro().toString())));
        envio.setRestricoesLote(this.srvRestricaoLote.getRestricaoLote(solicitacaoAlvara.getCadastroImobiliario().getCadastroGeral()));
        return envio;
    }

    private Boolean possuiRestricaoRespTecVigSanitaria(List<RespostaWSAtividade> listaRespostaWSAtividade) throws BaseException {
        return this.srvVerificaExigencia.verificaRestricaoRespTecVigSanitaria(listaRespostaWSAtividade);
    }

    private Boolean possuiRestricaoRespTecMeioAmbiente(List<RespostaWSAtividade> listaRespostaWSAtividade) throws BaseException {
        return this.srvVerificaExigencia.verificaRestricaoRespTecMeioAmbiente(listaRespostaWSAtividade);
    }

    private Boolean possuiRestricaoRespTecVigAmbiental(List<RespostaWSAtividade> listaRespostaWSAtividade) throws BaseException {
        return this.srvVerificaExigencia.verificaRestricaoRespTecVigAmbiental(listaRespostaWSAtividade);
    }

    public void carregaExigenciasProibicaoNaSolicitacao(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraAtividadeEntity> listaSolicitacaoAtividades) throws BaseException {
        ArrayList<RespostaWSAtividade> listaRespostaWSAtividade = new ArrayList<RespostaWSAtividade>();
        for (SolicitacaoAlvaraAtividadeEntity atividade : listaSolicitacaoAtividades) {
            ConsultaAtividadeEnvio envio = this.prepararEnvioAtividade(solicitacao, atividade);
            RetornaAtividadeResponse resposta = this.getRespostaGeo(envio);
            listaRespostaWSAtividade.add(resposta.getRespostaWSAtividade());
        }
        ArrayList listaProibicao = new ArrayList();
        for (RespostaWSAtividade respostaWSAtividade : listaRespostaWSAtividade) {
            Optional.ofNullable(respostaWSAtividade.getProibicao()).map(Proibicao::getDescricao).filter(descricao -> !EloStringUtils.isEmpty((String)descricao)).filter(descricao -> listaProibicao.stream().noneMatch(descricao::equalsIgnoreCase)).ifPresent(listaProibicao::add);
        }
        solicitacao.setProibicao(String.join((CharSequence)", ", listaProibicao));
        solicitacao.setExigencias(this.srvVerificaExigenciaCnae.verificaExigencias(listaRespostaWSAtividade));
    }

    public ConsultaAtividadeEnvio prepararEnvioAtividade(SolicitacaoAlvaraEntity solicitacaoAlvara, SolicitacaoAlvaraAtividadeEntity atividade) {
        ConsultaAtividadeEnvio envio = new ConsultaAtividadeEnvio();
        envio.setCadastroImobiliario(solicitacaoAlvara.getCadastroImobiliario().getId().getCodigo().toString());
        envio.setCnae(atividade.getCodigoAtividade());
        if (solicitacaoAlvara.getImobiliarioTestada() != null) {
            envio.setCodLogradouro(Integer.valueOf(solicitacaoAlvara.getImobiliarioTestada().getId().getLogradouroTestada().getLogradouro().getId().getLogradouro().intValue()));
        } else {
            CadastroImobiliarioTestadaEntity testada = this.carregaTestadaPrincipal(solicitacaoAlvara);
            envio.setCodLogradouro(Integer.valueOf(testada.getId().getLogradouroTestada().getLogradouro().getId().getLogradouro().intValue()));
        }
        if (atividade.getSolicitacaoAlvara().isSolicitacaoCBO()) {
            envio.setTipoAtividade(TipoAtividadeEnum.CBO);
        } else if (atividade.getSolicitacaoAlvara().isSolicitacaoMEI()) {
            envio.setTipoAtividade(TipoAtividadeEnum.MEI);
            envio.setOcupacao(atividade.getAtividadeMei().getOcupacao());
        } else {
            envio.setTipoAtividade(TipoAtividadeEnum.CNAE);
        }
        CadastroGeralAiseEntity cadastroImobiliario = solicitacaoAlvara.getCadastroImobiliario().getCadastroGeral();
        envio.setRestricoesLote(this.srvRestricaoLote.getRestricaoLote(cadastroImobiliario));
        return envio;
    }

    protected CadastroImobiliarioTestadaEntity carregaTestadaPrincipal(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        return this.repositoryImobiliarioTestada.buscarTestadaPrincipal(solicitacaoAlvara.getCadastroImobiliario().getId().getCodigo());
    }

    public Integer retornaMaiorCodigoISSQN(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        Integer maiorCodigoISSQN = 0;
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            ConsultaAtividadeEnvio envio = this.prepararEnvioAtividade(solicitacao, atividade);
            RetornaAtividadeResponse resposta = this.getRespostaGeo(envio);
            Integer codigoISSQN = Integer.valueOf(resposta.getRespostaWSAtividade().getCodIss());
            if (codigoISSQN <= maiorCodigoISSQN) continue;
            maiorCodigoISSQN = codigoISSQN;
        }
        return maiorCodigoISSQN;
    }

    public void carregaGrauRiscoDaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (!solicitacao.isSolicitacaoMEIPrestador() && !solicitacao.isSolicitacaoPrestadorServico()) {
            for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
                ConsultaAtividadeEnvio envio = this.prepararEnvioAtividade(solicitacao, atividade);
                RetornaAtividadeResponse resposta = this.getRespostaGeo(envio);
                this.carregaGrauRisco(solicitacao, resposta);
                if (solicitacao.isSolicitacaoMEI()) {
                    atividade.getAtividadeMei().getCnae().setGrauRisco(resposta.getRespostaWSAtividade().getGrauRisco());
                    continue;
                }
                atividade.getCnae().setGrauRisco(resposta.getRespostaWSAtividade().getGrauRisco());
            }
        }
    }

    private void carregaGrauRisco(SolicitacaoAlvaraEntity solicitacaoAlvara, RetornaAtividadeResponse resposta) {
        if (solicitacaoAlvara.getGrauRisco() == null) {
            solicitacaoAlvara.setGrauRisco(resposta.getRespostaWSAtividade().getGrauRisco());
        } else if (GrauDeRiscoEnum.isGrauRiscoAlto((String)resposta.getRespostaWSAtividade().getGrauRisco())) {
            solicitacaoAlvara.setGrauRisco(GrauDeRiscoEnum.RISCO_ALTO.getSigla());
        }
    }

    public void executaVerificacaoLaudoExigido(SolicitacaoAlvaraEntity solicitacaoAlvara, Set<LaudoExigidoEntity> listaLaudoExigido, SolicitacaoAlvaraAtividadeEntity atividade) throws BaseException {
        ConsultaAtividadeEnvio envio = this.prepararEnvioAtividade(solicitacaoAlvara, atividade);
        RetornaAtividadeResponse resposta = this.srvWebServiceGeo.consultaTabelaConfiguracaoCnae(envio);
        this.carregaCodigoTaxa(solicitacaoAlvara, resposta);
        listaLaudoExigido.addAll(this.verificaLaudoExigido(resposta));
        this.carregaGrauRisco(solicitacaoAlvara, resposta);
    }

    private void carregaCodigoTaxa(SolicitacaoAlvaraEntity solicitacaoAlvara, RetornaAtividadeResponse resposta) {
        if (solicitacaoAlvara.getTaxaLocalizacao() == null) {
            solicitacaoAlvara.setTaxaLocalizacao(resposta.getRetornoConsultaAtividade().getAtividade().getCodigoDeTaxa());
        } else if (resposta.getRetornoConsultaAtividade().getAtividade().getCodigoDeTaxa() > solicitacaoAlvara.getTaxaLocalizacao()) {
            solicitacaoAlvara.setTaxaLocalizacao(resposta.getRetornoConsultaAtividade().getAtividade().getCodigoDeTaxa());
        }
    }

    private List<LaudoExigidoEntity> verificaLaudoExigido(RetornaAtividadeResponse resposta) {
        LaudoExigidoEntity laudoExigido;
        ArrayList<LaudoExigidoEntity> listaLaudoExigido = new ArrayList<LaudoExigidoEntity>();
        if (resposta.possuiLaudoAmbiental()) {
            TipoLaudoEntity tipoLaudoAmbiental = this.repositoryTipoLaudo.getTipoLaudoPorId(TipoLaudoEnum.AMBIENTAL.getCodigo());
            laudoExigido = new LaudoExigidoEntity();
            laudoExigido.setTipoLaudo(tipoLaudoAmbiental);
            if (!this.existeTipoLaudoNaLista(laudoExigido.getTipoLaudo(), listaLaudoExigido)) {
                listaLaudoExigido.add(laudoExigido);
            }
        }
        if (resposta.possuiLaudoBombeiro()) {
            TipoLaudoEntity tipoLaudoBombeiro = this.repositoryTipoLaudo.getTipoLaudoPorId(TipoLaudoEnum.BOMBEIRO.getCodigo());
            laudoExigido = new LaudoExigidoEntity();
            laudoExigido.setTipoLaudo(tipoLaudoBombeiro);
            if (!this.existeTipoLaudoNaLista(laudoExigido.getTipoLaudo(), listaLaudoExigido)) {
                listaLaudoExigido.add(laudoExigido);
            }
        }
        if (resposta.possuiLaudoPostura()) {
            TipoLaudoEntity tipoLaudoPostura = this.repositoryTipoLaudo.getTipoLaudoPorId(TipoLaudoEnum.POSTURA.getCodigo());
            laudoExigido = new LaudoExigidoEntity();
            laudoExigido.setTipoLaudo(tipoLaudoPostura);
            if (!this.existeTipoLaudoNaLista(laudoExigido.getTipoLaudo(), listaLaudoExigido)) {
                listaLaudoExigido.add(laudoExigido);
            }
        }
        if (resposta.possuiLaudoTransporte()) {
            TipoLaudoEntity tipoLaudoTrans = this.repositoryTipoLaudo.getTipoLaudoPorId(TipoLaudoEnum.TRANSPORTE.getCodigo());
            laudoExigido = new LaudoExigidoEntity();
            laudoExigido.setTipoLaudo(tipoLaudoTrans);
            if (!this.existeTipoLaudoNaLista(laudoExigido.getTipoLaudo(), listaLaudoExigido)) {
                listaLaudoExigido.add(laudoExigido);
            }
        }
        if (resposta.possuiLaudoVigSanitaria()) {
            TipoLaudoEntity tipoLaudoVS = this.repositoryTipoLaudo.getTipoLaudoPorId(TipoLaudoEnum.VIGILANCIA_SANITARIA.getCodigo());
            laudoExigido = new LaudoExigidoEntity();
            laudoExigido.setTipoLaudo(tipoLaudoVS);
            if (!this.existeTipoLaudoNaLista(laudoExigido.getTipoLaudo(), listaLaudoExigido)) {
                listaLaudoExigido.add(laudoExigido);
            }
        }
        return listaLaudoExigido;
    }

    public void validaAtividadeNaoPermitida(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
    }

    public void atualizarGrauRiscoCnae() {
    }
}

