/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.exception.ConsultaAtividadeException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.service.impl.SrvConsultaAtividadeGeoImpl;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ConsultaAtividadeEnvio;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornaAtividadeResponse;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioCboEntity;
import br.com.elotech.tributacao.domain.aise.RhCboEntity;
import br.com.elotech.tributacao.enumerator.TipoAtividadeEnum;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.util.list.EloListUtils;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="srvConsultaAtividadeCboGeo")
public class SrvConsultaAtividadeCboGeoImpl
extends SrvConsultaAtividadeGeoImpl {
    public static final String SERVICE_NAME = "srvConsultaAtividadeCboGeo";

    protected ConsultaAtividadeEnvio prepararEnvioAtividadeNova() {
        ConsultaAtividadeEnvio envio = super.prepararEnvioAtividadeNova();
        envio.setTipoAtividade(TipoAtividadeEnum.CBO);
        return envio;
    }

    protected ConsultaAtividadeEnvio prepararEnvioAtividadeExistente() {
        ConsultaAtividadeEnvio envio = super.prepararEnvioAtividadeExistente();
        envio.setTipoAtividade(TipoAtividadeEnum.CBO);
        return envio;
    }

    protected void verificarAtividade(RetornaAtividadeResponse resposta) throws BaseException {
        super.verificarAtividade(resposta);
        RhCboEntity cbo = (RhCboEntity)this.consultaAtividadeVo.getAtividadeSelecionada();
        cbo.setGrauRisco(resposta.getRespostaWSAtividade().getGrauRisco());
        cbo.setTaxaLocalizacao(Integer.valueOf(Integer.parseInt(resposta.getRespostaWSAtividade().getCodTaxa())));
        this.consultaAtividadeVo.setAtividadeSelecionada((Atividade)cbo);
        super.adicionarAtividade();
    }

    public void carregarTabelaAtividadesAtuais() throws BaseException {
        if (!EloListUtils.safeIsEmpty((List)this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioCbos()).booleanValue()) {
            for (CadastroMobiliarioCboEntity mobCbo : this.consultaAtividadeVo.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioCbos()) {
                ConsultaAtividadeEnvio envio = this.prepararEnvioAtividadeExistente();
                envio.setCnae(mobCbo.getRhCbo().getCodigo());
                RetornaAtividadeResponse resposta = this.getRespostaGeo(envio);
                mobCbo.getRhCbo().setGrauRisco(resposta.getRespostaWSAtividade().getGrauRisco());
                RhCboEntity atividade = mobCbo.getRhCbo();
                atividade.setPrincipal(mobCbo.getPrincipal());
                atividade.setTaxaLocalizacao(Integer.valueOf(Integer.parseInt(resposta.getRespostaWSAtividade().getCodTaxa())));
                atividade.setSituacao("A");
                this.consultaAtividadeVo.getListaAtiv().add(atividade);
            }
        } else {
            throw new ConsultaAtividadeException("N\u00e3o foi encontrado nenhum CBO no cadastro mobili\u00e1rio, favor entrar em contato com o Setor de Alvar\u00e1, email: \"" + UtilsController.getEmailSetorAlvara() + "\"");
        }
    }

    public ConsultaAtividadeEnvio prepararEnvioParaVerificacaoResponsavelTecnico(SolicitacaoAlvaraAtividadeEntity atividade) throws SolicitacaoAlvaraException {
        ConsultaAtividadeEnvio envio = super.prepararEnvioParaVerificacaoResponsavelTecnico(atividade);
        envio.setTipoAtividade(TipoAtividadeEnum.CBO);
        return envio;
    }

    public void carregaExigenciasProibicaoNaSolicitacao(SolicitacaoAlvaraEntity solicitacao, List<SolicitacaoAlvaraAtividadeEntity> listaSolicitacaoAtividades) throws BaseException {
        listaSolicitacaoAtividades = this.prepararListaSolicitacaoAtividades(solicitacao);
        super.carregaExigenciasProibicaoNaSolicitacao(solicitacao, listaSolicitacaoAtividades);
    }
}

