/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.exception.common.ValidacaoException;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.vo.DocumentoAtividadeTipoInscricaoVo;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoConfiguradaException;
import br.com.elotech.portalarrecadacao.filter.NaturezaSolicitacaoTipoInscricaoFilter;
import br.com.elotech.portalarrecadacao.repository.RepositoryConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.repository.RepositoryConfiguracaoAtividadeDoc;
import br.com.elotech.portalarrecadacao.repository.RepositoryNaturezaSolicitacaoTipoInscricaoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvConfiguracaoAtividade;
import br.com.elotech.portalarrecadacao.service.impl.SrvConfiguracaoAtividadeImpl;
import br.com.elotech.tributacao.domain.aise.AtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.CnaeEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeDocumentoEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.RhCboEntity;
import br.com.elotech.tributacao.domain.aise.TipoDocTipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.enumerator.TipoAtividadeEnum;
import br.com.elotech.tributacao.enumerator.TipoConfiguracaoAtividadeDocEnum;
import br.com.elotech.tributacao.filter.FiltroConfiguracaoAtividade;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.tributacao.repository.RepositoryParametroGeral;
import br.com.elotech.tributacao.repository.aise.RepositoryAtividadeMei;
import br.com.elotech.tributacao.repository.aise.RepositoryCnae;
import br.com.elotech.tributacao.repository.aise.RepositoryRhCbo;
import br.com.elotech.tributacao.repository.aise.RepositoryTipoDocTipoInscricaoAlvara;
import br.com.elotech.util.list.EloListUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="srvConfiguracaoAtividade")
public class SrvConfiguracaoAtividadeImpl
extends EloLogger
implements SrvConfiguracaoAtividade {
    @Resource
    private RepositoryAtividadeMei repositoryAtividadeMei;
    @Resource
    private RepositoryNaturezaSolicitacaoTipoInscricaoAlvara repositoryNaturezaSolicitacaoTipoInscricaoAlvara;
    @Resource
    private RepositoryCnae repositoryCnae;
    @Resource
    private RepositoryRhCbo repositoryRhCbo;
    @Resource
    private RepositoryConfiguracaoAtividade repositoryConfiguracaoAtividade;
    @Resource
    private RepositoryConfiguracaoAtividadeDoc repositoryConfiguracaoAtividadeDoc;
    @Resource
    private RepositoryTipoDocTipoInscricaoAlvara repositoryTipoDocTipoInscricaoAlvara;
    @Resource
    private RepositoryParametroGeral repositoryParametroGeral;

    public List<Atividade> consultarConfiguracaoAtividadeByFiltros(FiltroConfiguracaoAtividade filtroConfiguracaoAtividade) throws BaseException {
        return this.consultar(filtroConfiguracaoAtividade);
    }

    private List<Atividade> consultar(FiltroConfiguracaoAtividade filtroConfiguracaoAtividade) {
        ArrayList<Atividade> retorno = new ArrayList<Atividade>();
        if (TipoAtividadeEnum.MEI.equals((Object)filtroConfiguracaoAtividade.getTipoAtividadeEnum())) {
            List listaAtividadeMei = this.repositoryAtividadeMei.consultarAtividadeMeiPorFiltroConfiguracaoAtividade(filtroConfiguracaoAtividade);
            retorno.addAll(listaAtividadeMei);
        } else if (TipoAtividadeEnum.CNAE.equals((Object)filtroConfiguracaoAtividade.getTipoAtividadeEnum())) {
            List listaCnae = this.repositoryCnae.consultarCnaePorFiltroConfiguracaoAtividade(filtroConfiguracaoAtividade);
            retorno.addAll(listaCnae);
        } else if (TipoAtividadeEnum.CBO.equals((Object)filtroConfiguracaoAtividade.getTipoAtividadeEnum())) {
            List listaCbo = this.repositoryRhCbo.consultarRhCboPorFiltroConfiguracaoAtividade(filtroConfiguracaoAtividade);
            retorno.addAll(listaCbo);
        }
        return retorno;
    }

    public List<DocumentoAtividadeTipoInscricaoVo> carregarDocumentosPorAtividadeETipoInscricao(SolicitacaoAlvaraEntity solicitacao, TipoConfiguracaoAtividadeDocEnum tipo) throws BaseException {
        DocumentoAtividadeTipoInscricaoVo documento;
        ArrayList documentos = Lists.newArrayList();
        ArrayList configuracaoDocumentos = Lists.newArrayList();
        List documentosTipoInscricoes = Lists.newArrayList();
        for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
            if (this.repositoryParametroGeral.verificaIntegradoGeo().booleanValue() || !Objects.nonNull(atividade.getConfiguracaoAtividade())) continue;
            configuracaoDocumentos.addAll(this.repositoryConfiguracaoAtividadeDoc.findByIdConfiguracaoAtividadeAndTipo(atividade.getConfiguracaoAtividade(), tipo));
        }
        documentosTipoInscricoes = this.repositoryTipoDocTipoInscricaoAlvara.carregaTiposDocumentoPorTipoInscricao(solicitacao.getTipoDeInscricao());
        if (!EloListUtils.safeIsEmpty((List)configuracaoDocumentos).booleanValue()) {
            for (ConfiguracaoAtividadeDocumentoEntity configDocumento : configuracaoDocumentos) {
                documento = new DocumentoAtividadeTipoInscricaoVo();
                documento.setTipoDocumento(configDocumento.getTipoDocumento());
                documento.setObrigatorio(configDocumento.getObrigatorio());
                documentos.add(documento);
            }
        }
        if (!EloListUtils.safeIsEmpty((List)documentosTipoInscricoes).booleanValue()) {
            for (TipoDocTipoInscricaoAlvaraEntity documentoTipoInscricao : documentosTipoInscricoes) {
                documento = new DocumentoAtividadeTipoInscricaoVo();
                documento.setTipoDocumento(documentoTipoInscricao.getTipoDocumento());
                documento.setMensagem(documentoTipoInscricao.getMensagem());
                documento.setObrigatorio(documentoTipoInscricao.getObrigatorio());
                documentos.add(documento);
            }
        }
        return documentos;
    }

    public boolean possuiDocumentoParaAtividade(SolicitacaoAlvaraEntity solicitacao, TipoConfiguracaoAtividadeDocEnum tipo) {
        try {
            for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
                if (!Objects.nonNull(atividade.getConfiguracaoAtividade()) || !this.repositoryConfiguracaoAtividadeDoc.possuiDocumentoParaAtividade(atividade, tipo)) continue;
                return Boolean.TRUE;
            }
        }
        catch (AtividadeNaoConfiguradaException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return Boolean.FALSE;
    }

    public ConfiguracaoAtividadeEntity criarConfiguracaoAtividade(TipoAtividadeEnum tipo, Atividade atividade) {
        ConfiguracaoAtividadeEntity configuracaoAtividade = new ConfiguracaoAtividadeEntity();
        configuracaoAtividade.setTipo(tipo);
        configuracaoAtividade.setIdAtividade(atividade.getId());
        configuracaoAtividade = this.repositoryConfiguracaoAtividade.save(configuracaoAtividade);
        return configuracaoAtividade;
    }

    public Atividade atribuirConfiguracaoAtividadeToAtividade(Atividade atividade, ConfiguracaoAtividadeEntity configuracaoAtividadeEntity) throws ValidacaoException {
        switch (1.$SwitchMap$br$com$elotech$tributacao$enumerator$TipoAtividadeEnum[configuracaoAtividadeEntity.getTipo().ordinal()]) {
            case 1: {
                AtividadeMeiEntity atividadeMei = this.repositoryAtividadeMei.load(configuracaoAtividadeEntity.getIdAtividade());
                atividadeMei.setIdConfiguracaoAtividade(configuracaoAtividadeEntity);
                return this.repositoryAtividadeMei.saveOrUpdate(atividadeMei);
            }
            case 2: {
                CnaeEntity cnae = this.repositoryCnae.load(configuracaoAtividadeEntity.getIdAtividade());
                cnae.setIdConfiguracaoAtividade(configuracaoAtividadeEntity);
                return this.repositoryCnae.saveOrUpdate(cnae);
            }
            case 3: {
                RhCboEntity rhCbo = this.repositoryRhCbo.load(configuracaoAtividadeEntity.getIdAtividade());
                rhCbo.setIdConfiguracaoAtividade(configuracaoAtividadeEntity);
                return this.repositoryRhCbo.saveOrUpdate(rhCbo);
            }
        }
        throw new ValidacaoException("Tipo de Atividade n\u00e3o definido");
    }

    public List<TipoAtividadeEnum> buscarTiposAtividadeConfiguracaoAtividade() {
        ArrayList toReturn = Lists.newArrayList();
        if (this.habilitarTipoAtividadeCnaeConfiguracaoAtividade()) {
            toReturn.add(TipoAtividadeEnum.CNAE);
        }
        if (this.habilitarTipoAtividadeMeiConfiguracaoAtividade()) {
            toReturn.add(TipoAtividadeEnum.MEI);
        }
        if (this.habilitarTipoAtividadeCboConfiguracaoAtividade()) {
            toReturn.add(TipoAtividadeEnum.CBO);
        }
        return toReturn;
    }

    public boolean habilitarTipoAtividadeMeiConfiguracaoAtividade() {
        ArrayList siglasTipoInscricao = Lists.newArrayList();
        siglasTipoInscricao.add("M");
        siglasTipoInscricao.add("MP");
        return this.hasNaturezasAtivasSiglasTipoInscricao((List)siglasTipoInscricao);
    }

    public boolean habilitarTipoAtividadeCnaeConfiguracaoAtividade() {
        ArrayList siglasTipoInscricao = Lists.newArrayList();
        siglasTipoInscricao.add("N");
        return this.hasNaturezasAtivasSiglasTipoInscricao((List)siglasTipoInscricao);
    }

    public boolean habilitarTipoAtividadeCboConfiguracaoAtividade() {
        ArrayList siglasTipoInscricao = Lists.newArrayList();
        siglasTipoInscricao.add("C");
        return this.hasNaturezasAtivasSiglasTipoInscricao((List)siglasTipoInscricao);
    }

    private boolean hasNaturezasAtivasSiglasTipoInscricao(List<String> siglasTipoInscricao) {
        NaturezaSolicitacaoTipoInscricaoFilter filter = new NaturezaSolicitacaoTipoInscricaoFilter.BuilderNaturezaSolicitacaoTipoInscricaoFilter().ativo(Boolean.valueOf(true)).siglasTipoInscricao(siglasTipoInscricao).build();
        List naturezas = this.repositoryNaturezaSolicitacaoTipoInscricaoAlvara.carregarNaturezasSolicitacaoTipoInscricaoByFilter(filter);
        return EloListUtils.safeIsEmpty((List)naturezas) == false;
    }
}

