/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.HistoricoExigenciaUrlDocEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoDocRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.UrlArquivoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.AnexoConsultaPreviaRedeSimVo;
import br.com.elotech.portalarrecadacao.domain.vo.AnexoSolicitacaoRedeSimVo;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.DeferirRedeSimException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Arquivo;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.ConsultaPreviaDTO;
import br.com.elotech.portalarrecadacao.repository.RepositoryHistoricoExigenciaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryHistoricoExigenciaUrlDoc;
import br.com.elotech.portalarrecadacao.repository.RepositorySolicitacaoDocRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryUrlArquivoRedeSim;
import br.com.elotech.portalarrecadacao.rest.response.RedeSimErrorMessage;
import br.com.elotech.portalarrecadacao.rest.service.RestRequestService;
import br.com.elotech.portalarrecadacao.service.SrvAnexosSolicitacaoVo;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraHelperImpl;
import br.com.elotech.util.json.EloJsonUtils;
import br.com.elotech.util.list.EloListUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.faces.context.FacesContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResourceAccessException;

@EloService(value="srvAnexosSolicitacaoVo")
@Scope(value="prototype")
public class SrvAnexosSolicitacaoVoImpl
extends SrvSolicitacaoAlvaraHelperImpl
implements SrvAnexosSolicitacaoVo {
    private static final String HEADER_AUTH = "auth-token";
    @Resource
    private RepositorySolicitacaoDocRedeSim repositorySolicitacaoDocRedeSim;
    @Resource
    private RepositoryHistoricoExigenciaRedeSim repositoryHistoricoExigenciaRedeSim;
    @Resource
    private RepositoryHistoricoExigenciaUrlDoc repositoryHistoricoExigenciaUrlDoc;
    @Resource
    private RepositoryUrlArquivoRedeSim repositoryUrlArquivoRedeSim;

    public void setRepositoryHistoricoExigenciaUrlDoc(RepositoryHistoricoExigenciaUrlDoc repositoryHistoricoExigenciaUrlDoc) {
        this.repositoryHistoricoExigenciaUrlDoc = repositoryHistoricoExigenciaUrlDoc;
    }

    public void setRepositorySolicitacaoDocRedeSim(RepositorySolicitacaoDocRedeSim repositorySolicitacaoDocRedeSim) {
        this.repositorySolicitacaoDocRedeSim = repositorySolicitacaoDocRedeSim;
    }

    public void setRepositoryHistoricoExigenciaRedeSim(RepositoryHistoricoExigenciaRedeSim repositoryHistoricoExigenciaRedeSim) {
        this.repositoryHistoricoExigenciaRedeSim = repositoryHistoricoExigenciaRedeSim;
    }

    public void setRepositoryUrlArquivoRedeSim(RepositoryUrlArquivoRedeSim repositoryUrlArquivoRedeSim) {
        this.repositoryUrlArquivoRedeSim = repositoryUrlArquivoRedeSim;
    }

    public List<AnexoSolicitacaoRedeSimVo> montarAnexosSolicitacaoVo(SolicitacaoRedeSimEntity solicitacao) {
        ArrayList<AnexoSolicitacaoRedeSimVo> anexosSolicitacao = new ArrayList<AnexoSolicitacaoRedeSimVo>();
        List exigencias = this.repositoryHistoricoExigenciaRedeSim.findBySolicitacaoId(solicitacao.getId());
        List solicitacoesDoc = this.repositorySolicitacaoDocRedeSim.getSolicitacoesDocumento(solicitacao);
        if (!EloListUtils.safeIsEmpty((List)exigencias).booleanValue()) {
            for (HistoricoExigenciaRedeSimEntity exigencia : exigencias) {
                if (EloListUtils.safeIsEmpty((List)exigencia.getUrlsDocHistoricoExigencia()).booleanValue()) continue;
                for (HistoricoExigenciaUrlDocEntity urlDoc : exigencia.getUrlsDocHistoricoExigencia()) {
                    anexosSolicitacao.add(this.criarAnexoSolicitacaoUrlDocExigenciaVo(urlDoc));
                }
            }
        }
        if (!EloListUtils.safeIsEmpty((List)solicitacoesDoc).booleanValue()) {
            for (SolicitacaoDocRedeSimEntity solicitacaoDoc : solicitacoesDoc) {
                if (EloListUtils.safeIsEmpty((List)solicitacaoDoc.getUrlArquivos()).booleanValue()) continue;
                for (UrlArquivoRedeSimEntity urlArquivo : solicitacaoDoc.getUrlArquivos()) {
                    anexosSolicitacao.add(this.criarAnexoSolicitacaoUrlDocArquivoVo(urlArquivo));
                }
            }
        }
        return anexosSolicitacao;
    }

    private AnexoSolicitacaoRedeSimVo criarAnexoSolicitacaoUrlDocArquivoVo(UrlArquivoRedeSimEntity urlArquivo) {
        AnexoSolicitacaoRedeSimVo anexoSolicitacaoVo = new AnexoSolicitacaoRedeSimVo();
        anexoSolicitacaoVo.setIdUrlArquivoRedeSim(urlArquivo.getId());
        anexoSolicitacaoVo.setTipo("Solicita\u00e7\u00e3o de Documento");
        anexoSolicitacaoVo.setValidado(urlArquivo.isValidado());
        return anexoSolicitacaoVo;
    }

    private AnexoSolicitacaoRedeSimVo criarAnexoSolicitacaoUrlDocExigenciaVo(HistoricoExigenciaUrlDocEntity urlDoc) {
        AnexoSolicitacaoRedeSimVo anexoSolicitacaoVo = new AnexoSolicitacaoRedeSimVo();
        anexoSolicitacaoVo.setIdHistoricoExigenciaUrlDoc(urlDoc.getId());
        if (Objects.isNull(urlDoc.getTipoArquivo())) {
            anexoSolicitacaoVo.setTipo("Exig\u00eancia");
        } else {
            anexoSolicitacaoVo.setTipo(urlDoc.getTipoArquivo().getDescricao());
        }
        anexoSolicitacaoVo.setValidado(urlDoc.isValidado());
        return anexoSolicitacaoVo;
    }

    public void buscarDocumentoAnexo(AnexoSolicitacaoRedeSimVo anexoSolicitacao) throws BaseException {
        byte[] documento;
        String url;
        String token = this.getParametroAlvara(ParametroAlvaraEnum.SERVER_TOKEN_SOLICITACAO_REDESIM).getValor();
        if (anexoSolicitacao.getIdHistoricoExigenciaUrlDoc() != null) {
            HistoricoExigenciaUrlDocEntity exigenciaUrl = this.repositoryHistoricoExigenciaUrlDoc.buscarExigenciaUrlPorId(anexoSolicitacao.getIdHistoricoExigenciaUrlDoc());
            try {
                if (exigenciaUrl.getDocumento() == null) {
                    url = exigenciaUrl.getUrl();
                    documento = this.getDocumentoAnexo(url, token);
                    exigenciaUrl.setDocumento(documento);
                    this.repositoryHistoricoExigenciaUrlDoc.saveOrUpdate(exigenciaUrl);
                    this.imprimirRelatorio(documento);
                } else {
                    this.imprimirRelatorio(exigenciaUrl.getDocumento());
                }
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SolicitacaoAlvaraException("Houve um erro para imprimir o documento, entre em contato com o suporte.");
            }
        }
        if (anexoSolicitacao.getIdUrlArquivoRedeSim() != null) {
            UrlArquivoRedeSimEntity urlArquivo = this.repositoryUrlArquivoRedeSim.buscarUrlArquivoPorId(anexoSolicitacao.getIdUrlArquivoRedeSim());
            try {
                if (urlArquivo.getDocumento() == null) {
                    url = urlArquivo.getUrl();
                    documento = this.getDocumentoAnexo(url, token);
                    urlArquivo.setDocumento(documento);
                    this.repositoryUrlArquivoRedeSim.saveOrUpdate(urlArquivo);
                    this.imprimirRelatorio(documento);
                } else {
                    this.imprimirRelatorio(urlArquivo.getDocumento());
                }
            }
            catch (IOException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SolicitacaoAlvaraException("Houve um erro parar imprimir o documento, entre em contato com o suporte.");
            }
        }
    }

    public byte[] getDocumentoAnexo(String url, String token) throws BaseException {
        try {
            RestRequestService restRequestService = new RestRequestService();
            HttpHeaders headers = new HttpHeaders();
            headers.add(HEADER_AUTH, token);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = restRequestService.getWithHeaders(url, entity, org.springframework.core.io.Resource.class);
            int status = response.getStatusCode().value();
            if (status != HttpStatus.OK.value() && status != HttpStatus.CREATED.value()) {
                throw new DeferirRedeSimException(String.format("%s%s", "Ocorreu uma falha ao enviar requisi\u00e7\u00e3o: ", response.getStatusCode()));
            }
            return IOUtils.toByteArray((InputStream)((org.springframework.core.io.Resource)response.getBody()).getInputStream());
        }
        catch (IOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraRedeSimException("Ocorreu um erro inesperado, entre em contato com o Suporte");
        }
        catch (ResourceAccessException e) {
            throw new SolicitacaoAlvaraRedeSimException(" N\u00e3o houve exito em receber os arquivos solicitados, provavelmente o Servidor da Rede Sim est\u00e1 fora do ar! Tente mais tarde!");
        }
        catch (HttpClientErrorException e) {
            RedeSimErrorMessage message = (RedeSimErrorMessage)EloJsonUtils.fromJson((String)e.getResponseBodyAsString(), RedeSimErrorMessage.class);
            throw new SolicitacaoAlvaraRedeSimException(message.getErro());
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraRedeSimException(String.format("Ocorreu uma Falha ao enviar a resposta. %s", e.getMessage()), (Throwable)e);
        }
        catch (HttpServerErrorException ex) {
            this.logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new SolicitacaoAlvaraRedeSimException(String.format("Ocorreu uma Falha ao enviar a resposta. %s", ex.getMessage()), (Throwable)ex);
        }
    }

    private void imprimirRelatorio(byte[] relatorio) throws IOException {
        ServletOutputStream outputStream = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType("application/pdf");
        response.setHeader("Content-disposition", "inline; filename=\"relatorio.pdf\"");
        response.setContentLength(relatorio.length);
        outputStream = response.getOutputStream();
        outputStream.write(relatorio, 0, relatorio.length);
        outputStream.flush();
        outputStream.close();
        facesContext.responseComplete();
    }

    public List<AnexoConsultaPreviaRedeSimVo> montarAnexosConsultaPreviaRedeSim(ConsultaPreviaDTO arquivoConsultaRedeSim) {
        ArrayList<AnexoConsultaPreviaRedeSimVo> anexosConsultaPreviaRedeSimVo = new ArrayList<AnexoConsultaPreviaRedeSimVo>();
        if (arquivoConsultaRedeSim.getDados_consulta_previa().getUtilizacao_solo() != null && !EloListUtils.safeIsEmpty((List)arquivoConsultaRedeSim.getDados_consulta_previa().getUtilizacao_solo().getDs_arquivo()).booleanValue()) {
            for (Arquivo arquivo : arquivoConsultaRedeSim.getDados_consulta_previa().getUtilizacao_solo().getDs_arquivo()) {
                AnexoConsultaPreviaRedeSimVo anexoConsulta = new AnexoConsultaPreviaRedeSimVo();
                anexoConsulta.setTipo(arquivoConsultaRedeSim.getDados_consulta_previa().getUtilizacao_solo().getTipoAutorizacaoPorCodigo());
                anexoConsulta.setNumeroAutorizacao(arquivoConsultaRedeSim.getDados_consulta_previa().getUtilizacao_solo().getNu_autorizacao());
                anexoConsulta.setUrlDocumento(arquivo.getDs_url_servico());
                anexosConsultaPreviaRedeSimVo.add(anexoConsulta);
            }
        }
        return anexosConsultaPreviaRedeSimVo;
    }

    public void validarOuInvalidarDocumentoAnexoSolicitacao(AnexoSolicitacaoRedeSimVo docAnexo) {
        if (docAnexo.getIdHistoricoExigenciaUrlDoc() != null) {
            HistoricoExigenciaUrlDocEntity exigenciaUrl;
            exigenciaUrl.setValidado(!(exigenciaUrl = this.repositoryHistoricoExigenciaUrlDoc.buscarExigenciaUrlPorId(docAnexo.getIdHistoricoExigenciaUrlDoc())).isValidado());
            this.repositoryHistoricoExigenciaUrlDoc.saveOrUpdate(exigenciaUrl);
        }
        if (docAnexo.getIdUrlArquivoRedeSim() != null) {
            UrlArquivoRedeSimEntity urlArquivo;
            urlArquivo.setValidado(!(urlArquivo = this.repositoryUrlArquivoRedeSim.buscarUrlArquivoPorId(docAnexo.getIdUrlArquivoRedeSim())).isValidado());
            this.repositoryUrlArquivoRedeSim.saveOrUpdate(urlArquivo);
        }
    }

    public Boolean isDocumentosValidados(SolicitacaoRedeSimEntity solicitacaoRedeSim) {
        List solicitacoesDoc;
        if (!EloListUtils.safeIsEmpty((List)solicitacaoRedeSim.getHistoricosExigencias()).booleanValue()) {
            for (HistoricoExigenciaRedeSimEntity exigencia : solicitacaoRedeSim.getHistoricosExigencias()) {
                if (EloListUtils.safeIsEmpty((List)exigencia.getUrlsDocHistoricoExigencia()).booleanValue()) continue;
                for (HistoricoExigenciaUrlDocEntity urlDoc : exigencia.getUrlsDocHistoricoExigencia()) {
                    if (urlDoc.isValidado()) continue;
                    return Boolean.FALSE;
                }
            }
        }
        if (!EloListUtils.safeIsEmpty((List)(solicitacoesDoc = this.repositorySolicitacaoDocRedeSim.getSolicitacoesDocumento(solicitacaoRedeSim))).booleanValue()) {
            for (SolicitacaoDocRedeSimEntity solicitacaoDoc : solicitacoesDoc) {
                if (EloListUtils.safeIsEmpty((List)solicitacaoDoc.getUrlArquivos()).booleanValue()) continue;
                for (UrlArquivoRedeSimEntity urlArquivo : solicitacaoDoc.getUrlArquivos()) {
                    if (urlArquivo.isValidado()) continue;
                    return Boolean.FALSE;
                }
            }
        }
        return Boolean.TRUE;
    }
}

