/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SituacaoDocRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.LaudoNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.StatusDocumentos;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.Exigencia;
import br.com.elotech.portalarrecadacao.repository.RepositoryAndamentoLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryAndamentoLaudoRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryDocumentoRedeSimLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositorySituacaoDocRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvAndamentoLaudoRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvLaudoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvSolicitacaoAlvaraHelper;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.exceptions.InvalidDateString;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.gson.Gson;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;

@EloService(value="srvAndamentoLaudoRedeSim")
public class SrvAndamentoLaudoRedeSimImpl
extends EloLogger
implements SrvAndamentoLaudoRedeSim {
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;
    @Resource
    private RepositoryDocumentoRedeSimLaudoAlvara repositoryDocumentoRedeSimLaudoAlvara;
    @Resource
    private RepositorySituacaoDocRedeSim repositorySituacaoDocRedeSim;
    @Resource
    private SrvLaudoAlvara srvLaudoAlvara;
    @Resource
    private SrvSolicitacaoAlvaraHelper srvSolicitacaoAlvaraHelper;
    @Resource
    private RepositoryAndamentoLaudoRedeSim repositoryAndamentoLaudoRedeSim;
    @Resource
    private RepositoryLaudoAlvara repositoryLaudoAlvara;
    @Resource
    private RepositoryAndamentoLaudoAlvara repositoryAndamentoLaudoAlvara;

    protected void setRepositoryAndamentoLaudoAlvara(RepositoryAndamentoLaudoAlvara repositoryAndamentoLaudoAlvara) {
        this.repositoryAndamentoLaudoAlvara = repositoryAndamentoLaudoAlvara;
    }

    protected void setRepositoryDocumentoRedeSimLaudoAlvara(RepositoryDocumentoRedeSimLaudoAlvara repositoryDocumentoRedeSimLaudoAlvara) {
        this.repositoryDocumentoRedeSimLaudoAlvara = repositoryDocumentoRedeSimLaudoAlvara;
    }

    protected void setRepositorySituacaoDocRedeSim(RepositorySituacaoDocRedeSim repositorySituacaoDocRedeSim) {
        this.repositorySituacaoDocRedeSim = repositorySituacaoDocRedeSim;
    }

    protected void setRepositoryConsultaRedeSim(RepositoryConsultaRedeSim repositoryConsultaRedeSim) {
        this.repositoryConsultaRedeSim = repositoryConsultaRedeSim;
    }

    public AndamentoLaudoRedeSimEntity processarAndamento(StatusDocumentos statusDocumentos) throws BaseException {
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.getSolicitacaoRedeSim(statusDocumentos);
        TipoLaudoEntity tipoLaudoSelecionado = this.getTipoLaudo(statusDocumentos);
        LaudoAlvaraEntity laudoAlvaraSelecionado = this.getLaudoSelecionado(solicitacaoRedeSim, tipoLaudoSelecionado);
        AndamentoLaudoAlvaraEntity andamentoLaudo = new AndamentoLaudoAlvaraEntity();
        andamentoLaudo.setIdAndamentoLaudoAlvara(this.repositoryAndamentoLaudoAlvara.getSequence());
        andamentoLaudo.setIdLaudoAlvara(laudoAlvaraSelecionado);
        andamentoLaudo.setDataAndamento(new Date());
        andamentoLaudo.setDescricao(statusDocumentos.getDados_documento().getDs_observacao());
        SituacaoDocRedeSimEntity situacaoDocRedeSim = this.getSituacaoDocRedeSim(statusDocumentos);
        andamentoLaudo.setStatus(StatusLaudoAlvara.getStatusByCodigo((String)situacaoDocRedeSim.getSituacaoLaudo()));
        andamentoLaudo.setUsuario(this.srvSolicitacaoAlvaraHelper.getUsuarioIntegraSGO());
        if (!EloStringUtils.isEmpty((String)statusDocumentos.getDados_documento().getDt_validade())) {
            try {
                andamentoLaudo.setStatus(StatusLaudoAlvara.LIBERADO_PROVISORIO);
                andamentoLaudo.setValidadeProvisorio(EloDateUtils.fromAnsiDateString((String)statusDocumentos.getDados_documento().getDt_validade(), (String)"YYYY-MM-DD"));
            }
            catch (InvalidDateString e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SolicitacaoAlvaraException("Falha ao converter data de validade.", e.getCause());
            }
        }
        if (!EloListUtils.safeIsEmpty((List)statusDocumentos.getDados_documento().getExigencias()).booleanValue()) {
            StringBuilder descExigencia = new StringBuilder();
            for (Exigencia exigencia : statusDocumentos.getDados_documento().getExigencias()) {
                descExigencia.append(" - ");
                descExigencia.append(exigencia.getCo_exigencia().toString()).append(" : ");
                descExigencia.append(exigencia.getDs_motivo_exigencia()).append(", ");
            }
            andamentoLaudo.setDescricao(andamentoLaudo.getDescricao().concat(descExigencia.toString()));
        }
        laudoAlvaraSelecionado.setStatus(andamentoLaudo.getStatus());
        try {
            this.srvLaudoAlvara.salvarAndamento(laudoAlvaraSelecionado, andamentoLaudo, solicitacaoRedeSim.getSolicitacaoAlvara());
        }
        catch (BaseException | URISyntaxException e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new SolicitacaoAlvaraException("Falha ao salvar andamento no laudo.", e.getCause());
        }
        this.repositoryLaudoAlvara.saveOrUpdate(laudoAlvaraSelecionado);
        this.repositoryAndamentoLaudoAlvara.saveOrUpdate(andamentoLaudo);
        return this.salvarAndamentoLaudoRedeSim(statusDocumentos);
    }

    private AndamentoLaudoRedeSimEntity salvarAndamentoLaudoRedeSim(StatusDocumentos statusDocumentos) {
        AndamentoLaudoRedeSimEntity andamento = new AndamentoLaudoRedeSimEntity();
        andamento.setId(this.repositoryAndamentoLaudoRedeSim.getSequence());
        andamento.setData(new Date());
        Gson gson = new Gson();
        andamento.setDocumento(gson.toJson((Object)statusDocumentos));
        return this.repositoryAndamentoLaudoRedeSim.saveOrUpdate(andamento);
    }

    protected SituacaoDocRedeSimEntity getSituacaoDocRedeSim(StatusDocumentos statusDocumentos) {
        return this.repositorySituacaoDocRedeSim.getSituacaoByCodigo(Long.valueOf(statusDocumentos.getDados_documento().getCo_situacao().longValue()));
    }

    protected LaudoAlvaraEntity getLaudoSelecionado(SolicitacaoRedeSimEntity solicitacaoRedeSim, TipoLaudoEntity tipoLaudoSelecionado) {
        return solicitacaoRedeSim.getSolicitacaoAlvara().getLaudoSelecionado(tipoLaudoSelecionado.getIdTipoLaudo());
    }

    protected TipoLaudoEntity getTipoLaudo(StatusDocumentos statusDocumentos) throws LaudoNaoEncontradoException {
        return this.repositoryDocumentoRedeSimLaudoAlvara.getTipoLaudo(new Long(statusDocumentos.getDados_documento().getCo_tipo_modelo_documento().intValue()));
    }

    protected SolicitacaoRedeSimEntity getSolicitacaoRedeSim(StatusDocumentos statusDocumentos) {
        return this.repositoryConsultaRedeSim.getConsultaByTipo(statusDocumentos.getDados_documento().getCo_protocolo_redesim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
    }
}

