/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ObservacaoAndamentoLaudoEntity;
import br.com.elotech.portalarrecadacao.repository.RepositoryAndamentoLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryLaudoAlvara;
import br.com.elotech.portalarrecadacao.repository.RepositoryObservacaoAndamentoLaudo;
import br.com.elotech.portalarrecadacao.service.SrvAndamentoLaudoAlvara;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;

@EloService(value="srvAndamentoLaudoAlvara")
public class SrvAndamentoLaudoAlvaraImpl
extends EloLogger
implements SrvAndamentoLaudoAlvara {
    @Autowired
    private RepositoryLaudoAlvara repositoryLaudoALvara;
    @Autowired
    private RepositoryAndamentoLaudoAlvara repositoryAndamentoLaudoAlvara;
    @Autowired
    private RepositoryObservacaoAndamentoLaudo repositoryObservacaoAndamentoLaudo;

    public void salvarAndamento(AndamentoLaudoAlvaraEntity andamentoLaudo) throws BaseException {
        if (andamentoLaudo.getIdAndamentoLaudoAlvara() == null) {
            andamentoLaudo.setIdAndamentoLaudoAlvara(this.repositoryAndamentoLaudoAlvara.getSequence());
        }
        if (andamentoLaudo.getProcessoFiscalizacao() != null && andamentoLaudo.getProcessoFiscalizacao().getId() == null) {
            andamentoLaudo.getProcessoFiscalizacao().setId(this.repositoryAndamentoLaudoAlvara.getSequenceProcessoFiscalizacao());
        }
        this.repositoryAndamentoLaudoAlvara.saveOrUpdate(andamentoLaudo);
        LaudoAlvaraEntity laudo = andamentoLaudo.getIdLaudoAlvara();
        laudo.setStatus(andamentoLaudo.getStatus());
        this.repositoryLaudoALvara.saveOrUpdate(laudo);
        this.repositoryLaudoALvara.flush();
    }

    public void adicionarAndamentoLaudoRiscoBaixo(LaudoAlvaraEntity laudoAlvara, UsuarioEntity usuarioLogado) {
        AndamentoLaudoAlvaraEntity andamento = new AndamentoLaudoAlvaraEntity();
        andamento.setStatus(laudoAlvara.getStatus());
        andamento.setUsuario(usuarioLogado);
        andamento.setDataAndamento(new Date());
        andamento.setIdLaudoAlvara(laudoAlvara);
        andamento.setIdAndamentoLaudoAlvara(this.repositoryAndamentoLaudoAlvara.getSequence());
        this.addObservacaoLaudoRiscoBaixo(andamento);
        this.repositoryAndamentoLaudoAlvara.saveOrUpdate(andamento);
    }

    private AndamentoLaudoAlvaraEntity addObservacaoLaudoRiscoBaixo(AndamentoLaudoAlvaraEntity andamento) {
        ObservacaoAndamentoLaudoEntity observacaoAndamentoLaudo = new ObservacaoAndamentoLaudoEntity();
        observacaoAndamentoLaudo.setId(this.repositoryObservacaoAndamentoLaudo.getSequence());
        observacaoAndamentoLaudo.setDescricao("Laudo Liberado Risco Baixo.");
        observacaoAndamentoLaudo.setIdAndamentoLaudoAlvara(andamento);
        observacaoAndamentoLaudo.setUsuario(andamento.getUsuario());
        observacaoAndamentoLaudo.setDataObservacao(new Date());
        observacaoAndamentoLaudo.setResolvido(SimNaoEnum.SIM.getShortText());
        andamento.getObservacoes().add(observacaoAndamentoLaudo);
        return andamento;
    }
}

