/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.portalarrecadacao.domain.AndamentoAlvaraProvisorioEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.TipoAlvaraEnum;
import br.com.elotech.portalarrecadacao.filter.FiltroAlvaraProvisorioRedeSim;
import br.com.elotech.portalarrecadacao.repository.RepositoryAndamentoAlvaraProvisorio;
import br.com.elotech.portalarrecadacao.repository.RepositoryConsultaRedeSim;
import br.com.elotech.portalarrecadacao.service.SrvAndamentoAlvaraProvisorio;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.hibernate.Hibernate;
import org.springframework.security.core.context.SecurityContextHolder;

@EloService(value="srvAndamentoAlvaraProvisorio")
public class SrvAndamentoAlvaraProvisorioImpl
implements SrvAndamentoAlvaraProvisorio {
    @Resource
    private RepositoryAndamentoAlvaraProvisorio repositoryAndamentoAlvaraProvisorio;
    @Resource
    private RepositoryConsultaRedeSim repositoryConsultaRedeSim;

    public AndamentoAlvaraProvisorioEntity salvarAndamentoAlvaraProvisorio(Long solicitacaoAlvara) {
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.repositoryConsultaRedeSim.getSolicitacaoBySolicitacaoAlvara(solicitacaoAlvara);
        if (Objects.isNull(solicitacaoRedeSim.getAlvaraEnviado()) || TipoAlvaraEnum.FUNCIONAMENTO_PROVISORIO.equals((Object)solicitacaoRedeSim.getAlvaraEnviado())) {
            AndamentoAlvaraProvisorioEntity andamentoAlvara = new AndamentoAlvaraProvisorioEntity();
            andamentoAlvara.setSolicitacaoRedeSim(solicitacaoRedeSim);
            andamentoAlvara.setEnviouAlvara(SimNaoEnum.getNaoShortText());
            andamentoAlvara.setGerouAlvara(SimNaoEnum.getNaoShortText());
            andamentoAlvara.setGerouDebito(SimNaoEnum.getNaoShortText());
            andamentoAlvara.setDataAndamento(new Date());
            UsuarioEntity usuarioLogado = (UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            andamentoAlvara.setUsuario(usuarioLogado);
            this.repositoryAndamentoAlvaraProvisorio.save(andamentoAlvara);
            return andamentoAlvara;
        }
        return null;
    }

    public void setRepositoryAndamentoAlvaraProvisorio(RepositoryAndamentoAlvaraProvisorio repositoryAndamentoAlvaraProvisorio) {
        this.repositoryAndamentoAlvaraProvisorio = repositoryAndamentoAlvaraProvisorio;
    }

    public void setRepositoryConsultaRedeSim(RepositoryConsultaRedeSim repositoryConsultaRedeSim) {
        this.repositoryConsultaRedeSim = repositoryConsultaRedeSim;
    }

    public List<AndamentoAlvaraProvisorioEntity> pesquisarAlvarasProvisorio(FiltroAlvaraProvisorioRedeSim filtro) {
        return this.repositoryAndamentoAlvaraProvisorio.pesquisarAlvarasProvisorio(filtro);
    }

    private void inicializarDadosLazyLoading(SolicitacaoRedeSimEntity consultaRedeSim) {
        if (Objects.nonNull(consultaRedeSim.getSolicitacaoAlvara())) {
            Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getNaturezas());
            Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getDocumentos());
            Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getLaudos());
            Hibernate.initialize((Object)consultaRedeSim.getHistoricosExigencias());
            Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getCadastroImobiliario().getSegmentos());
            if (consultaRedeSim.getSolicitacaoAlvara().getCadastroMobiliario() != null) {
                if (consultaRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral() != null) {
                    Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral().getIsencoes());
                    if (consultaRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral().getPessoa() != null) {
                        Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral().getPessoa().getContatos());
                        Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getCadastroGeral().getPessoa().getEnderecos());
                    }
                }
                Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioServicos());
                Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioCnaes());
                Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioSituacao());
                consultaRedeSim.getSolicitacaoAlvara().getCadastroMobiliario().getMobiliarioSituacao().stream().forEach(p -> Hibernate.initialize((Object)p.getSituacaoMobiliario().getSituacoesMobiliarioAlvara()));
            }
            Hibernate.initialize((Object)consultaRedeSim.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades());
            consultaRedeSim.getSolicitacaoAlvara().getSolicitacaoAlvaraAtividades().stream().forEach(p -> Hibernate.initialize((Object)p.getNumerosConselho()));
        }
    }

    public List<AndamentoAlvaraProvisorioEntity> buscarTramitesAlvara(SolicitacaoRedeSimEntity solicitacaoRedeSim) {
        return this.repositoryAndamentoAlvaraProvisorio.buscarTramitesAlvara(solicitacaoRedeSim);
    }

    public void adicionarHistoricoAndamentoAlvaraProvisorio(AndamentoAlvaraProvisorioEntity andamento) {
        andamento.setDataAndamento(new Date());
        UsuarioEntity usuarioLogado = (UsuarioEntity)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        andamento.setUsuario(usuarioLogado);
        this.repositoryAndamentoAlvaraProvisorio.save(andamento);
    }

    public AndamentoAlvaraProvisorioEntity carregarUltimoAndamentoAlvaraProvisorio(SolicitacaoRedeSimEntity solicitacaoRedeSim) {
        AndamentoAlvaraProvisorioEntity andamento = this.repositoryAndamentoAlvaraProvisorio.carregarUltimoAndamentoAlvaraProvisorio(solicitacaoRedeSim);
        this.inicializarDadosLazyLoading(andamento.getSolicitacaoRedeSim());
        return andamento;
    }
}

