/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.service.SrvAberturaProcessoFiscalizacaoAutomatico;
import br.com.elotech.portalarrecadacao.service.SrvProcessoFiscalizacao;
import br.com.elotech.tributacao.domain.aise.TipoDocTipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.repository.aise.RepositoryTipoDocTipoInscricaoAlvara;
import br.com.elotech.util.list.EloListUtils;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;

@EloService(value="srvAberturaProcessoFiscalizacaoAutomatico")
public class SrvAberturaProcessoFiscalizacaoAutomaticoImpl
implements SrvAberturaProcessoFiscalizacaoAutomatico {
    @Resource
    private RepositoryTipoDocTipoInscricaoAlvara repositoryTipoDocTipoInscricaoAlvara;
    @Resource
    private SrvProcessoFiscalizacao srvProcessoFiscalizacao;

    public void setRepositoryTipoDocTipoInscricaoAlvara(RepositoryTipoDocTipoInscricaoAlvara repositoryTipoDocTipoInscricaoAlvara) {
        this.repositoryTipoDocTipoInscricaoAlvara = repositoryTipoDocTipoInscricaoAlvara;
    }

    public void setSrvProcessoFiscalizacao(SrvProcessoFiscalizacao srvProcessoFiscalizacao) {
        this.srvProcessoFiscalizacao = srvProcessoFiscalizacao;
    }

    public void abrirProcessos(SolicitacaoAlvaraEntity solicitacaoAlvara, Optional<Integer> idAssunto) throws BaseException, URISyntaxException {
        if (this.permiteAbrirProcessos(solicitacaoAlvara)) {
            this.srvProcessoFiscalizacao.abrirProcesso(solicitacaoAlvara, Optional.empty());
        }
    }

    private boolean permiteAbrirProcessos(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        return !SimNaoEnum.SIM.getShortText().equalsIgnoreCase(solicitacaoAlvara.getProcessoGerado()) && this.isAberturaAutomaticaHabilitada() && this.isDocumentosObrigatoriosValidados(solicitacaoAlvara) && this.possuiAlgumLaudoIntegracaoEmAndamento(solicitacaoAlvara);
    }

    private boolean isAberturaAutomaticaHabilitada() throws BaseException {
        String habilitaAberturaProcesso = UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.HABILITA_ABERTURA_PROCESSO_AUTOMATICA);
        return SimNaoEnum.SIM.getShortText().equalsIgnoreCase(habilitaAberturaProcesso);
    }

    protected boolean isDocumentosObrigatoriosValidados(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        if (!this.isTodosDocumentosValidos(solicitacaoAlvara.getDocumentos())) {
            return false;
        }
        return this.isTodosDocumentosObrigatoriosAnexados(solicitacaoAlvara);
    }

    private boolean isTodosDocumentosObrigatoriosAnexados(SolicitacaoAlvaraEntity solicitacaoAlvara) {
        List tiposDocumentos = this.repositoryTipoDocTipoInscricaoAlvara.carregaTiposDocumentoPorTipoInscricao(solicitacaoAlvara.getTipoDeInscricao());
        List tiposDocumentoObrigatorios = tiposDocumentos.stream().filter(tipo -> "S".equals(tipo.getObrigatorio())).collect(Collectors.toList());
        for (TipoDocTipoInscricaoAlvaraEntity tipoDocumentoObrigatorio : tiposDocumentoObrigatorios) {
            boolean documentoEncontrado = false;
            for (SolicitacaoAlvaraDocumentoEntity documentoDaSolicitacao : solicitacaoAlvara.getDocumentos()) {
                if (documentoDaSolicitacao.getTipoDocumento().getTipoDocumento().compareTo(tipoDocumentoObrigatorio.getTipoDocumento().getTipoDocumento()) != 0) continue;
                documentoEncontrado = true;
                break;
            }
            if (documentoEncontrado) continue;
            return false;
        }
        return true;
    }

    protected boolean isTodosDocumentosValidos(List<SolicitacaoAlvaraDocumentoEntity> listaDocumentos) {
        if (!EloListUtils.safeIsEmpty(listaDocumentos).booleanValue()) {
            for (SolicitacaoAlvaraDocumentoEntity documento : listaDocumentos) {
                if (!documento.isDocumentoNaoValidado()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean possuiAlgumLaudoIntegracaoEmAndamento(SolicitacaoAlvaraEntity solicitacao) {
        try {
            List laudos = this.srvProcessoFiscalizacao.getLaudosIntegracaoEmAndamento(solicitacao);
            return !laudos.isEmpty();
        }
        catch (BaseException e) {
            return false;
        }
    }
}

