/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.service.impl;

import br.com.elotech.annotations.spring.EloService;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.EventoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoBaixaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.RestricaoAlvaraVo;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.RedeSimEventoEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.EventosNaoTratadosException;
import br.com.elotech.portalarrecadacao.exception.ProtocoloMenorQueOInicialException;
import br.com.elotech.portalarrecadacao.exception.RegistroProcessadoAnteriormenteException;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeSituacaoMobiliarioAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.DadosSolicitacao;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Evento;
import br.com.elotech.portalarrecadacao.integration.transformer.ProcessaConsulta;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraRedeSimDTO;
import br.com.elotech.portalarrecadacao.rest.resource.RedeSimBaseResource;
import br.com.elotech.portalarrecadacao.service.ProcessamentoWS02Service;
import br.com.elotech.portalarrecadacao.service.impl.SrvSolicitacaoAlvaraRedeSimImpl;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@EloService
public class ProcessamentoWS02ServiceImpl
implements ProcessamentoWS02Service {
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoWS02ServiceImpl.class);
    @Autowired
    private FacadeRedeSim facadeRedeSim;
    @Autowired
    private FacadeSolicitacaoAlvara facadeSolicitacaoAlvara;
    @Autowired
    private FacadeSituacaoMobiliarioAlvara facadeSituacaoMobiliarioAlvara;
    @Autowired
    private ProcessaConsulta processaConsulta;

    public DadosSolicitacao processar(String protocolo, String token, String json, SolicitacaoAlvaraRedeSimDTO solicitacaoRedeSimDTO) throws BaseException {
        Long numeroProtocolo = EloStringUtils.getLongFromString((String)protocolo);
        if (RedeSimBaseResource.isLowerThanProtocoloInicialRedeSim((Long)numeroProtocolo).booleanValue()) {
            throw new ProtocoloMenorQueOInicialException(String.format("Protocolo %d menor que o inicial %d.", numeroProtocolo, RedeSimBaseResource.getProtocoloInicialRedeSim()));
        }
        if (this.processaConsulta.existeConsultaOuSolicitacaoComProtocolo(protocolo, TipoSolicitacaoRedeSimEnum.SOLICITACAO)) {
            throw new RegistroProcessadoAnteriormenteException("Processado anteriormente.");
        }
        boolean solicitacaoDeBaixaAtiva = SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.SOLICITACAO_BAIXA_ATIVAR));
        boolean solicitacaoDeBaixa = this.verificaSolicitacaoBaixa(solicitacaoRedeSimDTO.getDados_solicitacao(), token);
        List naturezas = this.processaConsulta.getNaturezaEventoSolicitacao(solicitacaoRedeSimDTO.getDados_solicitacao());
        if (!(!EloListUtils.safeIsEmpty((List)naturezas).booleanValue() || solicitacaoDeBaixaAtiva && solicitacaoDeBaixa)) {
            ArrayList<Long> listaEventos = new ArrayList<Long>();
            for (Evento e : solicitacaoRedeSimDTO.getDados_solicitacao().getEventos_redesim()) {
                Long evento = e.getCo_evento();
                EventoRedeSimEntity eventoRedeSim = this.facadeRedeSim.getEventoRedeSim(evento);
                if (!Objects.isNull(eventoRedeSim)) continue;
                listaEventos.add(evento);
            }
            String eventos = listaEventos.stream().map(String::valueOf).collect(Collectors.joining(","));
            throw new EventosNaoTratadosException(String.format("Protocolo %s - eventos n\u00e3o tratados pelo sistema: %s.", protocolo, eventos));
        }
        SolicitacaoRedeSimEntity solicitacaoNaoProcessada = new SolicitacaoRedeSimEntity();
        solicitacaoNaoProcessada.setArquivoDadosEmpresa(json);
        solicitacaoNaoProcessada.setTipo(TipoSolicitacaoRedeSimEnum.SOLICITACAO.getSigla());
        solicitacaoNaoProcessada.setProtocolo(protocolo);
        solicitacaoNaoProcessada.setSituacao(SituacaoConsultaPreviaRedeSimEnum.NAO_PROCESSADO.getSigla());
        solicitacaoNaoProcessada = this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoNaoProcessada);
        if (solicitacaoDeBaixaAtiva && solicitacaoDeBaixa) {
            SolicitacaoBaixaRedeSimEntity solicitacaoBaixaRedeSim = new SolicitacaoBaixaRedeSimEntity();
            solicitacaoBaixaRedeSim.setSolicitacaoRedeSim(solicitacaoNaoProcessada);
            solicitacaoBaixaRedeSim = this.facadeRedeSim.salvarSolicitacaoBaixaRedeSim(solicitacaoBaixaRedeSim);
            solicitacaoNaoProcessada.setSolicitacaoBaixaRedeSim(solicitacaoBaixaRedeSim);
            solicitacaoNaoProcessada = this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoNaoProcessada);
        }
        DadosSolicitacao dadosSolicitacao = this.facadeRedeSim.solicitacaoAlvara(solicitacaoRedeSimDTO, solicitacaoNaoProcessada);
        boolean enviaInscricaoMunicipalDadosAtualizados = SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS));
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.facadeRedeSim.getConsultaRedeSim(solicitacaoRedeSimDTO.getDados_solicitacao().getCo_protocolo_redesim(), TipoSolicitacaoRedeSimEnum.SOLICITACAO);
        if (!enviaInscricaoMunicipalDadosAtualizados || !solicitacaoDeBaixa && this.possuiRestricaoCadastralBloqueante(solicitacaoRedeSim, token)) {
            dadosSolicitacao.setId(solicitacaoRedeSim.getId().intValue());
            return dadosSolicitacao;
        }
        log.info("WS02 - [{}] Realizando a gera\u00e7\u00e3o do cadastro mobili\u00e1rio e envio da inscri\u00e7\u00e3o municipal! protocolo: {} ", (Object)token, (Object)protocolo);
        this.generateCadastroMobiliarioAndInscricaoMunicipal("WS02", token, dadosSolicitacao, protocolo);
        dadosSolicitacao.setId(solicitacaoRedeSim.getId().intValue());
        return dadosSolicitacao;
    }

    private boolean verificaSolicitacaoBaixa(DadosSolicitacao dadosSolicitacao, String token) throws BaseException {
        boolean mudancaEnderecoParaForaDoMunicipio;
        List eventosSolicitacao = dadosSolicitacao.getEventos_redesim().stream().map(Evento::getCo_evento).map(Long::valueOf).collect(Collectors.toList());
        List<Long> eventosMudancaEndereco = Arrays.asList(RedeSimEventoEnum.EVENTO_209.getCodigo(), RedeSimEventoEnum.EVENTO_210.getCodigo());
        boolean mudancaEndereco = eventosSolicitacao.stream().anyMatch(eventosMudancaEndereco::contains);
        boolean bl = mudancaEnderecoParaForaDoMunicipio = mudancaEndereco && !this.processaConsulta.isMudancaEnderecoParaMunicipioDaEntidade(dadosSolicitacao);
        if (!eventosSolicitacao.contains(RedeSimEventoEnum.EVENTO_517.getCodigo()) && !mudancaEnderecoParaForaDoMunicipio) {
            return false;
        }
        if (eventosSolicitacao.contains(RedeSimEventoEnum.EVENTO_517.getCodigo())) {
            log.info("WS02 - [{}] Baixa - {}", (Object)token, (Object)RedeSimEventoEnum.EVENTO_517.getDescricao());
        }
        if (eventosSolicitacao.contains(RedeSimEventoEnum.EVENTO_209.getCodigo()) || eventosSolicitacao.contains(RedeSimEventoEnum.EVENTO_210.getCodigo())) {
            log.info("WS02 - [{}] Baixa - Altera\u00e7\u00e3o de endere\u00e7o para fora do munic\u00edpio", (Object)token);
        }
        return true;
    }

    private boolean possuiRestricaoCadastralBloqueante(SolicitacaoRedeSimEntity solicitacaoRedeSim, String token) throws BaseException {
        if (solicitacaoRedeSim.getSolicitacaoAlvara().isSolicitacaoJuridicaNormal() && !solicitacaoRedeSim.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica()) {
            log.info("WS02 - [{}] Analisando Restri\u00e7\u00e3o Cadastral - ", (Object)token);
            RestricaoAlvaraVo restricaoAlvaraVo = this.facadeSolicitacaoAlvara.verificarRestricaoCadastroAlvara(solicitacaoRedeSim.getSolicitacaoAlvara());
            if (!restricaoAlvaraVo.getRenderBtAvancar().booleanValue()) {
                log.info("WS02 - [{}] Restri\u00e7\u00e3o cadastral Bloqueante - ", (Object)token);
                this.facadeRedeSim.adicionarHistoricoDeAndamento(solicitacaoRedeSim, SituacaoConsultaPreviaRedeSimEnum.RESTRICAO_CADASTRAL, Optional.of(restricaoAlvaraVo.getDescricaoRestricao()));
                return true;
            }
        }
        return false;
    }

    private void generateCadastroMobiliarioAndInscricaoMunicipal(String prefix, String token, DadosSolicitacao dadosSolicitacao, String protocolo) throws BaseException {
        ((SrvSolicitacaoAlvaraRedeSimImpl)SpringContext.getBean(SrvSolicitacaoAlvaraRedeSimImpl.class)).generateCadastroMobiliarioAndInscricaoMunicipal(prefix, token, protocolo);
    }

    public void setFacadeRedeSim(FacadeRedeSim facadeRedeSim) {
        this.facadeRedeSim = facadeRedeSim;
    }

    public void setFacadeSolicitacaoAlvara(FacadeSolicitacaoAlvara facadeSolicitacaoAlvara) {
        this.facadeSolicitacaoAlvara = facadeSolicitacaoAlvara;
    }

    public void setFacadeSituacaoMobiliarioAlvara(FacadeSituacaoMobiliarioAlvara facadeSituacaoMobiliarioAlvara) {
        this.facadeSituacaoMobiliarioAlvara = facadeSituacaoMobiliarioAlvara;
    }

    public void setProcessaConsulta(ProcessaConsulta processaConsulta) {
        this.processaConsulta = processaConsulta;
    }
}

