/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.security;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.repository.RepositoryTipoLaudo;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.TipoDocumentoUsuarioAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.facade.FacadeLoginAise;
import br.com.elotech.tributacao.repository.aise.RepositoryTipoDocumento;
import br.com.elotech.tributacao.security.CustomUserKeyCloak;
import br.com.elotech.tributacao.service.SrvUnico;
import br.com.elotech.tributacao.service.SrvUsuarioTecnico;
import br.com.elotech.unico.rest.exception.UnicoClientException;
import br.com.elotech.util.enumerator.UsuarioMasterTecnicoEnum;
import br.com.elotech.util.exceptions.HashException;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.sql.Modulo;
import br.com.elotech.util.string.EloHashUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.keycloak.representations.AccessTokenResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Component
public class CustomUserAiseProvider
extends EloLogger
implements AuthenticationProvider,
UserDetailsService {
    @Resource
    private SrvUnico srvUnico;
    @Resource
    private SrvUsuarioTecnico srvUsuarioTecnico;
    @Resource
    private RepositoryTipoLaudo repositoryTipoLaudo;
    @Resource
    private RepositoryTipoDocumento repositoryTipoDocumento;
    @Autowired
    private CustomUserKeyCloak customUserKeyCloak;
    private static final String CLIENT_SECRET_KEYCLOAK_PROD_ALVARA = "851a20f6-2384-4bc8-8411-c6bfd0d678de";
    private static final String CLIENT_SECRET_KEYCLOAK_QA_ALVARA = "98ac5456-7888-4be9-879b-d9907e59bce9";

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UsernamePasswordAuthenticationToken auth;
        block12: {
            String cpfCnpj = authentication.getName();
            String password = (String)authentication.getCredentials();
            String passwordHash = "";
            auth = null;
            try {
                AccessTokenResponse token;
                if (UsuarioMasterTecnicoEnum.isUsuarioTecnicoOuMaster((String)cpfCnpj)) {
                    UserDetails user = null;
                    user = this.loadUserByUsername(cpfCnpj);
                    passwordHash = EloHashUtils.hashMD5((String)password);
                    if (!passwordHash.toUpperCase().equals(user.getPassword().toUpperCase())) {
                        throw new BadCredentialsException("Senha n\u00e3o est\u00e1 correta!");
                    }
                    user = this.carregarAuthorities(user);
                    return new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
                }
                if (UtilsController.isAutenticacaoKeyCloak() && (token = this.validarPeloKeycloak(cpfCnpj, password)) != null) {
                    auth = this.instanciarAutentication(cpfCnpj, password);
                    return auth;
                }
                UserDetails user = this.loadUserByUsername(cpfCnpj);
                if (user == null) break block12;
                if (Objects.nonNull(password)) {
                    if (this.srvUnico.isIntegrado()) {
                        try {
                            UsuarioEntity usuario = (UsuarioEntity)user;
                            String token2 = this.srvUnico.autenticar(usuario.getUsuario(), password);
                            usuario.setTokenUnico(token2);
                        }
                        catch (UnicoClientException e) {
                            throw new BadCredentialsException(e.getMessage());
                        }
                    }
                    try {
                        passwordHash = EloHashUtils.hashMD5((String)password);
                    }
                    catch (HashException e) {
                        this.logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    if (!passwordHash.toUpperCase().equals(user.getPassword().toUpperCase())) {
                        throw new BadCredentialsException("Senha n\u00e3o est\u00e1 correta!");
                    }
                }
                user = this.carregarAuthorities(user);
                auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
            }
            catch (Exception e1) {
                throw new BadCredentialsException("Ocorreu uma falha na classe CustomUserAiseProvider");
            }
        }
        return auth;
    }

    private UserDetails carregarAuthorities(UserDetails user) {
        UsuarioEntity usuario = (UsuarioEntity)user;
        try {
            usuario.setAuthorities((List)Lists.newArrayList());
            if (UsuarioMasterTecnicoEnum.isUsuarioTecnicoOuMaster((String)user.getUsername()) || UtilsController.isAutenticacaoKeyCloak()) {
                usuario.setAuthorities(this.srvUsuarioTecnico.carregarSeletoresPorModulo(Modulo.ALVARAONLINE));
                usuario.setTipoLaudos(this.carregarTiposLaudo(usuario));
                usuario.setTiposDocumento(this.carregarTiposDocumento(usuario));
            } else {
                List seletores = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).buscarSeletoresUsuarioPorModulo(usuario, Modulo.ALVARAONLINE);
                if (!EloListUtils.safeIsEmpty((List)seletores).booleanValue()) {
                    seletores.stream().forEach(seletor -> usuario.getAuthorities().add(new SimpleGrantedAuthority(seletor.getSeletor())));
                }
            }
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return usuario;
    }

    private List<TipoDocumentoUsuarioAlvaraEntity> carregarTiposDocumento(UsuarioEntity usuario) {
        ArrayList tipoDocumentosUsuario = Lists.newArrayList();
        List tiposDocumento = this.repositoryTipoDocumento.buscarTiposDocumento();
        if (!EloListUtils.safeIsEmpty((List)tiposDocumento).booleanValue()) {
            tiposDocumento.forEach(tipoDoc -> {
                TipoDocumentoUsuarioAlvaraEntity tipoDocUsuario = new TipoDocumentoUsuarioAlvaraEntity();
                tipoDocUsuario.setTipoDocumento(tipoDoc);
                tipoDocUsuario.setUsuario(usuario);
                tipoDocumentosUsuario.add(tipoDocUsuario);
            });
        }
        return tipoDocumentosUsuario;
    }

    private List<TipoLaudoEntity> carregarTiposLaudo(UsuarioEntity usuario) {
        return this.repositoryTipoLaudo.getTipoLaudo();
    }

    public AccessTokenResponse validarPeloKeycloak(String cpfCnpj, String password) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"username", (Object)cpfCnpj);
        body.add((Object)"password", (Object)password);
        body.add((Object)"grant_type", (Object)"client_credentials");
        body.add((Object)"client_id", (Object)"alvaraonline");
        body.add((Object)"scope", (Object)"offline_access");
        String ambiente = this.customUserKeyCloak.getAmbienteByUrl();
        if ("oxy".equals(ambiente)) {
            body.add((Object)"client_secret", (Object)CLIENT_SECRET_KEYCLOAK_PROD_ALVARA);
        } else {
            body.add((Object)"client_secret", (Object)CLIENT_SECRET_KEYCLOAK_QA_ALVARA);
        }
        return this.customUserKeyCloak.validateUserAndGroup((MultiValueMap)body, ambiente);
    }

    private UsernamePasswordAuthenticationToken instanciarAutentication(String cpfCnpj, String password) {
        UsuarioEntity usuario = new UsuarioEntity();
        usuario.setAtivo(SimNaoEnum.SIM.getShortText());
        usuario.setNome(cpfCnpj);
        usuario.setSenha(password);
        usuario.setUsuario(cpfCnpj);
        usuario.setUsuarioModulos(this.srvUsuarioTecnico.carregarUsuarioModulo(usuario, Modulo.fromCodigo((String)"40")));
        UserDetails userDetailsComPermissoes = this.carregarAuthorities((UserDetails)usuario);
        return new UsernamePasswordAuthenticationToken((Object)userDetailsComPermissoes, (Object)userDetailsComPermissoes.getPassword(), userDetailsComPermissoes.getAuthorities());
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        try {
            if (UsuarioMasterTecnicoEnum.isUsuarioTecnicoOuMaster((String)username)) {
                return this.srvUsuarioTecnico.instanciarUsuarioTecnico(username);
            }
            return ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).verificarLogin(username);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setSrvUsuarioTecnico(SrvUsuarioTecnico srvUsuarioTecnico) {
        this.srvUsuarioTecnico = srvUsuarioTecnico;
    }

    public void setRepositoryTipoLaudo(RepositoryTipoLaudo repositoryTipoLaudo) {
        this.repositoryTipoLaudo = repositoryTipoLaudo;
    }

    public void setRepositoryTipoDocumento(RepositoryTipoDocumento repositoryTipoDocumento) {
        this.repositoryTipoDocumento = repositoryTipoDocumento;
    }

    public void setCustomUserKeyCloak(CustomUserKeyCloak customUserKeyCloak) {
        this.customUserKeyCloak = customUserKeyCloak;
    }
}

