/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.security;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.AcessoWebEntity;
import br.com.elotech.tributacao.facade.FacadeLoginAise;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class CustomUserAcessoWebProvider
extends EloLogger
implements AuthenticationProvider,
UserDetailsService {
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UsernamePasswordAuthenticationToken auth = null;
        String cpfCnpj = authentication.getName();
        String password = (String)authentication.getCredentials();
        UserDetails user = this.loadUserByUsername(cpfCnpj);
        if (user != null) {
            if (!password.equalsIgnoreCase(user.getPassword())) {
                throw new BadCredentialsException("Senha n\u00e3o est\u00e1 correta!");
            }
            auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)user.getPassword(), user.getAuthorities());
        }
        return auth;
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        AcessoWebEntity user = null;
        try {
            user = ((FacadeLoginAise)SpringContext.getBean(FacadeLoginAise.class)).verificarLoginAcessoWeb(username);
        }
        catch (BaseException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return user;
    }
}

