/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.service;

import br.com.elotech.portalarrecadacao.rest.dto.UserDTO;
import br.com.elotech.portalarrecadacao.rest.response.TokenResponse;
import br.com.elotech.portalarrecadacao.rest.security.encoder.PasswordEncoderAise;
import br.com.elotech.portalarrecadacao.rest.security.exception.UserAuthenticationException;
import br.com.elotech.portalarrecadacao.rest.service.SrvTokenAuthentication;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import br.com.elotech.tributacao.repository.aise.RepositoryUsuario;
import br.com.elotech.unico.domain.ConfiguracaoUnico;
import br.com.elotech.unico.rest.client.LoginUnicoClient;
import br.com.elotech.unico.rest.exception.UnicoClientException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SrvAuthenticationAlvara {
    @Autowired
    private RepositoryUsuario repositoryUsuario;
    @Autowired
    private SrvTokenAuthentication srvTokenAuthentication;
    @Autowired
    private PasswordEncoderAise passwordEncoder;
    @Autowired
    private LoginUnicoClient loginUnicoClient;
    @Autowired
    private ConfiguracaoUnico configuracaoUnico;

    public TokenResponse authenticate(UserDTO user) throws UserAuthenticationException {
        if (this.configuracaoUnico.isIntegrado()) {
            UsuarioEntity usuarioEntity = this.repositoryUsuario.verificaLoginByCnpjCpf(user.getUsername());
            if (usuarioEntity == null) {
                throw new UserAuthenticationException("Usu\u00e1rio/Senha ou c\u00f3digo inv\u00e1lidos.");
            }
            try {
                String tokenUnico = this.loginUnicoClient.autenticar(usuarioEntity.getUsuario(), user.getPassword());
                return this.srvTokenAuthentication.createUserUnicoToken(user, tokenUnico);
            }
            catch (UnicoClientException e) {
                throw new UserAuthenticationException(e.getMessage(), (Throwable)e);
            }
        }
        String senhaCriptografada = this.passwordEncoder.encode((CharSequence)user.getPassword());
        UsuarioEntity usuarioEntity = this.repositoryUsuario.verificarLogin(user.getUsername(), senhaCriptografada);
        if (usuarioEntity == null || !usuarioEntity.isAtivo()) {
            throw new UserAuthenticationException("Usu\u00e1rio/Senha ou c\u00f3digo inv\u00e1lidos.");
        }
        return this.srvTokenAuthentication.createUserToken(user);
    }
}

