/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.security.token;

import br.com.elotech.portalarrecadacao.rest.response.TokenResponse;
import br.com.elotech.portalarrecadacao.rest.security.exception.UserAuthenticationException;
import br.com.elotech.portalarrecadacao.security.CustomUserAiseProvider;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
public class TokenHandler {
    private static final Long EXPIRES = 86400000L;
    @Value(value="${token.secret}")
    private String secret;
    @Autowired
    private CustomUserAiseProvider customUserAiseProvider;

    public TokenResponse createUserToken(String username) {
        Date created = new Date();
        Date expiration = this.buildExpirationDate();
        String token = Jwts.builder().setSubject(username).signWith(SignatureAlgorithm.HS512, this.secret).setExpiration(expiration).compact();
        return new TokenResponse(token, expiration, created);
    }

    public TokenResponse createUnicoUserToken(String username, String tokenUnico) {
        return this.createUserToken(username + ":" + tokenUnico);
    }

    public UserDetails parseUserFromToken(String token) {
        String text = "";
        try {
            text = ((Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody()).getSubject();
        }
        catch (SignatureException s) {
            throw new UserAuthenticationException("Token inv\u00e1lido.", (Throwable)s);
        }
        int indiceSeparador = text.indexOf(":");
        if (indiceSeparador >= 0) {
            text = text.substring(0, indiceSeparador);
        }
        return this.customUserAiseProvider.loadUserByUsername(text);
    }

    private Date buildExpirationDate() {
        Long expirationDate = System.currentTimeMillis() + EXPIRES;
        return new Date(expirationDate);
    }

    public String parseUnicoFromToken(String token) {
        String text = ((Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody()).getSubject();
        int indiceSeparador = text.indexOf(":");
        if (indiceSeparador >= 0) {
            return text.substring(indiceSeparador + 1);
        }
        return null;
    }

    public UserDetails loadUserRedeSim() {
        return this.customUserAiseProvider.loadUserByUsername("INTEGRASGO");
    }
}

