/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.security.entrypoint;

import br.com.elotech.portalarrecadacao.rest.mapper.AlvaraRestObjectMapper;
import br.com.elotech.portalarrecadacao.rest.response.AlvaraErrorMessage;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.stereotype.Component;

@Component
public class UnauthorizedRestEntryPoint
extends BasicAuthenticationEntryPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnauthorizedRestEntryPoint.class);
    @Autowired
    private AlvaraRestObjectMapper alvaraRestObjectMapper;

    public UnauthorizedRestEntryPoint() {
        this.setRealmName("REST realm");
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        String extractedToken = Optional.ofNullable(request.getHeader("X-Auth-Token")).orElse(request.getHeader("auth-token"));
        String token = Optional.ofNullable(extractedToken).orElse("");
        LOGGER.warn("A requisi\u00e7\u00e3o [{}] n\u00e3o foi autorizada. {}", (Object)request.getRequestURL().toString(), (Object)token);
        response.setStatus(401);
        response.setContentType(MediaType.APPLICATION_JSON.toString());
        response.getOutputStream().write(this.createUnauthorizedJsonResponse().getBytes());
    }

    public String createUnauthorizedJsonResponse() throws JsonProcessingException {
        AlvaraErrorMessage error = new AlvaraErrorMessage();
        error.setStatus(HttpStatus.UNAUTHORIZED.value());
        error.setMessage("Unauthorized");
        return this.alvaraRestObjectMapper.writeValueAsString((Object)error);
    }
}

