/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.resource;

import br.com.elotech.portalarrecadacao.domain.AndamentoLaudoRedeSimEntity;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.StatusDocumentos;
import br.com.elotech.portalarrecadacao.rest.resource.RedeSimBaseResource;
import br.com.elotech.util.string.EloStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/integracao/status-documentos"})
public class StatusDocumentosRedeSimResource
extends RedeSimBaseResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusDocumentosRedeSimResource.class);
    @Autowired
    private FacadeRedeSim facadeRedeSim;

    public void setFacadeRedeSim(FacadeRedeSim facadeRedeSim) {
        this.facadeRedeSim = facadeRedeSim;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<StatusDocumentos> processarAndamentoLaudoRedeSim(@RequestBody StatusDocumentos statusDocumentosDTO) throws SolicitacaoAlvaraRedeSimException {
        try {
            Long protocoloConsultaRedeSim = EloStringUtils.getLongFromString((String)statusDocumentosDTO.getDados_documento().getCo_protocolo_redesim());
            if (StatusDocumentosRedeSimResource.isLowerThanProtocoloInicialRedeSim((Long)protocoloConsultaRedeSim).booleanValue()) {
                return new ResponseEntity(HttpStatus.OK);
            }
            AndamentoLaudoRedeSimEntity andamentoLaudoRedeSim = this.facadeRedeSim.processarAndamentoLaudoRedeSim(statusDocumentosDTO);
            statusDocumentosDTO.getDados_documento().setId(Integer.valueOf(andamentoLaudoRedeSim.getId().intValue()));
            return new ResponseEntity((Object)statusDocumentosDTO, HttpStatus.CREATED);
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
            throw new SolicitacaoAlvaraRedeSimException(e.getCause());
        }
    }
}

