/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.resource;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.portalarrecadacao.domain.FilaRecebimentoProcessadaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.FilaRecebimentoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoProcessamentoFilaRecebimentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoFilaRecebimentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.RegistroNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.RegistroProcessadoAnteriormenteException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoRedeSimException;
import br.com.elotech.portalarrecadacao.facade.FacadeFilaRecebimentoRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.rest.dto.Dados_solicitacao_documento;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoDocumentosDTO;
import br.com.elotech.portalarrecadacao.rest.resource.RedeSimBaseResource;
import br.com.elotech.portalarrecadacao.service.impl.ProcessamentoWS04ServiceImpl;
import br.com.elotech.portalarrecadacao.utils.JsonUtils;
import br.com.elotech.tributacao.enumerator.TipoDocumentoRedeSimEnum;
import com.google.gson.Gson;
import java.util.Comparator;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/integracao/solicitacoes-documentos"})
public class SolicitacaoDocumentosRedeSimResource
extends RedeSimBaseResource {
    private static final Logger log = LoggerFactory.getLogger(SolicitacaoDocumentosRedeSimResource.class);
    private static final String MESSAGE_ERROR_SOLICITACAO_DOCUMENTOS = "Falha ao gravar Solicita\u00e7\u00e3o de Documentos";
    @Autowired
    private ProcessamentoWS04ServiceImpl processamentoWS04Service;
    @Resource
    private FacadeFilaRecebimentoRedeSim facadeFilaRecebimentoRedeSim;
    @Resource
    private FacadeRedeSim facadeRedeSim;

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<Dados_solicitacao_documento> solicitacaoDocumentos(@RequestBody SolicitacaoDocumentosDTO solicitacaoDocumentosDTO) throws BaseException {
        Gson gson = new Gson();
        String request = JsonUtils.sanitize((String)gson.toJson((Object)solicitacaoDocumentosDTO));
        String randomToken = UUID.randomUUID().toString();
        Dados_solicitacao_documento dadosSolicitacaoDocumento = solicitacaoDocumentosDTO.getDados_solicitacao_documento();
        String protocolo = dadosSolicitacaoDocumento.getCo_protocolo_redesim();
        log.info("[{}] Recebendo requisi\u00e7\u00e3o - {} ({}): {}", new Object[]{randomToken, TipoFilaRecebimentoRedeSimEnum.WS04.getDescricao(), protocolo, request});
        SolicitacaoRedeSimEntity solicitacaoRedeSimEntity = this.facadeRedeSim.getConsultaRedeSim(protocolo, TipoSolicitacaoRedeSimEnum.SOLICITACAO);
        if (Objects.isNull(solicitacaoRedeSimEntity)) {
            throw new RegistroNaoEncontradoException(String.format("N\u00e3o existe uma solicita\u00e7\u00e3o (WS02) com o protocolo %s.", protocolo));
        }
        Integer tipoDocumentoFromRequest = dadosSolicitacaoDocumento.getCo_tipo_modelo_documento();
        if (Objects.nonNull(tipoDocumentoFromRequest)) {
            TipoDocumentoRedeSimEnum tipoDocumento = TipoDocumentoRedeSimEnum.fromValue((Long)((Object)tipoDocumentoFromRequest));
            FilaRecebimentoProcessadaRedeSimEntity ultimoProcessamento = this.facadeFilaRecebimentoRedeSim.findFilaRecebimentoProcessByTipoAndProtocolo(TipoFilaRecebimentoRedeSimEnum.WS04, protocolo).stream().filter(registro -> {
                SolicitacaoDocumentosDTO dto = (SolicitacaoDocumentosDTO)gson.fromJson(JsonUtils.sanitize((String)registro.getRequest()), SolicitacaoDocumentosDTO.class);
                Integer tipoDocumentoSaved = dto.getDados_solicitacao_documento().getCo_tipo_modelo_documento();
                return SituacaoProcessamentoFilaRecebimentoRedeSimEnum.PROCESSADO.equals((Object)registro.getSituacao()) && Objects.nonNull(tipoDocumentoSaved) && tipoDocumentoSaved.compareTo(tipoDocumentoFromRequest) == 0;
            }).max(Comparator.comparing(FilaRecebimentoProcessadaRedeSimEntity::getId)).orElse(null);
            if (Objects.nonNull(ultimoProcessamento)) {
                throw new RegistroProcessadoAnteriormenteException("Registro processado anteriormente");
            }
            if (TipoDocumentoRedeSimEnum.ALVARA_FUNCIONAMENTO_PROVISORIO.equals((Object)tipoDocumento) && (solicitacaoRedeSimEntity.getSolicitacaoAlvara().isSolicitacaoMEI() || solicitacaoRedeSimEntity.getSolicitacaoAlvara().isGrauRiscoLiberdadeEconomica())) {
                throw new SolicitacaoRedeSimException("Alvar\u00e1 de Funcionamento Provis\u00f3rio n\u00e3o pode ser processado para esta solicita\u00e7\u00e3o.");
            }
        }
        FilaRecebimentoRedeSimEntity fila = new FilaRecebimentoRedeSimEntity();
        fila.setProtocolo(protocolo);
        fila.setTipo(TipoFilaRecebimentoRedeSimEnum.WS04);
        fila.setRequest(request);
        fila.setDataRecebimento(new Date());
        fila = this.facadeFilaRecebimentoRedeSim.salvarFilaRecebimento(fila);
        dadosSolicitacaoDocumento.setId(Integer.valueOf(fila.getId().intValue()));
        return new ResponseEntity((Object)dadosSolicitacaoDocumento, HttpStatus.CREATED);
    }

    public void setProcessamentoWS04Service(ProcessamentoWS04ServiceImpl processamentoWS04Service) {
        this.processamentoWS04Service = processamentoWS04Service;
    }
}

