/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.resource;

import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.DadosRetornoExigencia;
import br.com.elotech.portalarrecadacao.integration.dto.dadosEmpresa.RetornoExigencia;
import br.com.elotech.portalarrecadacao.rest.resource.RedeSimBaseResource;
import br.com.elotech.util.string.EloStringUtils;
import com.google.gson.Gson;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/integracao/retorno-exigencias"})
public class RetornoExigenciaResource
extends RedeSimBaseResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetornoExigenciaResource.class);
    @Resource
    private FacadeRedeSim facadeRedeSim;

    public void setFacadeRedeSim(FacadeRedeSim facadeRedeSim) {
        this.facadeRedeSim = facadeRedeSim;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<DadosRetornoExigencia> respostaExigencia(@RequestBody RetornoExigencia retornoExigencia) throws SolicitacaoAlvaraRedeSimException {
        try {
            DadosRetornoExigencia dadosRetornoExigencia = retornoExigencia.getDados_retorno_exigencias();
            Long protocoloConsultaRedeSim = EloStringUtils.getLongFromString((String)dadosRetornoExigencia.getCo_protocolo_redesim());
            if (RetornoExigenciaResource.isLowerThanProtocoloInicialRedeSim((Long)protocoloConsultaRedeSim).booleanValue()) {
                return new ResponseEntity(HttpStatus.OK);
            }
            LOGGER.info("SERVI\u00c7O DE RESPOSTA DE EXIGENCIA WS06 ----------- ");
            Gson gson = new Gson();
            LOGGER.info(gson.toJson((Object)retornoExigencia));
            SolicitacaoRedeSimEntity solicitacao = this.facadeRedeSim.salvarRespostaExigencia(dadosRetornoExigencia);
            if (Objects.isNull(solicitacao)) {
                return new ResponseEntity(HttpStatus.OK);
            }
            dadosRetornoExigencia.setId(Integer.valueOf(solicitacao.getId().intValue()));
            return new ResponseEntity((Object)dadosRetornoExigencia, HttpStatus.CREATED);
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
            throw new SolicitacaoAlvaraRedeSimException(e.getCause());
        }
    }
}

