/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.resource;

import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.exception.ConsultaPreviaRedeSimException;
import br.com.elotech.portalarrecadacao.exception.RegistroNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.RegistroProcessadoAnteriormenteException;
import br.com.elotech.portalarrecadacao.rest.response.Erro;
import br.com.elotech.portalarrecadacao.rest.response.RedeSimErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;

public class RedeSimBaseResource {
    private static final Logger log = LoggerFactory.getLogger(RedeSimBaseResource.class);
    private static Long protocoloInicialRedeSim;

    public static Long getProtocoloInicialRedeSim() {
        return protocoloInicialRedeSim;
    }

    private ResponseEntity<RedeSimErrorMessage> handleError(Throwable throwable, Long codigo, String retorno, String valor, HttpStatus status) {
        log.error(String.format("RedeSimBaseResource (%s): %s", throwable.getClass().getSimpleName(), throwable.getMessage()), throwable);
        Erro erro = new Erro();
        erro.setCo_retorno(codigo);
        erro.setDs_retorno(retorno);
        erro.setDs_valor(valor);
        RedeSimErrorMessage message = new RedeSimErrorMessage();
        message.getErros().add(erro);
        return new ResponseEntity((Object)message, status);
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<RedeSimErrorMessage> throwableExceptionHandler(Throwable ex) {
        return this.handleError(ex, Long.valueOf(9920L), "Erro interno.", ex.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={RegistroProcessadoAnteriormenteException.class})
    public ResponseEntity<RedeSimErrorMessage> handleAlreadyProcessedException(Exception ex) {
        return this.handleError((Throwable)ex, Long.valueOf(9010L), "Requisi\u00e7\u00e3o j\u00e1 processada", ex.getMessage(), HttpStatus.NOT_ACCEPTABLE);
    }

    @ExceptionHandler(value={RegistroNaoEncontradoException.class})
    public ResponseEntity<RedeSimErrorMessage> handleNotFoundException(Exception ex) {
        return this.handleError((Throwable)ex, Long.valueOf(9005L), "Registro n\u00e3o encontrado", ex.getMessage(), HttpStatus.NOT_FOUND);
    }

    public static Boolean isLowerThanProtocoloInicialRedeSim(Long protocolo) throws ConsultaPreviaRedeSimException {
        protocoloInicialRedeSim = UtilsController.getProtocoloInicialRedeSim();
        return protocoloInicialRedeSim > 0L && protocolo < protocoloInicialRedeSim;
    }
}

