/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.resource;

import br.com.elotech.portalarrecadacao.enumerator.ErroRespostaRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.CadastroImobiliarioNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.integration.dto.ws30.Cep;
import br.com.elotech.portalarrecadacao.integration.dto.ws30.ConsultaEnderecoImobiliario;
import br.com.elotech.portalarrecadacao.integration.dto.ws30.Endereco;
import br.com.elotech.portalarrecadacao.integration.dto.ws30.ResponseWS30;
import br.com.elotech.portalarrecadacao.rest.resource.RedeSimBaseResource;
import br.com.elotech.portalarrecadacao.rest.response.Erro;
import br.com.elotech.portalarrecadacao.rest.response.RedeSimErrorMessage;
import br.com.elotech.util.string.EloStringUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/integracao/endereco"})
public class EnderecoResource
extends RedeSimBaseResource {
    private static final Logger log = LoggerFactory.getLogger(EnderecoResource.class);
    @Resource
    private FacadeRedeSim facadeRedeSim;

    public void setFacadeRedeSim(FacadeRedeSim facadeRedeSim) {
        this.facadeRedeSim = facadeRedeSim;
    }

    @RequestMapping(value={"/{nuInscricaoImobiliaria}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getEndereco(@PathVariable(value="nuInscricaoImobiliaria") String inscricaoImobiliaria) throws SolicitacaoAlvaraRedeSimException {
        try {
            ConsultaEnderecoImobiliario enderecoImobiliario = this.facadeRedeSim.getEndereco(inscricaoImobiliaria);
            StringJoiner joiner = new StringJoiner(",");
            if (Objects.isNull(enderecoImobiliario.getTipoLogradouro())) {
                joiner.add("Tipo de Logradouro");
            }
            if (EloStringUtils.isEmpty((String)enderecoImobiliario.getLogradouro())) {
                joiner.add("Logradouro");
            }
            if (EloStringUtils.isEmpty((String)enderecoImobiliario.getNumero())) {
                joiner.add("N\u00famero");
            } else {
                String numeroFinal = enderecoImobiliario.getNumero().replaceAll("[^a-zA-Z0-9]", "").replaceAll("0", "");
                if (EloStringUtils.isEmpty((String)numeroFinal)) {
                    joiner.add(String.format("N\u00famero (%s)", enderecoImobiliario.getNumero()));
                }
            }
            if (EloStringUtils.isEmpty((String)enderecoImobiliario.getBairro())) {
                joiner.add("Bairro");
            }
            AtomicReference<String> cepValido = new AtomicReference<String>("");
            Optional<Long> cepEncontrato = Optional.ofNullable(enderecoImobiliario.getCep());
            if (!cepEncontrato.isPresent()) {
                joiner.add("CEP");
            }
            cepEncontrato.ifPresent(cep -> {
                String cepConvertido = cep.toString();
                if (cepConvertido.length() < 7 || cepConvertido.length() > 8) {
                    joiner.add(String.format("CEP (%s)", cepConvertido));
                } else {
                    cepValido.set(cepConvertido);
                }
            });
            if (!EloStringUtils.isEmpty((String)joiner.toString())) {
                String errorString = String.format("Campos inv\u00e1lidos: %s - %s", joiner.toString(), "Por favor, entre em contato com o cadastro imobili\u00e1rio da Prefeitura do seu estado para verificar o problema.");
                RedeSimErrorMessage errorMessage = new RedeSimErrorMessage();
                Erro erro = new Erro();
                erro.setCo_retorno(ErroRespostaRedeSimEnum.VALOR_INVALIDO.getCodigo());
                erro.setDs_retorno(errorString);
                erro.setDs_valor(joiner.toString());
                errorMessage.getErros().add(erro);
                return new ResponseEntity((Object)errorMessage, HttpStatus.BAD_REQUEST);
            }
            Endereco endereco = new Endereco();
            endereco.setCo_tipo_logradouro(Integer.valueOf(enderecoImobiliario.getTipoLogradouro().intValue()));
            endereco.setDs_endereco(StringUtils.abbreviate((String)enderecoImobiliario.getLogradouro(), (int)100).trim());
            endereco.setNu_numero(StringUtils.abbreviate((String)enderecoImobiliario.getNumero(), (int)7).trim());
            endereco.setDs_bairro(StringUtils.abbreviate((String)enderecoImobiliario.getBairro(), (int)50).trim());
            if (!EloStringUtils.isEmpty((String)cepValido.get())) {
                Cep cep2 = new Cep();
                cep2.setCo_cep(cepValido.get());
                endereco.getCeps().add(cep2);
            }
            ResponseWS30 responseWS30 = new ResponseWS30();
            responseWS30.getEndereco().add(endereco);
            return new ResponseEntity((Object)responseWS30, HttpStatus.OK);
        }
        catch (CadastroImobiliarioNaoEncontradoException e) {
            Erro erro = new Erro();
            erro.setCo_retorno(ErroRespostaRedeSimEnum.WS30_INSCRICAO_IMOBILIARIA_INEXISTENTE.getCodigo());
            erro.setDs_retorno("Cadastro Imobili\u00e1rio n\u00e3o encontrado");
            erro.setDs_valor(inscricaoImobiliaria);
            RedeSimErrorMessage errorMessage = new RedeSimErrorMessage();
            errorMessage.getErros().add(erro);
            return new ResponseEntity((Object)errorMessage, HttpStatus.BAD_REQUEST);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            throw new SolicitacaoAlvaraRedeSimException(e.getCause());
        }
    }
}

