/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.resource;

import br.com.elotech.exception.common.CommandExecuteException;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.exception.ConsultaPreviaRedeSimException;
import br.com.elotech.portalarrecadacao.exception.DataInvalidaException;
import br.com.elotech.portalarrecadacao.exception.EncerramentoProcessoException;
import br.com.elotech.portalarrecadacao.exception.LaudoNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.RegistroNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoNaoEncontradaException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoRedeSimException;
import br.com.elotech.portalarrecadacao.exception.StatusLaudoNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.UsuarioNaoEncontradoException;
import br.com.elotech.portalarrecadacao.rest.response.AlvaraErrorMessage;
import br.com.elotech.portalarrecadacao.rest.response.ConsultaPreviaRedeSimErrorMessage;
import br.com.elotech.portalarrecadacao.rest.security.exception.UserAuthenticationException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;

public class BaseResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseResource.class);
    private Long protocoloInicialRedeSim;

    public Long getProtocoloInicialRedeSim() {
        return this.protocoloInicialRedeSim;
    }

    public void setProtocoloInicialRedeSim(Long protocoloInicialRedeSim) {
        this.protocoloInicialRedeSim = protocoloInicialRedeSim;
    }

    @ExceptionHandler(value={Throwable.class})
    public ResponseEntity<AlvaraErrorMessage> throwableExceptionHandler(Throwable ex) {
        LOGGER.error(ex.getMessage(), ex);
        AlvaraErrorMessage errorMessage = new AlvaraErrorMessage();
        errorMessage.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        errorMessage.setError(HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
        errorMessage.setMessage(ex.getMessage());
        errorMessage.setException(ex.getClass().getName());
        return new ResponseEntity((Object)errorMessage, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<AlvaraErrorMessage> illegalArgumentExceptionHanlder(IllegalArgumentException ex) {
        LOGGER.error(ex.getMessage(), (Throwable)ex);
        AlvaraErrorMessage errorMessage = new AlvaraErrorMessage();
        errorMessage.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        errorMessage.setError(HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
        errorMessage.setMessage(ex.getMessage());
        errorMessage.setException(ex.getClass().getName());
        return new ResponseEntity((Object)errorMessage, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={LaudoNaoEncontradoException.class})
    public ResponseEntity<AlvaraErrorMessage> handleLaudoNaoEncontradoException(LaudoNaoEncontradoException ex) {
        AlvaraErrorMessage errorMessage = new AlvaraErrorMessage();
        errorMessage.setStatus(HttpStatus.NOT_FOUND.value());
        errorMessage.setError(HttpStatus.NOT_FOUND.getReasonPhrase());
        errorMessage.setMessage(ex.getMessage());
        errorMessage.setException(ex.getClass().getName());
        return new ResponseEntity((Object)errorMessage, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={SolicitacaoNaoEncontradaException.class})
    public ResponseEntity<AlvaraErrorMessage> handleSolicitacaoNaoEncontradaException(SolicitacaoNaoEncontradaException ex) {
        AlvaraErrorMessage errorMessage = new AlvaraErrorMessage();
        errorMessage.setStatus(HttpStatus.NOT_FOUND.value());
        errorMessage.setError(HttpStatus.NOT_FOUND.getReasonPhrase());
        errorMessage.setMessage(ex.getMessage());
        errorMessage.setException(ex.getClass().getName());
        return new ResponseEntity((Object)errorMessage, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={CommandExecuteException.class})
    public ResponseEntity<AlvaraErrorMessage> handleCommandExecuteException(CommandExecuteException ex) {
        if (ex.getCause() instanceof UserAuthenticationException) {
            return this.handleUserAuthenticationException((UserAuthenticationException)ex.getCause());
        }
        AlvaraErrorMessage errorMessage = new AlvaraErrorMessage();
        errorMessage.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        errorMessage.setError(HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
        errorMessage.setMessage(ex.getMessage());
        errorMessage.setException(ex.getClass().getName());
        return new ResponseEntity((Object)errorMessage, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    @ExceptionHandler(value={UserAuthenticationException.class})
    public ResponseEntity<AlvaraErrorMessage> handleUserAuthenticationException(UserAuthenticationException ex) {
        AlvaraErrorMessage errorMessage = new AlvaraErrorMessage();
        errorMessage.setStatus(HttpStatus.UNAUTHORIZED.value());
        errorMessage.setError(HttpStatus.UNAUTHORIZED.getReasonPhrase());
        errorMessage.setMessage(ex.getMessage());
        errorMessage.setException(ex.getClass().getName());
        StringWriter trace = new StringWriter();
        ex.printStackTrace(new PrintWriter(trace));
        return new ResponseEntity((Object)errorMessage, HttpStatus.UNAUTHORIZED);
    }

    @ExceptionHandler(value={StatusLaudoNaoEncontradoException.class})
    public ResponseEntity<AlvaraErrorMessage> handleStatusLaudoNaoEncontradoException(StatusLaudoNaoEncontradoException ex) {
        AlvaraErrorMessage errorMessage = new AlvaraErrorMessage();
        errorMessage.setStatus(HttpStatus.NOT_FOUND.value());
        errorMessage.setError(HttpStatus.NOT_FOUND.getReasonPhrase());
        errorMessage.setMessage(ex.getMessage());
        errorMessage.setException(ex.getClass().getName());
        return new ResponseEntity((Object)errorMessage, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={DataInvalidaException.class})
    public ResponseEntity<AlvaraErrorMessage> handleDataInvalidaException(DataInvalidaException ex) {
        AlvaraErrorMessage errorMessage = new AlvaraErrorMessage();
        errorMessage.setStatus(HttpStatus.BAD_REQUEST.value());
        errorMessage.setError(HttpStatus.BAD_REQUEST.getReasonPhrase());
        errorMessage.setMessage(ex.getMessage());
        errorMessage.setException(ex.getClass().getName());
        return new ResponseEntity((Object)errorMessage, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={UsuarioNaoEncontradoException.class})
    public ResponseEntity<AlvaraErrorMessage> handleUsuarioNaoEncontradoException(UsuarioNaoEncontradoException ex) {
        AlvaraErrorMessage errorMessage = new AlvaraErrorMessage();
        errorMessage.setStatus(HttpStatus.NOT_FOUND.value());
        errorMessage.setError(HttpStatus.NOT_FOUND.getReasonPhrase());
        errorMessage.setMessage(ex.getMessage());
        errorMessage.setException(ex.getClass().getName());
        return new ResponseEntity((Object)errorMessage, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={EncerramentoProcessoException.class})
    public ResponseEntity<AlvaraErrorMessage> handleEncerramentoProcessoException(EncerramentoProcessoException ex) {
        AlvaraErrorMessage errorMessage = new AlvaraErrorMessage();
        errorMessage.setStatus(HttpStatus.CONFLICT.value());
        errorMessage.setError(HttpStatus.CONFLICT.getReasonPhrase());
        errorMessage.setMessage(ex.getMessage());
        errorMessage.setException(ex.getClass().getName());
        return new ResponseEntity((Object)errorMessage, HttpStatus.CONFLICT);
    }

    @ExceptionHandler(value={SolicitacaoRedeSimException.class})
    public ResponseEntity<ConsultaPreviaRedeSimErrorMessage> handleConsultaPreviaRedeSimException(SolicitacaoRedeSimException ex) {
        ConsultaPreviaRedeSimErrorMessage message = new ConsultaPreviaRedeSimErrorMessage();
        return new ResponseEntity((Object)message, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={RegistroNaoEncontradoException.class})
    public ResponseEntity<ConsultaPreviaRedeSimErrorMessage> handleRegistroNaoEncontradoException(RegistroNaoEncontradoException ex) {
        ConsultaPreviaRedeSimErrorMessage message = new ConsultaPreviaRedeSimErrorMessage();
        return new ResponseEntity((Object)message, HttpStatus.NOT_FOUND);
    }

    public Boolean isLowerThanProtocoloInicialRedeSim(Long protocolo) throws ConsultaPreviaRedeSimException {
        this.protocoloInicialRedeSim = UtilsController.getProtocoloInicialRedeSim();
        return this.protocoloInicialRedeSim > 0L && protocolo < this.protocoloInicialRedeSim;
    }
}

