/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.imprimirdocumento;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.facade.FacadeDocumento;
import br.com.elotech.portalarrecadacao.service.SrvDebitosPortal;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.DocumentoAiseEntity;
import br.com.elotech.tributacao.enumerator.DocumentoTipoEnum;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.utils.URIBuilder;
import org.apache.poi.util.IOUtils;
import org.primefaces.context.RequestContext;
import org.springframework.stereotype.Component;

@Component
public class ImprimeDocumentoAlvara
extends EloLogger {
    @Resource
    private SrvDebitosPortal srvDebitosPortal;

    public void imprimirDocumentoAlvara(String numeroDoc, Long exercicioDoc, Long idTipoDocumento, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        try {
            URI uri = this.getUrlDocumentoAlvara(numeroDoc, exercicioDoc, idTipoDocumento);
            Response response = Request.Get((URI)uri).execute();
            byte[] content = IOUtils.toByteArray((InputStream)response.returnResponse().getEntity().getContent());
            Long tipoDocumentoLiberdadeEconomica = null;
            if (SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.ENVIA_INSCRICAO_MUNICIPAL_COM_DADOS_ATUALIZADOS)).booleanValue()) {
                tipoDocumentoLiberdadeEconomica = Optional.of(UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.TIPODOCUMENTO_LIBERDADE_ECONOMICA)).map(ParametroAlvaraEntity::getValor).map(Long::valueOf).orElse(null);
            }
            List<Long> tiposDocumentoValidos = Arrays.asList(DocumentoTipoEnum.ALVARA_LOCALIZACAO.getCodigo(), DocumentoTipoEnum.INSCRICAO_MUNICIPAL.getCodigo(), tipoDocumentoLiberdadeEconomica);
            if (Objects.nonNull(content) && tiposDocumentoValidos.contains(idTipoDocumento)) {
                DocumentoAiseEntity documentoAise = this.getUltimoDocumentoEmitido(solicitacao.getCadastroMobiliario().getId(), idTipoDocumento);
                ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).salvarDocumentoEloArquivo(content, solicitacao, documentoAise);
                if (this.isRequestVindaDaSolicitacaoRedeSimOuAlvaraProvisorioOuAcompanhamento()) {
                    RequestContext.getCurrentInstance().execute("window.open('" + uri.toString() + "','_blank')");
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new SolicitacaoAlvaraException("N\u00e3o foi poss\u00edvel imprimir o Alvar\u00e1. " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean isRequestVindaDaSolicitacaoRedeSimOuAlvaraProvisorioOuAcompanhamento() {
        if (FacesContext.getCurrentInstance() == null) {
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        return request.getRequestURI().contains("solicitacaoRedeSim") || request.getRequestURI().contains("acompanhamento");
    }

    private DocumentoAiseEntity getUltimoDocumentoEmitido(CadastroGeralAisePK id, Long idTipoDocumento) throws BaseException {
        return ((FacadeDocumento)SpringContext.getBean(FacadeDocumento.class)).buscarUltimoDocumentoEmitidoDoCadastro(id, idTipoDocumento);
    }

    public URI getUrlDocumentoAlvara(String numeroDoc, Long exercicioDoc, Long idTipoDocumento) throws URISyntaxException {
        String urlImprimeDocumento = (String)SpringContext.getBean((String)"urlImprimirDocumento", String.class);
        String userKey = this.srvDebitosPortal.loginWeb();
        URIBuilder uriBuilder = new URIBuilder(urlImprimeDocumento).addParameter("uid", userKey);
        uriBuilder.addParameter("value", numeroDoc);
        uriBuilder.addParameter("valuetipo", Long.toString(idTipoDocumento));
        uriBuilder.addParameter("valueexercicio", Long.toString(exercicioDoc));
        URI uri = uriBuilder.build();
        return uri;
    }

    public void reimpressaoDocumentoAlvara(String numeroDoc, Long exercicioDoc, Long idTipoDocumento) throws BaseException, URISyntaxException {
        URI uri = this.getUrlDocumentoAlvara(numeroDoc, exercicioDoc, idTipoDocumento);
        RequestContext.getCurrentInstance().execute("window.open('" + uri.toString() + "','_blank')");
    }
}

