/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.geradocumento;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.exception.BuscaNumeroDocumentoException;
import br.com.elotech.portalarrecadacao.exception.GeraDocumentoClienteAlvaraExcetion;
import br.com.elotech.portalarrecadacao.rest.AlvaraObjectMapper;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.enumerator.DocumentoTipoEnum;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class GeraDocumentoClientAlvara
extends EloLogger {
    public <T> T doGet(Class<T> responseType, String userKey, Long entidade, Long exercicio) throws BaseException {
        try {
            String urlGeraNumeroDocumento = (String)SpringContext.getBean((String)"urlAiseRest", String.class);
            urlGeraNumeroDocumento = urlGeraNumeroDocumento + String.format("/tdocumentos/GetDocumentoNumero/%s/%s/%s", entidade, exercicio, DocumentoTipoEnum.ALVARA_LOCALIZACAO.getCodigo());
            URI uri = new URIBuilder(urlGeraNumeroDocumento).build();
            this.logger.info((Object)("URL: " + uri.toString()));
            HttpResponse response = Request.Get((URI)uri).addHeader("Authorization", "Bearer " + userKey).execute().returnResponse();
            int statusCode = response.getStatusLine().getStatusCode();
            byte[] content = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
            this.logger.info((Object)String.format("Resposta: %d - %s", statusCode, new String(content)));
            if (statusCode != 200) {
                throw new BuscaNumeroDocumentoException(String.format("[%d] %s: %s", statusCode, response.getStatusLine().getReasonPhrase(), new String(content)));
            }
            return (T)AlvaraObjectMapper.getInstance().readValue(content, responseType);
        }
        catch (IOException | URISyntaxException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public <T> T doPost(Class<T> responseType, Object objetoEnvio, String userKey) throws BaseException {
        try {
            String urlGeraDocumentoGenerico = (String)SpringContext.getBean((String)"urlGeraDocumentoGenerico", String.class);
            URI uri = new URIBuilder(urlGeraDocumentoGenerico).addParameter("uid", userKey).build();
            this.logger.info((Object)("URL: " + uri.toString()));
            this.logger.info((Object)("Envio: " + AlvaraObjectMapper.jsonToString((Object)objetoEnvio)));
            StringEntity jsonEnvio = new StringEntity(AlvaraObjectMapper.jsonToString((Object)objetoEnvio), ContentType.APPLICATION_JSON);
            HttpResponse response = Request.Post((URI)uri).body((HttpEntity)jsonEnvio).execute().returnResponse();
            int statusCode = response.getStatusLine().getStatusCode();
            byte[] content = IOUtils.toByteArray((InputStream)response.getEntity().getContent());
            this.logger.info((Object)String.format("Resposta: %d - %s", statusCode, new String(content)));
            if (statusCode != 200) {
                throw new GeraDocumentoClienteAlvaraExcetion(String.format("[%d] %s: %s", statusCode, response.getStatusLine().getReasonPhrase(), new String(content)));
            }
            return (T)AlvaraObjectMapper.getInstance().readValue(content, responseType);
        }
        catch (IOException | URISyntaxException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new GeraDocumentoClienteAlvaraExcetion(e.getMessage(), (Throwable)e);
        }
    }
}

