/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.rest.geradocumento;

import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.rest.AlvaraObjectMapper;
import br.com.elotech.portalarrecadacao.rest.geradocumento.EnvioGeraDocumento;
import br.com.elotech.portalarrecadacao.utils.params.PortalUtils;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GeraDocumento
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Integer MODO_GRAVACAO_NOVO_DOCUMENTO = 0;
    public static final Integer OPERACAO = 0;
    public static final Boolean GERAR_ITEM_APOS_DOCUMENTO = Boolean.FALSE;
    public static final String MODULO_RELATORIO = "05";
    public static final String CLASS_NAME_ALVARA_LOCALIZACAO = "TDocumentoExecuteAlvaraLocalizacao";
    public static final Integer NUMERO_RELATORIO = 1101;
    public static final String DESCRICAO_TIPO_DOCUMENTO = "ALVAR\u00c1 DE LOCALIZA\u00c7\u00c3O";
    @JsonProperty(value="ClassName")
    private String className;
    @JsonProperty(value="Entidade")
    private Integer entidade;
    @JsonProperty(value="Exercicio")
    private Integer exercicio;
    @JsonProperty(value="TipoDocumento")
    private Integer tipoDocumento;
    @JsonProperty(value="Documento")
    private Integer documento;
    @JsonProperty(value="Impresso")
    private Boolean impresso;
    @JsonProperty(value="DataEmissao")
    private Date dataEmissao;
    @JsonProperty(value="DataValidade")
    private Date dataValidade;
    @JsonProperty(value="CodigoValidacao")
    private String codigoValidacao;
    @JsonProperty(value="Usuario")
    private String usuario;
    @JsonProperty(value="OrigemImpressao")
    private String origemImpressao;
    @JsonProperty(value="DataSolicitacao")
    private Date dataSolicitacao;
    @JsonProperty(value="ExercicioProcesso")
    private Integer exercicioProcesso;
    @JsonProperty(value="IdProcesso")
    private Integer idProcesso;
    @JsonProperty(value="Processo")
    private Integer processo;
    @JsonProperty(value="Observacao")
    private String observacao;
    @JsonProperty(value="Cabecalho")
    private String cabecalho;
    @JsonProperty(value="Rodape")
    private String rodape;
    @JsonProperty(value="Requerente")
    private String requerente;
    @JsonProperty(value="CpfRequerente")
    private String cpfRequerente;
    @JsonProperty(value="SequenciaFinalidade")
    private Integer sequenciaFinalidade;
    @JsonProperty(value="TipoCadastro")
    private Integer tipoCadastro;
    @JsonProperty(value="CadastroGeral")
    private Integer cadastroGeral;
    @JsonProperty(value="Pessoa")
    private Integer pessoa;
    @JsonProperty(value="ExercicioProjeto")
    private Integer exercicioProjeto;
    @JsonProperty(value="Projeto")
    private Integer projeto;
    @JsonProperty(value="ModoGravacao")
    private Integer modoGravacao = MODO_GRAVACAO_NOVO_DOCUMENTO;
    @JsonProperty(value="GerouNovo")
    private Boolean gerouNovo;
    @JsonProperty(value="subTipo")
    private String subTipo;
    @JsonProperty(value="AreaAcrescimo")
    private Double areaAcrescimo;
    @JsonProperty(value="Historico")
    private String historico;
    @JsonProperty(value="ModuloRelatorio")
    private String moduloRelatorio;
    @JsonProperty(value="TipoRelatorio")
    private String tipoRelatorio;
    @JsonProperty(value="Relatorio")
    private Integer relatorio;
    @JsonProperty(value="XMLItemDocumento")
    private String XMLItemDocumento;
    @JsonProperty(value="PossuiDebitoPendente")
    private Boolean possuiDebitoPendente;
    @JsonProperty(value="IsencaoRemissao")
    private Integer isencaoRemissao;
    @JsonProperty(value="PorCadastro")
    private Boolean porCadastro;
    @JsonProperty(value="Web")
    private Boolean web;
    @JsonProperty(value="EnderecoRequerente")
    private String enderecoRequerente;
    @JsonProperty(value="OutraFinalidade")
    private String outraFinalidade;
    @JsonProperty(value="TipoPessoaRequerente")
    private String tipoPessoaRequerente;
    @JsonProperty(value="CNPJ_CPF")
    private String cnpjCpf;
    @JsonProperty(value="MsgErro")
    private String msgErro;
    @JsonProperty(value="SequenciaProfissao")
    private Integer sequenciaProfissao;
    @JsonProperty(value="CasoEspecial")
    private Boolean casoEspecial;
    @JsonProperty(value="IdSequenciaITBI")
    private Integer idSequenciaITBI;
    @JsonProperty(value="SalvaPDF")
    private Boolean salvaPDF;
    @JsonProperty(value="TipoDocumento_Descricao")
    private String tipoDocumentoDescricao;
    @JsonProperty(value="EmitirCertidaoEspecial")
    private Boolean emitirCertidaoEspecial;
    @JsonProperty(value="NaoAlteradoDocumentoCadastro")
    private Boolean naoAlteradoDocumentoCadastro;
    @JsonProperty(value="NaoUsouNaCertidaoEspecial")
    private String naoUsouNaCertidaoEspecial;
    @JsonProperty(value="NumeroPrimeroAlvara")
    private String numeroPrimeiroAlvara;
    @JsonProperty(value="AnoEmissaoAlvara")
    private String anoEmissaoAlvara;
    @JsonProperty(value="UsuarioCancelamento")
    private String usuarioCancelamento;
    @JsonProperty(value="DataCancelamento")
    private Date dataCancelamento;
    @JsonProperty(value="ObservacaoCancelamento")
    private String observacaoCancelamento;
    @JsonProperty(value="ExigeNumeroProcesso")
    private Boolean exigeNumeroProcesso;
    @JsonProperty(value="MaisDeUmLayout")
    private Boolean maisDeUmLayout;
    @JsonProperty(value="SequenciaAvaliacaoImobiliario")
    private Integer sequenciaAvaliacaoImobiliario;
    @JsonProperty(value="ValorVenalTerritorialITBI")
    private Double valorVenalTerritorialITBI;
    @JsonProperty(value="ValorVenalPredialITBI")
    private Double valorVenalPredialITBI;
    @JsonProperty(value="AreaLote")
    private Double areaLote;
    @JsonProperty(value="AreaTotalConstruida")
    private Double areaTotalConstruida;
    @JsonProperty(value="Operacao")
    private Integer operacao;
    @JsonProperty(value="GerarItemAposDocumento")
    private Boolean gerarItemAposDocumento;
    @JsonProperty(value="ListaFiltroSubReport")
    private Map<Integer, String> listaFiltroSubReport;
    @JsonProperty(value="CodigoPGD")
    private String codigoPGD;
    @JsonProperty(value="DataPrimeiroAlvara")
    private Date dataPrimeiroAlvara;
    @JsonProperty(value="CodigoLiberacaoSGO")
    private String codigoLiberacaoSGO;
    @JsonProperty(value="Cancelado")
    private String cancelado;
    @JsonProperty(value="Situacao")
    private Integer situacao;

    public GeraDocumento() {
    }

    public GeraDocumento(SolicitacaoAlvaraEntity solicitacao) {
        this.criarJson(solicitacao);
    }

    public Integer getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Integer entidade) {
        this.entidade = entidade;
    }

    public Integer getExercicio() {
        return this.exercicio;
    }

    public void setExercicio(Integer exercicio) {
        this.exercicio = exercicio;
    }

    public Integer getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(Integer tipoDocumento) {
        this.tipoDocumento = tipoDocumento;
    }

    public Integer getDocumento() {
        return this.documento;
    }

    public void setDocumento(Integer documento) {
        this.documento = documento;
    }

    public Boolean getImpresso() {
        return this.impresso;
    }

    public void setImpresso(Boolean impresso) {
        this.impresso = impresso;
    }

    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public Date getDataValidade() {
        return this.dataValidade;
    }

    public void setDataValidade(Date dataValidade) {
        this.dataValidade = dataValidade;
    }

    public String getCodigoValidacao() {
        return this.codigoValidacao;
    }

    public void setCodigoValidacao(String codigoValidacao) {
        this.codigoValidacao = codigoValidacao;
    }

    public String getUsuario() {
        return this.usuario;
    }

    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    public String getOrigemImpressao() {
        return this.origemImpressao;
    }

    public void setOrigemImpressao(String origemImpressao) {
        this.origemImpressao = origemImpressao;
    }

    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setDataSolicitacao(Date dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public Integer getExercicioProcesso() {
        return this.exercicioProcesso;
    }

    public void setExercicioProcesso(Integer exercicioProcesso) {
        this.exercicioProcesso = exercicioProcesso;
    }

    public Integer getIdProcesso() {
        return this.idProcesso;
    }

    public void setIdProcesso(Integer idProcesso) {
        this.idProcesso = idProcesso;
    }

    public Integer getProcesso() {
        return this.processo;
    }

    public void setProcesso(Integer processo) {
        this.processo = processo;
    }

    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public String getCabecalho() {
        return this.cabecalho;
    }

    public void setCabecalho(String cabecalho) {
        this.cabecalho = cabecalho;
    }

    public String getRodape() {
        return this.rodape;
    }

    public void setRodape(String rodape) {
        this.rodape = rodape;
    }

    public String getRequerente() {
        return this.requerente;
    }

    public void setRequerente(String requerente) {
        this.requerente = requerente;
    }

    public String getCpfRequerente() {
        return this.cpfRequerente;
    }

    public void setCpfRequerente(String cpfRequerente) {
        this.cpfRequerente = cpfRequerente;
    }

    public Integer getSequenciaFinalidade() {
        return this.sequenciaFinalidade;
    }

    public void setSequenciaFinalidade(Integer sequenciaFinalidade) {
        this.sequenciaFinalidade = sequenciaFinalidade;
    }

    public Integer getTipoCadastro() {
        return this.tipoCadastro;
    }

    public void setTipoCadastro(Integer tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    public Integer getCadastroGeral() {
        return this.cadastroGeral;
    }

    public void setCadastroGeral(Integer cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    public Integer getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Integer pessoa) {
        this.pessoa = pessoa;
    }

    public Integer getExercicioProjeto() {
        return this.exercicioProjeto;
    }

    public void setExercicioProjeto(Integer exercicioProjeto) {
        this.exercicioProjeto = exercicioProjeto;
    }

    public Integer getProjeto() {
        return this.projeto;
    }

    public void setProjeto(Integer projeto) {
        this.projeto = projeto;
    }

    public Integer getModoGravacao() {
        return this.modoGravacao;
    }

    public void setModoGravacao(Integer modoGravacao) {
        this.modoGravacao = modoGravacao;
    }

    public Boolean getGerouNovo() {
        return this.gerouNovo;
    }

    public void setGerouNovo(Boolean gerouNovo) {
        this.gerouNovo = gerouNovo;
    }

    public String getSubTipo() {
        return this.subTipo;
    }

    public void setSubTipo(String subTipo) {
        this.subTipo = subTipo;
    }

    public Double getAreaAcrescimo() {
        return this.areaAcrescimo;
    }

    public void setAreaAcrescimo(Double areaAcrescimo) {
        this.areaAcrescimo = areaAcrescimo;
    }

    public String getHistorico() {
        return this.historico;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    public String getModuloRelatorio() {
        return this.moduloRelatorio;
    }

    public void setModuloRelatorio(String moduloRelatorio) {
        this.moduloRelatorio = moduloRelatorio;
    }

    public String getTipoRelatorio() {
        return this.tipoRelatorio;
    }

    public void setTipoRelatorio(String tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
    }

    public Integer getRelatorio() {
        return this.relatorio;
    }

    public void setRelatorio(Integer relatorio) {
        this.relatorio = relatorio;
    }

    public String getXMLItemDocumento() {
        return this.XMLItemDocumento;
    }

    public void setXMLItemDocumento(String xMLItemDocumento) {
        this.XMLItemDocumento = xMLItemDocumento;
    }

    public Boolean getPossuiDebitoPendente() {
        return this.possuiDebitoPendente;
    }

    public void setPossuiDebitoPendente(Boolean possuiDebitoPendente) {
        this.possuiDebitoPendente = possuiDebitoPendente;
    }

    public Integer getIsencaoRemissao() {
        return this.isencaoRemissao;
    }

    public void setIsencaoRemissao(Integer isencaoRemissao) {
        this.isencaoRemissao = isencaoRemissao;
    }

    public Boolean getPorCadastro() {
        return this.porCadastro;
    }

    public void setPorCadastro(Boolean porCadastro) {
        this.porCadastro = porCadastro;
    }

    public Boolean getWeb() {
        return this.web;
    }

    public void setWeb(Boolean web) {
        this.web = web;
    }

    public String getEnderecoRequerente() {
        return this.enderecoRequerente;
    }

    public void setEnderecoRequerente(String enderecoRequerente) {
        this.enderecoRequerente = enderecoRequerente;
    }

    public String getOutraFinalidade() {
        return this.outraFinalidade;
    }

    public void setOutraFinalidade(String outraFinalidade) {
        this.outraFinalidade = outraFinalidade;
    }

    public String getTipoPessoaRequerente() {
        return this.tipoPessoaRequerente;
    }

    public void setTipoPessoaRequerente(String tipoPessoaRequerente) {
        this.tipoPessoaRequerente = tipoPessoaRequerente;
    }

    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    public String getMsgErro() {
        return this.msgErro;
    }

    public void setMsgErro(String msgErro) {
        this.msgErro = msgErro;
    }

    public Integer getSequenciaProfissao() {
        return this.sequenciaProfissao;
    }

    public void setSequenciaProfissao(Integer sequenciaProfissao) {
        this.sequenciaProfissao = sequenciaProfissao;
    }

    public Boolean getCasoEspecial() {
        return this.casoEspecial;
    }

    public void setCasoEspecial(Boolean casoEspecial) {
        this.casoEspecial = casoEspecial;
    }

    public Integer getIdSequenciaITBI() {
        return this.idSequenciaITBI;
    }

    public void setIdSequenciaITBI(Integer idSequenciaITBI) {
        this.idSequenciaITBI = idSequenciaITBI;
    }

    public Boolean getSalvaPDF() {
        return this.salvaPDF;
    }

    public void setSalvaPDF(Boolean salvaPDF) {
        this.salvaPDF = salvaPDF;
    }

    public String getTipoDocumentoDescricao() {
        return this.tipoDocumentoDescricao;
    }

    public void setTipoDocumentoDescricao(String tipoDocumentoDescricao) {
        this.tipoDocumentoDescricao = tipoDocumentoDescricao;
    }

    public Boolean getEmitirCertidaoEspecial() {
        return this.emitirCertidaoEspecial;
    }

    public void setEmitirCertidaoEspecial(Boolean emitirCertidaoEspecial) {
        this.emitirCertidaoEspecial = emitirCertidaoEspecial;
    }

    public Boolean getNaoAlteradoDocumentoCadastro() {
        return this.naoAlteradoDocumentoCadastro;
    }

    public void setNaoAlteradoDocumentoCadastro(Boolean naoAlteradoDocumentoCadastro) {
        this.naoAlteradoDocumentoCadastro = naoAlteradoDocumentoCadastro;
    }

    public String getNaoUsouNaCertidaoEspecial() {
        return this.naoUsouNaCertidaoEspecial;
    }

    public void setNaoUsouNaCertidaoEspecial(String naoUsouNaCertidaoEspecial) {
        this.naoUsouNaCertidaoEspecial = naoUsouNaCertidaoEspecial;
    }

    public String getNumeroPrimeiroAlvara() {
        return this.numeroPrimeiroAlvara;
    }

    public void setNumeroPrimeiroAlvara(String numeroPrimeiroAlvara) {
        this.numeroPrimeiroAlvara = numeroPrimeiroAlvara;
    }

    public String getAnoEmissaoAlvara() {
        return this.anoEmissaoAlvara;
    }

    public void setAnoEmissaoAlvara(String anoEmissaoAlvara) {
        this.anoEmissaoAlvara = anoEmissaoAlvara;
    }

    public String getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    public void setUsuarioCancelamento(String usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    public Date getDataCancelamento() {
        return this.dataCancelamento;
    }

    public void setDataCancelamento(Date dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    public String getObservacaoCancelamento() {
        return this.observacaoCancelamento;
    }

    public void setObservacaoCancelamento(String observacaoCancelamento) {
        this.observacaoCancelamento = observacaoCancelamento;
    }

    public Boolean getExigeNumeroProcesso() {
        return this.exigeNumeroProcesso;
    }

    public void setExigeNumeroProcesso(Boolean exigeNumeroProcesso) {
        this.exigeNumeroProcesso = exigeNumeroProcesso;
    }

    public Boolean getMaisDeUmLayout() {
        return this.maisDeUmLayout;
    }

    public void setMaisDeUmLayout(Boolean maisDeUmLayout) {
        this.maisDeUmLayout = maisDeUmLayout;
    }

    public Integer getSequenciaAvaliacaoImobiliario() {
        return this.sequenciaAvaliacaoImobiliario;
    }

    public void setSequenciaAvaliacaoImobiliario(Integer sequenciaAvaliacaoImobiliario) {
        this.sequenciaAvaliacaoImobiliario = sequenciaAvaliacaoImobiliario;
    }

    public Double getValorVenalTerritorialITBI() {
        return this.valorVenalTerritorialITBI;
    }

    public void setValorVenalTerritorialITBI(Double valorVenalTerritorialITBI) {
        this.valorVenalTerritorialITBI = valorVenalTerritorialITBI;
    }

    public Double getValorVenalPredialITBI() {
        return this.valorVenalPredialITBI;
    }

    public void setValorVenalPredialITBI(Double valorVenalPredialITBI) {
        this.valorVenalPredialITBI = valorVenalPredialITBI;
    }

    public Double getAreaLote() {
        return this.areaLote;
    }

    public void setAreaLote(Double areaLote) {
        this.areaLote = areaLote;
    }

    public Double getAreaTotalConstruida() {
        return this.areaTotalConstruida;
    }

    public void setAreaTotalConstruida(Double areaTotalConstruida) {
        this.areaTotalConstruida = areaTotalConstruida;
    }

    public Integer getOperacao() {
        return this.operacao;
    }

    public void setOperacao(Integer operacao) {
        this.operacao = operacao;
    }

    public Boolean getGerarItemAposDocumento() {
        return this.gerarItemAposDocumento;
    }

    public void setGerarItemAposDocumento(Boolean gerarItemAposDocumento) {
        this.gerarItemAposDocumento = gerarItemAposDocumento;
    }

    public Map<Integer, String> getListaFiltroSubReport() {
        return this.listaFiltroSubReport;
    }

    public void setListaFiltroSubReport(Map<Integer, String> listaFiltroSubReport) {
        this.listaFiltroSubReport = listaFiltroSubReport;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getCodigoPGD() {
        return this.codigoPGD;
    }

    public void setCodigoPGD(String codigoPGD) {
        this.codigoPGD = codigoPGD;
    }

    public Date getDataPrimeiroAlvara() {
        return this.dataPrimeiroAlvara;
    }

    public void setDataPrimeiroAlvara(Date dataPrimeiroAlvara) {
        this.dataPrimeiroAlvara = dataPrimeiroAlvara;
    }

    public String getCodigoLiberacaoSGO() {
        return this.codigoLiberacaoSGO;
    }

    public void setCodigoLiberacaoSGO(String codigoLiberacaoSGO) {
        this.codigoLiberacaoSGO = codigoLiberacaoSGO;
    }

    public String getCancelado() {
        return this.cancelado;
    }

    public void setCancelado(String cancelado) {
        this.cancelado = cancelado;
    }

    public Integer getSituacao() {
        return this.situacao;
    }

    public void setSituacao(Integer situacao) {
        this.situacao = situacao;
    }

    public String formatJson() {
        return AlvaraObjectMapper.jsonToString((Object)this);
    }

    private GeraDocumento criarJson(SolicitacaoAlvaraEntity solicitacao) {
        this.setClassName(CLASS_NAME_ALVARA_LOCALIZACAO);
        this.setAnoEmissaoAlvara(UtilsController.getEntidadeTributacao().getId().getExercicioTributacao().getExercicio().toString());
        if (Objects.isNull(solicitacao.getAreaConstruida())) {
            solicitacao.setAreaConstruida(BigDecimal.ZERO);
        }
        this.setAreaTotalConstruida(Double.valueOf(solicitacao.getAreaConstruida().doubleValue()));
        this.setCadastroGeral(Integer.valueOf(solicitacao.getCadastroMobiliario().getCadastroGeral().getId().getCodigo().intValue()));
        this.setCasoEspecial(Boolean.FALSE);
        this.setCnpjCpf(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf());
        this.setCpfRequerente(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getCnpjCpf());
        this.setDataEmissao(new Date());
        this.setDataSolicitacao(solicitacao.getDataSolicitacao());
        this.setDataValidade(solicitacao.getCadastroMobiliario().getDataValidadeAlvara());
        this.setEmitirCertidaoEspecial(Boolean.FALSE);
        this.setEntidade(Integer.valueOf(UtilsController.getEntidadeTributacao().getId().getEntidade().getId().intValue()));
        this.setExercicio(Integer.valueOf(UtilsController.getEntidadeTributacao().getId().getExercicioTributacao().getExercicio().intValue()));
        this.setImpresso(Boolean.TRUE);
        this.setMaisDeUmLayout(Boolean.FALSE);
        this.setModoGravacao(MODO_GRAVACAO_NOVO_DOCUMENTO);
        this.setModuloRelatorio(MODULO_RELATORIO);
        this.setNaoAlteradoDocumentoCadastro(Boolean.FALSE);
        this.setPessoa(Integer.valueOf(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getPessoa().intValue()));
        this.setPorCadastro(Boolean.TRUE);
        this.setPossuiDebitoPendente(null);
        this.setRequerente(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getNome());
        this.setSubTipo(SimNaoEnum.NAO.getShortText());
        this.setTipoCadastro(Integer.valueOf(solicitacao.getCadastroMobiliario().getCadastroGeral().getId().getTipo().intValue()));
        this.setTipoDocumento(EnvioGeraDocumento.TIPO_DOCUMENTO_ALVARA_LOCALIZACAO);
        this.setTipoDocumentoDescricao(DESCRICAO_TIPO_DOCUMENTO);
        this.setTipoPessoaRequerente(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getTipoPessoa());
        this.setTipoRelatorio(SimNaoEnum.SIM.getShortText());
        this.setUsuario(PortalUtils.getUsuarioalvaraonline());
        this.setOperacao(OPERACAO);
        this.setGerarItemAposDocumento(GERAR_ITEM_APOS_DOCUMENTO);
        this.setListaFiltroSubReport(null);
        this.setCodigoPGD("");
        this.setWeb(Boolean.TRUE);
        this.setDataPrimeiroAlvara(new Date());
        this.setCodigoLiberacaoSGO(solicitacao.getCadastroMobiliario().getCadastroGeral().getPessoa().getCodigoLiberacaoSGO());
        this.setCancelado(SimNaoEnum.NAO.getShortText());
        this.setSituacao(Integer.valueOf(1));
        return this;
    }
}

