/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.primefaces;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.primefaces.model.StreamedContent;

public class PrimeResourceHandler
extends org.primefaces.application.PrimeResourceHandler {
    public PrimeResourceHandler(ResourceHandler wrapped) {
        super(wrapped);
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        String library = (String)params.get("ln");
        String dynamicContentId = (String)params.get("pfdrid");
        if (dynamicContentId != null && library != null && "primefaces".equals(library)) {
            Map session = context.getExternalContext().getSessionMap();
            StreamedContent streamedContent = null;
            boolean cache = Boolean.valueOf((String)params.get("pfdrid_c"));
            try {
                Object dynamicContentEL = session.get(dynamicContentId);
                ExternalContext externalContext = context.getExternalContext();
                if (dynamicContentEL != null) {
                    streamedContent = (StreamedContent)dynamicContentEL;
                    externalContext.setResponseStatus(200);
                    externalContext.setResponseContentType(streamedContent.getContentType());
                    if (cache) {
                        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(1, 1);
                        externalContext.setResponseHeader("Cache-Control", "max-age=29030400");
                        externalContext.setResponseHeader("Expires", httpDateFormat.format(calendar.getTime()));
                    } else {
                        externalContext.setResponseHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                        externalContext.setResponseHeader("Pragma", "no-cache");
                        externalContext.setResponseHeader("Expires", "Mon, 8 Aug 1980 10:00:00 GMT");
                    }
                    if (streamedContent.getContentEncoding() != null) {
                        externalContext.setResponseHeader("Content-Encoding", streamedContent.getContentEncoding());
                    }
                    byte[] buffer = new byte[2048];
                    InputStream inputStream = streamedContent.getStream();
                    if (inputStream != null) {
                        int length;
                        while ((length = inputStream.read(buffer)) >= 0) {
                            externalContext.getResponseOutputStream().write(buffer, 0, length);
                        }
                    }
                }
                externalContext.responseFlushBuffer();
                context.responseComplete();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                session.remove(dynamicContentId);
                if (streamedContent != null && streamedContent.getStream() != null) {
                    streamedContent.getStream().close();
                }
            }
        } else {
            super.handleResourceRequest(context);
        }
    }
}

