/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.integration.vo;

import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.tributacao.domain.CidadeEntity;
import br.com.elotech.tributacao.domain.aise.BairroEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.LogradouroEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.domain.aise.TipoLogradouroEntity;
import br.com.elotech.util.math.EloNumberUtils;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PessoaIssExternoEnvio
implements Serializable {
    private static final long serialVersionUID = -2391167124302576765L;
    private Integer id;
    private String tipo;
    @JsonProperty(value="cpf_cnpj")
    private String cpfCnpj;
    @JsonProperty(value="razao_social")
    private String razaoSocial;
    @JsonProperty(value="nome_fantasia")
    private String nomeFantasia;
    @JsonProperty(value="inscricao_estadual")
    private String inscricaoEstadual;
    private String email;
    private String fone;
    private String celular;
    private String site;
    private String rg;
    @JsonProperty(value="rg_orgao_emissor")
    private String rgOrgaoEmissor;
    @JsonProperty(value="rg_emissao")
    private Date rgEmissao;
    @JsonProperty(value="rg_uf")
    private String rgUf;
    @JsonProperty(value="crc")
    private String crc;
    private String crea;
    private String cau;
    private Boolean arquiteto;
    private Boolean engenheiro;
    @JsonProperty(value="tecnico_edificacao")
    private Boolean tecnicoEdificacao;
    @JsonProperty(value="endereco_logradouro")
    private String enderecoLogradouro;
    @JsonProperty(value="endereco_logradouro_tipo")
    private String enderecoLogradouroTipo;
    @JsonProperty(value="endereco_bairro")
    private String enderecoBairro;
    @JsonProperty(value="endereco_numero")
    private String enderecoNumero;
    @JsonProperty(value="endereco_complemento")
    private String enderecoComplemento;
    @JsonProperty(value="endereco_cep")
    private String enderecoCep;
    @JsonProperty(value="endereco_cidade")
    private String enderecoCidade;
    @JsonProperty(value="endereco_uf")
    private String enderecoUf;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap();

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String razaoSocial) {
        this.razaoSocial = razaoSocial;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String inscricaoEstadual) {
        this.inscricaoEstadual = inscricaoEstadual;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFone() {
        return this.fone;
    }

    public void setFone(String fone) {
        this.fone = fone;
    }

    public String getCelular() {
        return this.celular;
    }

    public void setCelular(String celular) {
        this.celular = celular;
    }

    public String getSite() {
        return this.site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public String getRg() {
        return this.rg;
    }

    public void setRg(String rg) {
        this.rg = rg;
    }

    public String getRgOrgaoEmissor() {
        return this.rgOrgaoEmissor;
    }

    public void setRgOrgaoEmissor(String rgOrgaoEmissor) {
        this.rgOrgaoEmissor = rgOrgaoEmissor;
    }

    public Date getRgEmissao() {
        return this.rgEmissao;
    }

    public void setRgEmissao(Date date) {
        this.rgEmissao = date;
    }

    public String getRgUf() {
        return this.rgUf;
    }

    public void setRgUf(String rgUf) {
        this.rgUf = rgUf;
    }

    public String getCrc() {
        return this.crc;
    }

    public void setCrc(String crc) {
        this.crc = crc;
    }

    public String getCrea() {
        return this.crea;
    }

    public void setCrea(String crea) {
        this.crea = crea;
    }

    public String getCau() {
        return this.cau;
    }

    public void setCau(String cau) {
        this.cau = cau;
    }

    public Boolean getArquiteto() {
        return this.arquiteto;
    }

    public void setArquiteto(Boolean arquiteto) {
        this.arquiteto = arquiteto;
    }

    public Boolean getEngenheiro() {
        return this.engenheiro;
    }

    public void setEngenheiro(Boolean engenheiro) {
        this.engenheiro = engenheiro;
    }

    public Boolean getTecnicoEdificacao() {
        return this.tecnicoEdificacao;
    }

    public void setTecnicoEdificacao(Boolean tecnicoEdificacao) {
        this.tecnicoEdificacao = tecnicoEdificacao;
    }

    public String getEnderecoLogradouro() {
        return this.enderecoLogradouro;
    }

    public void setEnderecoLogradouro(String enderecoLogradouro) {
        this.enderecoLogradouro = enderecoLogradouro;
    }

    public String getEnderecoLogradouroTipo() {
        return this.enderecoLogradouroTipo;
    }

    public void setEnderecoLogradouroTipo(String enderecoLogradouroTipo) {
        this.enderecoLogradouroTipo = enderecoLogradouroTipo;
    }

    public String getEnderecoBairro() {
        return this.enderecoBairro;
    }

    public void setEnderecoBairro(String enderecoBairro) {
        this.enderecoBairro = enderecoBairro;
    }

    public String getEnderecoNumero() {
        return this.enderecoNumero;
    }

    public void setEnderecoNumero(String enderecoNumero) {
        this.enderecoNumero = enderecoNumero;
    }

    public String getEnderecoComplemento() {
        return this.enderecoComplemento;
    }

    public void setEnderecoComplemento(String enderecoComplemento) {
        this.enderecoComplemento = enderecoComplemento;
    }

    public String getEnderecoCep() {
        return this.enderecoCep;
    }

    public void setEnderecoCep(String enderecoCep) {
        this.enderecoCep = enderecoCep;
    }

    public String getEnderecoCidade() {
        return this.enderecoCidade;
    }

    public void setEnderecoCidade(String enderecoCidade) {
        this.enderecoCidade = enderecoCidade;
    }

    public String getEnderecoUf() {
        return this.enderecoUf;
    }

    public void setEnderecoUf(String enderecoUf) {
        this.enderecoUf = enderecoUf;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public static PessoaIssExternoEnvio fromSolicitacao(SolicitacaoAlvaraEntity solicitacao) {
        CadastroMobiliarioEntity cadastroMobiliario = solicitacao.getCadastroMobiliario();
        PessoaEntity pessoa = cadastroMobiliario.getCadastroGeral().getPessoa();
        PessoaIssExternoEnvio envio = new PessoaIssExternoEnvio();
        PessoaIssExternoEnvio.setarDadosIdentificacao((PessoaIssExternoEnvio)envio, (PessoaEntity)pessoa);
        PessoaIssExternoEnvio.setarDadosEndereco((PessoaIssExternoEnvio)envio, (SolicitacaoAlvaraEntity)solicitacao);
        PessoaIssExternoEnvio.setarDadosContato((PessoaIssExternoEnvio)envio, (CadastroMobiliarioEntity)cadastroMobiliario);
        return envio;
    }

    private static void setarDadosContato(PessoaIssExternoEnvio envio, CadastroMobiliarioEntity cadastroMobiliario) {
        envio.setFone(cadastroMobiliario.getTelefone());
    }

    private static void setarDadosIdentificacao(PessoaIssExternoEnvio envio, PessoaEntity pessoa) {
        envio.setTipo(pessoa.getTipoPessoa());
        envio.setRazaoSocial(pessoa.getNome());
        envio.setNomeFantasia(pessoa.getNomeFantasia());
        envio.setCpfCnpj(pessoa.getCnpjCpf());
        envio.setRg(pessoa.getRg());
        envio.setRgEmissao(pessoa.getDataEmissao());
        envio.setRgOrgaoEmissor(pessoa.getOrgaoEmissor());
        envio.setRgUf(pessoa.getEstadoEmissor());
        envio.setInscricaoEstadual(pessoa.getInscricaoEstadual());
    }

    private static void setarDadosEndereco(PessoaIssExternoEnvio envio, SolicitacaoAlvaraEntity solicitacaoAlvara) {
        LogradouroEntity logradouro;
        CadastroGeralAiseEntity cadastroGeral = Optional.ofNullable(solicitacaoAlvara.getCadastroImobiliario()).map(CadastroImobiliarioEntity::getCadastroGeral).orElse(Optional.ofNullable(solicitacaoAlvara.getCadastroMobiliario()).map(CadastroMobiliarioEntity::getCadastroGeral).get());
        envio.setEnderecoComplemento(cadastroGeral.getComplemento());
        envio.setEnderecoNumero(cadastroGeral.getNumero());
        BairroEntity bairro = cadastroGeral.getBairro();
        if (Objects.nonNull(bairro)) {
            envio.setEnderecoBairro(bairro.getDescricao());
            CidadeEntity cidade = bairro.getId().getCidade();
            if (Objects.nonNull(cidade)) {
                envio.setEnderecoCidade(cidade.getDescricao());
                if (Objects.nonNull(cidade.getUnidadeFederacao())) {
                    envio.setEnderecoUf(cidade.getUnidadeFederacao().getId().getUnidadeFederacao());
                }
            }
        }
        if (EloNumberUtils.isBiggerThanZero((Number)cadastroGeral.getCep()).booleanValue()) {
            envio.setEnderecoCep(String.valueOf(cadastroGeral.getCep()));
        }
        if (Objects.nonNull(logradouro = cadastroGeral.getLogradouro())) {
            envio.setEnderecoLogradouro(logradouro.getDescricao());
            TipoLogradouroEntity tipoLogradouro = logradouro.getTipoLogradouro();
            if (Objects.nonNull(tipoLogradouro)) {
                envio.setEnderecoLogradouroTipo(tipoLogradouro.getDescricao());
            }
        }
    }
}

