/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.integration.vo;

import br.com.elotech.portalarrecadacao.domain.RestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraNumConselhoEntity;
import br.com.elotech.portalarrecadacao.exception.ProcessoFiscalizacaoException;
import br.com.elotech.tributacao.domain.aise.ContratoSocialEntity;
import br.com.elotech.tributacao.domain.aise.ContratoSocialPessoaEntity;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.math.EloNumberUtils;
import br.com.elotech.util.string.EloStringUtils;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
public class Items {
    public String titulo;
    public String valor;
    public String field_name;

    public static Items[] getItemsSolicitacao(SolicitacaoAlvaraEntity solicitacao, List<RestricaoAlvaraEntity> listaRestricaoAlvara) throws ProcessoFiscalizacaoException {
        try {
            Optional contratoSocial;
            ArrayList<Items> itensCadastro = new ArrayList<Items>();
            Items razaoSocial = new Items();
            razaoSocial.titulo = "Raz\u00e3o Social";
            razaoSocial.valor = solicitacao.getNomeRazaoSocial();
            itensCadastro.add(razaoSocial);
            Items nomeFantasia = new Items();
            nomeFantasia.titulo = "Nome Fantasia";
            nomeFantasia.valor = solicitacao.getFantasia();
            itensCadastro.add(nomeFantasia);
            Items cnpj = new Items();
            cnpj.titulo = "CNPJ";
            cnpj.valor = solicitacao.getCpfCnpj();
            itensCadastro.add(cnpj);
            Items telefone = new Items();
            telefone.titulo = "Telefone";
            telefone.valor = Items.getValorItems((Object)EloStringUtils.formatFone((String)solicitacao.getTelefone()));
            itensCadastro.add(telefone);
            Items mobiliario = new Items();
            mobiliario.titulo = "Cadastro Mobili\u00e1rio";
            mobiliario.valor = Items.getValorItems((Object)solicitacao.getCadastroMobiliario().getId().getCodigo());
            itensCadastro.add(mobiliario);
            Items endereco = new Items();
            endereco.titulo = "Endere\u00e7o";
            endereco.valor = solicitacao.montarEnderecoCorretoDaSolicitacao();
            itensCadastro.add(endereco);
            Items complemento = new Items();
            complemento.titulo = "Complemento";
            complemento.valor = solicitacao.montarComplementoMobiliarioEImobiliario();
            itensCadastro.add(complemento);
            Items bairro = new Items();
            bairro.titulo = "Bairro";
            bairro.valor = Items.getValorItems((Object)solicitacao.getCadastroImobiliario().getCadastroGeral().getBairro().getDescricao());
            itensCadastro.add(bairro);
            Items zona = new Items();
            zona.titulo = "Zona";
            zona.valor = Items.getValorItems((Object)solicitacao.getCadastroImobiliario().getSetorDescr());
            itensCadastro.add(zona);
            Items quadra = new Items();
            quadra.titulo = "Quadra";
            quadra.valor = Items.getValorItems((Object)solicitacao.getCadastroImobiliario().getQuadraDescr());
            itensCadastro.add(quadra);
            Items lote = new Items();
            lote.titulo = "Lote";
            lote.valor = Items.getValorItems((Object)solicitacao.getCadastroImobiliario().getLoteDescr());
            itensCadastro.add(lote);
            Items descricaoAtividades = new Items();
            descricaoAtividades.titulo = "Descri\u00e7\u00e3o das Atividades";
            descricaoAtividades.valor = Items.getValorItems((Object)solicitacao.getDescricaoAtividades());
            itensCadastro.add(descricaoAtividades);
            if (!EloListUtils.safeIsEmpty((List)solicitacao.getSolicitacaoAlvaraAtividades()).booleanValue()) {
                for (SolicitacaoAlvaraAtividadeEntity atividade : solicitacao.getSolicitacaoAlvaraAtividades()) {
                    Items codigoAtividade = new Items();
                    codigoAtividade.titulo = "C\u00f3digo Atividade";
                    codigoAtividade.valor = Items.getValorItems((Object)atividade.getCodigoAtividade());
                    Items grauRisco = new Items();
                    grauRisco.titulo = "Grau de Risco";
                    grauRisco.valor = Items.getValorItems((Object)atividade.getGrauRisco());
                    Items descricaoAtividade = new Items();
                    descricaoAtividade.titulo = "Atividades";
                    descricaoAtividade.valor = Items.getValorItems((Object)atividade.getDescricaoAtividade());
                    Items atividadePrincipal = new Items();
                    atividadePrincipal.titulo = "Atividade Principal";
                    atividadePrincipal.valor = "S".equals(atividade.getPrincipal()) ? "Sim" : "N\u00e3o";
                    itensCadastro.add(codigoAtividade);
                    itensCadastro.add(descricaoAtividade);
                    itensCadastro.add(grauRisco);
                    if (EloListUtils.safeIsEmpty((List)atividade.getNumerosConselho()).booleanValue()) continue;
                    for (SolicitacaoAlvaraNumConselhoEntity numConselho : atividade.getNumerosConselho()) {
                        Items responsavel = new Items();
                        responsavel.titulo = "Respons\u00e1vel Tecnico";
                        responsavel.valor = Items.getValorItems((Object)numConselho.getNomeResponsavel());
                        Items numeroRegistro = new Items();
                        numeroRegistro.titulo = "N\u00famero Registro";
                        numeroRegistro.valor = Items.getValorItems((Object)numConselho.getNumeroRegistro());
                        itensCadastro.add(responsavel);
                        itensCadastro.add(numeroRegistro);
                    }
                }
            }
            if (EloNumberUtils.isBiggerThanZero((Number)solicitacao.getAreaConstruida()).booleanValue()) {
                Items areaConstruida = new Items();
                areaConstruida.titulo = "\u00c1rea Constru\u00edda";
                areaConstruida.valor = Items.getValorItems((Object)solicitacao.getAreaConstruida().toString());
                itensCadastro.add(areaConstruida);
            }
            if (EloNumberUtils.isBiggerThanZero((Number)solicitacao.getAreaPatio()).booleanValue()) {
                Items areaPatio = new Items();
                areaPatio.titulo = "\u00c1rea Patio";
                areaPatio.valor = Items.getValorItems((Object)solicitacao.getAreaPatio().toString());
                itensCadastro.add(areaPatio);
            }
            Items areaUtilizada = new Items();
            areaUtilizada.titulo = "\u00c1rea Utilizada";
            areaUtilizada.valor = Items.getValorItems((Object)solicitacao.getAreaUtilizada().toString());
            itensCadastro.add(areaUtilizada);
            if (!Strings.isNullOrEmpty((String)solicitacao.getExigencias())) {
                Items exigencias = new Items();
                exigencias.titulo = "Exig\u00eancias";
                exigencias.valor = Items.getValorItems((Object)solicitacao.getExigencias());
                itensCadastro.add(exigencias);
            }
            StringBuilder restricaoAlvara = new StringBuilder();
            if (!EloListUtils.safeIsEmpty(listaRestricaoAlvara).booleanValue()) {
                listaRestricaoAlvara.stream().forEach(item -> restricaoAlvara.append(item.getDescricao()).append(", "));
                Items restricoes = new Items();
                restricoes.titulo = "Restri\u00e7\u00f5es";
                restricoes.valor = restricaoAlvara.toString();
                itensCadastro.add(restricoes);
            }
            if ((contratoSocial = solicitacao.getCadastroMobiliario().getContratosSociais().stream().sorted((p2, p1) -> p1.getId().getSequencia().compareTo(p2.getId().getSequencia())).findFirst()).isPresent() && !EloListUtils.safeIsEmpty((List)((ContratoSocialEntity)contratoSocial.get()).getPessoas()).booleanValue()) {
                for (ContratoSocialPessoaEntity csPessoa : ((ContratoSocialEntity)contratoSocial.get()).getPessoas()) {
                    Items socioNome = new Items();
                    socioNome.titulo = "S\u00f3cio";
                    socioNome.valor = csPessoa.getId().getPessoa().getNome();
                    Items socioCpf = new Items();
                    socioCpf.titulo = "Cpf:";
                    socioCpf.valor = csPessoa.getId().getPessoa().getCnpjCpf();
                    itensCadastro.add(socioNome);
                    itensCadastro.add(socioCpf);
                }
            }
            return itensCadastro.toArray(new Items[itensCadastro.size()]);
        }
        catch (Exception e) {
            throw new ProcessoFiscalizacaoException("Ocorreu uma falha ao montar os Items da ordem de servi\u00e7o");
        }
    }

    private static String getValorItems(Object valor) {
        if (Objects.nonNull(valor)) {
            return valor.toString();
        }
        return new String();
    }
}

