/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.integration.transformer;

import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.logLayer.EloLogger;
import br.com.elotech.portalarrecadacao.controller.ConsultaRedeSimController;
import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.domain.ClassificacaoTipoInscricaoEntity;
import br.com.elotech.portalarrecadacao.domain.EventoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ScriptAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaAtividadeVo;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaPreviaVo;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaRedeSim;
import br.com.elotech.portalarrecadacao.enumerator.FormaAtuacaoEnum;
import br.com.elotech.portalarrecadacao.enumerator.GrauDeRiscoEnum;
import br.com.elotech.portalarrecadacao.enumerator.MotivoIndeferimentoRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.RedeSimEventoEnum;
import br.com.elotech.portalarrecadacao.enumerator.SituacaoConsultaPreviaRedeSimEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoDeUnidadeEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoScriptAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.TipoSolicitacaoRedeSimEnum;
import br.com.elotech.portalarrecadacao.exception.AnexoRedeSimNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoConfiguradaException;
import br.com.elotech.portalarrecadacao.exception.AtividadeNaoPermitidaException;
import br.com.elotech.portalarrecadacao.exception.CadastroImobiliarioNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.CadastroImobiliarioNaoInformadoException;
import br.com.elotech.portalarrecadacao.exception.ConfiguracaoTestadaException;
import br.com.elotech.portalarrecadacao.exception.ConsultaPreviaRedeSimException;
import br.com.elotech.portalarrecadacao.exception.DeferimentoRedeSimSigFacilException;
import br.com.elotech.portalarrecadacao.exception.EnderecoIncompletoException;
import br.com.elotech.portalarrecadacao.exception.IndeferimentoRedeSimException;
import br.com.elotech.portalarrecadacao.exception.IndeferimentoRedeSimSigFacilException;
import br.com.elotech.portalarrecadacao.exception.LogradouroNaoEncontradoException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraRedeSimException;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoInconsistenteException;
import br.com.elotech.portalarrecadacao.exception.TestadaNaoEncontradaException;
import br.com.elotech.portalarrecadacao.facade.FacadeAlteracaoAtividades;
import br.com.elotech.portalarrecadacao.facade.FacadeAtividadeCnae;
import br.com.elotech.portalarrecadacao.facade.FacadeCadastroImobiliario;
import br.com.elotech.portalarrecadacao.facade.FacadeEntidade;
import br.com.elotech.portalarrecadacao.facade.FacadeNaturezaSolicitacaoTipoInscricao;
import br.com.elotech.portalarrecadacao.facade.FacadeRedeSim;
import br.com.elotech.portalarrecadacao.facade.FacadeScriptAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.facade.FacadeTipoInscricao;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Atividades;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.ConsultaPreviaDTO;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.DadosConsultaPrevia;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.DadosSolicitacao;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Endereco;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Evento;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.GrauRiscoPergunta;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Natureza_imovel;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Solicitante;
import br.com.elotech.portalarrecadacao.rest.imprimirdocumento.ImprimeDocumentoAlvara;
import br.com.elotech.portalarrecadacao.service.SrvDebitosPortal;
import br.com.elotech.portalarrecadacao.service.SrvVerificaExigenciaCnae;
import br.com.elotech.portalarrecadacao.service.impl.SrvFindEnderecoBySimilarity;
import br.com.elotech.portalarrecadacao.utils.JsonUtils;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.DecisaoGeo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.ObservacaoGeo;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornaAtividadeResponse;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RetornoConsultaAtividade;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioTestadaEntity;
import br.com.elotech.tributacao.domain.aise.LogradouroEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.enumerator.SimNaoEnum;
import br.com.elotech.tributacao.exception.CadastroImobiliarioException;
import br.com.elotech.tributacao.interfaces.Atividade;
import br.com.elotech.tributacao.repository.aise.RepositoryDocumentoAise;
import br.com.elotech.tributacao.repository.aise.RepositoryEntidadeTributacao;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import br.com.elotech.util.string.PadOption;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import groovy.lang.GroovyShell;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="processaConsulta")
public class ProcessaConsulta
extends EloLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String QUEBRA_LINHA = "<br/>";
    private static final String REGEX_FIND_NAO_DIGITOS = "[^0-9]";
    private static final String TIPOREQUERENTE = "J";
    private static final String IMOVEL_RURAL = "1";
    private StringBuilder observacaoConsultaPrevia;
    @Resource
    private RepositoryEntidadeTributacao repositoryEntidadeTributacao;
    @Resource
    private transient SrvDebitosPortal srvDebitosPortal;
    @Resource
    private RepositoryDocumentoAise repositoryDocumentoAise;
    @Resource
    private transient ImprimeDocumentoAlvara imprimeDocumentoAlvara;
    @Resource
    private FacadeRedeSim facadeRedeSim;
    @Resource
    private FacadeEntidade facadeEntidade;
    @Resource
    private FacadeSolicitacaoAlvara facadeSolicitacaAlvara;
    @Resource
    private FacadeCadastroImobiliario facadeCadastroImobiliario;
    @Resource
    private FacadeNaturezaSolicitacaoTipoInscricao facadeNaturezaSolicitacaoTipoInscricao;
    @Resource
    private FacadeAlteracaoAtividades facadeAlteracaoAtividades;
    @Resource
    private FacadeAtividadeCnae facadeAtividadeCnae;
    @Resource
    private FacadeTipoInscricao facadeTipoInscricao;
    @Resource
    private transient SrvVerificaExigenciaCnae srvVerificaExigenciaCnae;
    @Resource
    private transient SrvFindEnderecoBySimilarity srvFindEnderecoBySimilarity;
    private SolicitacaoAlvaraEntity consultaPrevia;
    private boolean integradoGeo = false;
    private StringBuilder obsSolicitacao;
    private static final GroovyShell SHELL = new GroovyShell();

    public void setFacadeEntidade(FacadeEntidade facadeEntidade) {
        this.facadeEntidade = facadeEntidade;
    }

    public void setFacadeSolicitacaAlvara(FacadeSolicitacaoAlvara facadeSolicitacaAlvara) {
        this.facadeSolicitacaAlvara = facadeSolicitacaAlvara;
    }

    public void setFacadeNaturezaSolicitacaoTipoInscricao(FacadeNaturezaSolicitacaoTipoInscricao facadeNaturezaSolicitacaoTipoInscricao) {
        this.facadeNaturezaSolicitacaoTipoInscricao = facadeNaturezaSolicitacaoTipoInscricao;
    }

    public void setFacadeAlteracaoAtividades(FacadeAlteracaoAtividades facadeAlteracaoAtividades) {
        this.facadeAlteracaoAtividades = facadeAlteracaoAtividades;
    }

    public void setFacadeRedeSim(FacadeRedeSim facadeRedeSim) {
        this.facadeRedeSim = facadeRedeSim;
    }

    protected void setIntegradoGeo(boolean integradoGeo) {
        this.integradoGeo = integradoGeo;
    }

    public SolicitacaoRedeSimEntity process(ConsultaPreviaDTO consultaPreviaDTO) throws BaseException {
        Gson gson = new Gson();
        consultaPreviaDTO = (ConsultaPreviaDTO)gson.fromJson(JsonUtils.sanitize((String)gson.toJson((Object)consultaPreviaDTO)), ConsultaPreviaDTO.class);
        this.obsSolicitacao = new StringBuilder();
        this.integradoGeo = this.integradoGeo();
        this.observacaoConsultaPrevia = new StringBuilder();
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.getSolicitacaoRedeSim(consultaPreviaDTO);
        solicitacaoRedeSim.setInvalidado(SimNaoEnum.getNaoShortText());
        this.consultaPrevia = null;
        try {
            this.consultaPrevia = this.inicializarConsultaPrevia(consultaPreviaDTO, solicitacaoRedeSim);
            this.consultaPrevia.setTipoDeInscricao(this.facadeRedeSim.findTipoInscricaoAlvara(consultaPreviaDTO.getDados_consulta_previa().getTipo_unidade(), consultaPreviaDTO.getDados_consulta_previa().getFormas_atuacao(), consultaPreviaDTO.getDados_consulta_previa().getAtividades(), consultaPreviaDTO.getDados_consulta_previa().getCo_enquadramento()));
            if (solicitacaoRedeSim.getSolicitacoesAlvara().stream().noneMatch(p -> p.getSolicitacaoAlvara().equals(this.consultaPrevia.getSolicitacaoAlvara()))) {
                this.consultaPrevia = this.facadeSolicitacaAlvara.salvarConsultaPrevia(this.consultaPrevia, Boolean.valueOf(true));
                solicitacaoRedeSim.setSolicitacaoAlvara(this.consultaPrevia);
                solicitacaoRedeSim = this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
            }
            this.adicionarClassificacaoTipoInscricao(consultaPreviaDTO, this.consultaPrevia);
            if (!this.isImovelRural(consultaPreviaDTO.getDados_consulta_previa()) || UtilsController.isImovelRuralUsaCadastroImobiliario()) {
                this.preencherCadastroImobiliario(consultaPreviaDTO, this.consultaPrevia);
                this.preencherDadosImobiliarioTestada(consultaPreviaDTO, this.consultaPrevia);
            }
            if (SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.VALIDA_FORMAATUACAO_ATIVIDADE_CONSULTAPREVIA)).booleanValue()) {
                boolean formaAtuacaoEstabelecimentoFixo;
                boolean naoExerceNenhumaAtividadeNoEndereco = Objects.nonNull(consultaPreviaDTO.getDados_consulta_previa().getAtividades()) && consultaPreviaDTO.getDados_consulta_previa().getAtividades().stream().noneMatch(Atividades::isIs_exerce_no_endereco);
                boolean exerceTodasAtividadesNoEndereco = Objects.nonNull(consultaPreviaDTO.getDados_consulta_previa().getAtividades()) && consultaPreviaDTO.getDados_consulta_previa().getAtividades().stream().allMatch(Atividades::isIs_exerce_no_endereco);
                boolean formaAtuacaoAtividadeForaEstabelecimento = Objects.nonNull(consultaPreviaDTO.getDados_consulta_previa().getFormas_atuacao()) && consultaPreviaDTO.getDados_consulta_previa().getFormas_atuacao().stream().anyMatch(formaAtuacao -> FormaAtuacaoEnum.ATV_FORA_ESTAB.getCodigo() == formaAtuacao.getCo_forma_atuacao());
                boolean bl = formaAtuacaoEstabelecimentoFixo = Objects.nonNull(consultaPreviaDTO.getDados_consulta_previa().getFormas_atuacao()) && consultaPreviaDTO.getDados_consulta_previa().getFormas_atuacao().stream().anyMatch(formaAtuacao -> FormaAtuacaoEnum.ESTABELECIMENTO_FIXO.getCodigo() == formaAtuacao.getCo_forma_atuacao());
                if (naoExerceNenhumaAtividadeNoEndereco && formaAtuacaoEstabelecimentoFixo) {
                    throw new IndeferimentoRedeSimException(MotivoIndeferimentoRedeSimEnum.OUTROS, "Nenhuma atividade \u00e9 exercida no local, portanto, a forma de atua\u00e7\u00e3o Estabelecimento Fixo \u00e9 incompat\u00edvel.");
                }
                if (exerceTodasAtividadesNoEndereco && formaAtuacaoAtividadeForaEstabelecimento) {
                    throw new IndeferimentoRedeSimException(MotivoIndeferimentoRedeSimEnum.OUTROS, "Todas as atividades s\u00e3o exercidas no local, portanto, a forma de atua\u00e7\u00e3o Fora do Estabelicimento \u00e9 incompat\u00edvel.");
                }
            }
            this.preencherAtividadesDaSolicitacao(consultaPreviaDTO, this.consultaPrevia);
            this.montarObservacaoSolicitacaoAlvara(solicitacaoRedeSim, this.consultaPrevia);
            this.facadeSolicitacaAlvara.salvarConsultaPrevia(this.consultaPrevia, Boolean.valueOf(true));
            this.facadeRedeSim.respostaSolicitacaoRedeSim(solicitacaoRedeSim);
            solicitacaoRedeSim.setSituacao(SituacaoConsultaPreviaRedeSimEnum.DEFERIDO.getSigla());
            solicitacaoRedeSim.setUsuarioTramitacao("INTEGRASGO");
            solicitacaoRedeSim.setDataTramitacao(new Date());
            return this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
        }
        catch (AtividadeNaoConfiguradaException ae) {
            this.facadeSolicitacaAlvara.salvarConsultaPrevia(this.consultaPrevia, Boolean.valueOf(true));
            solicitacaoRedeSim.setSolicitacaoAlvara(this.consultaPrevia);
            solicitacaoRedeSim.setSituacao(SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla());
            return this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
        }
        catch (AtividadeNaoPermitidaException anpe) {
            this.observacaoConsultaPrevia.append(anpe.getMessage()).append("\n");
            this.facadeSolicitacaAlvara.salvarConsultaPrevia(this.consultaPrevia, Boolean.valueOf(true));
            solicitacaoRedeSim.setSolicitacaoAlvara(this.consultaPrevia);
            IndeferimentoRedeSimException irse = new IndeferimentoRedeSimException(MotivoIndeferimentoRedeSimEnum.ATIVIDADE_NAO_PERMITIDA, anpe.getMessage());
            this.verificarRespostaAutomatica(solicitacaoRedeSim, irse);
            return this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
        }
        catch (IndeferimentoRedeSimException ex) {
            this.observacaoConsultaPrevia.append(ex.getMessage()).append("\n");
            this.facadeSolicitacaAlvara.salvarConsultaPrevia(this.consultaPrevia, Boolean.valueOf(true));
            solicitacaoRedeSim.setSolicitacaoAlvara(this.consultaPrevia);
            this.verificarRespostaAutomatica(solicitacaoRedeSim, ex);
            return this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
        }
        catch (AnexoRedeSimNaoEncontradoException arsnee) {
            this.logger.error((Object)arsnee.getMessage(), (Throwable)arsnee);
            this.facadeSolicitacaAlvara.salvarConsultaPrevia(this.consultaPrevia, Boolean.valueOf(true));
            solicitacaoRedeSim.setSolicitacaoAlvara(this.consultaPrevia);
            solicitacaoRedeSim.setSituacao(SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla());
            return this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
        }
        catch (EnderecoIncompletoException ex) {
            this.observacaoConsultaPrevia.append(ex.getMessage()).append("\n");
            this.facadeSolicitacaAlvara.salvarConsultaPrevia(this.consultaPrevia, Boolean.valueOf(true));
            solicitacaoRedeSim.setSolicitacaoAlvara(this.consultaPrevia);
            IndeferimentoRedeSimException irse = new IndeferimentoRedeSimException(MotivoIndeferimentoRedeSimEnum.ENDERECO_INCOMPLETO, ex.getMessage());
            this.verificarRespostaAutomatica(solicitacaoRedeSim, irse);
            return this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
        }
        catch (LogradouroNaoEncontradoException | TestadaNaoEncontradaException ex) {
            this.observacaoConsultaPrevia.append(ex.getMessage()).append("\n");
            this.facadeSolicitacaAlvara.salvarConsultaPrevia(this.consultaPrevia, Boolean.valueOf(true));
            solicitacaoRedeSim.setSolicitacaoAlvara(this.consultaPrevia);
            IndeferimentoRedeSimException irse = new IndeferimentoRedeSimException(MotivoIndeferimentoRedeSimEnum.ENDERECO_INCOMPATIVEL, ex.getMessage());
            this.verificarRespostaAutomatica(solicitacaoRedeSim, irse);
            return this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
        }
        catch (CadastroImobiliarioNaoEncontradoException | CadastroImobiliarioNaoInformadoException cine) {
            if (this.isImovelRural(consultaPreviaDTO.getDados_consulta_previa())) {
                this.observacaoConsultaPrevia.append(this.getParamImovelRuralIrregular()).append("\n");
            } else {
                this.observacaoConsultaPrevia.append(cine.getMessage()).append("\n");
            }
            this.facadeSolicitacaAlvara.salvarConsultaPrevia(this.consultaPrevia, Boolean.valueOf(true));
            solicitacaoRedeSim.setSolicitacaoAlvara(this.consultaPrevia);
            IndeferimentoRedeSimException irse = new IndeferimentoRedeSimException(MotivoIndeferimentoRedeSimEnum.CADASTRO_IMOBILIARIO_INVALIDO, cine.getMessage());
            this.verificarRespostaAutomatica(solicitacaoRedeSim, irse);
            return this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
        }
        catch (ConsultaPreviaRedeSimException e) {
            this.logger.info((Object)"Ocorreu um erro e a consulta est\u00e1 com a situa\u00e7\u00e3o em AN\u00c1LISE");
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            solicitacaoRedeSim.setSolicitacaoAlvara(this.consultaPrevia);
            solicitacaoRedeSim.setSituacao(SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla());
            this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
            throw new ConsultaPreviaRedeSimException((Throwable)e);
        }
        catch (DeferimentoRedeSimSigFacilException def) {
            this.logger.info((Object)("DeferimentoRedeSimSigFacilException: " + solicitacaoRedeSim.getProtocolo()));
            ConsultaRedeSimController consultaRedeSimController = (ConsultaRedeSimController)SpringContext.getBean(ConsultaRedeSimController.class);
            consultaRedeSimController.setConsultaRedeSimAtual(solicitacaoRedeSim);
            return consultaRedeSimController.saveDeferimentoConsulta();
        }
        catch (IndeferimentoRedeSimSigFacilException def) {
            this.logger.info((Object)("IndeferimentoRedeSimSigFacilException: " + solicitacaoRedeSim.getProtocolo()));
            ConsultaRedeSimController consultaRedeSimController = (ConsultaRedeSimController)SpringContext.getBean(ConsultaRedeSimController.class);
            consultaRedeSimController.setConsultaRedeSimAtual(solicitacaoRedeSim);
            return consultaRedeSimController.saveDeferimentoConsulta();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            this.facadeSolicitacaAlvara.salvarConsultaPrevia(this.consultaPrevia, Boolean.valueOf(true));
            solicitacaoRedeSim.setSolicitacaoAlvara(this.consultaPrevia);
            solicitacaoRedeSim.setSituacao(SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla());
            return this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
        }
    }

    private void montarObservacaoSolicitacaoAlvara(SolicitacaoRedeSimEntity solicitacaoRedeSim, SolicitacaoAlvaraEntity consultaPrevia) {
        try {
            boolean isObservacaoAtividadesDefereimentoGeo;
            ParametroAlvaraEntity parametroTipoDocumento = UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.TIPO_DOCUMENTO_OBSERVACAO);
            String observacaoAtividades = consultaPrevia.getObservacaoDasAtividades(Boolean.TRUE.booleanValue());
            boolean bl = isObservacaoAtividadesDefereimentoGeo = this.integradoGeo && consultaPrevia.isObservacaoAtividadesDeferimentoGeo();
            if (isObservacaoAtividadesDefereimentoGeo && !EloStringUtils.isEmpty((String)observacaoAtividades)) {
                this.obsSolicitacao.append(observacaoAtividades);
                this.obsSolicitacao.append(QUEBRA_LINHA);
                this.obsSolicitacao.append(QUEBRA_LINHA);
            }
            this.obsSolicitacao.append(UtilsController.getRestricaoCadastro((SolicitacaoAlvaraEntity)consultaPrevia));
            if (!StringUtils.isBlank((String)parametroTipoDocumento.getValor()) && StringUtils.isNumeric((String)parametroTipoDocumento.getValor())) {
                String linkObservacao = this.facadeRedeSim.generateDocumentoObservacao(Long.valueOf(parametroTipoDocumento.getValor()), solicitacaoRedeSim);
                this.obsSolicitacao.append(QUEBRA_LINHA);
                this.obsSolicitacao.append("<strong><a href= '" + linkObservacao + "' style='color: red'>Clique aqui para visualizar as observa\u00e7\u00f5es gerais</a></strong>");
                this.obsSolicitacao.append(QUEBRA_LINHA);
            } else {
                this.obsSolicitacao.append(UtilsController.montarObservacaoGeral());
            }
            if (!isObservacaoAtividadesDefereimentoGeo && !EloStringUtils.isEmpty((String)observacaoAtividades)) {
                this.obsSolicitacao.append(QUEBRA_LINHA);
                this.obsSolicitacao.append(observacaoAtividades);
                this.obsSolicitacao.append(QUEBRA_LINHA);
            }
            if (!EloStringUtils.isEmpty((String)consultaPrevia.getExigencias())) {
                this.obsSolicitacao.append("<br/> -Exig\u00eancia: <br/>");
                this.obsSolicitacao.append(consultaPrevia.getExigencias());
            }
            if (!EloStringUtils.isEmpty((String)solicitacaoRedeSim.getSolicitacaoAlvara().getProibicao())) {
                this.obsSolicitacao.append("<br/> -Proibi\u00e7\u00f5es: <br/>");
                this.obsSolicitacao.append(solicitacaoRedeSim.getSolicitacaoAlvara().getProibicao());
            }
            solicitacaoRedeSim.setObservacao(this.obsSolicitacao.toString());
        }
        catch (BaseException | ConsultaPreviaRedeSimException e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new ConsultaPreviaRedeSimException("Problema ao montar observa\u00e7\u00e3o da consulta.", e);
        }
    }

    private void preencherCadastroImobiliario(ConsultaPreviaDTO consultaPreviaDTO, SolicitacaoAlvaraEntity consultaPrevia) throws BaseException {
        String inscricaoCadastral = this.getNuInscricao(consultaPreviaDTO);
        if (SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.VALIDA_INSCRICAOMUNICIPAL_CONSULTAPREVIA)).booleanValue() && EloStringUtils.isEmpty((String)inscricaoCadastral)) {
            throw new CadastroImobiliarioNaoInformadoException("Inscri\u00e7\u00e3o Municipal n\u00e3o informada.");
        }
        Endereco endereco = consultaPreviaDTO.getDados_consulta_previa().getEndereco();
        if (SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.VALIDA_ENDERECO_CONSULTAPREVIA)).booleanValue() && Objects.nonNull(endereco) && (EloStringUtils.isEmpty((String)endereco.getDs_endereco()) || EloStringUtils.isEmpty((String)endereco.getDs_bairro()) || EloStringUtils.isEmpty((String)endereco.getDs_tipo_logradouro()) || EloStringUtils.isEmpty((String)endereco.getNu_numero()) || EloStringUtils.isEmpty((String)endereco.getCo_cep()))) {
            throw new EnderecoIncompletoException("As informa\u00e7\u00f5es de endere\u00e7o est\u00e3o incompletas.");
        }
        CadastroImobiliarioEntity cadastroImobiliario = this.carregaCadastroImobiliario(consultaPrevia, inscricaoCadastral);
        consultaPrevia.setCadastroImobiliario(cadastroImobiliario);
    }

    private SolicitacaoAlvaraEntity inicializarConsultaPrevia(ConsultaPreviaDTO consultaPreviaDTO, SolicitacaoRedeSimEntity solicitacaoRedeSim) throws BaseException {
        ConsultaPreviaVo consultaPreviaVo = this.getConsultaPreviaVo(consultaPreviaDTO, solicitacaoRedeSim);
        return this.facadeSolicitacaAlvara.iniciaConsultaPrevia(consultaPreviaVo);
    }

    private void preencherDadosImobiliarioTestada(ConsultaPreviaDTO consultaPreviaDTO, SolicitacaoAlvaraEntity consultaPrevia) throws BaseException {
        if (UtilsController.isTestadaGenerica()) {
            consultaPrevia.setImobiliarioTestadaGenerica(consultaPrevia.getCadastroImobiliario().getTestadaPrincipalGenerica());
        } else if (Objects.nonNull(consultaPrevia.getCadastroImobiliario())) {
            if (consultaPrevia.getCadastroImobiliario().getTestadas().size() > 1 && consultaPrevia.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA})) {
                String logradouroDesc = consultaPreviaDTO.getDados_consulta_previa().getEndereco().getDs_tipo_logradouro() + " " + consultaPreviaDTO.getDados_consulta_previa().getEndereco().getDs_endereco();
                LogradouroEntity logradouroLocalizado = this.srvFindEnderecoBySimilarity.findDescricaoLogradouroBySimilarity(logradouroDesc);
                if (Objects.isNull(logradouroLocalizado)) {
                    throw new LogradouroNaoEncontradoException(String.format("O logradouro '%s' n\u00e3o foi localizado na base de dados.", logradouroDesc));
                }
                for (CadastroImobiliarioTestadaEntity testada : consultaPrevia.getCadastroImobiliario().getTestadas()) {
                    if (!testada.getLogradouro().getId().getLogradouro().equals(logradouroLocalizado.getId().getLogradouro())) continue;
                    consultaPrevia.setImobiliarioTestada(testada);
                    break;
                }
                if (!UtilsController.isUtilizaEnderecoCadastroGeral() && Objects.isNull(consultaPrevia.getImobiliarioTestada())) {
                    throw new TestadaNaoEncontradaException("Testada n\u00e3o encontrada na base de dados.");
                }
            } else {
                consultaPrevia.setImobiliarioTestada(consultaPrevia.getCadastroImobiliario().getTestadaPrincipal());
            }
        }
        consultaPrevia.setAreaUtilizada(this.getValorNumerico(consultaPreviaDTO.getDados_consulta_previa().getEndereco().getNu_area_utilizada()));
        consultaPrevia.setAreaConstruida(this.getValorNumerico(consultaPreviaDTO.getDados_consulta_previa().getEndereco().getNu_area_total()));
    }

    private List<GrauRiscoPergunta> getPerguntasGrauRisco(ConsultaPreviaDTO consultaPreviaDTO) {
        ArrayList<GrauRiscoPergunta> perguntas = new ArrayList<GrauRiscoPergunta>();
        if (Objects.nonNull(consultaPreviaDTO.getDados_consulta_previa().getQuestionario())) {
            perguntas.addAll(consultaPreviaDTO.getDados_consulta_previa().getQuestionario().stream().map(GrauRiscoPergunta::of).collect(Collectors.toList()));
        }
        if (Objects.nonNull(consultaPreviaDTO.getDados_consulta_previa().getClassificacao_risco())) {
            perguntas.addAll(consultaPreviaDTO.getDados_consulta_previa().getClassificacao_risco().getPergunta_classificacao_risco().stream().map(GrauRiscoPergunta::of).collect(Collectors.toList()));
        }
        return perguntas;
    }

    private SolicitacaoAlvaraEntity preencherAtividadesDaSolicitacao(ConsultaPreviaDTO consultaPreviaDTO, SolicitacaoAlvaraEntity consultaPrevia) throws BaseException {
        if (!consultaPrevia.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.MUDANCA_AREA, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
            return consultaPrevia;
        }
        List listaConsultaAtividadeVo = this.getAtividade(consultaPreviaDTO, consultaPrevia);
        if (!this.isImovelRural(consultaPreviaDTO.getDados_consulta_previa())) {
            consultaPrevia = this.consultaCadastroImobiliario(consultaPrevia, Boolean.FALSE.booleanValue());
        }
        if (consultaPrevia.isSolicitacaoPrestadorServico() || consultaPrevia.isSolicitacaoMEIPrestador()) {
            this.processaAtividadesNaSolicitacaoAlvara(consultaPrevia, consultaPreviaDTO);
        } else {
            consultaPrevia = this.consultaAtividade(consultaPrevia, listaConsultaAtividadeVo, consultaPreviaDTO.getDados_consulta_previa().getAtividades(), this.getPerguntasGrauRisco(consultaPreviaDTO));
        }
        if (this.integradoGeo && !consultaPrevia.isSolicitacaoPrestadorServico()) {
            consultaPrevia = this.facadeSolicitacaAlvara.salvarConsultaPrevia(consultaPrevia, Boolean.valueOf(true));
        }
        return consultaPrevia;
    }

    public boolean todasAtividadesMeiPrestador(List<ConsultaAtividadeVo> listaConsultaAtividadeVo) throws BaseException {
        if (EloListUtils.safeIsEmpty(listaConsultaAtividadeVo).booleanValue()) {
            return false;
        }
        for (ConsultaAtividadeVo consultaAtividadeVo : listaConsultaAtividadeVo) {
            if (!this.cnaeNaoPermitidoParaMeiPrestador(consultaAtividadeVo.getCodigoAtividade())) continue;
            return false;
        }
        return true;
    }

    public boolean cnaeNaoPermitidoParaMeiPrestador(String codigoCnae) throws BaseException {
        return !((FacadeAlteracaoAtividades)SpringContext.getBean(FacadeAlteracaoAtividades.class)).isCnaePermitidoParaMeiPrestador(codigoCnae);
    }

    public void adicionarClassificacaoTipoInscricao(ConsultaPreviaDTO consultaPreviaDTO, SolicitacaoAlvaraEntity solicitacaoAlvara) throws SolicitacaoAlvaraRedeSimException {
        try {
            if (solicitacaoAlvara.getClassificacaoTipoInscricao() == null) {
                ClassificacaoTipoInscricaoEntity classificacaoTipoInscricao = new ClassificacaoTipoInscricaoEntity();
                classificacaoTipoInscricao.setIdSolicitacaoAlvara(solicitacaoAlvara);
                classificacaoTipoInscricao.setIdClassificacaoTipoInscricao(this.facadeTipoInscricao.getSequenceClassificacaoTipoInscricao());
                classificacaoTipoInscricao.setPontoReferencia(this.getPontoReferencia(consultaPreviaDTO.getDados_consulta_previa().getAtividades()));
                solicitacaoAlvara.setClassificacaoTipoInscricao(classificacaoTipoInscricao);
            }
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraRedeSimException("Falha ao carregar a classifica\u00e7\u00e3o tipo inscri\u00e7\u00e3o", e.getCause());
        }
    }

    private String getPontoReferencia(List<Atividades> atividades) throws BaseException {
        return this.facadeRedeSim.getPontoReferencia(atividades);
    }

    private Long getCep(ConsultaPreviaDTO consultaPreviaDTO) {
        return new Long(consultaPreviaDTO.getDados_consulta_previa().getEndereco().getCo_cep());
    }

    private boolean isImovelRural(DadosConsultaPrevia dadosConsultaPrevia) {
        return Optional.ofNullable(dadosConsultaPrevia).map(DadosConsultaPrevia::getEndereco).map(Endereco::getNatureza_imovel).map(Natureza_imovel::getCo_tipo_natureza).map(IMOVEL_RURAL::equals).orElse(false);
    }

    public String getNuInscricao(ConsultaPreviaDTO consultaPreviaDTO) {
        if (Objects.nonNull(consultaPreviaDTO.getDados_consulta_previa().getEndereco()) && Objects.nonNull(consultaPreviaDTO.getDados_consulta_previa().getEndereco().getNatureza_imovel()) && !EloStringUtils.isEmpty((String)consultaPreviaDTO.getDados_consulta_previa().getEndereco().getNatureza_imovel().getNu_inscricao())) {
            return consultaPreviaDTO.getDados_consulta_previa().getEndereco().getNatureza_imovel().getNu_inscricao();
        }
        return null;
    }

    private void verificarRespostaAutomatica(SolicitacaoRedeSimEntity solicitacaoRedeSim, IndeferimentoRedeSimException ex) throws BaseException {
        if (!this.isRespostaConsultaAutomatica()) {
            solicitacaoRedeSim.setIndeferido(SimNaoEnum.NAO.getShortText());
            solicitacaoRedeSim.setSituacao(SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla());
            this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
        } else {
            this.enviarSolicitacaoIndeferida(solicitacaoRedeSim, ex.getMotivo());
        }
    }

    private void enviarSolicitacaoIndeferida(SolicitacaoRedeSimEntity solicitacaoRedeSim, MotivoIndeferimentoRedeSimEnum motivo) throws BaseException {
        solicitacaoRedeSim.setIndeferido(SimNaoEnum.SIM.getShortText());
        solicitacaoRedeSim.setMotivoIndeferimento(this.observacaoConsultaPrevia.toString());
        ArrayList indeferimentos = Lists.newArrayList();
        indeferimentos.add(UtilsController.getIndeferimentoByCodigo((MotivoIndeferimentoRedeSimEnum)motivo));
        solicitacaoRedeSim.setIndeferimentos((List)indeferimentos);
        solicitacaoRedeSim.setSituacao(SituacaoConsultaPreviaRedeSimEnum.INDEFERIDO.getSigla());
        solicitacaoRedeSim.setUsuarioTramitacao("INTEGRASGO");
        solicitacaoRedeSim.setDataTramitacao(new Date());
        this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
        this.facadeRedeSim.respostaSolicitacaoRedeSim(solicitacaoRedeSim);
    }

    public BigDecimal getValorNumerico(String valor) {
        try {
            return !EloStringUtils.isEmpty((String)valor) ? new BigDecimal(valor) : BigDecimal.ZERO;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Erro ao converter valor para num\u00e9rico: %s", valor), e);
        }
    }

    public ConsultaPreviaVo getConsultaPreviaVo(ConsultaPreviaDTO consultaPreviaDTO, SolicitacaoRedeSimEntity solicitacaoRedeSim) throws ConsultaPreviaRedeSimException {
        ConsultaPreviaVo consultaPreviaVo = new ConsultaPreviaVo();
        try {
            List solicitacoesAlvara = this.facadeSolicitacaAlvara.buscaSolicitacaoAlvaraPorProtocoloRedeSim(consultaPreviaDTO.getDados_consulta_previa().getCo_protocolo_redesim(), Optional.of(TipoSolicitacaoRedeSimEnum.CONSULTA.getSigla()));
            SolicitacaoAlvaraEntity solicitacaoAlvara = solicitacoesAlvara.stream().max(Comparator.comparing(SolicitacaoAlvaraEntity::getSolicitacaoAlvara)).orElse(new SolicitacaoAlvaraEntity());
            consultaPreviaVo.setTipoRequerente(TIPOREQUERENTE);
            consultaPreviaVo.setNaturezas(this.getNaturezaEventoConsulta(consultaPreviaDTO.getDados_consulta_previa().getEventos()));
            solicitacaoAlvara.setNaturezas(consultaPreviaVo.getNaturezas());
            solicitacaoAlvara.setProtocoloRedeSim(solicitacaoRedeSim.getProtocolo());
            solicitacaoAlvara.setEfetivado(SimNaoEnum.NAO.getShortText());
            solicitacaoAlvara.setExercicio(this.getExercicioAtual());
            solicitacaoAlvara.setCpfCnpjConsulta(consultaPreviaDTO.getDados_consulta_previa().getSolicitante().getNu_cpf());
            solicitacaoAlvara.setDescricaoAtividades(consultaPreviaDTO.getDados_consulta_previa().getDs_objeto_social());
            if (!solicitacaoAlvara.isNaturezaInicial()) {
                if (consultaPreviaDTO.getDados_consulta_previa().getNu_cnpj().length() == 13) {
                    String cnpj = "0".concat(consultaPreviaDTO.getDados_consulta_previa().getNu_cnpj());
                    consultaPreviaDTO.getDados_consulta_previa().setNu_cnpj(cnpj);
                }
                consultaPreviaVo.setCpfCnpj(consultaPreviaDTO.getDados_consulta_previa().getNu_cnpj());
            }
            consultaPreviaVo.setSolicitacaoAlvara(solicitacaoAlvara);
        }
        catch (Exception e) {
            throw new ConsultaPreviaRedeSimException("Problema ao iniciar solicita\u00e7\u00e3o de alvar\u00e1", (Throwable)e);
        }
        return consultaPreviaVo;
    }

    private boolean isRespostaConsultaAutomatica() throws BaseException {
        String valorParam = UtilsController.getParametro((ParametroAlvaraEnum)ParametroAlvaraEnum.RESPOSTA_AUTOMATICA_DE_INDEFERIMENTO_CONSULTA).getValor();
        if (EloStringUtils.isEmpty((String)valorParam) || SimNaoEnum.equalNao((String)valorParam).booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private SolicitacaoRedeSimEntity getSolicitacaoRedeSim(ConsultaPreviaDTO consultaPreviaDTO) throws BaseException {
        SolicitacaoRedeSimEntity solicitacaoRedeSim = this.facadeRedeSim.getConsultaRedeSim(consultaPreviaDTO.getDados_consulta_previa().getCo_protocolo_redesim(), TipoSolicitacaoRedeSimEnum.CONSULTA);
        if (solicitacaoRedeSim == null) {
            solicitacaoRedeSim = new SolicitacaoRedeSimEntity();
            solicitacaoRedeSim.setSituacao(SituacaoConsultaPreviaRedeSimEnum.ANALISE.getSigla());
            solicitacaoRedeSim.setArquivoConsulta(new Gson().toJson((Object)consultaPreviaDTO));
            solicitacaoRedeSim.setTipo(TipoSolicitacaoRedeSimEnum.CONSULTA.getSigla());
            solicitacaoRedeSim.setProtocolo(consultaPreviaDTO.getDados_consulta_previa().getCo_protocolo_redesim());
            solicitacaoRedeSim.setCpfSolicitante((String)Optional.ofNullable(consultaPreviaDTO.getDados_consulta_previa()).map(DadosConsultaPrevia::getSolicitante).map(Solicitante::getNu_cpf).orElse(null));
            solicitacaoRedeSim.setCnpjEmpresa((String)Optional.ofNullable(consultaPreviaDTO.getDados_consulta_previa()).map(DadosConsultaPrevia::getNu_cnpj).orElse(null));
            solicitacaoRedeSim.setEventos(this.getEventos(consultaPreviaDTO));
            solicitacaoRedeSim.setDataSolicitacao(new Date());
            solicitacaoRedeSim.setResposta(SimNaoEnum.NAO.getShortText());
            solicitacaoRedeSim.setIndeferido(SimNaoEnum.NAO.getShortText());
        }
        return this.facadeRedeSim.salvarSolicitacaoRedeSim(solicitacaoRedeSim);
    }

    public boolean validarAlteracaoAlvaraTipoInscricaoCadastroMobiliario(SolicitacaoAlvaraEntity solicitacaoAlvaraEntity, TipoInscricaoAlvaraEntity tipoInscricao) throws BaseException {
        for (NaturezaSolicitacaoAlvaraEntity naturezaSolicitacao : solicitacaoAlvaraEntity.getNaturezas()) {
            if (((FacadeNaturezaSolicitacaoTipoInscricao)SpringContext.getBean(FacadeNaturezaSolicitacaoTipoInscricao.class)).isNaturezaSolicitacaoTipoInscricaoAtiva(naturezaSolicitacao.getCodigo(), tipoInscricao)) continue;
            return false;
        }
        return true;
    }

    public SolicitacaoAlvaraEntity carregaDadosCadastroNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        return ((FacadeSolicitacaoAlvara)SpringContext.getBean(FacadeSolicitacaoAlvara.class)).carregaDadosCadastroNaSolicitacao(solicitacao);
    }

    public List<ConsultaAtividadeVo> getAtividade(ConsultaPreviaDTO consultaPreviaDTO, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        ArrayList listaConsultaVo = Lists.newArrayList();
        for (Atividades atividadeItem : consultaPreviaDTO.getDados_consulta_previa().getAtividades()) {
            if (solicitacao.isSolicitacaoMEI()) {
                listaConsultaVo.addAll(this.getAtividadeMei(solicitacao, atividadeItem));
                continue;
            }
            ConsultaAtividadeVo consultaAtividadeVo = new ConsultaAtividadeVo();
            consultaAtividadeVo.setSolicitacaoAlvara(solicitacao);
            consultaAtividadeVo.setCodigoAtividade(atividadeItem.getCo_cnae().replaceAll(REGEX_FIND_NAO_DIGITOS, ""));
            consultaAtividadeVo.setAtividadeSelecionada(this.facadeAlteracaoAtividades.consultaAtividadePorCodigo(consultaAtividadeVo));
            consultaAtividadeVo.getAtividadeSelecionada().setSituacao("I");
            if (atividadeItem.isIs_atividade_principal()) {
                consultaAtividadeVo.getAtividadeSelecionada().setPrincipal(SimNaoEnum.SIM.getShortText());
            } else {
                consultaAtividadeVo.getAtividadeSelecionada().setPrincipal(SimNaoEnum.NAO.getShortText());
            }
            listaConsultaVo.add(consultaAtividadeVo);
        }
        boolean somenteEscritorio = consultaPreviaDTO.getDados_consulta_previa().getTipo_unidade().stream().anyMatch(tipoUnidade -> tipoUnidade.getCo_tipo_unidade() == TipoDeUnidadeEnum.ESCRITORIO_ADM.getCodigo());
        listaConsultaVo.forEach(atividade -> atividade.setOpcaoSomenteEscritorio(somenteEscritorio));
        return listaConsultaVo;
    }

    private List<ConsultaAtividadeVo> getAtividadeMei(SolicitacaoAlvaraEntity solicitacao, Atividades atividadeItem) throws BaseException {
        String codigoCnae = EloStringUtils.somenteNumeros((String)atividadeItem.getCo_cnae());
        ArrayList listaConsultaVo = Lists.newArrayList();
        List atividadesMei = this.facadeAlteracaoAtividades.consultaAtividadeMeiPorCnae(codigoCnae, SimNaoEnum.getNaoShortText());
        for (Atividade atividade : atividadesMei) {
            ConsultaAtividadeVo consultaAtividadeVo = new ConsultaAtividadeVo();
            consultaAtividadeVo.setSolicitacaoAlvara(solicitacao);
            consultaAtividadeVo.setCodigoAtividade(atividade.getCodigo());
            consultaAtividadeVo.setAtividadeSelecionada(atividade);
            consultaAtividadeVo.getAtividadeSelecionada().setSituacao("I");
            if (atividadeItem.isIs_atividade_principal()) {
                consultaAtividadeVo.getAtividadeSelecionada().setPrincipal(SimNaoEnum.SIM.getShortText());
            } else {
                consultaAtividadeVo.getAtividadeSelecionada().setPrincipal(SimNaoEnum.NAO.getShortText());
            }
            listaConsultaVo.add(consultaAtividadeVo);
        }
        return listaConsultaVo;
    }

    public List<NaturezaSolicitacaoAlvaraEntity> getNaturezaEventoSolicitacao(DadosSolicitacao dadosSolicitacao) throws BaseException {
        ArrayList naturezas = Lists.newArrayList();
        List eventosRedeSim = this.facadeRedeSim.getEventoRedeSim(dadosSolicitacao.getEventos_redesim());
        boolean mudancaParaForaDoMunicipio = eventosRedeSim.stream().anyMatch(evento -> {
            try {
                return !this.verificaEventoMudancaEnderecoParaMunicipioDaEntidade(evento, dadosSolicitacao);
            }
            catch (SolicitacaoAlvaraRedeSimException e) {
                throw new RuntimeException(e);
            }
        });
        if (mudancaParaForaDoMunicipio) {
            return new ArrayList<NaturezaSolicitacaoAlvaraEntity>();
        }
        if (!EloListUtils.safeIsEmpty((List)eventosRedeSim).booleanValue()) {
            for (EventoRedeSimEntity evento2 : eventosRedeSim) {
                if (EloStringUtils.isEmpty((String)evento2.getSigla()) || EloStringUtils.isEmpty((String)evento2.getSigla()) || this.isEventoJaAdicionado((List)naturezas, evento2)) continue;
                naturezas.add(this.facadeSolicitacaAlvara.getNatureza(evento2.getSigla()));
            }
        }
        return naturezas;
    }

    public List<NaturezaSolicitacaoAlvaraEntity> getNaturezaEventoConsulta(List<Evento> eventos) throws BaseException {
        ArrayList naturezas = Lists.newArrayList();
        List eventosRedeSim = this.facadeRedeSim.getEventoRedeSim(eventos);
        if (!EloListUtils.safeIsEmpty((List)eventosRedeSim).booleanValue()) {
            for (EventoRedeSimEntity evento : eventosRedeSim) {
                if (EloStringUtils.isEmpty((String)evento.getSigla()) || this.isEventoJaAdicionado((List)naturezas, evento)) continue;
                naturezas.add(this.facadeSolicitacaAlvara.getNatureza(evento.getSigla()));
            }
        }
        return naturezas;
    }

    public boolean isMudancaEnderecoParaMunicipioDaEntidade(DadosSolicitacao dadosSolicitacao) throws BaseException {
        Long codigoIbgeEntidade = this.facadeEntidade.buscarEntidadePrincipal().getLogradouro().getId().getCidade().getCodigoIBGE();
        String codigoIbgeSemDigitoVerificador = EloStringUtils.pad((String)codigoIbgeEntidade.toString(), (PadOption)PadOption.RIGHT, (int)(codigoIbgeEntidade.toString().length() - 1));
        String codIbge = String.valueOf(dadosSolicitacao.getEmpresa().getEndereco().getCo_municipio());
        return codIbge.equalsIgnoreCase(codigoIbgeSemDigitoVerificador);
    }

    private boolean verificaEventoMudancaEnderecoParaMunicipioDaEntidade(EventoRedeSimEntity evento, DadosSolicitacao dadosSolicitacao) throws SolicitacaoAlvaraRedeSimException {
        try {
            if (Arrays.asList(RedeSimEventoEnum.EVENTO_209.getCodigo(), RedeSimEventoEnum.EVENTO_210.getCodigo()).contains(evento.getEvento())) {
                return this.isMudancaEnderecoParaMunicipioDaEntidade(dadosSolicitacao);
            }
        }
        catch (BaseException e) {
            throw new SolicitacaoAlvaraRedeSimException("Falha ao carregar o c\u00f3digo do Ibge da Entidade");
        }
        return Boolean.TRUE;
    }

    private boolean isEventoJaAdicionado(List<NaturezaSolicitacaoAlvaraEntity> naturezas, EventoRedeSimEntity evento) throws BaseException {
        if (!EloListUtils.safeIsEmpty(naturezas).booleanValue()) {
            for (NaturezaSolicitacaoAlvaraEntity natureza : naturezas) {
                boolean jaAdicionado = this.facadeSolicitacaAlvara.getNatureza(evento.getSigla()).getCodigo().equals(natureza.getCodigo());
                if (!jaAdicionado) continue;
                return true;
            }
        }
        return false;
    }

    public CadastroImobiliarioEntity carregaCadastroImobiliario(SolicitacaoAlvaraEntity solicitacao, String codigoImobiliario) throws BaseException {
        if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.INICIAL, NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.ALTERACAO_ATIVIDADE})) {
            CadastroImobiliarioEntity cadastros = this.getCadastroImobiliarioEntityByCodigoImobiliario(codigoImobiliario);
            if (Objects.nonNull(cadastros)) {
                return cadastros;
            }
            throw new CadastroImobiliarioNaoEncontradoException("Cadastro Imobili\u00e1rio n\u00e3o encontrado ou n\u00e3o informado.");
        }
        return null;
    }

    private CadastroImobiliarioEntity getCadastroImobiliarioEntityByCodigoImobiliario(String codigoImobiliario) throws BaseException {
        if (EloStringUtils.isEmpty((String)codigoImobiliario) || !StringUtils.isNumeric((String)codigoImobiliario)) {
            return null;
        }
        List cadastros = this.facadeCadastroImobiliario.getCadastroImobiliarioPorCodigoOuInscricaoCadastral(codigoImobiliario);
        if (EloListUtils.safeIsEmpty((List)cadastros).booleanValue()) {
            throw new CadastroImobiliarioNaoEncontradoException("Cadastro Imobili\u00e1rio n\u00e3o encontrado ou n\u00e3o informado.");
        }
        if (cadastros.size() > 1) {
            throw new CadastroImobiliarioNaoEncontradoException("Existem 2 (dois) ou mais registros para o n\u00famero informado, favor refazer a consulta informando o cadastro imobili\u00e1rio correto.");
        }
        return (CadastroImobiliarioEntity)cadastros.stream().findFirst().get();
    }

    private boolean existeRestricaoIsencao(CadastroImobiliarioEntity cadastroImobiliario) throws BaseException {
        boolean temRestricao = this.facadeCadastroImobiliario.verificaRestricaoIsencaoImobiliario(cadastroImobiliario);
        if (temRestricao) {
            this.indeferir(MotivoIndeferimentoRedeSimEnum.CADASTRO_IMOBILIARIO_INVALIDO, "Cadastro Imobili\u00e1rio Selecionado N\u00e3o \u00e9  V\u00e1lido para Solicita\u00e7\u00e3o de Alvar\u00e1! ");
        }
        return temRestricao;
    }

    private void indeferir(MotivoIndeferimentoRedeSimEnum motivo, String observacao) throws BaseException {
        if (!EloStringUtils.isEmpty((String)observacao)) {
            this.observacaoConsultaPrevia.append(observacao).append("\n");
        }
        throw new IndeferimentoRedeSimException(motivo, observacao);
    }

    public SolicitacaoAlvaraEntity consultaCadastroImobiliario(SolicitacaoAlvaraEntity solicitacao, boolean deferimentoManual) throws BaseException {
        if (!UtilsController.isIntegracaoSimplificadaRedeSim()) {
            if (solicitacao.possuiUmaDasNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.MUDANCA_ENDERECO, NaturezaSolicitacaoAlvaraEnum.INICIAL})) {
                this.existeRestricaoIsencao(solicitacao.getCadastroImobiliario());
            }
            if (!(this.integradoGeo || this.isEixoOuZonaPreenchido(solicitacao) || deferimentoManual)) {
                throw new CadastroImobiliarioException("N\u00e3o existe a configura\u00e7\u00e3o de eixo ou zoneamento na testada do cadastro imobili\u00e1rio!");
            }
        }
        return solicitacao;
    }

    private boolean isEixoOuZonaPreenchido(SolicitacaoAlvaraEntity solicitacao) {
        return solicitacao.isPossuiEixoNaTestada() || solicitacao.isPossuiZoneamentoNaTestada();
    }

    private void preencheGrauRiscoQuestionario(List<Atividades> atividades, List<GrauRiscoPergunta> perguntas) throws BaseException {
        ScriptAlvaraEntity scriptGrauRiscoQuestionario = ((FacadeScriptAlvara)SpringContext.getBean(FacadeScriptAlvara.class)).findByTipo(TipoScriptAlvaraEnum.GRAU_RISCO_QUESTIONARIO);
        if (Objects.nonNull(scriptGrauRiscoQuestionario)) {
            SHELL.getContext().setVariable("scriptGrauRisco", (Object)SHELL.parse(scriptGrauRiscoQuestionario.getCodigoFonte()));
            SHELL.getContext().setVariable("atividades", atividades);
            SHELL.getContext().setVariable("perguntas", perguntas);
            SHELL.evaluate("scriptGrauRisco.verifyGrauRisco(atividades, perguntas)");
        }
    }

    private void preencheGrauRiscoAtividades(List<Atividades> atividades) throws BaseException {
        List codigosCnaes = atividades.stream().map(atividade -> atividade.getCo_cnae().replaceAll(REGEX_FIND_NAO_DIGITOS, "")).collect(Collectors.toList());
        List cnaes = this.facadeAtividadeCnae.carregarCnaesPorCodigoCnae(codigosCnaes);
        atividades.forEach(atividade -> cnaes.stream().filter(cnae -> cnae.getCodigo().equalsIgnoreCase(atividade.getCo_cnae().replaceAll(REGEX_FIND_NAO_DIGITOS, ""))).findFirst().ifPresent(cnae -> atividade.setGrauRisco(cnae.getGrauRisco())));
    }

    private String getGrauRiscoFromAtividades(List<Atividades> atividades) {
        return atividades.stream().map(Atividades::getGrauRisco).map(GrauDeRiscoEnum::fromString).filter(Objects::nonNull).min(Comparator.comparing(GrauDeRiscoEnum::getIndice)).orElse(GrauDeRiscoEnum.RISCO_LIBERDADE_ECONOMICA).getSigla();
    }

    public SolicitacaoAlvaraEntity consultaAtividade(SolicitacaoAlvaraEntity solicitacao, List<ConsultaAtividadeVo> listaConsultaAtividadeVo, List<Atividades> atividades, List<GrauRiscoPergunta> perguntas) throws BaseException {
        try {
            Integer codTaxa = null;
            ArrayList listaAtividade = new ArrayList();
            ArrayList<RetornoConsultaAtividade> listaRetornoConsultaAtividade = new ArrayList<RetornoConsultaAtividade>();
            ArrayList listaProibicao = new ArrayList();
            for (ConsultaAtividadeVo consultaAtividadeVo : listaConsultaAtividadeVo) {
                consultaAtividadeVo.setSolicitacaoAlvara(solicitacao);
                RetornaAtividadeResponse resposta = this.facadeAlteracaoAtividades.consultarAtividade(consultaAtividadeVo);
                if (Objects.nonNull(resposta)) {
                    Integer respostaTaxa = resposta.getRetornoConsultaAtividade().getAtividade().getCodigoDeTaxa();
                    listaRetornoConsultaAtividade.add(resposta.getRetornoConsultaAtividade());
                    if (codTaxa == null) {
                        codTaxa = respostaTaxa;
                    } else if (respostaTaxa > codTaxa) {
                        codTaxa = respostaTaxa;
                    }
                    this.validaRespostaGeo(resposta);
                    this.preencherProibicoesSolicitacao(solicitacao, resposta, listaProibicao);
                }
                listaAtividade.addAll(consultaAtividadeVo.getListaAtiv());
            }
            if (!listaProibicao.isEmpty()) {
                solicitacao.setProibicao(String.join((CharSequence)QUEBRA_LINHA, listaProibicao));
            }
            solicitacao.setTaxaLocalizacao(codTaxa);
            if (EloListUtils.safeIsEmpty((List)solicitacao.getSolicitacaoAlvaraAtividades()).booleanValue()) {
                solicitacao.setSolicitacaoAlvaraAtividades(this.facadeAlteracaoAtividades.atribuiValoresSolicitacaoAtividade(solicitacao, listaAtividade));
            }
            solicitacao.setExigencias(this.srvVerificaExigenciaCnae.verificaExigenciasNovoGeo(listaRetornoConsultaAtividade));
            if (SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GRAURISCO_INTEGRACAO)).booleanValue()) {
                this.preencheGrauRiscoAtividades(atividades);
                this.preencheGrauRiscoQuestionario(atividades, perguntas);
                solicitacao.setGrauRisco(this.getGrauRiscoFromAtividades(atividades));
            } else {
                solicitacao.atribuirGrauRisco(listaAtividade);
            }
        }
        catch (AtividadeNaoConfiguradaException ae) {
            throw new AtividadeNaoConfiguradaException(ae.getMessage(), ae.getCause());
        }
        catch (AtividadeNaoPermitidaException anpe) {
            throw new AtividadeNaoPermitidaException(anpe.getMessage());
        }
        catch (ConfiguracaoTestadaException cte) {
            throw new ConfiguracaoTestadaException(cte.getMessage());
        }
        catch (BaseException e) {
            throw new SolicitacaoInconsistenteException(e.getMessage());
        }
        return solicitacao;
    }

    private void preencherProibicoesSolicitacao(SolicitacaoAlvaraEntity solicitacao, RetornaAtividadeResponse resposta, List<String> listaProibicao) {
        Optional.ofNullable(resposta.getRetornoConsultaAtividade().getDecisao()).map(DecisaoGeo::getObservacao).filter(Objects::nonNull).map(ObservacaoGeo::getDescricao).filter(descricao -> !EloStringUtils.isEmpty((String)descricao)).filter(descricao -> listaProibicao.stream().noneMatch(descricao::equalsIgnoreCase)).ifPresent(listaProibicao::add);
        Optional.ofNullable(resposta.getRetornoConsultaAtividade().getMotivosProibicao()).filter(motivos -> !EloStringUtils.isEmpty((String)motivos)).filter(motivos -> listaProibicao.stream().noneMatch(motivos::equalsIgnoreCase)).ifPresent(listaProibicao::add);
    }

    private void validaRespostaGeo(RetornaAtividadeResponse resposta) throws BaseException {
        if (!resposta.getRetornoConsultaAtividade().isAtividadePermitida()) {
            this.indeferir(MotivoIndeferimentoRedeSimEnum.ATIVIDADE_NAO_PERMITIDA, resposta.getRetornoConsultaAtividade().getMotivosProibicao());
        }
    }

    private Long getExercicioAtual() throws BaseException {
        return this.facadeEntidade.getEntidade().getId().getExercicioTributacao().getExercicio();
    }

    protected List<EventoRedeSimEntity> getEventos(ConsultaPreviaDTO consultaPreviaDTO) throws ConsultaPreviaRedeSimException {
        List eventos = Lists.newArrayList();
        try {
            eventos = this.facadeRedeSim.getEventoRedeSim(consultaPreviaDTO.getDados_consulta_previa().getEventos());
        }
        catch (BaseException e) {
            throw new ConsultaPreviaRedeSimException("Ocorreu uma falha ao carregar os eventos.");
        }
        return eventos;
    }

    private boolean integradoGeo() throws BaseException {
        return this.facadeEntidade.verificaIntegradoGeo();
    }

    private String getParamImovelRuralIrregular() throws BaseException {
        return UtilsController.getParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.MSG_INDEFERIMENTO_IMOVEL_RURAL).getValor();
    }

    public boolean existeConsultaOuSolicitacaoComProtocolo(String protocolo, TipoSolicitacaoRedeSimEnum tipo) throws BaseException {
        FiltroConsultaRedeSim filtro = new FiltroConsultaRedeSim.FiltroConsultaRedeSimBuilder().build();
        filtro.setTipo(tipo.getSigla());
        filtro.setProtocolo(protocolo);
        List consultasOuSolicitacoes = this.facadeRedeSim.carregarListaConsultaRedesim(filtro);
        return EloListUtils.safeIsEmpty((List)consultasOuSolicitacoes) == false;
    }

    public void processaAtividadesNaSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara, ConsultaPreviaDTO consultaPreviaDTO) throws BaseException {
        List listaAtividade = this.facadeRedeSim.preencherSolcitacaoAlvaraAtividades(solicitacaoAlvara, consultaPreviaDTO.getDados_consulta_previa().getAtividades());
        if (SimNaoEnum.equalSim((String)UtilsController.getValorParametroAlvara((ParametroAlvaraEnum)ParametroAlvaraEnum.GRAURISCO_INTEGRACAO)).booleanValue() && !solicitacaoAlvara.isGrauRiscoAlto()) {
            List perguntas = this.getPerguntasGrauRisco(consultaPreviaDTO);
            this.preencheGrauRiscoAtividades(consultaPreviaDTO.getDados_consulta_previa().getAtividades());
            this.preencheGrauRiscoQuestionario(consultaPreviaDTO.getDados_consulta_previa().getAtividades(), perguntas);
            solicitacaoAlvara.setGrauRisco(this.getGrauRiscoFromAtividades(consultaPreviaDTO.getDados_consulta_previa().getAtividades()));
        } else {
            solicitacaoAlvara.atribuirGrauRisco(listaAtividade);
        }
    }

    public void setRepositoryEntidadeTributacao(RepositoryEntidadeTributacao repositoryEntidadeTributacao) {
        this.repositoryEntidadeTributacao = repositoryEntidadeTributacao;
    }

    public void setSrvDebitosPortal(SrvDebitosPortal srvDebitosPortal) {
        this.srvDebitosPortal = srvDebitosPortal;
    }

    public void setRepositoryDocumentoAise(RepositoryDocumentoAise repositoryDocumentoAise) {
        this.repositoryDocumentoAise = repositoryDocumentoAise;
    }

    public void setImprimeDocumentoAlvara(ImprimeDocumentoAlvara imprimeDocumentoAlvara) {
        this.imprimeDocumentoAlvara = imprimeDocumentoAlvara;
    }

    public void setFacadeCadastroImobiliario(FacadeCadastroImobiliario facadeCadastroImobiliario) {
        this.facadeCadastroImobiliario = facadeCadastroImobiliario;
    }

    public void setFacadeAtividadeCnae(FacadeAtividadeCnae facadeAtividadeCnae) {
        this.facadeAtividadeCnae = facadeAtividadeCnae;
    }

    public void setFacadeTipoInscricao(FacadeTipoInscricao facadeTipoInscricao) {
        this.facadeTipoInscricao = facadeTipoInscricao;
    }

    public void setSrvVerificaExigenciaCnae(SrvVerificaExigenciaCnae srvVerificaExigenciaCnae) {
        this.srvVerificaExigenciaCnae = srvVerificaExigenciaCnae;
    }
}

