/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.gerador;

import br.com.elotech.portalarrecadacao.gerador.GeraMigracaoAtividadeMei;
import br.com.elotech.util.string.EloStringUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeraMigracaoAtividadeMei {
    private static final Logger logger = LoggerFactory.getLogger(GeraMigracaoAtividadeMei.class);
    private static final String JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private static final String URL_CONNECTION = "jdbc:oracle:thin:@192.168.1.251:1521:oraculo";
    private static final String DB_USER = "TRIBUTOS";
    private static final String DB_PASS = "ELOTRIBUTO";
    private static List<String> listaNaoEncontrados;
    private static List<AtividadeMei> listaMei;

    public static void main(String[] args) {
        try {
            listaNaoEncontrados = new ArrayList();
            listaMei = new ArrayList();
            System.out.println("** Estabelecendo conex\u00e3o...");
            Connection connection = GeraMigracaoAtividadeMei.createConnection();
            Statement statement = connection.createStatement();
            System.out.println("** Conectado ao Banco de Dados!");
            System.out.println("++ iniciando carregamento do arquivo...");
            String arquivoPlanilha = "src/main/java/br/com/elotech/portalarrecadacao/gerador/atividadesmei.xlsx";
            FileInputStream inp = new FileInputStream(arquivoPlanilha);
            Workbook planilha = WorkbookFactory.create((InputStream)inp);
            System.out.println("++ iniciando leitura da planilha...");
            Sheet sheet = planilha.getSheetAt(0);
            System.out.println("-=-=-=- " + sheet.getLastRowNum() + " registro(s) encontrado(s) na planilha! -=-=-=-");
            System.out.println("++ iniciando atualiza\u00e7\u00e3o dos dados...");
            listaMei = GeraMigracaoAtividadeMei.getAtividadeMei((Statement)statement);
            for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
                Row linha = sheet.getRow(i);
                long codigoAtividadeMei = GeraMigracaoAtividadeMei.getCodigoAtividadeParaUpdate((Row)linha);
                if (codigoAtividadeMei <= 0L) continue;
                GeraMigracaoAtividadeMei.atualizaAtividadeMei((Statement)statement, (Row)linha, (long)codigoAtividadeMei);
            }
            connection.close();
            System.out.println("** Desconectado!");
            System.out.println("-=-=-=-=-=- " + listaNaoEncontrados.size() + " problema(s) encontrado(s) -=-=-=-=-=-");
            GeraMigracaoAtividadeMei.imprimirListaNaoEncontrados();
        }
        catch (ClassNotFoundException | SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            System.out.println("Arquivo n\u00e3o encontrado");
        }
        catch (InvalidFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            System.out.println("Arquivo com formato inv\u00e1lido");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static long getCodigoAtividadeParaUpdate(Row linha) {
        String ocupacao = linha != null && linha.getCell(0) != null ? linha.getCell(0).getStringCellValue() : "";
        String cnae = linha != null && linha.getCell(1) != null ? linha.getCell(1).getStringCellValue() : "";
        String cnaeFormatado = cnae.replaceAll("/", "").replaceAll("-", "").replaceAll("\u2013", "").replaceAll(" ", "").replaceAll("\r", "").replaceAll("\t", "").replaceAll("\n", "");
        for (AtividadeMei atividadeMei : listaMei) {
            String ocupacaoMeiFormatado;
            String ocupacaoFormatado;
            if (!cnaeFormatado.equals(String.valueOf(atividadeMei.codigoCnae)) || !(ocupacaoFormatado = EloStringUtils.retiraAcentos((String)ocupacao).replaceAll(Pattern.quote("(A)"), "").replaceAll(" ", "").replaceAll("-", "").replaceAll("\u2013", "").replaceAll("[\"']", "")).equalsIgnoreCase(ocupacaoMeiFormatado = EloStringUtils.retiraAcentos((String)atividadeMei.ocupacao).replaceAll(Pattern.quote("(A)"), "").replaceAll(" ", "").replaceAll("-", "").replaceAll("\u2013", "").replaceAll("[\"']", ""))) continue;
            return atividadeMei.codigo;
        }
        listaNaoEncontrados.add("Nao encontrou CNAE = " + cnaeFormatado + " e Ocupa\u00e7\u00e3o = " + ocupacao);
        return 0L;
    }

    public static Connection createConnection() throws ClassNotFoundException, SQLException {
        Class.forName("oracle.jdbc.driver.OracleDriver");
        return DriverManager.getConnection("jdbc:oracle:thin:@192.168.1.251:1521:oraculo", "TRIBUTOS", "ELOTRIBUTO");
    }

    public static List<AtividadeMei> getAtividadeMei(Statement statement) throws SQLException {
        GeraMigracaoAtividadeMei m = new GeraMigracaoAtividadeMei();
        String sql = "SELECT am.atividadeMei, c.codigo, am.ocupacao FROM TRIBATIVIDADEMEI am inner join CNAE c on am.CNAE = c.cnae ";
        ResultSet resultSet = statement.executeQuery(sql);
        ArrayList<AtividadeMei> listaAtividadeMei = new ArrayList<AtividadeMei>();
        while (resultSet.next()) {
            GeraMigracaoAtividadeMei geraMigracaoAtividadeMei = m;
            geraMigracaoAtividadeMei.getClass();
            AtividadeMei at = new AtividadeMei(geraMigracaoAtividadeMei, null);
            at.codigo = resultSet.getLong(1);
            at.codigoCnae = resultSet.getString(2);
            at.ocupacao = resultSet.getString(3);
            listaAtividadeMei.add(at);
        }
        return listaAtividadeMei;
    }

    public static void atualizaAtividadeMei(Statement statement, Row linha, long codigoAtividadeMei) {
        String ocupacao = linha != null && linha.getCell(0) != null ? linha.getCell(0).getStringCellValue() : "";
        String cnae = linha != null && linha.getCell(1) != null ? linha.getCell(1).getStringCellValue() : "";
        String iss = linha != null && linha.getCell(3) != null ? linha.getCell(3).getStringCellValue() : "";
        String icms = linha != null && linha.getCell(4) != null ? linha.getCell(4).getStringCellValue() : "";
        String classificacao = linha != null && linha.getCell(5) != null ? linha.getCell(5).getStringCellValue() : "";
        String cnaeFormatado = cnae.replaceAll("/", "").replaceAll("-", "").replaceAll("\u2013", "").replaceAll(" ", "").replaceAll("\r", "").replaceAll("\t", "").replaceAll("\n", "");
        String sql = "update TRIBATIVIDADEMEI set ISS = '" + iss.trim().toUpperCase() + "', ICMS = '" + icms.trim().toUpperCase() + "', CLASSIFICACAO = '" + classificacao.trim().toUpperCase() + "' where atividademei = " + codigoAtividadeMei;
        try {
            statement.execute(sql);
            System.out.println("Alterado com sucesso: C\u00f3digo do CNAE = " + cnaeFormatado + " e Ocupa\u00e7\u00e3o = " + ocupacao.toUpperCase());
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void imprimirListaNaoEncontrados() {
        for (String string : listaNaoEncontrados) {
            System.out.println(string);
        }
    }
}

