/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.gerador;

import br.com.elotech.portalarrecadacao.gerador.AtualizaZoneamentoNoCadastroImobiliario;
import br.com.elotech.spring.SpringContext;
import br.com.elotech.tributacao.domain.aise.ZoneamentoEntity;
import br.com.elotech.util.list.EloListUtils;
import br.com.elotech.util.string.EloStringUtils;
import br.com.elotech.util.string.PadOption;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AtualizaZoneamentoNoCadastroImobiliario {
    private static final String URL_CONNECTION = "jdbc:oracle:thin:@192.168.1.251:1521:oraculo";
    private static final String DB_USER = "UMUTRIBUTOS";
    private static final String DB_PASS = "UMUTRIBUTOS";
    private static final Logger logger = LoggerFactory.getLogger(AtualizaZoneamentoNoCadastroImobiliario.class);
    private static List<CadastroImobiliario> listaCadastroImobiliario;
    private static List<String> listaInsconcistencias;
    private static Bairro idBairro;

    public static void main(String[] args) {
        try {
            System.out.println("** Estabelecendo conex\u00e3o...");
            Connection connection = AtualizaZoneamentoNoCadastroImobiliario.createConnection();
            Statement statement = connection.createStatement();
            System.out.println("** Conectado ao Banco de Dados!");
            System.out.println("++ iniciando carregamento do arquivo...");
            String arquivoPlanilha = "src/main/java/br/com/elotech/portalarrecadacao/gerador/Zoneamento Umuarama.xlsx";
            FileInputStream inp = new FileInputStream(arquivoPlanilha);
            Workbook planilha = WorkbookFactory.create((InputStream)inp);
            System.out.println("++ iniciando leitura da planilha...");
            Sheet sheet = planilha.getSheetAt(0);
            System.out.println("-=-=-=- " + sheet.getLastRowNum() + " registro(s) encontrado(s) na planilha! -=-=-=-");
            System.out.println("++ iniciando atualiza\u00e7\u00e3o dos dados...");
            for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
                Row linha = sheet.getRow(i);
                System.out.println(" Linha>>>> " + i);
                AtualizaZoneamentoNoCadastroImobiliario.getBairro((Statement)statement, (Row)linha);
                AtualizaZoneamentoNoCadastroImobiliario.atualizaCadastroImobiliario((Row)linha, (Statement)statement, (Bairro)idBairro);
                System.out.println(" ******************************************************************************************\n");
            }
            connection.close();
            System.out.println("** Desconectado!");
            System.out.println("-=-=-=-=-=- " + listaInsconcistencias.size() + " problema(s) encontrado(s) -=-=-=-=-=-");
            AtualizaZoneamentoNoCadastroImobiliario.imprimirListaInconcistencia();
        }
        catch (ClassNotFoundException | SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            System.out.println("Arquivo n\u00e3o encontrado");
        }
        catch (InvalidFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
            System.out.println("Arquivo com formato inv\u00e1lido");
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void imprimirListaInconcistencia() {
        for (String string : listaInsconcistencias) {
            System.out.println(string);
        }
    }

    private static void getBairro(Statement statement, Row linha) throws SQLException {
        String bairroPlanilha;
        String string = bairroPlanilha = linha != null && linha.getCell(0) != null ? linha.getCell(0).getStringCellValue() : "";
        if (bairroPlanilha.length() > 0) {
            if (bairroPlanilha.contains("ZONA") && bairroPlanilha.contains("0")) {
                bairroPlanilha = bairroPlanilha.replace("0", "");
            }
            System.out.println("Bairro:::" + bairroPlanilha);
            idBairro = AtualizaZoneamentoNoCadastroImobiliario.getIdBairro((Statement)statement, (String)bairroPlanilha);
        }
    }

    private static Bairro getIdBairro(Statement statement, String bairro) throws SQLException {
        AtualizaZoneamentoNoCadastroImobiliario a;
        if (bairro.startsWith("JD.")) {
            bairro = bairro.replace("JD.", "JARDIM");
        } else if (bairro.startsWith("PQ.")) {
            bairro = bairro.replace("PQ.", "PARQUE");
        } else if (bairro.startsWith("RES.")) {
            bairro = bairro.replace("RES.", "RESIDENCIAL");
        } else if (bairro.startsWith("PQ ")) {
            bairro = bairro.replace("PQ", "PARQUE");
        }
        if (!(bairro.equals("MORADIAS VIT\u00d3RIAS") || bairro.equals("JARDIM PRAD\u00d3POLIS") || bairro.contentEquals("JARDIM DAS GAR\u00c7AS") || bairro.equals("JARDIM PAC\u00cdFICO") || bairro.equals("JARDIM SAN LOUREN\u00c7O"))) {
            bairro = EloStringUtils.retiraAcentos((String)bairro);
        }
        String sql = "Select b.* from Bairro b where b.cidade = 6794 and TRIM( b.descricao) = '" + bairro.trim() + "' ORDER BY B.BAIRRO DESC";
        ResultSet resultSet = statement.executeQuery(sql);
        AtualizaZoneamentoNoCadastroImobiliario atualizaZoneamentoNoCadastroImobiliario = a = new AtualizaZoneamentoNoCadastroImobiliario();
        atualizaZoneamentoNoCadastroImobiliario.getClass();
        Bairro bairroEntity = new Bairro(atualizaZoneamentoNoCadastroImobiliario, null);
        while (resultSet.next()) {
            bairroEntity.codigo = resultSet.getLong(2);
            bairroEntity.descricao = resultSet.getString(3);
        }
        if (bairroEntity.codigo != null) {
            return bairroEntity;
        }
        listaInsconcistencias.add(new String("Bairro N\u00e3o Encontrado: " + bairro));
        return null;
    }

    private static void atualizaCadastroImobiliario(Row linha, Statement statement, Bairro idBairro) throws SQLException {
        String zoneamentoEspecificoPlanilha;
        String zoneamentoPlanilha = linha != null && linha.getCell(1) != null ? linha.getCell(1).getStringCellValue() : "";
        String string = zoneamentoEspecificoPlanilha = linha != null && linha.getCell(4) != null ? linha.getCell(4).getStringCellValue() : "";
        if (zoneamentoPlanilha.length() > 0) {
            AtualizaZoneamentoNoCadastroImobiliario.carregaListaImobiliarioPorBairro((String)zoneamentoPlanilha, (Statement)statement);
        } else if (zoneamentoEspecificoPlanilha.length() > 0) {
            AtualizaZoneamentoNoCadastroImobiliario.carregaListaImobiliarioPorBairroQuadra((Row)linha, (String)zoneamentoEspecificoPlanilha, (Statement)statement);
        }
    }

    private static void carregaListaImobiliarioPorBairroQuadra(Row linha, String zoneamentoEspecificoPlanilha, Statement statement) throws SQLException {
        if (idBairro != null) {
            String quadra = linha != null && linha.getCell(2) != null ? linha.getCell(2).getStringCellValue().trim() : "";
            System.out.println("Quadra: " + quadra);
            String lote = linha != null && linha.getCell(3) != null ? linha.getCell(3).getStringCellValue().toUpperCase().trim() : "";
            System.out.println("Lote: " + lote);
            if (quadra.length() > 0) {
                quadra = EloStringUtils.pad((String)quadra, (PadOption)PadOption.LEFT, (int)4, (char)'0');
            }
            ZoneamentoEntity zoneamentoEntity = null;
            if (zoneamentoEspecificoPlanilha != null) {
                zoneamentoEntity = AtualizaZoneamentoNoCadastroImobiliario.getZoneamento((String)zoneamentoEspecificoPlanilha, (Statement)statement);
            }
            StringBuilder sql = new StringBuilder();
            sql.append("Select imob.* from tribcadastroimobiliario imob  ");
            sql.append("join tribcadastrogeral cg ");
            sql.append("on cg.tipocadastro = imob.tipocadastro and cg.cadastrogeral = imob.cadastrogeral ");
            sql.append("join Bairro b on b.bairro = cg.bairro ");
            sql.append("where b.cidade = 6794 and cg.bairro = '");
            sql.append(AtualizaZoneamentoNoCadastroImobiliario.idBairro.codigo.toString()).append("' ");
            sql.append(" and imob.quadra_descr = '").append(quadra).append("' ");
            if (lote.length() > 0) {
                String loteI = null;
                String loteF = null;
                if (lote.toUpperCase().contains("AO")) {
                    loteI = lote.substring(0, lote.indexOf("AO")).trim();
                    loteF = lote.substring(lote.indexOf("AO") + 2, lote.length()).trim();
                } else if (lote.toUpperCase().contains("E")) {
                    loteI = lote.substring(0, lote.indexOf("E")).trim();
                    loteF = lote.substring(lote.indexOf("E") + 1, lote.length()).trim();
                }
                if (loteI == null && loteF == null) {
                    if (lote.matches("^[0-9]*$")) {
                        lote = EloStringUtils.pad((String)lote, (PadOption)PadOption.LEFT, (int)4, (char)'0');
                    }
                    sql.append(" and imob.lote_descr = '").append(lote.trim()).append("'");
                } else {
                    if (loteI.matches("^[0-9]*$")) {
                        loteI = EloStringUtils.pad((String)loteI, (PadOption)PadOption.LEFT, (int)4, (char)'0');
                    }
                    if (loteF.matches("^[0-9]*$")) {
                        loteF = EloStringUtils.pad((String)loteF, (PadOption)PadOption.LEFT, (int)4, (char)'0');
                    }
                    sql.append(" and imob.lote_descr BETWEEN '").append(loteI).append("' AND '").append(loteF).append("'");
                }
            }
            ResultSet resultSet = statement.executeQuery(sql.toString());
            AtualizaZoneamentoNoCadastroImobiliario a = new AtualizaZoneamentoNoCadastroImobiliario();
            listaCadastroImobiliario = new ArrayList();
            while (resultSet.next()) {
                AtualizaZoneamentoNoCadastroImobiliario atualizaZoneamentoNoCadastroImobiliario = a;
                atualizaZoneamentoNoCadastroImobiliario.getClass();
                CadastroImobiliario cad = new CadastroImobiliario(atualizaZoneamentoNoCadastroImobiliario, null);
                cad.codigo = resultSet.getLong(2);
                listaCadastroImobiliario.add(cad);
            }
            if (!EloListUtils.safeIsEmpty((List)listaCadastroImobiliario).booleanValue()) {
                AtualizaZoneamentoNoCadastroImobiliario.executeUpdateImobiliario((ZoneamentoEntity)zoneamentoEntity, (Statement)statement);
            } else {
                listaInsconcistencias.add(new String("Nenhum cadastro Imobili\u00e1rio encontrado com o bairro:" + AtualizaZoneamentoNoCadastroImobiliario.idBairro.descricao + "  quadra: " + quadra + " lote: " + lote));
            }
        }
    }

    private static void carregaListaImobiliarioPorBairro(String zoneamentoPlanilha, Statement statement) throws SQLException {
        ZoneamentoEntity zoneamento = AtualizaZoneamentoNoCadastroImobiliario.getZoneamento((String)zoneamentoPlanilha, (Statement)statement);
        if (idBairro != null) {
            StringBuilder sql = new StringBuilder();
            sql.append("Select imob.* from tribcadastroimobiliario imob  ");
            sql.append("join tribcadastrogeral cg ");
            sql.append("on cg.tipocadastro = imob.tipocadastro and cg.cadastrogeral = imob.cadastrogeral ");
            sql.append("join Bairro b on b.bairro = cg.bairro ");
            sql.append("where b.cidade = 6794 and cg.bairro = '");
            sql.append(AtualizaZoneamentoNoCadastroImobiliario.idBairro.codigo.toString()).append("' ");
            ResultSet resultSet = statement.executeQuery(sql.toString());
            AtualizaZoneamentoNoCadastroImobiliario a = new AtualizaZoneamentoNoCadastroImobiliario();
            listaCadastroImobiliario = new ArrayList();
            while (resultSet.next()) {
                AtualizaZoneamentoNoCadastroImobiliario atualizaZoneamentoNoCadastroImobiliario = a;
                atualizaZoneamentoNoCadastroImobiliario.getClass();
                CadastroImobiliario cad = new CadastroImobiliario(atualizaZoneamentoNoCadastroImobiliario, null);
                cad.codigo = resultSet.getLong(2);
                listaCadastroImobiliario.add(cad);
            }
            if (!EloListUtils.safeIsEmpty((List)listaCadastroImobiliario).booleanValue()) {
                AtualizaZoneamentoNoCadastroImobiliario.executeUpdateImobiliario((ZoneamentoEntity)zoneamento, (Statement)statement);
            } else {
                listaInsconcistencias.add(new String("N\u00e3o foi encontrado nenhum cadastro Imobili\u00e1rio com este Bairro:" + AtualizaZoneamentoNoCadastroImobiliario.idBairro.descricao));
            }
        }
    }

    private static void executeUpdateImobiliario(ZoneamentoEntity zoneamentoEntity, Statement statement) throws SQLException {
        for (CadastroImobiliario cad : listaCadastroImobiliario) {
            String sqlUpdate = "";
            sqlUpdate = "update tribcadastroimobiliario set idzoneamento = " + zoneamentoEntity.getIdZoneamento() + " where tipocadastro = 1 and cadastrogeral = " + cad.codigo;
            statement.execute(sqlUpdate);
        }
    }

    private static ZoneamentoEntity getZoneamento(String zoneamento, Statement statement) throws SQLException {
        String sql = "Select z.* from tribzoneamento z where z.sigla = '" + zoneamento + "'";
        ResultSet resultSet = statement.executeQuery(sql);
        ZoneamentoEntity z = new ZoneamentoEntity();
        while (resultSet.next()) {
            z.setIdZoneamento(Long.valueOf(resultSet.getLong(1)));
            z.setDescricao(resultSet.getString(2));
            z.setSigla(resultSet.getString(3));
        }
        return z;
    }

    public static Connection createConnection() throws ClassNotFoundException, SQLException {
        Class.forName((String)SpringContext.getBean((String)"AISE.jdbc.driverClassName", String.class));
        return DriverManager.getConnection("jdbc:oracle:thin:@192.168.1.251:1521:oraculo", "UMUTRIBUTOS", "UMUTRIBUTOS");
    }

    static {
        listaInsconcistencias = new ArrayList();
        idBairro = null;
    }
}

