/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.filter;

import br.com.elotech.portalarrecadacao.controller.UtilsController;
import br.com.elotech.portalarrecadacao.exception.ShowMessage;
import br.com.elotech.util.date.EloDateUtils;
import br.com.elotech.util.string.EloStringUtils;
import java.io.Serializable;
import java.util.Date;

public class FiltroHistoricoRenovacao
implements Serializable {
    private static final long serialVersionUID = 6449210517142423579L;
    private String numeroSolicitacaoExercicio;
    private Date dataInicialSolicitacao;
    private Date dataFinalSolicitacao;
    private Date dataInicialRenovacao;
    private Date dataFinalRenovacao;
    private Long tipoCadastroImobiliario = 1L;
    private Long codigoCadastroImobiliario;

    public String getNumeroSolicitacaoExercicio() {
        return this.numeroSolicitacaoExercicio;
    }

    public void setNumeroSolicitacaoExercicio(String numeroSolicitacaoExercicio) {
        this.numeroSolicitacaoExercicio = numeroSolicitacaoExercicio;
    }

    public Date getDataInicialSolicitacao() {
        return this.dataInicialSolicitacao;
    }

    public void setDataInicialSolicitacao(Date dataInicialSolicitacao) {
        this.dataInicialSolicitacao = dataInicialSolicitacao;
    }

    public Date getDataFinalSolicitacao() {
        return this.dataFinalSolicitacao;
    }

    public void setDataFinalSolicitacao(Date dataFinalSolicitacao) {
        this.dataFinalSolicitacao = dataFinalSolicitacao;
    }

    public Date getDataInicialRenovacao() {
        return this.dataInicialRenovacao;
    }

    public void setDataInicialRenovacao(Date dataInicialRenovacao) {
        this.dataInicialRenovacao = dataInicialRenovacao;
    }

    public Date getDataFinalRenovacao() {
        return this.dataFinalRenovacao;
    }

    public void setDataFinalRenovacao(Date dataFinalRenovacao) {
        this.dataFinalRenovacao = dataFinalRenovacao;
    }

    public Long getTipoCadastroImobiliario() {
        return this.tipoCadastroImobiliario;
    }

    public void setTipoCadastroImobiliario(Long tipoCadastroImobiliario) {
        this.tipoCadastroImobiliario = tipoCadastroImobiliario;
    }

    public Long getCodigoCadastroImobiliario() {
        return this.codigoCadastroImobiliario;
    }

    public void setCodigoCadastroImobiliario(Long codigoCadastroImobiliario) {
        this.codigoCadastroImobiliario = codigoCadastroImobiliario;
    }

    public boolean isConsultaValida() {
        int quantidadeDias;
        boolean valido = true;
        if (this.isTodosCamposNull()) {
            ShowMessage.addWarnMessage((String)"validacao", (String)"Por favor, informe algum campo para pesquisar.");
            return false;
        }
        if (!UtilsController.isNumeroSolicitacaoValido((String)this.numeroSolicitacaoExercicio).booleanValue()) {
            valido = false;
        }
        if (this.dataInicialSolicitacao == null && this.dataFinalSolicitacao != null) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Informe a data inicial da solicita\u00e7\u00e3o.");
            valido = false;
        }
        if (this.dataInicialSolicitacao != null && this.dataFinalSolicitacao != null && (quantidadeDias = EloDateUtils.daysBetween((Date)this.dataInicialSolicitacao, (Date)this.dataFinalSolicitacao)) < 0) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"A data final da solicita\u00e7\u00e3o n\u00e3o pode ser anterior \u00e0 data inicial.");
            valido = false;
        }
        if (this.dataInicialRenovacao == null && this.dataFinalRenovacao != null) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"Informe a data inicial da renova\u00e7\u00e3o.");
            valido = false;
        }
        if (this.dataInicialRenovacao != null && this.dataFinalRenovacao != null && (quantidadeDias = EloDateUtils.daysBetween((Date)this.dataInicialRenovacao, (Date)this.dataFinalRenovacao)) < 0) {
            ShowMessage.addErrorMessage((String)"validacao", (String)"A data final da renova\u00e7\u00e3o n\u00e3o pode ser anterior \u00e0 data inicial.");
            valido = false;
        }
        if (this.dataInicialSolicitacao != null && this.dataFinalSolicitacao == null) {
            this.dataFinalSolicitacao = new Date();
        }
        if (this.dataInicialRenovacao != null && this.dataFinalRenovacao == null) {
            this.dataFinalRenovacao = new Date();
        }
        return valido;
    }

    private boolean isTodosCamposNull() {
        if (this.codigoCadastroImobiliario != null) {
            return false;
        }
        if (this.dataInicialSolicitacao != null) {
            return false;
        }
        if (this.dataInicialRenovacao != null) {
            return false;
        }
        return EloStringUtils.isEmpty((String)this.numeroSolicitacaoExercicio);
    }
}

