/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.domain.Page;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandAdicionaRestricaoConsultaPrevia;
import br.com.elotech.portalarrecadacao.command.CommandAlteraMobiliarioSituacaoParaNormal;
import br.com.elotech.portalarrecadacao.command.CommandAlteraSituacaoCadastroParaDesatualizado;
import br.com.elotech.portalarrecadacao.command.CommandAtualizaSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandBuscaCodAutenticidadeAlvaraLocalizacao;
import br.com.elotech.portalarrecadacao.command.CommandBuscaConsultaPreviaPorCpfCnpjExercicioNumSolic;
import br.com.elotech.portalarrecadacao.command.CommandBuscaNaturezaPorCodigo;
import br.com.elotech.portalarrecadacao.command.CommandBuscaSolicitacaoPorCpfCnpj;
import br.com.elotech.portalarrecadacao.command.CommandBuscaSolicitacaoPorCpfCnpjExercicioNumSolic;
import br.com.elotech.portalarrecadacao.command.CommandBuscaSolicitacoesAlvaraPorProtocoloRedeSim;
import br.com.elotech.portalarrecadacao.command.CommandCadastroMobiliarioByCadastroGeral;
import br.com.elotech.portalarrecadacao.command.CommandCadastroMobiliarioIsento;
import br.com.elotech.portalarrecadacao.command.CommandCarregaCodigoServico;
import br.com.elotech.portalarrecadacao.command.CommandCarregaCodigoTaxaLocalizacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaDadosCadastroNaSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaDocumentoTipoAlvaraLocalizacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaDocumentosEnviadosSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaDocumentosSefaz;
import br.com.elotech.portalarrecadacao.command.CommandCarregaGuiaRecolhimentoPorSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaLaudosAGerarPrestadorServico;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaParticipantesContratoSocial;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaSolicitacaoAlvaraPaginado;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaSolicitacaoCnpjDataTipoLaudoNumSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaListaTiposDeLaudoDaAtividadeMei;
import br.com.elotech.portalarrecadacao.command.CommandCarregaMenusTipoInscricaoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandCarregaNaturezaInicial;
import br.com.elotech.portalarrecadacao.command.CommandCarregaNaturezasSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaParametroAlvaraNatureza;
import br.com.elotech.portalarrecadacao.command.CommandCarregaSolicitacoesParaValidar;
import br.com.elotech.portalarrecadacao.command.CommandCarregaTipoInscricaoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandCarregaVencimentoSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandCarregarAtividadesMobNaSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregarGuiaRecolhimentoTaxaMobiliariaExercicio;
import br.com.elotech.portalarrecadacao.command.CommandCarregarHistoricoRenovacaoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandCarregarSolicitacaoPorId;
import br.com.elotech.portalarrecadacao.command.CommandCarregarSolicitacoesParaGerarProcessoFiscalizacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregarTodasNaturezasSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregarValidadeAnual;
import br.com.elotech.portalarrecadacao.command.CommandCloneSolicitacaoAlvaraNaRenovacao;
import br.com.elotech.portalarrecadacao.command.CommandConcluirSolicitacaoRedeSim;
import br.com.elotech.portalarrecadacao.command.CommandConsultaTaxaMobiliaria;
import br.com.elotech.portalarrecadacao.command.CommandConsultaViabilidadeRedeSim;
import br.com.elotech.portalarrecadacao.command.CommandDocumentoResponsavelSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandEnviarEmail;
import br.com.elotech.portalarrecadacao.command.CommandEnviarEmailDebitosSocios;
import br.com.elotech.portalarrecadacao.command.CommandExecuteAlteracaoArea;
import br.com.elotech.portalarrecadacao.command.CommandExigeDocumentoNaImpressao;
import br.com.elotech.portalarrecadacao.command.CommandGeraCodigoAutenticidade;
import br.com.elotech.portalarrecadacao.command.CommandGeraSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandGetCodTaxaLocalizacaoWS;
import br.com.elotech.portalarrecadacao.command.CommandGetConsultaRedeSim;
import br.com.elotech.portalarrecadacao.command.CommandGetQtdeParcEmAberto;
import br.com.elotech.portalarrecadacao.command.CommandGetTableParametroGeral;
import br.com.elotech.portalarrecadacao.command.CommandHibernateInitializeSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandImprimiAlvara;
import br.com.elotech.portalarrecadacao.command.CommandImprimiTaxasAlvara;
import br.com.elotech.portalarrecadacao.command.CommandImprimirLicencaSanitaria;
import br.com.elotech.portalarrecadacao.command.CommandImprimirTaxas;
import br.com.elotech.portalarrecadacao.command.CommandIniciaConsultaPrevia;
import br.com.elotech.portalarrecadacao.command.CommandMontaObsAlvara;
import br.com.elotech.portalarrecadacao.command.CommandMontarDataValidadeAlvaraAnual;
import br.com.elotech.portalarrecadacao.command.CommandProcessarFilaEnvioEmailSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandRetornaValidadeAtualPorSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandRetornaValorLicencaSanitaria;
import br.com.elotech.portalarrecadacao.command.CommandRetornaValorTaxaMobiliaria;
import br.com.elotech.portalarrecadacao.command.CommandRetornaValorTaxaMobiliariaISSQN;
import br.com.elotech.portalarrecadacao.command.CommandSalvaSolicitacaoAlvaraValidade;
import br.com.elotech.portalarrecadacao.command.CommandSalvarBoletimMobiliario;
import br.com.elotech.portalarrecadacao.command.CommandSalvarCadastroGeral;
import br.com.elotech.portalarrecadacao.command.CommandSalvarDocumentoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandSalvarDocumentoImpresso;
import br.com.elotech.portalarrecadacao.command.CommandSalvarEnderecoPessoa;
import br.com.elotech.portalarrecadacao.command.CommandSalvarHistoricoRenovacaoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandSalvarMobiliarioServico;
import br.com.elotech.portalarrecadacao.command.CommandSalvarNumerosConselho;
import br.com.elotech.portalarrecadacao.command.CommandSalvarSolicitacaoAlteracao;
import br.com.elotech.portalarrecadacao.command.CommandSalvarSolicitacaoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandSalvarSolicitacaoDispensaLicencaAmbiental;
import br.com.elotech.portalarrecadacao.command.CommandSaveSolicitacaoRenovacao;
import br.com.elotech.portalarrecadacao.command.CommandValidaAlteracaoGeraLaudoPrestadorServico;
import br.com.elotech.portalarrecadacao.command.CommandValidaGeraLaudoPrestadorServico;
import br.com.elotech.portalarrecadacao.command.CommandValidaImpressaoTaxas;
import br.com.elotech.portalarrecadacao.command.CommandValidaSegmentoImobiliario;
import br.com.elotech.portalarrecadacao.command.CommandVerificaCadastrosDuplSolAlvara;
import br.com.elotech.portalarrecadacao.command.CommandVerificaDebitoExercicioAtual;
import br.com.elotech.portalarrecadacao.command.CommandVerificaExigenciaCnae;
import br.com.elotech.portalarrecadacao.command.CommandVerificaExisteAlvaraPorEndereco;
import br.com.elotech.portalarrecadacao.command.CommandVerificaRestricaoCadastroAlvara;
import br.com.elotech.portalarrecadacao.command.CommandVerificaSeExisteParcelaPaga;
import br.com.elotech.portalarrecadacao.controller.dataModel.SolicitacaoAlvaraDataModel;
import br.com.elotech.portalarrecadacao.domain.HistoricoRenovacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.LaudoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.NaturezaSolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraNaturezaEntity;
import br.com.elotech.portalarrecadacao.domain.RestricaoConsultaPreviaEntity;
import br.com.elotech.portalarrecadacao.domain.SefazDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraDocumentoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraNumConselhoEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraValidadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoContratoSocialPessoaEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoDispensaAmbientalEntity;
import br.com.elotech.portalarrecadacao.domain.StatusLaudoAlvara;
import br.com.elotech.portalarrecadacao.domain.helper.ImprimirTaxasAlvara;
import br.com.elotech.portalarrecadacao.domain.vo.ConsultaPreviaVo;
import br.com.elotech.portalarrecadacao.domain.vo.EmailVo;
import br.com.elotech.portalarrecadacao.domain.vo.ResponsavelSolicitacaoVo;
import br.com.elotech.portalarrecadacao.domain.vo.RestricaoAlvaraVo;
import br.com.elotech.portalarrecadacao.domain.vo.SolicitacaoAlvaraVo;
import br.com.elotech.portalarrecadacao.enumerator.NaturezaSolicitacaoAlvaraEnum;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraNaturezaEnum;
import br.com.elotech.portalarrecadacao.exception.SolicitacaoAlvaraException;
import br.com.elotech.portalarrecadacao.filter.FiltroHistoricoRenovacao;
import br.com.elotech.portalarrecadacao.integration.dto.consulta.Mensagem;
import br.com.elotech.portalarrecadacao.rest.dto.SolicitacaoAlvaraDTO;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RespostaWSAtividade;
import br.com.elotech.tributacao.command.CommandSalvarCadastroMobiliario;
import br.com.elotech.tributacao.domain.aise.AtividadeMeiEntity;
import br.com.elotech.tributacao.domain.aise.BoletimMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAiseEntity;
import br.com.elotech.tributacao.domain.aise.CadastroGeralAisePK;
import br.com.elotech.tributacao.domain.aise.CadastroImobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.CadastroMobiliarioEntity;
import br.com.elotech.tributacao.domain.aise.DocumentoAiseEntity;
import br.com.elotech.tributacao.domain.aise.DocumentoImpressoEntity;
import br.com.elotech.tributacao.domain.aise.DocumentoTipoEntity;
import br.com.elotech.tributacao.domain.aise.GuiaRecolhimentoEntity;
import br.com.elotech.tributacao.domain.aise.MobiliarioServicoEntity;
import br.com.elotech.tributacao.domain.aise.ModeloRespostaEntity;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.domain.aise.ServicoEntity;
import br.com.elotech.tributacao.domain.aise.TipoInscricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.TipoLaudoEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.messaging.Message;
import org.springframework.security.core.userdetails.UserDetails;

public abstract class FacadeSolicitacaoAlvara
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandCarregaNaturezasSolicitacao getCommandCarregaNaturezasSolicitacao();

    protected abstract CommandSalvarSolicitacaoAlteracao getCommandSalvarSolicitacao();

    protected abstract CommandSalvarSolicitacaoAlvara getCommandSalvarSolicitacaoAlvara();

    protected abstract CommandSalvarNumerosConselho getCommandSalvarNumerosConselho();

    protected abstract CommandVerificaExisteAlvaraPorEndereco getCommandVerificaExisteAlvaraPorEndereco();

    protected abstract CommandBuscaSolicitacaoPorCpfCnpjExercicioNumSolic getCommandBuscaSolicitacaoPorCpfCnpjExercicioNumSolic();

    protected abstract CommandBuscaSolicitacoesAlvaraPorProtocoloRedeSim getCommandBuscaSolicitacoesAlvaraPorProtocoloRedeSim();

    protected abstract CommandCarregaNaturezaInicial getCommandCarregaNaturezaInicial();

    protected abstract CommandBuscaSolicitacaoPorCpfCnpj getCommandBuscaSolicitacaoPorCpfCnpj();

    protected abstract CommandCarregaDocumentosEnviadosSolicitacao getCommandCarregaDocumentosEnviadosSolicitacao();

    protected abstract CommandCarregaSolicitacoesParaValidar getCommandCarregaSolicitacoesParaValidar();

    protected abstract CommandSalvarBoletimMobiliario getCommandSalvarBoletimMobiliario();

    protected abstract CommandSalvarMobiliarioServico getCommandSalvarMobiliarioServico();

    protected abstract CommandCarregaCodigoTaxaLocalizacao getCommandCarregaCodigoTaxaLocalizacao();

    protected abstract CommandCarregaCodigoServico getCommandCarregaCodigoServico();

    protected abstract CommandCarregaListaSolicitacaoCnpjDataTipoLaudoNumSolicitacao getCommandCarregaListaSolicitacaoCnpjDataTipoLaudoNumSolicitacao();

    protected abstract CommandSalvarCadastroGeral getCommandSalvarCadastroGeral();

    protected abstract CommandGeraCodigoAutenticidade getCommandGeraCodigoAutenticidade();

    protected abstract CommandSalvarDocumentoAlvara getCommandSalvaDocumentoAlvara();

    protected abstract CommandVerificaExigenciaCnae getCommandVerificaExigenciaCnae();

    protected abstract CommandCarregaDocumentoTipoAlvaraLocalizacao getCommandCarregaDocumentoTipoAlvaraLocalizacao();

    protected abstract CommandSalvarDocumentoAlvara getCommandSalvarDocumentoAlvaraLoc();

    protected abstract CommandSalvarDocumentoImpresso getCommandSalvarDocumentoImpresso();

    protected abstract CommandBuscaCodAutenticidadeAlvaraLocalizacao getCommandBuscaCodAutenticidadeAlvaraLocalizacao();

    protected abstract CommandAtualizaSolicitacaoAlvara getCommandAtualizaSolicitacaoAlvara();

    protected abstract CommandHibernateInitializeSolicitacaoAlvara getCommandHibernateInitializeSolicitacaoAlvara();

    protected abstract CommandImprimirTaxas getCommandImprimirTaxas();

    protected abstract CommandRetornaValorTaxaMobiliaria getCommandRetornaValorTaxaMobiliaria();

    protected abstract CommandRetornaValorLicencaSanitaria getCommandRetornaValorLicencaSanitaria();

    protected abstract CommandMontaObsAlvara getCommandMontaObsAlvara();

    protected abstract CommandCadastroMobiliarioByCadastroGeral getCommandCadastroMobiliarioByCadastroGeral();

    protected abstract CommandSalvaSolicitacaoAlvaraValidade getCommandSalvaSolicitacaoAlvaraValidade();

    protected abstract CommandSaveSolicitacaoRenovacao getCommandSaveSolicitacaoRenovacao();

    protected abstract CommandVerificaDebitoExercicioAtual getCommandVerificaDebitoExercicioAtual();

    protected abstract CommandCarregarGuiaRecolhimentoTaxaMobiliariaExercicio getCommandCarregarGuiaRecolhimentoTaxaMobiliariaExercicio();

    protected abstract CommandAlteraMobiliarioSituacaoParaNormal getCommandAlteraMobiliarioSituacaoParaNormal();

    protected abstract CommandSalvarHistoricoRenovacaoAlvara getCommandSalvarHistoricoRenovacaoAlvara();

    protected abstract CommandCarregarHistoricoRenovacaoAlvara getCommandCarregarHistoricoRenovacaoAlvara();

    protected abstract CommandCarregaVencimentoSolicitacaoAlvara getCommandCarregaVencimentoSolicitacaoAlvara();

    protected abstract CommandRetornaValidadeAtualPorSolicitacao getCommandRetornaValidadeAtualPorSolicitacao();

    protected abstract CommandConsultaViabilidadeRedeSim getCommandConsultaViabilidadeRedeSim();

    protected abstract CommandBuscaConsultaPreviaPorCpfCnpjExercicioNumSolic getCommandBuscaConsultaPreviaPorCpfExercNumSolic();

    protected abstract CommandCarregaGuiaRecolhimentoPorSolicitacao getCommandCarregaGuiaRecolhimentoPorSolicitacao();

    protected abstract CommandVerificaSeExisteParcelaPaga getCommandVerificaSeExisteParcelaPaga();

    protected abstract CommandGetQtdeParcEmAberto getCommandGetQtdeParcEmAberto();

    protected abstract CommandGetTableParametroGeral getCommandGetTableParamentroGeral();

    protected abstract CommandVerificaRestricaoCadastroAlvara getCommandVerificaRestricaoCadastroAlvara();

    protected abstract CommandGeraSolicitacaoAlvara getCommandGeraSolicitacaoAlvara();

    protected abstract CommandVerificaCadastrosDuplSolAlvara getCommandVerificaCadastroDuplSolAlvara();

    protected abstract CommandImprimiTaxasAlvara getcommandImprimiTaxasAlvara();

    protected abstract CommandImprimiAlvara getCommandImprimiAlvara();

    protected abstract CommandCarregaTipoInscricaoAlvara getCommandCarregaTipoInscricaoAlvara();

    protected abstract CommandCarregaParametroAlvaraNatureza getCommandCarregaParametrosAlvaraNatureza();

    protected abstract CommandGetCodTaxaLocalizacaoWS getCommandGetCodTaxaLocalizacaoWS();

    protected abstract CommandCarregaListaSolicitacaoAlvaraPaginado getCommandCarregaListaSolicitacaoAlvaraPaginado();

    protected abstract CommandValidaAlteracaoGeraLaudoPrestadorServico getCommandValidaAlteracaoGeraLaudoPrestadorServico();

    protected abstract CommandCarregaLaudosAGerarPrestadorServico getCommandCarregaLaudosAGerarPrestadorServico();

    protected abstract CommandCarregarAtividadesMobNaSolicitacao getCommandCarregarAtividadesMobNaSolicitacao();

    protected abstract CommandValidaGeraLaudoPrestadorServico getCommandValidaGeraLaudoPrestadorServico();

    protected abstract CommandBuscaNaturezaPorCodigo getCommandBuscaNaturezaPorCodigo();

    protected abstract CommandCarregaListaTiposDeLaudoDaAtividadeMei getCommandCarregaListaTiposDeLaudoDaAtividadeMei();

    protected abstract CommandRetornaValorTaxaMobiliariaISSQN getCommandRetornaValorTaxaMobiliariaISSQN();

    protected abstract CommandCarregaMenusTipoInscricaoAlvara getCommandCarregaMenusTipoInscricaoAlvara();

    protected abstract CommandAlteraSituacaoCadastroParaDesatualizado getCommandAlteraSituacaoCadastroParaDesatualizado();

    protected abstract CommandCarregaListaParticipantesContratoSocial getCommandCarregaListaParticipantesContratoSocial();

    protected abstract CommandCarregaDocumentosSefaz getCommandCarregaDocumentosSefaz();

    protected abstract CommandExecuteAlteracaoArea getCommandExecuteAlteracaoArea();

    protected abstract CommandSalvarCadastroMobiliario getCommandSalvarCadastroMobiliario();

    protected abstract CommandValidaImpressaoTaxas getCommandValidaImpressaoTaxas();

    protected abstract CommandEnviarEmail getCommandEnviarEmail();

    protected abstract CommandConsultaTaxaMobiliaria getCommandConsultaTaxaMobiliaria();

    protected abstract CommandGetConsultaRedeSim getCommandConsultaRedeSim();

    protected abstract CommandConcluirSolicitacaoRedeSim getCommandConcluirSolicitacaoRedeSim();

    protected abstract CommandEnviarEmailDebitosSocios getCommandEnviarEmailDebitosSocios();

    protected abstract CommandIniciaConsultaPrevia getCommandIniciaConsultaPrevia();

    protected abstract CommandValidaSegmentoImobiliario getCommandValidaSegmentoImobiliario();

    protected abstract CommandCarregaDadosCadastroNaSolicitacao getCommandCarregaDadosCadastroNaSolicitacao();

    protected abstract CommandAdicionaRestricaoConsultaPrevia getCommandAdicionaRestricaoConsultaPrevia();

    protected abstract CommandCarregarValidadeAnual getCommandCarregarValidadeAnual();

    protected abstract CommandCarregarTodasNaturezasSolicitacao getCommandCarregarTodasNaturezasSolicitacao();

    protected abstract CommandCarregarSolicitacoesParaGerarProcessoFiscalizacao getCommandCarregarSolicitacoesParaGerarProcessoFiscalizacao();

    protected abstract CommandCarregarSolicitacaoPorId getCommandCarregarSolicitacaoPorId();

    protected abstract CommandProcessarFilaEnvioEmailSolicitacao getCommandProcessarFilaEnvioEmailSolicitacao();

    protected abstract CommandMontarDataValidadeAlvaraAnual getCommandMontarDataValidadeAlvaraAnual();

    protected abstract CommandImprimirLicencaSanitaria getCommandImprimirLicencaSanitaria();

    protected abstract CommandDocumentoResponsavelSolicitacaoAlvara getCommandDocumentoResponsavelSolicitacaoAlvara();

    protected abstract CommandCadastroMobiliarioIsento getCommandCadastroMobiliarioIsento();

    protected abstract CommandCloneSolicitacaoAlvaraNaRenovacao getCommandCloneSolicitacaoAlvaraNaRenovacao();

    protected abstract CommandExigeDocumentoNaImpressao getCommandExigeDocumentoNaImpressao();

    protected abstract CommandSalvarSolicitacaoDispensaLicencaAmbiental getCommandSalvarSolicitacaoDispensaLicencaAmbiental();

    protected abstract CommandSalvarEnderecoPessoa getCommandSalvarEnderecoPessoa();

    public List<NaturezaSolicitacaoAlvaraEntity> carregaNaturezas(boolean comNaturezaInicial) throws BaseException {
        CommandCarregaNaturezasSolicitacao command = this.getCommandCarregaNaturezasSolicitacao();
        command.setComNaturezaInicial(comNaturezaInicial);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getNaturezas();
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoAlvaraAlteracao(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CommandSalvarSolicitacaoAlteracao command = this.getCommandSalvarSolicitacao();
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        command.setGeraLaudos(true);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getSolicitacaoAlvara();
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoAlvaraAlteracao(SolicitacaoAlvaraEntity solicitacaoAlvara, boolean geraLaudos) throws BaseException {
        CommandSalvarSolicitacaoAlteracao command = this.getCommandSalvarSolicitacao();
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        command.setGeraLaudos(geraLaudos);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getSolicitacaoAlvara();
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CommandSalvarSolicitacaoAlvara command = this.getCommandSalvarSolicitacaoAlvara();
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getSolicitacaoAlvara();
    }

    public List<SolicitacaoAlvaraNumConselhoEntity> salvarNumerosConselho(List<SolicitacaoAlvaraNumConselhoEntity> numeros) throws BaseException {
        CommandSalvarNumerosConselho command = this.getCommandSalvarNumerosConselho();
        command.setListaNumerosConselho(numeros);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getListaNumerosConselho();
    }

    public SolicitacaoAlvaraEntity salvarSolicitacaoInicial(SolicitacaoAlvaraEntity solicitacaoAlvara, boolean geraRestricaoCadastroExistente) throws BaseException {
        CommandGeraSolicitacaoAlvara command = this.getCommandGeraSolicitacaoAlvara();
        command.setConsultaPrevia(Boolean.valueOf(false));
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        command.setGeraRestricaoCadastroExistente(geraRestricaoCadastroExistente);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getSolicitacaoAlvara();
    }

    public boolean existeAlvaraPorEndereco(CadastroImobiliarioEntity cadastroImobiliario) throws BaseException {
        CommandVerificaExisteAlvaraPorEndereco command = this.getCommandVerificaExisteAlvaraPorEndereco();
        command.setCadastroImobiliario(cadastroImobiliario);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.isExisteAlvara();
    }

    public SolicitacaoAlvaraEntity buscaConsultaPreviaPorCpfCnpjExercicioNumSolic(Long solicitacao, Long exercicio, String cpfCnpj) throws BaseException {
        CommandBuscaConsultaPreviaPorCpfCnpjExercicioNumSolic command = this.getCommandBuscaConsultaPreviaPorCpfExercNumSolic();
        command.setCpfCnpj(cpfCnpj);
        command.setExercicio(exercicio);
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getSolicitacaoAlvara();
    }

    public SolicitacaoAlvaraEntity buscaSolicitacaoAlvaraPorCpfCnpjExercicioNumSolic(Long solicitacao, Long exercicio, String cpfCnpj) throws BaseException {
        CommandBuscaSolicitacaoPorCpfCnpjExercicioNumSolic command = this.getCommandBuscaSolicitacaoPorCpfCnpjExercicioNumSolic();
        command.setSolicitacao(solicitacao);
        command.setExercicio(exercicio);
        command.setCpfCnpj(cpfCnpj);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getSolicitacaoAlvara();
    }

    public List<SolicitacaoAlvaraEntity> buscaSolicitacaoAlvaraPorProtocoloRedeSim(String protocolo, Optional<String> tipo) throws BaseException {
        CommandBuscaSolicitacoesAlvaraPorProtocoloRedeSim command = this.getCommandBuscaSolicitacoesAlvaraPorProtocoloRedeSim();
        command.setProtocolo(protocolo);
        command.setTipoSolicitacao(tipo);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getSolicitacoesAlvara();
    }

    public List<SolicitacaoAlvaraEntity> buscaSolicitacaoAlvaraPorCpfCnpj(SolicitacaoAlvaraVo solicitacaoVo) throws BaseException {
        CommandBuscaSolicitacaoPorCpfCnpj command = this.getCommandBuscaSolicitacaoPorCpfCnpj();
        command.setSolicitacaoAlvaraVo(solicitacaoVo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getSolicitacoes();
    }

    public NaturezaSolicitacaoAlvaraEntity carregaNaturezaInicial() throws BaseException {
        CommandCarregaNaturezaInicial command = this.getCommandCarregaNaturezaInicial();
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getNaturezaSolicitacao();
    }

    public List<SolicitacaoAlvaraDocumentoEntity> carregaDocumentosEnviadosSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandCarregaDocumentosEnviadosSolicitacao command = this.getCommandCarregaDocumentosEnviadosSolicitacao();
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getDocumentos();
    }

    public List<SolicitacaoAlvaraEntity> carregaSolicitacoesParaValidar(Long numeroSolicitacao, Long exercicio, String cpfCnpj, Date dataInicial, Date dataFinal, boolean documentoNaoValidado) throws BaseException {
        CommandCarregaSolicitacoesParaValidar command = this.getCommandCarregaSolicitacoesParaValidar();
        command.setNumeroSolicitacao(numeroSolicitacao);
        command.setExercicio(exercicio);
        command.setCpfCnpj(cpfCnpj);
        command.setDataInicial(dataInicial);
        command.setDataFinal(dataFinal);
        command.setDocumentoNaoValidado(documentoNaoValidado);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getSolicitacoes();
    }

    public void salvarBoletimMobiliario(BoletimMobiliarioEntity boletimMobiliario) throws BaseException {
        CommandSalvarBoletimMobiliario command = this.getCommandSalvarBoletimMobiliario();
        command.setBoletimMobiliario(boletimMobiliario);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public void salvarMobiliarioServico(MobiliarioServicoEntity mobiliarioServico) throws BaseException {
        CommandSalvarMobiliarioServico command = this.getCommandSalvarMobiliarioServico();
        command.setMobiliarioServico(mobiliarioServico);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public List<ModeloRespostaEntity> carregaModeloResposta() throws BaseException {
        CommandCarregaCodigoTaxaLocalizacao command = this.getCommandCarregaCodigoTaxaLocalizacao();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getTaxasLocalizacao();
    }

    public List<ServicoEntity> carregaListaServico(Long exercicio) throws BaseException {
        CommandCarregaCodigoServico command = this.getCommandCarregaCodigoServico();
        command.setExercicio(exercicio);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getListaServico();
    }

    public List<SolicitacaoAlvaraEntity> carregaListaSolicitacaoByCnpjDataTipoLaudoNumSol(String numSolicitacao, String cpfCnpj, Date dataInicial, Date dataFinal, TipoLaudoEntity tipoLaudo, StatusLaudoAlvara situacaoSelecionada) throws BaseException {
        CommandCarregaListaSolicitacaoCnpjDataTipoLaudoNumSolicitacao command = this.getCommandCarregaListaSolicitacaoCnpjDataTipoLaudoNumSolicitacao();
        command.setCpfCnpj(cpfCnpj);
        command.setDataFinal(dataFinal);
        command.setDataInicial(dataInicial);
        command.setNumeroSolicitacao(numSolicitacao);
        command.setTipoLaudo(tipoLaudo);
        command.setSituacaoLaudo(situacaoSelecionada);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getSolicitacao();
    }

    public CadastroGeralAiseEntity salvarCadastroGeral(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandSalvarCadastroGeral command = this.getCommandSalvarCadastroGeral();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getCadastroGeral();
    }

    public void salvarEnderecoPessoa(PessoaEntity pessoa) throws BaseException {
        CommandSalvarEnderecoPessoa command = this.getCommandSalvarEnderecoPessoa();
        command.setPessoa(pessoa);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public String gerarCodigoAutenticidade() throws BaseException {
        CommandGeraCodigoAutenticidade command = this.getCommandGeraCodigoAutenticidade();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getCodigoAutenticidade();
    }

    public void gravarDocumentoAlvara(DocumentoAiseEntity documento) throws BaseException {
        CommandSalvarDocumentoAlvara command = this.getCommandSalvaDocumentoAlvara();
        command.setDocumento(documento);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public String verificarExigenciaPorCnae(List<RespostaWSAtividade> configuracaoCnae, String rivGas, String rivNave) throws BaseException {
        CommandVerificaExigenciaCnae command = this.getCommandVerificaExigenciaCnae();
        command.setListaConfiguracaoCnae(configuracaoCnae);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getExigencias();
    }

    public DocumentoTipoEntity carregarDocumentoTipoAlvaraLocalizacao() throws BaseException {
        CommandCarregaDocumentoTipoAlvaraLocalizacao command = this.getCommandCarregaDocumentoTipoAlvaraLocalizacao();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getDocumentoTipoAlvaraLocalizacao();
    }

    public DocumentoAiseEntity salvarDocumentoTipoAlvaraLocalizacao(DocumentoAiseEntity documento) throws BaseException {
        CommandSalvarDocumentoAlvara command = this.getCommandSalvarDocumentoAlvaraLoc();
        command.setDocumento(documento);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getDocumentoAiseEntity();
    }

    public void salvarDocumentoImpresso(DocumentoImpressoEntity documento) throws BaseException {
        CommandSalvarDocumentoImpresso command = this.getCommandSalvarDocumentoImpresso();
        command.setDocumentoImpresso(documento);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public String buscarCodAutenticidadeAlvaraLoc(Long exercicio, Long codDocumento) throws BaseException {
        CommandBuscaCodAutenticidadeAlvaraLocalizacao command = this.getCommandBuscaCodAutenticidadeAlvaraLocalizacao();
        command.setCodDocumento(codDocumento);
        command.setExercicio(exercicio);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getCodigoAutenticidade();
    }

    public SolicitacaoAlvaraEntity atualizaSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CommandAtualizaSolicitacaoAlvara command = this.getCommandAtualizaSolicitacaoAlvara();
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getSolicitacaoAlvara();
    }

    public SolicitacaoAlvaraEntity hibernateInitializeSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CommandHibernateInitializeSolicitacaoAlvara command = this.getCommandHibernateInitializeSolicitacaoAlvara();
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getSolicitacaoAlvara();
    }

    public BigDecimal getValorTaxasMobiliarias(Long exercicio, Long entidade, SolicitacaoAlvaraEntity solicitacao, String taxaLocalizacao) throws BaseException {
        CommandRetornaValorTaxaMobiliaria command = this.getCommandRetornaValorTaxaMobiliaria();
        command.setSolicitacaoAlvara(solicitacao);
        command.setEntidade(entidade);
        command.setExercicio(exercicio);
        command.setTaxaLocalizacao(taxaLocalizacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getValorTaxa();
    }

    public BigDecimal getConsultaTaxaMobiliaria(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandConsultaTaxaMobiliaria command = this.getCommandConsultaTaxaMobiliaria();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getValorTaxaMobiliaria();
    }

    public BigDecimal getValorLicencaSanitaria(Long exercicio, Long entidade, SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CommandRetornaValorLicencaSanitaria command = this.getCommandRetornaValorLicencaSanitaria();
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        command.setEntidade(entidade);
        command.setExercicio(exercicio);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getValor();
    }

    public String montarObservacaoAlvara(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandMontaObsAlvara command = this.getCommandMontaObsAlvara();
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getObservacao();
    }

    public CadastroMobiliarioEntity carregaCadastroMobiliarioByCadastroGeral(Long cadastroGeral) throws BaseException {
        CommandCadastroMobiliarioByCadastroGeral command = this.getCommandCadastroMobiliarioByCadastroGeral();
        command.setCadastroGeral(cadastroGeral);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getCadastroMobiliario();
    }

    public void salvarSolicitacaoAlvaraValidade(SolicitacaoAlvaraValidadeEntity validade) throws BaseException {
        CommandSalvaSolicitacaoAlvaraValidade command = this.getCommandSalvaSolicitacaoAlvaraValidade();
        command.setSolicitacaoAlvaraValidade(validade);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public SolicitacaoAlvaraEntity saveSolicitacaoRenovacao(SolicitacaoAlvaraEntity solicitacao, List<LaudoAlvaraEntity> listaLaudosProvisorios) throws BaseException {
        CommandSaveSolicitacaoRenovacao command = this.getCommandSaveSolicitacaoRenovacao();
        command.setSolicitacao(solicitacao);
        command.setListaLaudosProvisorios(listaLaudosProvisorios);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getSolicitacaoAlvara();
    }

    public GuiaRecolhimentoEntity carregarGuiaRecolhimentoTaxaMobiliariaExercicio(Long exercicio) throws BaseException {
        CommandCarregarGuiaRecolhimentoTaxaMobiliariaExercicio command = this.getCommandCarregarGuiaRecolhimentoTaxaMobiliariaExercicio();
        command.setExercicio(exercicio);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getGuiaRecolhimento();
    }

    public Boolean verificarDebitoExercicioAtual(GuiaRecolhimentoEntity guia, CadastroGeralAisePK cadastro, Long exercicio) throws BaseException {
        CommandVerificaDebitoExercicioAtual command = this.getCommandVerificaDebitoExercicioAtual();
        command.setCadastroGeral(cadastro);
        command.setExercicio(exercicio);
        command.setGuiaRecolhimento(guia);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getPossuiDebito();
    }

    public void alteraMobiliarioSituacaoParaNormal(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        CommandAlteraMobiliarioSituacaoParaNormal command = this.getCommandAlteraMobiliarioSituacaoParaNormal();
        command.setCadastroMobiliario(cadastroMobiliario);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public void salvarHistoricoRenovacao(List<LaudoAlvaraEntity> listaLaudoProvisorio, SolicitacaoAlvaraEntity solicitacao, UserDetails usuario, String descHistorico) throws BaseException {
        CommandSalvarHistoricoRenovacaoAlvara command = this.getCommandSalvarHistoricoRenovacaoAlvara();
        command.setDescHistorico(descHistorico);
        command.setListaLaudoProvisorio(listaLaudoProvisorio);
        command.setSolicitacaoAlvara(solicitacao);
        command.setUsuario(usuario);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public List<HistoricoRenovacaoAlvaraEntity> carregarHistoricoRenovacao(FiltroHistoricoRenovacao filtro) throws BaseException {
        CommandCarregarHistoricoRenovacaoAlvara command = this.getCommandCarregarHistoricoRenovacaoAlvara();
        command.setFiltro(filtro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getRenovacoes();
    }

    public List<SolicitacaoAlvaraValidadeEntity> carregaVencimentosSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandCarregaVencimentoSolicitacaoAlvara command = this.getCommandCarregaVencimentoSolicitacaoAlvara();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getListaVencimentos();
    }

    public List<SolicitacaoAlvaraValidadeEntity> retornaValidadeAtualPorSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandRetornaValidadeAtualPorSolicitacao command = this.getCommandRetornaValidadeAtualPorSolicitacao();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getSolicitacoesAlvaraValidade();
    }

    public GuiaRecolhimentoEntity carregaGuiaRecolhimentoPorSolicitacao(Long exercicio, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandCarregaGuiaRecolhimentoPorSolicitacao command = this.getCommandCarregaGuiaRecolhimentoPorSolicitacao();
        command.setExercicio(exercicio);
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getGuiaRecolhimento();
    }

    public Long verificaQtdeParcelasEmAberto(Long exercicio, Long guiaRecolhimento, CadastroGeralAisePK cadastroGeral) throws BaseException {
        CommandGetQtdeParcEmAberto command = this.getCommandGetQtdeParcEmAberto();
        command.setCadastroGeral(cadastroGeral);
        command.setExercicio(exercicio);
        command.setGuiaRecolhimento(guiaRecolhimento);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getQtdeParcelas();
    }

    public String getParamentroGeral(String modulo, String paramentro) throws BaseException {
        CommandGetTableParametroGeral command = this.getCommandGetTableParamentroGeral();
        command.setModulo(modulo);
        command.setParametro(paramentro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getValor();
    }

    public RestricaoAlvaraVo verificarRestricaoCadastroAlvara(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandVerificaRestricaoCadastroAlvara command = this.getCommandVerificaRestricaoCadastroAlvara();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getRestricaoAlvara();
    }

    public SolicitacaoAlvaraEntity salvarConsultaPrevia(SolicitacaoAlvaraEntity solicitacao, Boolean consultaPrevia) throws BaseException {
        CommandGeraSolicitacaoAlvara command = this.getCommandGeraSolicitacaoAlvara();
        command.setConsultaPrevia(consultaPrevia);
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getSolicitacaoAlvara();
    }

    public boolean verificaCadastrosDuplicados(SolicitacaoAlvaraEntity solicitacao, Boolean geraRestricao) throws BaseException {
        CommandVerificaCadastrosDuplSolAlvara command = this.getCommandVerificaCadastroDuplSolAlvara();
        command.setGeraRestricaoCadastroExistente(geraRestricao);
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.isRestricao();
    }

    public void validaImpressaoTaxas(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandValidaImpressaoTaxas command = this.getCommandValidaImpressaoTaxas();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public ImprimirTaxasAlvara imprimirTaxasAlvara(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandImprimiTaxasAlvara command = this.getcommandImprimiTaxasAlvara();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getImprimirTaxas();
    }

    public ImprimirTaxasAlvara imprimirTaxas(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.possuiSomenteNaturezas(new NaturezaSolicitacaoAlvaraEnum[]{NaturezaSolicitacaoAlvaraEnum.ALTERACAO_SOCIOS})) {
            return null;
        }
        CommandImprimirTaxas command = this.getCommandImprimirTaxas();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getImprimirTaxas();
    }

    public void alterarSituacaoMobiliarioParaDesatualizado(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandAlteraSituacaoCadastroParaDesatualizado commandAlteraSituacaoParaDesatualizado = this.getCommandAlteraSituacaoCadastroParaDesatualizado();
        commandAlteraSituacaoParaDesatualizado.setCadastroMobiliario(solicitacao.getCadastroMobiliario());
        this.getCommandContainer().executeCommand((Command)commandAlteraSituacaoParaDesatualizado);
    }

    public SolicitacaoAlvaraEntity alterarArea(SolicitacaoAlvaraEntity solicitacao) throws BaseException, SolicitacaoAlvaraException {
        CommandExecuteAlteracaoArea commandExecuteAlteracaoArea = this.getCommandExecuteAlteracaoArea();
        commandExecuteAlteracaoArea.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((CommandTransactional)commandExecuteAlteracaoArea);
        return commandExecuteAlteracaoArea.getSolicitacaoAlvara();
    }

    public ImprimirTaxasAlvara imprimiTaxaAlvaraCadastroMob(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        BigDecimal areaUtilizadaMobiliario = null;
        BigDecimal areaBombeiroMobiliario = null;
        BigDecimal areaPatioMobiliario = null;
        BigDecimal areaConstruidaMobiliario = null;
        if (!solicitacao.isNaturezaInicial()) {
            areaUtilizadaMobiliario = solicitacao.getCadastroMobiliario().getAreaUtilizada();
            areaBombeiroMobiliario = solicitacao.getCadastroMobiliario().getAreaBombeiro();
            areaPatioMobiliario = solicitacao.getCadastroMobiliario().getAreaPatio();
            areaConstruidaMobiliario = solicitacao.getCadastroMobiliario().getAreaConstruida();
        }
        solicitacao = this.alterarArea(solicitacao);
        CommandImprimiTaxasAlvara command = this.getcommandImprimiTaxasAlvara();
        command.setSolicitacaoAlvara(solicitacao);
        if (!solicitacao.isNaturezaInicial() && solicitacao.isSituacaoMobiliarioDesatualizado()) {
            Date dataEncerramento = solicitacao.getCadastroMobiliario().getDataEncerramento();
            try {
                ImprimirTaxasAlvara imprimirTaxas = this.executeCommandImprimirTaxas(command, solicitacao);
                return imprimirTaxas;
            }
            catch (Exception e) {
                solicitacao.getCadastroMobiliario().setDataEncerramento(dataEncerramento);
                solicitacao.getCadastroMobiliario().setAreaUtilizada(areaUtilizadaMobiliario);
                solicitacao.getCadastroMobiliario().setAreaBombeiro(areaBombeiroMobiliario);
                solicitacao.getCadastroMobiliario().setAreaPatio(areaPatioMobiliario);
                solicitacao.getCadastroMobiliario().setAreaConstruida(areaConstruidaMobiliario);
                this.alterarSituacaoMobiliarioParaDesatualizado(solicitacao);
                this.salvarCadastroMobiliario(solicitacao.getCadastroMobiliario());
                throw new SolicitacaoAlvaraException(e.getMessage());
            }
        }
        try {
            ImprimirTaxasAlvara imprimirTaxas = this.executeCommandImprimirTaxas(command, solicitacao);
            return imprimirTaxas;
        }
        catch (Exception e) {
            if (!solicitacao.isNaturezaInicial()) {
                solicitacao.getCadastroMobiliario().setAreaUtilizada(areaUtilizadaMobiliario);
                solicitacao.getCadastroMobiliario().setAreaBombeiro(areaBombeiroMobiliario);
                solicitacao.getCadastroMobiliario().setAreaPatio(areaPatioMobiliario);
                solicitacao.getCadastroMobiliario().setAreaConstruida(areaConstruidaMobiliario);
            }
            this.salvarCadastroMobiliario(solicitacao.getCadastroMobiliario());
            throw new SolicitacaoAlvaraException(e.getMessage());
        }
    }

    public ImprimirTaxasAlvara executeCommandImprimirTaxas(CommandImprimiTaxasAlvara command, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        if (solicitacao.isNaturezaInicial()) {
            this.salvarCadastroMobiliario(solicitacao.getCadastroMobiliario());
        }
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getImprimirTaxas();
    }

    public void imprimirAlvaraCadastroMobiliario(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandImprimiAlvara command = this.getCommandImprimiAlvara();
        command.setSolicitacaoAlvara(solicitacao);
        this.executeCommandImprimirAlvara(command);
    }

    public void imprimirAlvara(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandImprimiAlvara command = this.getCommandImprimiAlvara();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public void executeCommandImprimirAlvara(CommandImprimiAlvara command) throws BaseException {
        this.getCommandContainer().executeCommand((Command)command);
    }

    public List<TipoInscricaoAlvaraEntity> carregarTipoInscricaoAlvara() throws BaseException {
        CommandCarregaTipoInscricaoAlvara command = this.getCommandCarregaTipoInscricaoAlvara();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getTipoInscricaoAlvara();
    }

    public ParametroAlvaraNaturezaEntity getParametroAlvaraNatureza(NaturezaSolicitacaoAlvaraEntity natureza, ParametroAlvaraNaturezaEnum param, TipoInscricaoAlvaraEntity tipoInscricao) throws BaseException {
        CommandCarregaParametroAlvaraNatureza command = this.getCommandCarregaParametrosAlvaraNatureza();
        command.setParametro(param);
        command.setNatureza(natureza);
        command.setTipoInscricaoAlvaraEntity(tipoInscricao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getParametro();
    }

    public String getCodigoTaxaLocalizacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandGetCodTaxaLocalizacaoWS command = this.getCommandGetCodTaxaLocalizacaoWS();
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getCodTaxa();
    }

    public Page<SolicitacaoAlvaraEntity> carregaListaSolicitacaoAlvaraPaginado(SolicitacaoAlvaraDataModel solicitacaoAlvara, int pagina, int tamanhoPagina) throws BaseException {
        CommandCarregaListaSolicitacaoAlvaraPaginado command = this.getCommandCarregaListaSolicitacaoAlvaraPaginado();
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        command.setPagina(Integer.valueOf(pagina));
        command.setTamanhoPagina(Integer.valueOf(tamanhoPagina));
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getListaSolicitacaoAlvara();
    }

    public void validaAlteracaoGeraLaudo(SolicitacaoAlvaraEntity solicitacao, NaturezaSolicitacaoAlvaraEnum naturezaEnum) throws BaseException {
        CommandValidaAlteracaoGeraLaudoPrestadorServico command = this.getCommandValidaAlteracaoGeraLaudoPrestadorServico();
        command.setSolicitacaoAlvara(solicitacao);
        command.setNaturezaSolicitacaoAlvaraEnum(naturezaEnum);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public Set<TipoLaudoEntity> carregaLaudosAGerarPrestadorServico(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandCarregaLaudosAGerarPrestadorServico command = this.getCommandCarregaLaudosAGerarPrestadorServico();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getLaudosAGerar();
    }

    public SolicitacaoAlvaraEntity carregarAtividadesMobNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandCarregarAtividadesMobNaSolicitacao command = this.getCommandCarregarAtividadesMobNaSolicitacao();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getSolicitacaoAlvara();
    }

    public boolean validaGeraLaudoPrestadorServico(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandValidaGeraLaudoPrestadorServico command = this.getCommandValidaGeraLaudoPrestadorServico();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.isGeraLaudo();
    }

    public NaturezaSolicitacaoAlvaraEntity getNatureza(String codigo) throws BaseException {
        CommandBuscaNaturezaPorCodigo command = this.getCommandBuscaNaturezaPorCodigo();
        command.setCodigo(codigo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getNatureza();
    }

    public List<TipoLaudoEntity> getTiposLaudoAtividadeMei(AtividadeMeiEntity atividade) throws BaseException {
        CommandCarregaListaTiposDeLaudoDaAtividadeMei command = this.getCommandCarregaListaTiposDeLaudoDaAtividadeMei();
        command.setAtividade(atividade);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getTiposLaudo();
    }

    public BigDecimal getValorTaxasISSQN(SolicitacaoAlvaraEntity solicitacao, Long entidade, Long exercicio) throws BaseException {
        CommandRetornaValorTaxaMobiliariaISSQN command = this.getCommandRetornaValorTaxaMobiliariaISSQN();
        command.setSolicitacao(solicitacao);
        command.setEntidade(entidade);
        command.setExercicio(exercicio);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getValorTaxa();
    }

    public List<TipoInscricaoAlvaraEntity> carregarMenusTipoInscricao() throws BaseException {
        CommandCarregaMenusTipoInscricaoAlvara command = this.getCommandCarregaMenusTipoInscricaoAlvara();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getMenusTipoInscricaoAlvara();
    }

    public List<SolicitacaoContratoSocialPessoaEntity> carregaListaParticipantesContratoSocial(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CommandCarregaListaParticipantesContratoSocial command = this.getCommandCarregaListaParticipantesContratoSocial();
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getCarregaListaParticipantesContratoSocialDaSolicitacao();
    }

    public List<SefazDocumentoEntity> carregaDocumentosSefaz(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandCarregaDocumentosSefaz command = this.getCommandCarregaDocumentosSefaz();
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getDocumentos();
    }

    public Message<Mensagem> validaConsultaPreviaRedeSim(Message<Mensagem> message) throws BaseException {
        CommandConsultaViabilidadeRedeSim command = this.getCommandConsultaViabilidadeRedeSim();
        command.setMessage(message);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getMessage();
    }

    public CadastroMobiliarioEntity salvarCadastroMobiliario(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        CommandSalvarCadastroMobiliario command = this.getCommandSalvarCadastroMobiliario();
        command.setCadastroMobiliario(cadastroMobiliario);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getCadastroMobiliario();
    }

    public void enviarEmail(EmailVo emailVo) throws BaseException {
        CommandEnviarEmail command = this.getCommandEnviarEmail();
        command.setEmailVo(emailVo);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public void enviarEmailDebitosSocios(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandEnviarEmailDebitosSocios command = this.getCommandEnviarEmailDebitosSocios();
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public SolicitacaoAlvaraEntity iniciaConsultaPrevia(ConsultaPreviaVo consultaPreviaVo) throws BaseException {
        CommandIniciaConsultaPrevia command = this.getCommandIniciaConsultaPrevia();
        command.setConsultaPreviaVo(consultaPreviaVo);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getSolicitacao();
    }

    public boolean validaSegmentoImobiliario(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandValidaSegmentoImobiliario command = this.getCommandValidaSegmentoImobiliario();
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.isSegmentoValido();
    }

    public SolicitacaoAlvaraEntity carregaDadosCadastroNaSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandCarregaDadosCadastroNaSolicitacao command = this.getCommandCarregaDadosCadastroNaSolicitacao();
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getSolicitacao();
    }

    public RestricaoConsultaPreviaEntity adicionaRestricaoConsultaPrevia(RestricaoAlvaraVo restricaoAlvaraVo, SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandAdicionaRestricaoConsultaPrevia command = this.getCommandAdicionaRestricaoConsultaPrevia();
        command.setRestricaoAlvaraVo(restricaoAlvaraVo);
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getRestricaoConsultaPrevia();
    }

    public SolicitacaoAlvaraValidadeEntity carregarValidadeAnual(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CommandCarregarValidadeAnual command = this.getCommandCarregarValidadeAnual();
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getValidade();
    }

    public List<NaturezaSolicitacaoAlvaraEntity> carregarTodasNaturezasSolicitacao() throws BaseException {
        CommandCarregarTodasNaturezasSolicitacao command = this.getCommandCarregarTodasNaturezasSolicitacao();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getNaturezas();
    }

    public List<SolicitacaoAlvaraEntity> carregarSolicitacoesParaGerarProcessoFiscalizacao() throws BaseException {
        CommandCarregarSolicitacoesParaGerarProcessoFiscalizacao command = this.getCommandCarregarSolicitacoesParaGerarProcessoFiscalizacao();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getSolicitacoes();
    }

    public SolicitacaoAlvaraDTO carregarById(Long idSolicitacao) throws BaseException {
        CommandCarregarSolicitacaoPorId command = this.getCommandCarregarSolicitacaoPorId();
        command.setIdSolicitacao(idSolicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getSolicitacaoDto();
    }

    public void processarFilaEnvioEmail() throws BaseException {
        CommandProcessarFilaEnvioEmailSolicitacao command = this.getCommandProcessarFilaEnvioEmailSolicitacao();
        this.getCommandContainer().executeCommand((Command)command);
    }

    public Date montarDataAlvaraValidadeAnual() throws BaseException {
        CommandMontarDataValidadeAlvaraAnual command = this.getCommandMontarDataValidadeAlvaraAnual();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getDataValidadeAlvaraAnual();
    }

    public void imprimirLicencaSanitaria(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandImprimirLicencaSanitaria commandImprimirLicencaSanitaria = this.getCommandImprimirLicencaSanitaria();
        commandImprimirLicencaSanitaria.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((Command)commandImprimirLicencaSanitaria);
    }

    public ResponsavelSolicitacaoVo getResponsavelSolicitacaoAlvara(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CommandDocumentoResponsavelSolicitacaoAlvara commandDocumentoResponsavelSolicitacaoAlvara = this.getCommandDocumentoResponsavelSolicitacaoAlvara();
        commandDocumentoResponsavelSolicitacaoAlvara.setSolicitacaoAlvara(solicitacaoAlvara);
        this.getCommandContainer().executeCommand((Command)commandDocumentoResponsavelSolicitacaoAlvara);
        return commandDocumentoResponsavelSolicitacaoAlvara.getResponsavelSolicitacaoAlvara();
    }

    public boolean isCadastroMobiliarioIsento(CadastroMobiliarioEntity cadastroMobiliario) throws BaseException {
        CommandCadastroMobiliarioIsento command = this.getCommandCadastroMobiliarioIsento();
        command.setCadastroMobiliario(cadastroMobiliario);
        this.getCommandContainer().executeCommand((Command)command);
        return command.isIsento();
    }

    public SolicitacaoAlvaraEntity clonarSolicitacaoNaRenovacao(SolicitacaoAlvaraEntity solicitacaoAlvara) throws BaseException {
        CommandCloneSolicitacaoAlvaraNaRenovacao command = this.getCommandCloneSolicitacaoAlvaraNaRenovacao();
        command.setSolicitacaoAlvara(solicitacaoAlvara);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getSolicitacaoAlvara();
    }

    public boolean exigirDocumentoNaImpressao(SolicitacaoAlvaraEntity solicitacao, ArrayList<String> tiposDocumentos) throws BaseException {
        CommandExigeDocumentoNaImpressao command = this.getCommandExigeDocumentoNaImpressao();
        command.setSolicitacaoAlvara(solicitacao);
        command.setTiposDocumentos(tiposDocumentos);
        this.getCommandContainer().executeCommand((Command)command);
        return command.exigeDocumentoNaImpressao();
    }

    public void salvarSolicitacaoDispensaLicencaAmbiental(SolicitacaoDispensaAmbientalEntity solicitacaoDispensa) throws BaseException {
        CommandSalvarSolicitacaoDispensaLicencaAmbiental command = this.getCommandSalvarSolicitacaoDispensaLicencaAmbiental();
        command.setSolicitacaoDispensa(solicitacaoDispensa);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }
}

