/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandCarregaAtividadesBySolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaCadastroRestricaoAlvaraPorCodigo;
import br.com.elotech.portalarrecadacao.command.CommandCarregaParametrosAlvara;
import br.com.elotech.portalarrecadacao.command.CommandCarregaRestricaoAlvaraBySolicitacaoCadRestricao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaRestricaoForLiberacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaRestricaoPorSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaRestricoesPorSolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandCarregarListaCadastroRestricoes;
import br.com.elotech.portalarrecadacao.command.CommandPossuiRestricaoResponsavelTecnicoBloqueante;
import br.com.elotech.portalarrecadacao.command.CommandSalvarCadastroRestricao;
import br.com.elotech.portalarrecadacao.command.CommandUpdateRestricaoAlvara;
import br.com.elotech.portalarrecadacao.command.CommandValidaAcessibilidade;
import br.com.elotech.portalarrecadacao.command.CommandValidaHabitese;
import br.com.elotech.portalarrecadacao.command.CommandVerificaDebitos;
import br.com.elotech.portalarrecadacao.command.CommandVerificaLiberacaoRestricaoBySolicitacao;
import br.com.elotech.portalarrecadacao.command.CommandVerificaLiberacaoRestricaoSolicitacaoAlv;
import br.com.elotech.portalarrecadacao.command.CommandVerificaLiberacaoSolicitacaoByCadastroRestricao;
import br.com.elotech.portalarrecadacao.command.CommandVerificaPossuiSituacaoImobiliarioSegmento;
import br.com.elotech.portalarrecadacao.command.CommandVerificaProprietarioImob;
import br.com.elotech.portalarrecadacao.command.CommandVerificaRestricaoRespTecMeioAmbiente;
import br.com.elotech.portalarrecadacao.command.CommandVerificaRestricaoRespTecVigSanitaria;
import br.com.elotech.portalarrecadacao.command.impl.CommandVerificaRestricaoRespTecVigAmbiental;
import br.com.elotech.portalarrecadacao.domain.ParametroAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.RestricaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraAtividadeEntity;
import br.com.elotech.portalarrecadacao.domain.SolicitacaoAlvaraEntity;
import br.com.elotech.portalarrecadacao.enumerator.ParametroAlvaraEnum;
import br.com.elotech.portalarrecadacao.filter.FiltroCadastroRestricao;
import br.com.elotech.portalarrecadacao.ws.oxm.geo.RespostaWSAtividade;
import br.com.elotech.tributacao.domain.aise.CadastroRestricaoAlvaraEntity;
import br.com.elotech.tributacao.domain.aise.EntidadeAiseEntity;
import java.util.List;

public abstract class FacadeRestricaoCadastro
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandCarregaParametrosAlvara getCommandCarregaParametrosAlvara();

    protected abstract CommandValidaHabitese getCommandValidaHabitese();

    protected abstract CommandValidaAcessibilidade getCommandValidaAcessibilidade();

    protected abstract CommandVerificaDebitos getCommandVerificaDebitos();

    protected abstract CommandVerificaProprietarioImob getCommandVerificaProprietarioImob();

    protected abstract CommandVerificaPossuiSituacaoImobiliarioSegmento getCommandVerificaPossuiSituacaoImobiliarioSegmento();

    protected abstract CommandCarregaRestricoesPorSolicitacao getCommandCarregaRestricoesPorSolicitacao();

    protected abstract CommandVerificaLiberacaoRestricaoSolicitacaoAlv getCommandVerificaLiberacaoRestricaoSolicitacaoAlv();

    protected abstract CommandCarregaRestricaoPorSolicitacao getCommandCarregaRestricaoPorSolicitacao();

    protected abstract CommandCarregaCadastroRestricaoAlvaraPorCodigo getCommandCarregaCadastroRestricaoAlvara();

    protected abstract CommandUpdateRestricaoAlvara getCommandUpdateRestricaoAlvara();

    protected abstract CommandCarregaRestricaoForLiberacao getCommandCarregaRestricaoForLiberacao();

    protected abstract CommandVerificaLiberacaoSolicitacaoByCadastroRestricao getCommandVerificaLiberacaoSolicitacaoByCadastroRestricao();

    protected abstract CommandCarregaAtividadesBySolicitacao getCommandCarregaAtividadesBySolicitacao();

    protected abstract CommandVerificaRestricaoRespTecVigSanitaria getCommandVerificaRestricaoRespTecVigSanitaria();

    protected abstract CommandVerificaRestricaoRespTecMeioAmbiente getCommandVerificaRestricaoRespTecMeioAmbiente();

    protected abstract CommandVerificaRestricaoRespTecVigAmbiental getCommandVerificaRestricaoRespTecVigAmbiental();

    protected abstract CommandVerificaLiberacaoRestricaoBySolicitacao getCommandVerificaLiberacaoRestricaoBySolicitacao();

    protected abstract CommandCarregaRestricaoAlvaraBySolicitacaoCadRestricao getCommandCarregaRestricaoAlvaraBySolicitacaoCadRestricao();

    protected abstract CommandPossuiRestricaoResponsavelTecnicoBloqueante getCommandPossuiRestricaoResponsavelTecnicoBloqueante();

    protected abstract CommandCarregarListaCadastroRestricoes getCommandCarregarListaCadastroRestricoes();

    protected abstract CommandSalvarCadastroRestricao getCommandSalvarCadastroRestricao();

    public boolean verificaPossuiSituacaoImobSegmento(Long tipoCadastro, Long cadastroGeral) throws BaseException {
        CommandVerificaPossuiSituacaoImobiliarioSegmento command = this.getCommandVerificaPossuiSituacaoImobiliarioSegmento();
        command.setCadastroGeral(cadastroGeral);
        command.setTipoCadastro(tipoCadastro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.verificaSituacao();
    }

    public ParametroAlvaraEntity getParametros(EntidadeAiseEntity entidade, ParametroAlvaraEnum parametroAlvaraEnum) throws BaseException {
        CommandCarregaParametrosAlvara command = this.getCommandCarregaParametrosAlvara();
        command.setEntidade(entidade);
        command.setParametroAlvaraEnum(parametroAlvaraEnum);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getParametroAlvara();
    }

    public Boolean possuiHabitese(Long tipoCadastro, Long cadastroGeral) throws BaseException {
        CommandValidaHabitese command = this.getCommandValidaHabitese();
        command.setTipoCadastro(tipoCadastro);
        command.setCadastroGeral(cadastroGeral);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getPossuiHabitese();
    }

    public Boolean possuiAcessibilidade(Long tipoCadastro, Long cadastroGeral) throws BaseException {
        CommandValidaAcessibilidade command = this.getCommandValidaAcessibilidade();
        command.setTipoCadastro(tipoCadastro);
        command.setCadastroGeral(cadastroGeral);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getPossuiAcessibilidade();
    }

    public Boolean possuiDebitos(Long tipoCadastro, Long cadastroGeral) throws BaseException {
        CommandVerificaDebitos command = this.getCommandVerificaDebitos();
        command.setTipoCadastro(tipoCadastro);
        command.setCadastroGeral(cadastroGeral);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getPossuiDebitos();
    }

    public Boolean isProprietarioImobiliario(Long cadMobiliario, Long cadImobiliario) throws BaseException {
        CommandVerificaProprietarioImob command = this.getCommandVerificaProprietarioImob();
        command.setCadMobiliario(cadMobiliario);
        command.setCadImobiliario(cadImobiliario);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getIsProprietario();
    }

    public List<RestricaoAlvaraEntity> carregaRestricoesPorSolicitacao(Long idSolicitacao) throws BaseException {
        CommandCarregaRestricoesPorSolicitacao command = this.getCommandCarregaRestricoesPorSolicitacao();
        command.setIdSolicitacao(idSolicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getRestricao();
    }

    public List<CadastroRestricaoAlvaraEntity> carregarListaCadastroRestricoes(FiltroCadastroRestricao filtro) throws BaseException {
        CommandCarregarListaCadastroRestricoes command = this.getCommandCarregarListaCadastroRestricoes();
        command.setFiltro(filtro);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getListaCadastroRestricoes();
    }

    public void salvarCadastroRestricao(CadastroRestricaoAlvaraEntity cadastroRestricao) throws BaseException {
        CommandSalvarCadastroRestricao command = this.getCommandSalvarCadastroRestricao();
        command.setCadastroRestricao(cadastroRestricao);
        this.getCommandContainer().executeCommand((Command)command);
    }

    public boolean verificaLiberacaoRestricaoByCadastroRestricao(Long idSolicitacaoAlvara, Long idCadastroRestricao) throws BaseException {
        CommandVerificaLiberacaoSolicitacaoByCadastroRestricao command = this.getCommandVerificaLiberacaoSolicitacaoByCadastroRestricao();
        command.setSolicitacao(idSolicitacaoAlvara);
        command.setCadastroRestricao(idCadastroRestricao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getLiberado();
    }

    public boolean verificaLiberacaoSolicitacao(Long idSolicitacaoAlvara) throws BaseException {
        CommandVerificaLiberacaoRestricaoSolicitacaoAlv command = this.getCommandVerificaLiberacaoRestricaoSolicitacaoAlv();
        command.setIdSolicitacao(idSolicitacaoAlvara);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getSolicitacaoLiberada();
    }

    public List<RestricaoAlvaraEntity> carregaRestricaoPorSolicitacao(SolicitacaoAlvaraEntity solicitacao) throws BaseException {
        CommandCarregaRestricaoPorSolicitacao command = this.getCommandCarregaRestricaoPorSolicitacao();
        command.setSolicitacao(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getRestricao();
    }

    public CadastroRestricaoAlvaraEntity carregaCadastroRestricaoAlvaraPorCodigo(Long codigo) throws BaseException {
        CommandCarregaCadastroRestricaoAlvaraPorCodigo command = this.getCommandCarregaCadastroRestricaoAlvara();
        command.setCodigo(codigo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getCadastroRestricaoAlvara();
    }

    public void atualizaRestricaoAlvara(RestricaoAlvaraEntity restricao) throws BaseException {
        CommandUpdateRestricaoAlvara command = this.getCommandUpdateRestricaoAlvara();
        command.setRestricaoAlvara(restricao);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public List<RestricaoAlvaraEntity> carregaRestricaoForLiberacao(Long idSolicitacao) throws BaseException {
        CommandCarregaRestricaoForLiberacao command = this.getCommandCarregaRestricaoForLiberacao();
        command.setSolicitacao(idSolicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getRestricaoAlvara();
    }

    public List<SolicitacaoAlvaraAtividadeEntity> carregaListaAtividadeBySolicitacao(Long idSolicitacao) throws BaseException {
        CommandCarregaAtividadesBySolicitacao command = this.getCommandCarregaAtividadesBySolicitacao();
        command.setIdSolicitacao(idSolicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getSolicitacaoAtividades();
    }

    public Boolean verificaRestricaoRespTecVigSanitaria(List<RespostaWSAtividade> listaConfiguracaoCnae) throws BaseException {
        CommandVerificaRestricaoRespTecVigSanitaria command = this.getCommandVerificaRestricaoRespTecVigSanitaria();
        command.setListaConfiguracaoCnae(listaConfiguracaoCnae);
        this.getCommandContainer().executeCommand((Command)command);
        return command.possuiRestricao();
    }

    public Boolean verificaRestricaoRespTecMeioAmbiente(List<RespostaWSAtividade> listaConfiguracaoCnae) throws BaseException {
        CommandVerificaRestricaoRespTecMeioAmbiente command = this.getCommandVerificaRestricaoRespTecMeioAmbiente();
        command.setListaConfiguracaoCnae(listaConfiguracaoCnae);
        this.getCommandContainer().executeCommand((Command)command);
        return command.possuiRestricao();
    }

    public Boolean verificaRestricaoRespTecVigAmbiental(List<RespostaWSAtividade> listaConfiguracaoCnae) throws BaseException {
        CommandVerificaRestricaoRespTecVigAmbiental command = this.getCommandVerificaRestricaoRespTecVigAmbiental();
        command.setListaConfiguracaoCnae(listaConfiguracaoCnae);
        this.getCommandContainer().executeCommand((Command)command);
        return command.possuiRestricao();
    }

    public RestricaoAlvaraEntity carregaRestricaoAlvaraBySolicitacaoCadRestricao(Long solicitacao, Long cadastroRestricao) throws BaseException {
        CommandCarregaRestricaoAlvaraBySolicitacaoCadRestricao command = this.getCommandCarregaRestricaoAlvaraBySolicitacaoCadRestricao();
        command.setCadastroRestricao(cadastroRestricao);
        command.setSolicitacaoAlvara(solicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getRestricao();
    }

    public boolean possuiRestricaoResponsavelTecnicoBloqueante(Long idSolicitacao) throws BaseException {
        CommandPossuiRestricaoResponsavelTecnicoBloqueante command = this.getCommandPossuiRestricaoResponsavelTecnicoBloqueante();
        command.setSolicitacao(idSolicitacao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.possuiRestricao();
    }
}

