/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandAuthenticate;
import br.com.elotech.portalarrecadacao.command.CommandCriaUsuarioPorToken;
import br.com.elotech.portalarrecadacao.command.CommandEnviarEmail;
import br.com.elotech.portalarrecadacao.command.CommandGetDadosUsuarioByToken;
import br.com.elotech.portalarrecadacao.command.CommandGetTokenDefinitivoOauth;
import br.com.elotech.portalarrecadacao.command.CommandGetUsuarioOauth;
import br.com.elotech.portalarrecadacao.rest.dto.UserDTO;
import br.com.elotech.portalarrecadacao.rest.response.TokenResponse;
import br.com.elotech.tributacao.command.CommandEfetuaLoginAcessoWeb;
import br.com.elotech.tributacao.domain.aise.PessoaEntity;
import br.com.elotech.tributacao.domain.aise.UsuarioEntity;
import java.util.Optional;
import net.sf.json.JSONObject;
import org.springframework.security.authentication.AuthenticationManager;

public abstract class FacadeLoginPortal
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandGetTokenDefinitivoOauth getCommandGetTokenDefinitivoOauth();

    protected abstract CommandGetUsuarioOauth getCommandGetUsuarioOauth();

    protected abstract CommandEnviarEmail getCommandEnviarEmail();

    protected abstract CommandEfetuaLoginAcessoWeb getCommandEfetuaLoginAcessoWeb();

    protected abstract CommandCriaUsuarioPorToken getCommandCriaUsuarioPorToken();

    protected abstract CommandAuthenticate getCommandAuthenticate();

    protected abstract CommandGetDadosUsuarioByToken getCommandGetDadosUsuarioByToken();

    public JSONObject getTokenOauth(String modulo, String tokenTemp, String redirect) throws BaseException {
        CommandGetTokenDefinitivoOauth command = this.getCommandGetTokenDefinitivoOauth();
        command.setModulo(modulo);
        command.setTokenTemp(tokenTemp);
        command.setRedirect(redirect);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getResposta();
    }

    public JSONObject getUsuarioOauth(String modulo, String acessToken) throws BaseException {
        CommandGetUsuarioOauth command = this.getCommandGetUsuarioOauth();
        command.setModulo(modulo);
        command.setAcessToken(acessToken);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getResposta();
    }

    public void enviarEmail() throws BaseException {
        CommandEnviarEmail command = this.getCommandEnviarEmail();
        this.getCommandContainer().executeCommand((Command)command);
    }

    public Boolean efetuaLoginContribuinte(String username, String password, AuthenticationManager autenticationManager) throws BaseException {
        CommandEfetuaLoginAcessoWeb command = this.getCommandEfetuaLoginAcessoWeb();
        command.setPassword(password);
        command.setUsername(username);
        this.getCommandContainer().executeCommand((Command)command);
        return command.isAutenticado();
    }

    public UsuarioEntity criaUsuarioPorToken(String token, Optional<PessoaEntity> pessoa) throws BaseException {
        CommandCriaUsuarioPorToken command = this.getCommandCriaUsuarioPorToken();
        command.setToken(token);
        command.setPessoa(pessoa);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getUsuario();
    }

    public TokenResponse authenticate(UserDTO user) throws BaseException {
        CommandAuthenticate command = this.getCommandAuthenticate();
        command.setUser(user);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getToken();
    }

    public JSONObject getUsuarioByToken(String modulo, String token) throws BaseException {
        CommandGetDadosUsuarioByToken command = this.getCommandGetDadosUsuarioByToken();
        command.setModulo(modulo);
        command.setTokenTemp(token);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getResposta();
    }
}

