/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.domain.Page;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandCarregaFilaRecebimentoRedeSimPaginada;
import br.com.elotech.portalarrecadacao.command.CommandCarregaFilaRecebimentoRedeSimParaProcessamento;
import br.com.elotech.portalarrecadacao.command.CommandCarregaFilaRecebimentoRedeSimProcessadaPaginada;
import br.com.elotech.portalarrecadacao.command.CommandFindFilaRecebimentoProcesssRedeSimByTipoAndProtocolo;
import br.com.elotech.portalarrecadacao.command.CommandProcessarRegistroFilaRecebimentoRedeSim;
import br.com.elotech.portalarrecadacao.command.CommandSalvarFilaRecebimentoProcessadaRedeSim;
import br.com.elotech.portalarrecadacao.command.CommandSalvarFilaRecebimentoRedeSim;
import br.com.elotech.portalarrecadacao.domain.FilaRecebimentoProcessadaRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.FilaRecebimentoRedeSimEntity;
import br.com.elotech.portalarrecadacao.domain.vo.FiltroConsultaFilaRecebimentoProcessRedeSim;
import br.com.elotech.portalarrecadacao.enumerator.TipoFilaRecebimentoRedeSimEnum;
import java.util.List;

public abstract class FacadeFilaRecebimentoRedeSim
extends Facade {
    protected abstract CommandSalvarFilaRecebimentoRedeSim getCommandSalvarFilaRecebimentoRedeSim();

    protected abstract CommandFindFilaRecebimentoProcesssRedeSimByTipoAndProtocolo getCommandFindFilaRecebimentoProcesssRedeSimByTipoAndProtocolo();

    protected abstract CommandCarregaFilaRecebimentoRedeSimParaProcessamento getCommandCarregaFilaRecebimentoRedeSimParaProcessamento();

    protected abstract CommandProcessarRegistroFilaRecebimentoRedeSim getCommandProcessarRegistroFilaRecebimentoRedeSim();

    protected abstract CommandCarregaFilaRecebimentoRedeSimProcessadaPaginada getCommandCarregaFilaRecebimentoRedeSimProcessadaPaginada();

    protected abstract CommandCarregaFilaRecebimentoRedeSimPaginada getCommandCarregaFilaRecebimentoRedeSimPaginada();

    protected abstract CommandSalvarFilaRecebimentoProcessadaRedeSim getCommandSalvarFilaRecebimentoProcessadaRedeSim();

    public FilaRecebimentoRedeSimEntity salvarFilaRecebimento(FilaRecebimentoRedeSimEntity registro) throws BaseException {
        CommandSalvarFilaRecebimentoRedeSim command = this.getCommandSalvarFilaRecebimentoRedeSim();
        command.setRegistro(registro);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getRegistro();
    }

    public List<FilaRecebimentoProcessadaRedeSimEntity> findFilaRecebimentoProcessByTipoAndProtocolo(TipoFilaRecebimentoRedeSimEnum tipo, String protocolo) throws BaseException {
        CommandFindFilaRecebimentoProcesssRedeSimByTipoAndProtocolo command = this.getCommandFindFilaRecebimentoProcesssRedeSimByTipoAndProtocolo();
        command.setTipo(tipo);
        command.setProtocolo(protocolo);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getRegistros();
    }

    public List<FilaRecebimentoRedeSimEntity> findRegistrosParaProcessamento() throws BaseException {
        CommandCarregaFilaRecebimentoRedeSimParaProcessamento command = this.getCommandCarregaFilaRecebimentoRedeSimParaProcessamento();
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getRegistros();
    }

    public FilaRecebimentoProcessadaRedeSimEntity processarRegistroFilaRecebimento(FilaRecebimentoRedeSimEntity registro) throws BaseException {
        CommandProcessarRegistroFilaRecebimentoRedeSim command = this.getCommandProcessarRegistroFilaRecebimentoRedeSim();
        command.setRegistro(registro);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getRegistroProcessado();
    }

    public Page<FilaRecebimentoProcessadaRedeSimEntity> carregaRegistrosProcessadosPaginados(FiltroConsultaFilaRecebimentoProcessRedeSim filtro, int pagina, int tamanhoPagina) throws BaseException {
        CommandCarregaFilaRecebimentoRedeSimProcessadaPaginada command = this.getCommandCarregaFilaRecebimentoRedeSimProcessadaPaginada();
        command.setFiltro(filtro);
        command.setPagina(Integer.valueOf(pagina));
        command.setTamanhoPagina(Integer.valueOf(tamanhoPagina));
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getRegistros();
    }

    public FilaRecebimentoProcessadaRedeSimEntity salvarFilaRecebimentoProcessada(FilaRecebimentoProcessadaRedeSimEntity registroProcessado) throws BaseException {
        CommandSalvarFilaRecebimentoProcessadaRedeSim command = this.getCommandSalvarFilaRecebimentoProcessadaRedeSim();
        command.setRegistroProcessado(registroProcessado);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getRegistroProcessado();
    }

    public Page<FilaRecebimentoRedeSimEntity> carregaRegistrosPaginados(FiltroConsultaFilaRecebimentoProcessRedeSim filtro, int pagina, int tamanhoPagina) throws BaseException {
        CommandCarregaFilaRecebimentoRedeSimPaginada command = this.getCommandCarregaFilaRecebimentoRedeSimPaginada();
        command.setFiltro(filtro);
        command.setPagina(Integer.valueOf(pagina));
        command.setTamanhoPagina(Integer.valueOf(tamanhoPagina));
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getRegistros();
    }
}

