/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandCarregaEnderecoPorCodigo;
import br.com.elotech.portalarrecadacao.command.CommandCarregaEnderecoPorDescricao;
import br.com.elotech.portalarrecadacao.command.CommandCarregaEnderecosPorCodigo;
import br.com.elotech.portalarrecadacao.command.CommandExcluirEnderecoCadastroAlvara;
import br.com.elotech.portalarrecadacao.command.CommandSalvarEnderecoCadastroAlvara;
import br.com.elotech.tributacao.domain.aise.EnderecoCadastroAlvaraEntity;
import java.util.List;

public abstract class FacadeEnderecoCadastroAlvara
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandCarregaEnderecoPorDescricao getCommandCarregaEnderecoPorDescricao();

    protected abstract CommandCarregaEnderecoPorCodigo getCommandCarregaEnderecoPorCodigo();

    protected abstract CommandCarregaEnderecosPorCodigo getCommandCarregaEnderecosPorCodigo();

    protected abstract CommandSalvarEnderecoCadastroAlvara getCommandSalvarEnderecoCadastroAlvara();

    protected abstract CommandExcluirEnderecoCadastroAlvara getCommandExcluirEnderecoCadastroAlvara();

    public EnderecoCadastroAlvaraEntity getEnderecoPorDescricao(String descricao) throws BaseException {
        CommandCarregaEnderecoPorDescricao command = this.getCommandCarregaEnderecoPorDescricao();
        command.setDescricao(descricao);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getEnderecoCadastroGeral();
    }

    public EnderecoCadastroAlvaraEntity getEnderecoPorCodigo(Long codigo) throws BaseException {
        CommandCarregaEnderecoPorCodigo command = this.getCommandCarregaEnderecoPorCodigo();
        command.setCodigo(codigo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getEnderecoCadastroGeral();
    }

    public List<EnderecoCadastroAlvaraEntity> getEnderecosPorCodigo(Long codigo) throws BaseException {
        CommandCarregaEnderecosPorCodigo command = this.getCommandCarregaEnderecosPorCodigo();
        command.setCodigo(codigo);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getEnderecos();
    }

    public EnderecoCadastroAlvaraEntity salvar(EnderecoCadastroAlvaraEntity enderecoCadastroAlvara) throws BaseException {
        CommandSalvarEnderecoCadastroAlvara command = this.getCommandSalvarEnderecoCadastroAlvara();
        command.setEnderecoCadastroAlvara(enderecoCadastroAlvara);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
        return command.getEnderecoCadastroAlvara();
    }

    public void excluir(EnderecoCadastroAlvaraEntity enderecoCadastroAlvara) throws BaseException {
        CommandExcluirEnderecoCadastroAlvara command = this.getCommandExcluirEnderecoCadastroAlvara();
        command.setEnderecoCadastroAlvara(enderecoCadastroAlvara);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }
}

