/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.portalarrecadacao.facade;

import br.com.elotech.commandLayer.Command;
import br.com.elotech.commandLayer.CommandTransactional;
import br.com.elotech.exceptionLayer.BaseException;
import br.com.elotech.facadeLayer.Facade;
import br.com.elotech.portalarrecadacao.command.CommandCarregarEixosPermitidos;
import br.com.elotech.portalarrecadacao.command.CommandCarregarTodosEixos;
import br.com.elotech.portalarrecadacao.command.CommandExcluirEixoPermitido;
import br.com.elotech.portalarrecadacao.command.CommandSalvarEixoPermitido;
import br.com.elotech.portalarrecadacao.domain.EixoPermitidoEntity;
import br.com.elotech.tributacao.domain.aise.ConfiguracaoAtividadeEntity;
import br.com.elotech.tributacao.domain.aise.EixoEntity;
import java.util.List;

public abstract class FacadeEixo
extends Facade {
    private static final long serialVersionUID = 1L;

    protected abstract CommandCarregarEixosPermitidos getCommandCarregarEixosPermitidos();

    protected abstract CommandCarregarTodosEixos getCommandCarregarTodosEixos();

    protected abstract CommandSalvarEixoPermitido getCommandSalvarEixoPermitido();

    protected abstract CommandExcluirEixoPermitido getCommandExcluirEixoPermitido();

    public List<EixoPermitidoEntity> carregarEixosPermitidosPorAtividade(ConfiguracaoAtividadeEntity configuracaoAtividade) throws BaseException {
        CommandCarregarEixosPermitidos command = this.getCommandCarregarEixosPermitidos();
        command.setConfiguracaoAtividade(configuracaoAtividade);
        this.getCommandContainer().executeCommand((Command)command);
        return command.getEixosPermitidos();
    }

    public List<EixoEntity> carregarTodosEixos() throws BaseException {
        CommandCarregarTodosEixos command = this.getCommandCarregarTodosEixos();
        this.getCommandContainer().executeCommand((Command)command);
        return command.getEixos();
    }

    public void excluirEixoProibido(EixoPermitidoEntity eixoPermitido) throws BaseException {
        CommandExcluirEixoPermitido command = this.getCommandExcluirEixoPermitido();
        command.setEixoPermitido(eixoPermitido);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }

    public void salvarEixoPermitido(EixoPermitidoEntity eixoPermitido) throws BaseException {
        CommandSalvarEixoPermitido command = this.getCommandSalvarEixoPermitido();
        command.setEixoPermitido(eixoPermitido);
        this.getCommandContainer().executeCommand((CommandTransactional)command);
    }
}

